      module modsibyllXs
      logical,save:: sibyllXsUsed
      end      module modsibyllXs
      subroutine csibyllXs(pj, tg, xs)
!  sibyll can compute  xs for
!      p-p, pi-p, K-p
!      p-Air, pi-Air, K-Air, A-Air (A=2~56)
!      for other  targets, we employ cosmsos standard
!  However, it seems possilbe to generate hadronic 
!   collision events for targets A'=2~??(56?)
!    projectile of n, nba, pbar, Kch (Kl, Ks) are also allowed
!
      use modsibyllXs
      implicit none
c  #ifndef Zptcl_
c  #define Zptcl_


c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum
          union
              map
                  real*8 p(4)
              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   
      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c  #endif  /* Zptcl.h */
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        klight: light normally 100 nm~1000 nm
c             subcode: kscinit scintillation light
c                      kceren  Cerekov light
c                      ksycn   synchrotron light
c        kEdepo: energy deposit in a small cell from whcih
c                scintillation lightis produced.
c        kchgPath: charged particle path form wich Cerenkov
c               light is generated.
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.

c               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=768.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
c        masddb and masnnb are the minimum value.
      record /ptcl/ pj  !input projectile particle
      record /ptcl/ tg  ! //   target particle.
                        ! if subcode  is 0, Air is assumed 
                        ! in sibyll
      real(8),intent(out)::xs  ! obtained x-section in mb
      
      integer::TA, PA, L
      real(4):: roots, sxs
      real(8)::At, Zt 
      real(4):: SQS,SIGT,SIGEL,SIGINEL,SIGDIF,SLOPE,RHO
      logical ok

      L = 0   ! p,pi,K code; not given yet 
      PA = 0  ! projectile is A; not given yet
      ok = .false.  ! sibyll could  give xs; not yet 

      if( pj.code == knuc) then 
         L = 1
      elseif( pj.code == kpion  ) then
         L = 2
      elseif( pj.code == kkaon ) then
         L = 3
      elseif( pj.code == kgnuc .and. pj.subcode <=56 ) then
         PA = pj.subcode
      else
         write(0,*) ' pj to csibyllXs is invalid'
         write(0,*) ' pj.code, subcode, charge=',
     *           pj.code, pj.subcode, pj.charge
         stop
      endif
 
      if( tg.subcode == 0 ) then   ! air target
         if( PA > 0 ) then
            call  csibyllXsAAir(PA, pj.fm.p(4), xs)
            ok = .true.
         else  !  p,pi,K- air xsec.
!           s = ( Epj + massT )**2 - Ppj**2
            roots =
     *      sqrt(2*masp*pj.fm.p(4) + masp**2 + pj.mass**2)
            call SIB_SIGMA_HAIR (L, roots, sxs)
            xs = sxs
            ok = .true.
         endif
      elseif( tg.code == knuc .and. tg.charge == 1 ) then
             ! target p
         if( L > 0 ) then  !  p,pi,K-p xsec. 
            SQS =
     *      sqrt(2*masp*pj.fm.p(4) + masp**2 + pj.mass**2)
            call SIB_SIGMA_HP(
     *           L,SQS,SIGT,SIGEL,SIGINEL,SIGDIF,SLOPE,RHO)
            xs = SIGINEL
            ok = .true.
         endif
      endif
      if( .not. ok ) then
         if( tg.subcode == 0 ) then
            At = 14.45
         elseif(tg.code /= kgnuc ) then
            At = 1.
         else
            At = tg.subcode 
         endif
         Zt = tg.charge ! not important
         call cinelx(pj, At, Zt, xs)
      endif

      sibyllXsUsed = ok
      end  subroutine csibyllXs

