      subroutine sample_intcospt(kin, amass, kout, ekin, pp, cospt)
      implicit doubleprecision (a-h, o-z)

      call calc_avrpt(kin, amass, kout, ekin, pp, avrpt)
      rpt = avrpt/pp
      call rpt2cptparm(rpt, a)
      call rndc(u1)
      if(a.eq.0) then
         cospt = 2*u1 - 1.d0
      else
         b = exp(-2.d0*a)
         u = u1*(1.d0 - b) + b
         cospt = 1.d0 + log(u)/a
      end if
c      write(*,*) rpt, a, u1, cospt
      end

      subroutine rpt2cptparm(rpt, parm)
      implicit doubleprecision(a-h,o-z)
      dimension cf1(141), cf2(141)

      Data (CF1(K),K=1,141)/
     &0.7853981631,0.7853981629,0.7853981626,0.7853981621,0.7853981613,
     &0.7853981601,0.7853981582,0.7853981552,0.7853981504,0.7853981427,
     &0.7853981307,0.7853981115,0.7853980812,0.7853980331,0.7853979569,
     &0.7853978361,0.7853976447,0.7853973414,0.7853968606,0.7853960986,
     &0.7853948909,0.7853929769,0.7853899435,0.7853851358,0.7853775166,
     &0.7853654415,0.7853463054,0.7853159810,0.7852679307,0.7851918024,
     &0.7850712138,0.7848802606,0.7845780385,0.7841000963,0.7833452283,
     &0.7821553740,0.7802857966,0.7773627036,0.7728275017,0.7658740226,
     &0.7554024361,0.7400452834,0.7183569048,0.6892462194,0.6525818746,
     &0.6096115272,0.5627377406,0.5146642190,0.4675569927,0.4227598718,
     &0.3809579505,0.3424283379,0.3072135888,0.2752221812,0.2462875997,
     &0.2202044336,0.1967508072,0.1757023000,0.1568404322,0.1399576355,
     &0.1248599391,0.1113681788,0.0993182591,0.0885608239,0.0789605717,
     &0.0703953726,0.0627552894,0.0559415717,0.0498656652,0.0444482616,
     &0.0396184058,0.0353126673,0.0314743774,0.0280529343,0.0250031709,
     &0.0222847840,0.0198618192,0.0177022080,0.0157773523,0.0140617520,
     &0.0125326714,0.0111698413,0.0099551925,0.0088726178,0.0079077595,
     &0.0070478197,0.0062813913,0.0055983067,0.0049895038,0.0044469054,
     &0.0039633124,0.0035323086,0.0031481753,0.0028058156,0.0025006867,
     &0.0022287401,0.0019863672,0.0017703519,0.0015778281,0.0014062409,
     &0.0012533137,0.0011170171,0.0009955426,0.0008872783,0.0007907876,
     &0.0007047902,0.0006281450,0.0005598348,0.0004989533,0.0004446926,
     &0.0003963327,0.0003532319,0.0003148183,0.0002805821,0.0002500690,
     &0.0002228743,0.0001986369,0.0001770353,0.0001577829,0.0001406242,
     &0.0001253314,0.0001117017,0.0000995543,0.0000887278,0.0000790788,
     &0.0000704790,0.0000628145,0.0000559835,0.0000498953,0.0000444693,
     &0.0000396333,0.0000353232,0.0000314818,0.0000280582,0.0000250069,
     &0.0000222874,0.0000198637,0.0000177035,0.0000157783,0.0000140624,
     &0.0000125331/
      Data (CF2(K),K=1,141)/
     &0.0078539816,0.0088123123,0.0098875771,0.0110940439,0.0124477220,
     &0.0139665738,0.0156707535,0.0175828745,0.0197283096,0.0221355272,
     &0.0248364696,0.0278669766,0.0312672608,0.0350824415,0.0393631429,
     &0.0441661660,0.0495552412,0.0556018737,0.0623862902,0.0699985010,
     &0.0785394891,0.0881225414,0.0988747358,0.1109385991,0.1244739480,
     &0.1396599194,0.1566971887,0.1758103487,0.1972503860,0.2212971174,
     &0.2482613161,0.2784860254,0.3123461430,0.3502446476,0.3926026280,
     &0.4398382895,0.4923270541,0.5503306490,0.6138787052,0.6825859411,
     &0.7554024361,0.8303444650,0.9043577622,0.9735861623,1.0342725706,
     &1.0840596270,1.1228094070,1.1521896665,1.1744500658,1.1914992068,
     &1.2046948164,1.2149815912,1.2230393261,1.2293723254,1.2343620078,
     &1.2383005302,1.2414136685,1.2438770258,1.2458278366,1.2473737390,
     &1.2485993909,1.2495715188,1.2503428027,1.2509548870,1.2514407255,
     &1.2518264159,1.2521326392,1.2523757918,1.2525688786,1.2527222175,
     &1.2528439966,1.2529407151,1.2530175325,1.2530785451,1.2531270056,
     &1.2531654970,1.2531960703,1.2532203547,1.2532396439,1.2532549655,
     &1.2532671357,1.2532768026,1.2532844813,1.2532905806,1.2532954254,
     &1.2532992738,1.2533023306,1.2533047588,1.2533066875,1.2533082195,
     &1.2533094365,1.2533104031,1.2533111710,1.2533117809,1.2533122653,
     &1.2533126502,1.2533129558,1.2533131987,1.2533133915,1.2533135447,
     &1.2533136664,1.2533137631,1.2533138399,1.2533139009,1.2533139493,
     &1.2533139878,1.2533140184,1.2533140426,1.2533140619,1.2533140773,
     &1.2533140894,1.2533140991,1.2533141068,1.2533141129,1.2533141177,
     &1.2533141216,1.2533141246,1.2533141270,1.2533141290,1.2533141305,
     &1.2533141317,1.2533141327,1.2533141335,1.2533141341,1.2533141345,
     &1.2533141349,1.2533141352,1.2533141355,1.2533141357,1.2533141358,
     &1.2533141360,1.2533141360,1.2533141361,1.2533141362,1.2533141362,
     &1.2533141363,1.2533141363,1.2533141362,1.2533141364,1.2533141363,
     &1.2533141366/

      if(rpt.gt.cf1(1)) then
         parm = 1.d-4
         return
      end if

      if(rpt.gt.cf1(61)) then
         i1 = 1
         i2 = 61
         do while (i2.gt.i1+1)
            i3 = int((i2+i1)/2)

            if(cf1(i3).lt.rpt) then
               i2 = i3
            else
               i1 = i3
            end if
         enddo

         dx = (rpt - cf1(i1))/(cf1(i2)-cf1(i1))
         xx = real(i1) + dx

         parm = 10.d0**(0.1d0*xx - 4.1d0)
         return
      end if

      if(rpt.le.cf2(141)*1e-5) then
         parm = (cf2(141)/rpt)**2
         return
      end if

      z1 = 1
      z2 = cf2(141)
      do while (abs(z1-z2).gt.1e-6)
         z1 = z2
         y  = (z1/rpt)**2
         yl = 10.d0*log10(y)
         nn = int(yl)
         dy = yl - nn

         i1 = nn + 41
         i2 = i1 + 1
         z2 = cf2(i2)*dy + cf2(i1)*(1.d0-dy)
      enddo
      parm = y
      end

      subroutine calc_avrpt(kin, amass, kout, ekin, pp, apt)
      implicit doubleprecision (a-h,o-z)

      common /averptd/cf(40,13,10,4)
      integer jin(20), jout(20)

c  kin, kout $B30It$G$NN3;R%3!<%I(B
c  code conversion for projectile : (outside to inside(1))
c                 1  2  3  4  5  6  7  8  9 10 11 12 13 14
      data  jin / 0, 0, 0, 1, 2, 5, 5, 4, 3, 3, 4, 1, 2, 0,
c                15 16 17 18 19 20
     &            0, 0, 0, 0, 0, 0/
c     Use the same pt distribution for kaons as the pions.
c     pbar is the same with n, and nbar is the same with p as well.
c     This should be replaced by their own pt-distribusion near future.
c   jout : code conversion for child particle (outside to inside(2))
c                 1  2  3  4  5  6  7  8  9 10 11 12 13 14
      data jout / 0, 0, 0, 3, 4, 6, 6, 9,10, 7, 8, 2, 3, 1,
c                15 16 17 18 19 20
     &            0, 0, 0, 0, 0, 0/

      iin = jin(kin)
      if(iin.eq.5) then
         call rndc(u)
         if(u.gt.0.5d0) then
            iin = 1
         else
            iin = 2
         end if
      end if

      iout = jout(kout)
      ekl = 2*log10(ekin)

      iek = int(ekl) + 1
      dek = ekl - 1.d0*(iek -1)

      call rndc(u)
      if(u.lt.dek) iek = iek + 1
      if(iek.lt. 1) iek = 1
      if(iek.gt.13) iek = 13

      pp0 = sqrt((ekin + amass)**2 - amass**2)
      ek1 = 10.d0**(0.5d0*(iek-1))
      pp1 = sqrt((ek1 + amass)**2 - amass**2)
      
      pp2 = (pp/pp0)*pp1
      ppl = 10*log10(10*pp2)+0.5


      ipp = int(ppl) + 1
      if(ipp.lt. 1) ipp = 1
      if(ipp.gt.38) ipp = 38
      dpp = ppl - 1.d0*(ipp -1)

      ipp0 = ipp
      do while((ipp.gt.0).and.(ipp.lt.39.).and.(iek.le.13)
     &     .and. (cf(ipp,iek,iout,iin).eq.0.))
         if(ipp.gt.7) then
            ipp = ipp - 1
         else if(ipp.lt.7) then
            ipp = ipp + 1
         else
            iek = iek + 1
            ipp = ipp0
         end if
      enddo

      if(cf(ipp,iek,iout,iin).eq.0.) then
         Stop 'in apt-block, (iek, ipp) out of range'
      end if

      if((ipp.eq.1) .or. (ipp.eq.38) .or. (ipp.ne.ipp0)) then
         apt = cf(ipp, iek, iout, iin)
      else 
         apt = (1.d0 -dpp)*cf(ipp, iek, iout, iin) +  
     &        dpp*cf(ipp+1, iek, iout, iin)
      end if

      end

      block data averpt_of_interaction
      implicit doubleprecision (a-h,o-z)
      common /averptd/cf(40,13,10,4)
c::::::::::::::
capt-01-01-block.f
c::::::::::::::
      Data ((CF(K,l, 1, 1),K=1,40),l=1,13)/
     &0.08475,0.10668,0.13536,0.16864,0.19333,0.23946,0.29641,0.24816,
     &0.13254,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08576,0.10989,0.13892,0.17680,0.21742,0.26931,0.32362,0.36359,
     &0.39081,0.39192,0.35674,0.32763,0.21532,0.14652,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08428,0.10507,0.13128,0.15842,0.18608,0.21612,0.24944,0.28076,
     &0.30934,0.33491,0.35982,0.38569,0.41581,0.44950,0.48156,0.51415,
     &0.55225,0.58026,0.59259,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08385,0.10709,0.13374,0.15749,0.17916,0.20260,0.22975,0.24784,
     &0.28037,0.29786,0.31359,0.32909,0.34615,0.36410,0.38260,0.40410,
     &0.42334,0.44455,0.46601,0.49087,0.52220,0.54589,0.57293,0.59195,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08305,0.10591,0.13437,0.15615,0.17815,0.20096,0.22559,0.24678,
     &0.26542,0.26750,0.28807,0.30215,0.31384,0.32606,0.33536,0.34736,
     &0.35752,0.36958,0.38056,0.39314,0.41082,0.42631,0.44559,0.46497,
     &0.49041,0.51930,0.55295,0.58973,0.63231,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08241,0.10606,0.13477,0.15574,0.17759,0.19947,0.22337,0.24548,
     &0.26206,0.27385,0.28376,0.29326,0.29201,0.31363,0.32134,0.32869,
     &0.33629,0.34359,0.35044,0.35658,0.36629,0.37382,0.38112,0.39037,
     &0.40259,0.41440,0.43133,0.45089,0.47247,0.50174,0.53403,0.56873,
     &0.61919,0.64461,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08203,0.10583,0.13597,0.15574,0.17677,0.19860,0.22263,0.24392,
     &0.25908,0.27116,0.28157,0.29022,0.29801,0.30726,0.30877,0.31960,
     &0.32730,0.33250,0.33755,0.34205,0.34801,0.35392,0.35735,0.36153,
     &0.36688,0.37231,0.37800,0.38586,0.39587,0.40846,0.41981,0.43944,
     &0.46031,0.49018,0.52056,0.54825,0.59284,0.63284,0.66804,0.00000,
     &0.08170,0.10566,0.13707,0.15507,0.17659,0.19777,0.22175,0.24235,
     &0.25830,0.26976,0.27921,0.28815,0.29636,0.30521,0.31157,0.31908,
     &0.32413,0.32379,0.33143,0.33655,0.34239,0.34538,0.34794,0.35086,
     &0.35470,0.35813,0.36090,0.36570,0.36844,0.37434,0.37878,0.38584,
     &0.39470,0.40535,0.41823,0.43417,0.45231,0.47286,0.50063,0.00000,
     &0.08131,0.10568,0.13814,0.15544,0.17656,0.19763,0.22150,0.24336,
     &0.25790,0.26928,0.27768,0.28681,0.29534,0.30264,0.31062,0.31684,
     &0.32270,0.32804,0.33193,0.33464,0.33962,0.34393,0.34898,0.35022,
     &0.35437,0.35495,0.35868,0.36108,0.36417,0.36715,0.37028,0.37343,
     &0.37833,0.38172,0.38699,0.39296,0.40153,0.41118,0.41825,0.00000,
     &0.08087,0.10537,0.13928,0.15526,0.17688,0.19811,0.22212,0.24215,
     &0.25755,0.26733,0.27576,0.28450,0.29420,0.30274,0.30959,0.31619,
     &0.32121,0.32674,0.33150,0.33551,0.34193,0.34539,0.34713,0.35252,
     &0.35581,0.35712,0.36038,0.36352,0.36498,0.36834,0.37132,0.37209,
     &0.37562,0.37903,0.38058,0.38526,0.38857,0.39028,0.39740,0.00000,
     &0.08070,0.10555,0.14035,0.15571,0.17725,0.19855,0.22249,0.24486,
     &0.25692,0.26522,0.27543,0.28462,0.29264,0.30068,0.30790,0.31501,
     &0.32092,0.32740,0.33195,0.33587,0.34337,0.34653,0.35177,0.35521,
     &0.35809,0.36109,0.36531,0.36807,0.37027,0.37226,0.37588,0.37673,
     &0.37683,0.38082,0.38457,0.38623,0.38993,0.39140,0.39724,0.00000,
     &0.08062,0.10514,0.14178,0.15518,0.17750,0.19814,0.22276,0.24391,
     &0.25857,0.26697,0.27500,0.28284,0.28997,0.29821,0.30728,0.31079,
     &0.31951,0.32327,0.32989,0.33486,0.34145,0.34622,0.35225,0.35693,
     &0.36179,0.36669,0.37154,0.37213,0.37709,0.37966,0.38166,0.38233,
     &0.38457,0.38556,0.38821,0.39047,0.39406,0.39872,0.40334,0.00000,
     &0.08076,0.10551,0.14269,0.15535,0.17771,0.20003,0.22234,0.24317,
     &0.25926,0.26722,0.27644,0.28471,0.29039,0.29541,0.30581,0.31218,
     &0.31881,0.32496,0.32865,0.33659,0.34354,0.34692,0.35438,0.35517,
     &0.36220,0.36698,0.36889,0.37400,0.37807,0.38311,0.38811,0.39077,
     &0.39348,0.39339,0.39868,0.39668,0.40082,0.40150,0.40377,0.00000/
c::::::::::::::
capt-01-02-block.f
c::::::::::::::
      Data ((CF(K,l, 2, 1),K=1,40),l=1,13)/
     &0.07650,0.09758,0.12254,0.14157,0.14361,0.15656,0.18662,0.25212,
     &0.15966,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08867,0.11070,0.13895,0.17411,0.21726,0.27460,0.33165,0.37013,
     &0.39500,0.39748,0.36420,0.31416,0.18222,0.14346,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08819,0.10925,0.13606,0.16564,0.19573,0.22820,0.26771,0.30044,
     &0.32998,0.35685,0.38513,0.41405,0.44304,0.47291,0.49725,0.52466,
     &0.55804,0.58453,0.57548,0.52584,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08640,0.10933,0.13684,0.16237,0.18916,0.21669,0.24722,0.26840,
     &0.29822,0.31696,0.33572,0.35241,0.36968,0.38784,0.40772,0.42793,
     &0.44574,0.46374,0.48159,0.49986,0.52438,0.54452,0.56119,0.56798,
     &0.54019,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08268,0.10864,0.13743,0.16112,0.18741,0.21325,0.24063,0.26429,
     &0.28221,0.29145,0.30523,0.32454,0.33545,0.34919,0.35936,0.37105,
     &0.38307,0.39563,0.40540,0.41710,0.43205,0.44535,0.45870,0.47862,
     &0.50084,0.52392,0.55268,0.58478,0.58959,0.55504,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08138,0.10803,0.13904,0.16056,0.18533,0.21173,0.23930,0.26116,
     &0.27905,0.29277,0.30489,0.31590,0.31731,0.33549,0.34500,0.35215,
     &0.36113,0.36636,0.37371,0.38097,0.39122,0.39735,0.40430,0.41091,
     &0.42201,0.43250,0.44613,0.46321,0.48438,0.50731,0.53786,0.57606,
     &0.60719,0.61220,0.56719,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08097,0.10806,0.14015,0.16008,0.18488,0.21066,0.23770,0.25920,
     &0.27700,0.28939,0.30196,0.31128,0.32331,0.33205,0.33605,0.34149,
     &0.35197,0.35695,0.36126,0.36502,0.37323,0.37733,0.38201,0.38603,
     &0.38969,0.39338,0.40138,0.40901,0.41851,0.42564,0.43963,0.45432,
     &0.47207,0.49583,0.52213,0.55634,0.59113,0.62921,0.62859,0.00000,
     &0.08052,0.10784,0.14092,0.15970,0.18472,0.20957,0.23562,0.25865,
     &0.27481,0.28716,0.29968,0.31036,0.32026,0.32895,0.33514,0.34201,
     &0.34820,0.34988,0.35676,0.36125,0.36705,0.37021,0.37380,0.37560,
     &0.37834,0.38146,0.38608,0.38929,0.39266,0.39685,0.40160,0.40850,
     &0.41666,0.42452,0.43413,0.44951,0.46821,0.48181,0.51162,0.00000,
     &0.08017,0.10807,0.14174,0.16005,0.18483,0.20914,0.23478,0.25609,
     &0.27302,0.28606,0.29808,0.30804,0.31937,0.32735,0.33526,0.34137,
     &0.34854,0.35331,0.35794,0.35979,0.36498,0.37093,0.37294,0.37519,
     &0.37875,0.38124,0.38606,0.38826,0.38764,0.39026,0.39602,0.39590,
     &0.39922,0.40291,0.40767,0.41344,0.42081,0.42745,0.44021,0.00000,
     &0.07994,0.10786,0.14222,0.15957,0.18327,0.20895,0.23319,0.25552,
     &0.27059,0.28343,0.29383,0.30709,0.31747,0.32608,0.33384,0.33983,
     &0.34601,0.35240,0.35785,0.36122,0.36813,0.37160,0.37314,0.37838,
     &0.38146,0.38429,0.38565,0.38916,0.39031,0.39430,0.39362,0.39596,
     &0.39938,0.40327,0.40416,0.41001,0.41047,0.41475,0.41776,0.00000,
     &0.07990,0.10803,0.14357,0.15986,0.18323,0.20831,0.23257,0.25471,
     &0.26844,0.28174,0.29255,0.30349,0.31436,0.32257,0.33147,0.33897,
     &0.34613,0.35240,0.35705,0.36111,0.36881,0.37213,0.37944,0.38295,
     &0.38537,0.38691,0.39145,0.40547,0.39820,0.39818,0.40114,0.40138,
     &0.40413,0.40595,0.41027,0.41088,0.41550,0.41943,0.42111,0.00000,
     &0.08002,0.10845,0.14489,0.15862,0.18413,0.20757,0.23291,0.25348,
     &0.26974,0.28175,0.29182,0.30248,0.31145,0.31911,0.32848,0.33711,
     &0.34362,0.35072,0.35453,0.35960,0.36854,0.37415,0.37811,0.38287,
     &0.38941,0.39215,0.39699,0.40036,0.40351,0.40872,0.40975,0.41283,
     &0.41199,0.41548,0.41552,0.41724,0.42368,0.42496,0.42959,0.00000,
     &0.07970,0.10754,0.14511,0.15855,0.18321,0.20803,0.23230,0.25294,
     &0.26895,0.28118,0.29124,0.30296,0.31256,0.31864,0.32665,0.33530,
     &0.34042,0.34964,0.35593,0.36176,0.37117,0.37450,0.38020,0.38245,
     &0.39067,0.39572,0.39695,0.40452,0.40764,0.41181,0.41590,0.42224,
     &0.42274,0.42435,0.42754,0.42771,0.42793,0.43127,0.43109,0.00000/
c::::::::::::::
capt-01-03-block.f
c::::::::::::::
      Data ((CF(K,l, 3, 1),K=1,40),l=1,13)/
     &0.08816,0.11078,0.13971,0.17428,0.21250,0.28773,0.37341,0.29636,
     &0.16123,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08270,0.11164,0.14088,0.17447,0.21927,0.26994,0.31789,0.35368,
     &0.38228,0.39304,0.33232,0.27514,0.23359,0.15317,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08153,0.10821,0.13763,0.16388,0.19612,0.22971,0.26512,0.29746,
     &0.32282,0.34751,0.37300,0.39994,0.42679,0.45314,0.47856,0.51291,
     &0.54281,0.55935,0.55874,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08116,0.10908,0.13886,0.16211,0.18885,0.21708,0.24767,0.26981,
     &0.29960,0.31841,0.33701,0.35342,0.37116,0.38810,0.40506,0.42388,
     &0.43984,0.45833,0.47772,0.49507,0.52077,0.54803,0.57202,0.61559,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08072,0.10865,0.13973,0.16114,0.18681,0.21465,0.24203,0.26628,
     &0.28459,0.29497,0.31140,0.32798,0.34098,0.35298,0.36400,0.37369,
     &0.38478,0.39484,0.40515,0.41705,0.43160,0.44721,0.46037,0.48078,
     &0.50423,0.52631,0.55955,0.59831,0.64524,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08027,0.10821,0.14020,0.16029,0.18626,0.21300,0.23935,0.26228,
     &0.28028,0.29435,0.30690,0.31948,0.32136,0.34086,0.35046,0.35786,
     &0.36472,0.37280,0.37877,0.38376,0.39286,0.40046,0.40698,0.41403,
     &0.42432,0.43810,0.45067,0.47038,0.49125,0.51379,0.54597,0.57725,
     &0.62118,0.65765,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08025,0.10842,0.14097,0.15993,0.18578,0.21110,0.23708,0.26062,
     &0.27811,0.29092,0.30272,0.31516,0.32467,0.33408,0.34029,0.34505,
     &0.35592,0.36007,0.36673,0.36976,0.37649,0.37962,0.38390,0.38875,
     &0.39353,0.39763,0.40467,0.41199,0.42143,0.43051,0.44453,0.45807,
     &0.47883,0.50040,0.52411,0.55838,0.59648,0.63959,0.69648,0.00000,
     &0.08006,0.10815,0.14155,0.15947,0.18510,0.20987,0.23495,0.25826,
     &0.27502,0.28734,0.29902,0.31006,0.32165,0.33072,0.33740,0.34474,
     &0.35052,0.35245,0.35964,0.36510,0.36873,0.37321,0.37622,0.37953,
     &0.38279,0.38405,0.38785,0.39258,0.39566,0.40070,0.40663,0.41336,
     &0.42146,0.42999,0.44049,0.45528,0.47168,0.49310,0.51413,0.00000,
     &0.07995,0.10803,0.14250,0.15996,0.18462,0.20942,0.23514,0.25611,
     &0.27210,0.28594,0.29727,0.30906,0.31802,0.32797,0.33614,0.34390,
     &0.34900,0.35471,0.35812,0.36237,0.36708,0.37389,0.37551,0.37837,
     &0.37951,0.38311,0.38676,0.39002,0.39233,0.39587,0.39751,0.39975,
     &0.40477,0.41007,0.41739,0.42324,0.42788,0.43677,0.44533,0.00000,
     &0.07967,0.10807,0.14362,0.15943,0.18368,0.20739,0.23303,0.25500,
     &0.27088,0.28278,0.29477,0.30563,0.31605,0.32524,0.33363,0.34071,
     &0.34799,0.35397,0.35831,0.36194,0.36876,0.37167,0.37279,0.38044,
     &0.38206,0.38570,0.38891,0.39032,0.39173,0.39618,0.39622,0.40080,
     &0.40427,0.40606,0.40986,0.41567,0.41326,0.42029,0.42688,0.00000,
     &0.07961,0.10777,0.14426,0.15975,0.18446,0.20761,0.23267,0.25284,
     &0.26818,0.28006,0.29111,0.30271,0.31353,0.32311,0.33265,0.33996,
     &0.34565,0.35381,0.35621,0.36139,0.36991,0.37511,0.37878,0.38233,
     &0.38494,0.38861,0.39360,0.39807,0.40007,0.40043,0.40315,0.40617,
     &0.40903,0.41213,0.41274,0.41660,0.41965,0.42343,0.42330,0.00000,
     &0.07964,0.10773,0.14470,0.15851,0.18415,0.20652,0.23268,0.25264,
     &0.26843,0.27957,0.29242,0.30114,0.30979,0.31972,0.32750,0.33666,
     &0.34206,0.35031,0.35507,0.36029,0.36853,0.37387,0.37830,0.38347,
     &0.38801,0.39403,0.39693,0.40145,0.40723,0.40856,0.41028,0.41535,
     &0.41501,0.41635,0.41839,0.42164,0.42393,0.42906,0.43262,0.00000,
     &0.07955,0.10832,0.14522,0.15855,0.18267,0.20761,0.23140,0.25341,
     &0.26793,0.28045,0.29053,0.30108,0.31100,0.32032,0.32670,0.33537,
     &0.34305,0.34966,0.35626,0.36167,0.36983,0.37317,0.37782,0.38409,
     &0.38870,0.39333,0.39816,0.40058,0.40900,0.41198,0.41424,0.42094,
     &0.42427,0.42740,0.42674,0.43196,0.43135,0.43178,0.43525,0.00000/
c::::::::::::::
capt-01-04-block.f
c::::::::::::::
      Data ((CF(K,l, 4, 1),K=1,40),l=1,13)/
     &0.06950,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08984,0.11352,0.14038,0.16855,0.20439,0.24433,0.28019,0.29585,
     &0.31202,0.31416,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08740,0.10603,0.13117,0.16344,0.19954,0.21867,0.22329,0.25127,
     &0.31620,0.38635,0.42015,0.42437,0.42687,0.43297,0.43561,0.44471,
     &0.46272,0.47265,0.46366,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08683,0.10792,0.13357,0.16413,0.19834,0.23240,0.26444,0.29282,
     &0.31794,0.33842,0.35001,0.36602,0.38263,0.40887,0.44359,0.48213,
     &0.51475,0.51644,0.51429,0.50540,0.51295,0.51380,0.52189,0.52918,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08354,0.10711,0.13442,0.16376,0.19894,0.23062,0.26364,0.29232,
     &0.31645,0.33448,0.35486,0.36806,0.37898,0.39065,0.40004,0.41007,
     &0.42613,0.43990,0.44303,0.45239,0.45909,0.46975,0.48379,0.48838,
     &0.49800,0.51419,0.51966,0.55540,0.58725,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08685,0.11120,0.13257,0.16348,0.20296,0.23462,0.26375,0.28832,
     &0.31538,0.33722,0.34724,0.36326,0.37688,0.38783,0.39562,0.40369,
     &0.40846,0.40667,0.41762,0.42613,0.43236,0.43073,0.44279,0.44662,
     &0.45072,0.45727,0.46819,0.47764,0.49054,0.50935,0.53470,0.55446,
     &0.58687,0.62385,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08676,0.10617,0.13417,0.16790,0.19889,0.23515,0.26222,0.29153,
     &0.31356,0.33838,0.35451,0.36763,0.37576,0.38890,0.39105,0.39965,
     &0.40720,0.40343,0.41207,0.41355,0.41612,0.41987,0.42378,0.42824,
     &0.43385,0.43514,0.44200,0.44330,0.45164,0.45831,0.46672,0.47210,
     &0.48783,0.50353,0.52711,0.54670,0.58481,0.60590,0.65075,0.00000,
     &0.08703,0.11107,0.13057,0.16430,0.19908,0.23295,0.26479,0.29560,
     &0.31739,0.33976,0.35351,0.36892,0.37843,0.38666,0.39447,0.40140,
     &0.40299,0.40509,0.41092,0.41204,0.41640,0.41720,0.42542,0.42340,
     &0.42451,0.43013,0.43028,0.43664,0.43931,0.44317,0.44319,0.44626,
     &0.45650,0.45807,0.46493,0.47350,0.49120,0.49656,0.51591,0.00000,
     &0.08783,0.11203,0.12842,0.16792,0.20373,0.23304,0.26528,0.29420,
     &0.32163,0.33228,0.35570,0.36602,0.37798,0.39427,0.39967,0.40586,
     &0.41031,0.41159,0.41753,0.42166,0.42172,0.42931,0.42823,0.42974,
     &0.43732,0.43252,0.43601,0.44103,0.44041,0.44759,0.45154,0.45163,
     &0.45212,0.44996,0.45577,0.45723,0.47219,0.46632,0.47552,0.00000,
     &0.09000,0.11443,0.13143,0.16781,0.20350,0.24084,0.26285,0.29707,
     &0.31966,0.33674,0.35866,0.36967,0.38497,0.38951,0.40359,0.40882,
     &0.41517,0.41852,0.42319,0.42452,0.42346,0.43019,0.43679,0.43740,
     &0.44542,0.44640,0.45078,0.44681,0.44642,0.45578,0.45271,0.46180,
     &0.46532,0.46432,0.45886,0.46753,0.47242,0.46939,0.47394,0.00000,
     &0.08406,0.10741,0.13612,0.16567,0.18900,0.22991,0.26347,0.29853,
     &0.32216,0.34137,0.35353,0.37633,0.38616,0.39585,0.40589,0.41024,
     &0.41028,0.42306,0.42433,0.43172,0.43834,0.44391,0.44674,0.45492,
     &0.46493,0.46336,0.46625,0.46768,0.47100,0.47190,0.47177,0.46795,
     &0.47353,0.47947,0.48149,0.48236,0.49073,0.49605,0.49441,0.00000,
     &0.08693,0.11860,0.13750,0.16962,0.20373,0.23091,0.27094,0.29371,
     &0.32257,0.33673,0.36317,0.37018,0.38780,0.38939,0.40433,0.40998,
     &0.41062,0.42754,0.42786,0.44114,0.44673,0.45607,0.45846,0.46223,
     &0.47371,0.48367,0.49237,0.48923,0.48829,0.49965,0.49457,0.48688,
     &0.49199,0.49560,0.50086,0.49417,0.49925,0.50255,0.50747,0.00000,
     &0.08317,0.10670,0.12873,0.16755,0.18977,0.24111,0.26461,0.29457,
     &0.31804,0.33571,0.35243,0.37444,0.39079,0.39634,0.39662,0.40852,
     &0.41672,0.42407,0.44541,0.44239,0.45097,0.46246,0.46414,0.47303,
     &0.48022,0.47917,0.48842,0.49210,0.50475,0.50351,0.51495,0.51557,
     &0.52485,0.52457,0.52676,0.52628,0.52386,0.52226,0.52432,0.00000/
c::::::::::::::
capt-01-05-block.f
c::::::::::::::
      Data ((CF(K,l, 5, 1),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.09218,0.10561,0.13109,0.15869,0.18735,0.22153,0.24698,0.28038,
     &0.31215,0.33830,0.35640,0.37233,0.38311,0.39070,0.41708,0.44041,
     &0.46930,0.48484,0.48290,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08907,0.10351,0.13178,0.16371,0.18609,0.22558,0.24510,0.27232,
     &0.29672,0.31789,0.33185,0.35236,0.36864,0.38602,0.40423,0.41694,
     &0.42897,0.44061,0.44451,0.45824,0.48843,0.50046,0.53864,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.09053,0.10222,0.12297,0.15858,0.19358,0.22527,0.24958,0.27155,
     &0.29452,0.31280,0.32470,0.34252,0.36053,0.37014,0.37933,0.38749,
     &0.39586,0.40743,0.41326,0.42133,0.43103,0.44558,0.45206,0.46560,
     &0.48289,0.50182,0.55319,0.56585,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.07879,0.11060,0.14143,0.16500,0.18868,0.21095,0.25221,0.28004,
     &0.29025,0.31018,0.32681,0.34333,0.35668,0.36614,0.37908,0.38885,
     &0.39574,0.39859,0.39573,0.40845,0.41333,0.41695,0.42301,0.43102,
     &0.43805,0.44494,0.45774,0.46616,0.48385,0.49945,0.52321,0.55859,
     &0.58008,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.09346,0.10967,0.13760,0.16163,0.19133,0.22353,0.25103,0.27405,
     &0.29015,0.30715,0.32818,0.35091,0.35972,0.37350,0.37773,0.38882,
     &0.38414,0.39282,0.39508,0.40382,0.40663,0.40933,0.41257,0.41768,
     &0.41718,0.42510,0.42873,0.43274,0.44206,0.44723,0.45576,0.47176,
     &0.47958,0.49826,0.51382,0.53412,0.55582,0.58777,0.00000,0.00000,
     &0.08766,0.10404,0.13105,0.16621,0.19228,0.23098,0.25342,0.26979,
     &0.29621,0.32100,0.33372,0.34894,0.36233,0.37401,0.38266,0.38854,
     &0.39163,0.40109,0.40156,0.40579,0.40550,0.40808,0.41297,0.41475,
     &0.41420,0.42339,0.42515,0.42793,0.43094,0.43228,0.43950,0.44995,
     &0.45027,0.45196,0.46447,0.46776,0.47899,0.49856,0.50944,0.00000,
     &0.07524,0.10359,0.12717,0.16653,0.20233,0.22763,0.25116,0.27844,
     &0.29628,0.31395,0.33649,0.35376,0.36619,0.37716,0.38501,0.39675,
     &0.39414,0.40425,0.40581,0.40556,0.41486,0.41776,0.41866,0.41872,
     &0.42387,0.42460,0.42359,0.42704,0.43443,0.43966,0.43944,0.44265,
     &0.44519,0.45033,0.45126,0.45897,0.46305,0.46763,0.47077,0.00000,
     &0.07785,0.10271,0.13261,0.16459,0.18852,0.22503,0.26319,0.27311,
     &0.30581,0.30905,0.33685,0.34791,0.35979,0.37949,0.38976,0.39425,
     &0.40365,0.40685,0.41052,0.41501,0.42285,0.42230,0.42610,0.43448,
     &0.43530,0.43821,0.43605,0.44342,0.44242,0.44563,0.45070,0.45033,
     &0.45828,0.46031,0.46035,0.46742,0.47040,0.47618,0.48397,0.00000,
     &0.08317,0.09345,0.13828,0.16525,0.17932,0.21054,0.24792,0.28153,
     &0.29904,0.31425,0.33410,0.34780,0.37019,0.37695,0.38639,0.39502,
     &0.40106,0.40707,0.41274,0.42261,0.42640,0.43022,0.43506,0.43959,
     &0.44146,0.44928,0.45632,0.45630,0.46337,0.45809,0.46720,0.46822,
     &0.46597,0.47577,0.47588,0.47866,0.48913,0.48980,0.49351,0.00000,
     &0.08810,0.10375,0.14068,0.16700,0.19760,0.21890,0.25152,0.27988,
     &0.29346,0.31184,0.32606,0.34860,0.36266,0.37308,0.39790,0.39359,
     &0.40993,0.40510,0.41789,0.42235,0.42708,0.43670,0.44363,0.45040,
     &0.45397,0.46758,0.46925,0.47423,0.47970,0.47981,0.48881,0.48859,
     &0.49284,0.48333,0.49459,0.49226,0.50280,0.50429,0.50282,0.00000,
     &0.08658,0.07750,0.13594,0.16677,0.16175,0.22875,0.24523,0.27323,
     &0.29562,0.31546,0.32108,0.34685,0.36250,0.37295,0.38553,0.40006,
     &0.40586,0.41917,0.41603,0.41924,0.43249,0.44323,0.44858,0.45389,
     &0.45951,0.46390,0.46931,0.47929,0.48198,0.49032,0.50196,0.50538,
     &0.50662,0.51171,0.51801,0.52205,0.52259,0.53064,0.52084,0.00000/
c::::::::::::::
capt-01-06-block.f
c::::::::::::::
      Data ((CF(K,l, 6, 1),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.09036,0.11334,0.13901,0.17116,0.20224,0.24024,0.27408,0.30046,
     &0.31392,0.30511,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08900,0.10804,0.13467,0.16264,0.19770,0.21945,0.22996,0.25424,
     &0.31234,0.37686,0.40803,0.41222,0.41953,0.42834,0.44164,0.46230,
     &0.49117,0.50538,0.51496,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08537,0.10888,0.13533,0.16643,0.19512,0.23030,0.26018,0.28817,
     &0.31079,0.33145,0.34923,0.36653,0.38604,0.40578,0.43442,0.46595,
     &0.48976,0.49712,0.49760,0.49427,0.50197,0.51197,0.53208,0.55961,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08842,0.10833,0.13463,0.16792,0.19258,0.22751,0.25806,0.29062,
     &0.30700,0.32945,0.34438,0.36166,0.37753,0.38678,0.39714,0.40629,
     &0.41773,0.42876,0.43669,0.44344,0.45163,0.46163,0.46497,0.47575,
     &0.48839,0.50780,0.53867,0.56432,0.60254,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08447,0.11175,0.12895,0.16710,0.19294,0.22705,0.26254,0.28305,
     &0.30790,0.32752,0.34379,0.36469,0.37706,0.38575,0.39242,0.40254,
     &0.40498,0.41158,0.41364,0.42028,0.42491,0.42978,0.43495,0.44354,
     &0.44913,0.44994,0.46637,0.47302,0.48412,0.50356,0.53289,0.55931,
     &0.58558,0.60733,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08353,0.10750,0.12982,0.16843,0.19483,0.23417,0.25880,0.28886,
     &0.30814,0.32839,0.34949,0.36374,0.37501,0.38846,0.39295,0.39740,
     &0.40154,0.40554,0.41060,0.41536,0.41673,0.42071,0.42089,0.42439,
     &0.42789,0.43207,0.43707,0.44280,0.44345,0.45582,0.46284,0.47175,
     &0.48420,0.50059,0.51940,0.54150,0.57967,0.60550,0.62530,0.00000,
     &0.08446,0.11567,0.13558,0.16548,0.20153,0.23235,0.26524,0.28835,
     &0.31023,0.32689,0.35227,0.36320,0.37933,0.38593,0.39371,0.40154,
     &0.40214,0.40690,0.41263,0.41391,0.41538,0.41855,0.41954,0.42196,
     &0.42287,0.42980,0.43027,0.43339,0.43762,0.44197,0.44416,0.44935,
     &0.45215,0.45741,0.46980,0.47667,0.48259,0.50321,0.51077,0.00000,
     &0.09079,0.11183,0.13434,0.16269,0.19485,0.23312,0.26295,0.29428,
     &0.31069,0.33058,0.34712,0.36407,0.37986,0.39051,0.39762,0.40374,
     &0.40868,0.40925,0.41237,0.41850,0.42175,0.42400,0.42722,0.43249,
     &0.43264,0.43344,0.43729,0.43741,0.43836,0.43992,0.44696,0.44838,
     &0.45190,0.45495,0.46127,0.45837,0.46608,0.47153,0.47723,0.00000,
     &0.08614,0.10689,0.13953,0.16365,0.20206,0.23237,0.25690,0.28490,
     &0.31131,0.33255,0.35503,0.36369,0.38221,0.39187,0.39885,0.40298,
     &0.41124,0.41295,0.42262,0.42319,0.42943,0.43244,0.43690,0.44092,
     &0.44223,0.44366,0.44877,0.45102,0.45153,0.45613,0.45704,0.45871,
     &0.45982,0.46691,0.46752,0.47411,0.47095,0.47439,0.47472,0.00000,
     &0.09189,0.10416,0.13906,0.16044,0.19240,0.23143,0.26301,0.28721,
     &0.31007,0.32768,0.34819,0.36363,0.38315,0.39714,0.40447,0.40924,
     &0.41488,0.41972,0.42453,0.43005,0.43488,0.44241,0.44792,0.45350,
     &0.45501,0.46110,0.46491,0.46683,0.47092,0.47136,0.47460,0.47725,
     &0.47717,0.47910,0.48301,0.48519,0.49000,0.49127,0.49518,0.00000,
     &0.08638,0.10558,0.12860,0.16349,0.20007,0.22860,0.25840,0.28268,
     &0.31473,0.33096,0.34769,0.36714,0.38240,0.39353,0.39924,0.40598,
     &0.41445,0.42187,0.42752,0.43205,0.43867,0.44615,0.45534,0.46160,
     &0.47084,0.47099,0.49128,0.48334,0.48526,0.48601,0.49608,0.49782,
     &0.49631,0.50456,0.49902,0.50237,0.50712,0.50862,0.51582,0.00000,
     &0.08338,0.11418,0.12689,0.16452,0.19287,0.23531,0.26196,0.28584,
     &0.31409,0.33094,0.34694,0.36701,0.37998,0.39088,0.40308,0.41114,
     &0.41432,0.42467,0.43367,0.44291,0.44971,0.45402,0.45573,0.46786,
     &0.47003,0.47533,0.48370,0.49193,0.49590,0.49848,0.50658,0.51617,
     &0.51748,0.52807,0.53160,0.52852,0.52959,0.52802,0.53223,0.00000/
c::::::::::::::
capt-01-07-block.f
c::::::::::::::
      Data ((CF(K,l, 7, 1),K=1,40),l=1,13)/
     &0.08833,0.11167,0.14080,0.17697,0.22184,0.27669,0.34196,0.37806,
     &0.33933,0.43346,0.46453,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08844,0.11142,0.14100,0.17728,0.22223,0.27708,0.34257,0.39025,
     &0.35334,0.45139,0.53096,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08727,0.10926,0.13671,0.17062,0.21192,0.26051,0.31402,0.35944,
     &0.38959,0.43380,0.49116,0.54255,0.60231,0.67951,0.70790,0.70273,
     &0.66876,0.68257,0.66882,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08668,0.10813,0.13502,0.16758,0.20729,0.25606,0.30920,0.36134,
     &0.40027,0.43551,0.47383,0.51540,0.56149,0.59436,0.62124,0.63751,
     &0.64456,0.62933,0.59745,0.57541,0.55400,0.53247,0.51447,0.52132,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08652,0.10815,0.13458,0.16680,0.20685,0.25414,0.30743,0.36068,
     &0.40258,0.43943,0.47915,0.51735,0.55422,0.57802,0.59476,0.59462,
     &0.58724,0.57968,0.56285,0.55795,0.53529,0.53240,0.53041,0.54671,
     &0.55610,0.56299,0.57921,0.55940,0.55948,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08652,0.10792,0.13414,0.16698,0.20671,0.25544,0.30916,0.36356,
     &0.40783,0.44959,0.48916,0.53052,0.56260,0.58833,0.60366,0.59643,
     &0.57832,0.56004,0.54326,0.54217,0.53321,0.53325,0.52648,0.52274,
     &0.51883,0.51832,0.52550,0.53217,0.54572,0.58132,0.60398,0.62029,
     &0.63677,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08660,0.10808,0.13493,0.16771,0.20868,0.25649,0.31140,0.36827,
     &0.41595,0.46075,0.50197,0.54199,0.57768,0.59574,0.61205,0.61190,
     &0.58936,0.56710,0.54755,0.53702,0.52894,0.52596,0.51706,0.51255,
     &0.52010,0.51631,0.51021,0.50525,0.51185,0.51346,0.52000,0.53716,
     &0.55992,0.57911,0.61519,0.63989,0.67326,0.67900,0.67273,0.00000,
     &0.08702,0.10837,0.13527,0.16798,0.20822,0.25802,0.31385,0.37128,
     &0.42160,0.46970,0.51082,0.54653,0.58265,0.60363,0.62018,0.61387,
     &0.60381,0.56917,0.54995,0.53723,0.52799,0.52398,0.51814,0.51172,
     &0.51368,0.50638,0.50471,0.50999,0.50673,0.50630,0.50559,0.51003,
     &0.51638,0.51851,0.52282,0.54002,0.55000,0.56778,0.60151,0.00000,
     &0.08682,0.10833,0.13525,0.16811,0.20867,0.25881,0.31605,0.37349,
     &0.42627,0.47525,0.51770,0.55545,0.58719,0.61188,0.62393,0.62046,
     &0.60645,0.58281,0.56366,0.54525,0.53973,0.53166,0.52871,0.51988,
     &0.52241,0.52210,0.51924,0.51629,0.51376,0.51432,0.51646,0.51386,
     &0.51336,0.51748,0.52184,0.52035,0.52579,0.52525,0.53722,0.00000,
     &0.08724,0.10817,0.13535,0.16915,0.21002,0.26046,0.31726,0.37531,
     &0.43126,0.47786,0.52224,0.56106,0.59137,0.61255,0.63414,0.62921,
     &0.61028,0.58728,0.56354,0.55515,0.55301,0.54569,0.53798,0.53256,
     &0.53808,0.53445,0.53038,0.53532,0.53011,0.52744,0.52657,0.52474,
     &0.53437,0.53083,0.54025,0.54827,0.53624,0.54481,0.54613,0.00000,
     &0.08675,0.10819,0.13547,0.16909,0.21040,0.26039,0.31858,0.37604,
     &0.43066,0.48231,0.52118,0.56282,0.59456,0.61211,0.63749,0.64194,
     &0.63082,0.60598,0.58204,0.57618,0.56263,0.56672,0.56232,0.55039,
     &0.55984,0.56151,0.56244,0.56172,0.56697,0.56701,0.56759,0.56374,
     &0.56632,0.56311,0.57634,0.57199,0.56527,0.56753,0.57114,0.00000,
     &0.08693,0.10845,0.13525,0.16858,0.21149,0.26002,0.31784,0.37482,
     &0.42855,0.48376,0.52436,0.56664,0.60181,0.62625,0.64647,0.65429,
     &0.63341,0.62498,0.58648,0.58157,0.57808,0.56962,0.55364,0.55667,
     &0.56683,0.56729,0.58466,0.58874,0.58371,0.59464,0.60394,0.60429,
     &0.59488,0.59356,0.60304,0.60151,0.59760,0.60050,0.61819,0.00000,
     &0.08688,0.10805,0.13513,0.16897,0.20953,0.26002,0.31631,0.37564,
     &0.43198,0.47733,0.52113,0.56060,0.60269,0.63712,0.65374,0.66533,
     &0.65639,0.63443,0.61327,0.58149,0.58744,0.57477,0.57442,0.58236,
     &0.57824,0.58937,0.58123,0.59628,0.60197,0.60259,0.61726,0.62043,
     &0.63609,0.63967,0.64766,0.64879,0.64929,0.64784,0.64166,0.00000/
c::::::::::::::
capt-01-08-block.f
c::::::::::::::
      Data ((CF(K,l, 8, 1),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.14175,0.15467,0.18240,0.23400,0.27530,0.28553,
     &0.36090,0.33319,0.33383,0.37201,0.38201,0.41263,0.44117,0.45035,
     &0.47726,0.45907,0.43665,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.14067,0.17700,0.17129,0.20200,0.28800,0.31605,0.33778,
     &0.38333,0.36349,0.35535,0.37508,0.37877,0.40158,0.42028,0.43400,
     &0.45160,0.47169,0.48692,0.48698,0.49603,0.50706,0.52331,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.09400,0.00000,0.08133,0.11725,0.20738,0.22975,0.30929,0.31640,
     &0.32562,0.36288,0.39351,0.40084,0.40580,0.42961,0.45424,0.46710,
     &0.47229,0.46392,0.46058,0.46469,0.47782,0.47995,0.50097,0.51602,
     &0.54068,0.56556,0.59883,0.55900,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.14150,0.14500,0.22050,0.28117,0.23124,0.34387,
     &0.37542,0.38686,0.39930,0.39840,0.40272,0.42159,0.45600,0.46891,
     &0.46462,0.46958,0.46454,0.46296,0.46623,0.46686,0.47369,0.47685,
     &0.48579,0.49620,0.50896,0.53138,0.55569,0.59577,0.64008,0.66190,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.12067,0.00000,0.09067,0.24333,0.26529,0.29518,0.30563,
     &0.37664,0.37437,0.37505,0.39827,0.40944,0.43050,0.44698,0.46347,
     &0.46702,0.46380,0.45733,0.45978,0.46451,0.46431,0.46552,0.47576,
     &0.47492,0.47948,0.48075,0.49364,0.49473,0.51261,0.52160,0.53494,
     &0.55584,0.59157,0.62133,0.68585,0.70196,0.76476,0.00000,0.00000,
     &0.09167,0.00000,0.06700,0.18450,0.13100,0.27431,0.31444,0.32571,
     &0.32952,0.37376,0.39050,0.39978,0.42094,0.43188,0.45017,0.46195,
     &0.46235,0.46632,0.46488,0.45583,0.46450,0.46294,0.46869,0.47312,
     &0.47410,0.47426,0.47537,0.48090,0.48516,0.48306,0.49171,0.50292,
     &0.50344,0.51218,0.52626,0.54389,0.56082,0.59457,0.60608,0.00000,
     &0.00000,0.00000,0.14133,0.20333,0.23417,0.26400,0.28108,0.30876,
     &0.38402,0.39851,0.35491,0.40162,0.43586,0.43056,0.43609,0.45323,
     &0.46148,0.45124,0.45743,0.46774,0.47193,0.47047,0.47923,0.48417,
     &0.48208,0.49002,0.49152,0.49123,0.49217,0.49167,0.50229,0.50324,
     &0.50509,0.51076,0.51510,0.52378,0.52532,0.53331,0.53682,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.24167,0.24983,0.31491,0.27989,
     &0.38896,0.40262,0.38257,0.40247,0.41124,0.43211,0.45622,0.46854,
     &0.45886,0.46073,0.46366,0.46970,0.47561,0.48334,0.48618,0.49565,
     &0.49157,0.50975,0.50712,0.51090,0.50743,0.51929,0.52042,0.51973,
     &0.52977,0.52880,0.53242,0.53481,0.54700,0.54643,0.54255,0.00000,
     &0.00000,0.00000,0.00000,0.20233,0.00000,0.23820,0.29922,0.30906,
     &0.38221,0.35054,0.41746,0.40949,0.41078,0.44990,0.44234,0.45791,
     &0.46648,0.47571,0.47348,0.47434,0.48540,0.49309,0.48896,0.51066,
     &0.52095,0.52943,0.53085,0.54182,0.54165,0.55315,0.54993,0.54930,
     &0.55853,0.55538,0.55677,0.56559,0.56778,0.57213,0.58356,0.00000,
     &0.00000,0.00000,0.00000,0.16900,0.18650,0.25820,0.21740,0.36025,
     &0.35250,0.35937,0.36585,0.40915,0.42343,0.42988,0.45292,0.47557,
     &0.46743,0.47045,0.48054,0.48675,0.49213,0.49492,0.51457,0.51072,
     &0.52429,0.53267,0.55978,0.55292,0.55731,0.57355,0.57821,0.58555,
     &0.58886,0.60012,0.60096,0.60327,0.58518,0.59884,0.60638,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.30900,0.33250,0.32189,
     &0.45742,0.36912,0.39058,0.38908,0.41082,0.44019,0.43478,0.45311,
     &0.46167,0.46738,0.48271,0.49400,0.50810,0.50607,0.52190,0.54148,
     &0.54148,0.55123,0.57309,0.57253,0.58401,0.58600,0.59701,0.60989,
     &0.62152,0.63033,0.62964,0.64749,0.64416,0.63454,0.63186,0.00000/
c::::::::::::::
capt-01-09-block.f
c::::::::::::::
      Data ((CF(K,l, 9, 1),K=1,40),l=1,13)/
     &0.08853,0.11173,0.14123,0.17748,0.22254,0.27772,0.34364,0.38927,
     &0.35950,0.39514,0.47665,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08829,0.11157,0.14101,0.17745,0.22229,0.27724,0.34268,0.38919,
     &0.35372,0.40894,0.48263,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08691,0.10891,0.13599,0.16985,0.21182,0.26092,0.31349,0.35806,
     &0.39052,0.43620,0.49360,0.53802,0.58282,0.63455,0.66124,0.69086,
     &0.68110,0.68359,0.67837,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08625,0.10743,0.13411,0.16703,0.20699,0.25505,0.30881,0.35897,
     &0.39841,0.43339,0.47306,0.51474,0.55930,0.59039,0.61161,0.62627,
     &0.62570,0.61808,0.60314,0.59485,0.57828,0.56875,0.57029,0.60370,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08617,0.10755,0.13364,0.16648,0.20629,0.25328,0.30571,0.35843,
     &0.40058,0.43781,0.48004,0.51927,0.55438,0.57501,0.59559,0.59481,
     &0.58325,0.56466,0.54759,0.53687,0.52986,0.53556,0.53522,0.55074,
     &0.57280,0.59063,0.61707,0.59099,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08645,0.10727,0.13389,0.16632,0.20729,0.25415,0.30837,0.36146,
     &0.40730,0.44925,0.49079,0.52892,0.56338,0.59012,0.60333,0.59849,
     &0.58476,0.56413,0.54381,0.53255,0.52467,0.52266,0.51947,0.51592,
     &0.52023,0.52117,0.52813,0.55120,0.56814,0.59349,0.63690,0.65696,
     &0.66591,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08617,0.10757,0.13447,0.16738,0.20790,0.25690,0.31021,0.36683,
     &0.41433,0.45743,0.50162,0.54125,0.57289,0.59629,0.61009,0.60554,
     &0.59197,0.56747,0.55341,0.53454,0.52033,0.52006,0.50748,0.51210,
     &0.51060,0.50827,0.51209,0.50872,0.50718,0.51364,0.53266,0.54667,
     &0.55843,0.59596,0.63623,0.68213,0.70558,0.00000,0.00000,0.00000,
     &0.08634,0.10747,0.13424,0.16732,0.20815,0.25693,0.31206,0.36993,
     &0.42080,0.46813,0.51252,0.54857,0.58384,0.60634,0.61661,0.61476,
     &0.59629,0.57145,0.54944,0.53697,0.53183,0.52468,0.51840,0.51322,
     &0.51765,0.50465,0.50567,0.50359,0.50498,0.49983,0.50239,0.50948,
     &0.52126,0.52221,0.53311,0.54662,0.55916,0.58416,0.61397,0.00000,
     &0.08649,0.10743,0.13422,0.16800,0.20884,0.25725,0.31362,0.37262,
     &0.42482,0.47260,0.51557,0.55538,0.58551,0.61005,0.62195,0.62382,
     &0.60717,0.57984,0.55969,0.54885,0.54362,0.53566,0.53001,0.52922,
     &0.52117,0.52237,0.51508,0.51191,0.52014,0.51125,0.52145,0.51354,
     &0.52444,0.51831,0.52330,0.52531,0.52532,0.53736,0.54125,0.00000,
     &0.08668,0.10822,0.13440,0.16749,0.20948,0.25936,0.31544,0.37378,
     &0.42777,0.47706,0.52302,0.55861,0.59272,0.61558,0.63046,0.63443,
     &0.61417,0.59315,0.57352,0.56275,0.55263,0.54875,0.55076,0.54773,
     &0.54657,0.54207,0.54530,0.53989,0.54830,0.53623,0.53790,0.53458,
     &0.53012,0.54121,0.53715,0.53884,0.54189,0.53952,0.54588,0.00000,
     &0.08644,0.10788,0.13498,0.16928,0.20929,0.25969,0.31707,0.37544,
     &0.42981,0.48194,0.52465,0.56167,0.59431,0.61565,0.62978,0.64234,
     &0.61947,0.60449,0.58624,0.56965,0.56330,0.56639,0.56245,0.55856,
     &0.56472,0.56368,0.56751,0.56916,0.56504,0.56442,0.57346,0.56648,
     &0.56676,0.56858,0.57108,0.56265,0.57523,0.57246,0.58341,0.00000,
     &0.08638,0.10727,0.13440,0.16752,0.21007,0.25978,0.31563,0.37628,
     &0.42991,0.48249,0.52371,0.56476,0.60176,0.63175,0.64691,0.64896,
     &0.63566,0.62383,0.59690,0.58645,0.57282,0.57005,0.57190,0.56920,
     &0.56758,0.57171,0.58670,0.58746,0.59034,0.59753,0.59883,0.60754,
     &0.60304,0.60890,0.59615,0.61336,0.60551,0.60313,0.62127,0.00000,
     &0.08584,0.10762,0.13418,0.16723,0.20923,0.25984,0.31437,0.37445,
     &0.42564,0.47510,0.52109,0.56861,0.59784,0.63362,0.65722,0.67027,
     &0.65473,0.63377,0.61043,0.59081,0.58580,0.58736,0.57876,0.57338,
     &0.58283,0.58696,0.58832,0.59967,0.60540,0.60474,0.62181,0.63411,
     &0.63488,0.65393,0.65761,0.65383,0.65703,0.65903,0.64821,0.00000/
c::::::::::::::
capt-01-10-block.f
c::::::::::::::
      Data ((CF(K,l,10, 1),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.12420,0.13700,0.00000,0.23788,0.25291,0.32293,0.33809,
     &0.34382,0.33455,0.36236,0.37570,0.39889,0.41945,0.43966,0.44762,
     &0.46845,0.48291,0.46655,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.09950,0.16900,0.18700,0.23700,0.25223,0.31991,0.37194,
     &0.37700,0.37690,0.36149,0.38766,0.39650,0.41322,0.41107,0.43075,
     &0.44605,0.45217,0.46225,0.47297,0.48731,0.49640,0.52699,0.52792,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08500,0.12800,0.12633,0.21200,0.23573,0.23725,0.25133,0.36070,
     &0.40353,0.39110,0.36607,0.38224,0.41119,0.41851,0.43976,0.45578,
     &0.46668,0.46026,0.46033,0.46597,0.47351,0.47722,0.48999,0.50556,
     &0.51447,0.53604,0.54614,0.56346,0.58258,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.12733,0.17980,0.19771,0.19272,0.28323,0.34022,
     &0.38689,0.40071,0.38657,0.39767,0.41882,0.43311,0.45574,0.46488,
     &0.46727,0.46716,0.45668,0.45483,0.46910,0.45929,0.47422,0.47665,
     &0.48100,0.49597,0.50637,0.52086,0.54187,0.56330,0.60097,0.60634,
     &0.60462,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.13550,0.14167,0.16600,0.22640,0.23120,0.32438,
     &0.39925,0.36549,0.38818,0.41729,0.41717,0.43388,0.44908,0.46205,
     &0.45817,0.46693,0.46229,0.46325,0.46463,0.47003,0.47221,0.46838,
     &0.47450,0.47855,0.48349,0.49256,0.49474,0.50307,0.51558,0.52881,
     &0.55073,0.57561,0.59582,0.62926,0.66067,0.67876,0.64593,0.00000,
     &0.00000,0.00000,0.00000,0.18233,0.27117,0.21575,0.27664,0.35676,
     &0.38945,0.34708,0.41333,0.37585,0.42324,0.43168,0.45174,0.45904,
     &0.46693,0.46154,0.46627,0.46439,0.46641,0.47154,0.46872,0.47578,
     &0.48274,0.47703,0.47746,0.47908,0.48371,0.48973,0.48909,0.49926,
     &0.50573,0.51085,0.52487,0.53982,0.55236,0.57020,0.58918,0.00000,
     &0.00000,0.00000,0.00000,0.15660,0.20157,0.27637,0.27182,0.35073,
     &0.36850,0.36526,0.39875,0.40349,0.41548,0.44479,0.45566,0.45912,
     &0.46240,0.46491,0.46729,0.47323,0.47263,0.47415,0.47609,0.48326,
     &0.48401,0.49137,0.49278,0.49025,0.49414,0.49557,0.50205,0.50298,
     &0.50630,0.51122,0.51671,0.51748,0.52387,0.52781,0.53519,0.00000,
     &0.10467,0.00000,0.15750,0.22600,0.19800,0.09533,0.24371,0.34912,
     &0.41415,0.40167,0.39516,0.43459,0.41576,0.43814,0.44012,0.46755,
     &0.46694,0.46512,0.48039,0.47317,0.48392,0.48337,0.50077,0.49621,
     &0.50764,0.51283,0.52146,0.51151,0.51203,0.51968,0.52771,0.52207,
     &0.52644,0.54325,0.53800,0.53388,0.54382,0.54070,0.54781,0.00000,
     &0.00000,0.00000,0.18150,0.12620,0.20050,0.21233,0.27482,0.37076,
     &0.37987,0.38843,0.38426,0.40613,0.44351,0.43533,0.44066,0.46523,
     &0.46982,0.48811,0.48105,0.48723,0.48932,0.49483,0.51218,0.51538,
     &0.51811,0.52577,0.53361,0.54702,0.54975,0.56314,0.55796,0.55842,
     &0.56357,0.56017,0.56837,0.57182,0.57218,0.56482,0.57492,0.00000,
     &0.00000,0.09500,0.00000,0.19350,0.00000,0.31750,0.27975,0.28357,
     &0.30482,0.40580,0.38577,0.41811,0.42688,0.44476,0.44256,0.46611,
     &0.47491,0.47834,0.48096,0.49207,0.48808,0.49770,0.51413,0.51798,
     &0.53200,0.55171,0.55341,0.56687,0.57575,0.58467,0.59005,0.60055,
     &0.59822,0.60181,0.60478,0.60206,0.60280,0.60777,0.61603,0.00000,
     &0.00000,0.09250,0.00000,0.00000,0.08900,0.32280,0.30942,0.32767,
     &0.49400,0.41543,0.41885,0.41824,0.45406,0.42696,0.45807,0.46798,
     &0.47055,0.47971,0.48760,0.49557,0.50764,0.52282,0.52773,0.53222,
     &0.54163,0.55947,0.56353,0.57704,0.59547,0.59975,0.60077,0.61551,
     &0.62496,0.63778,0.63427,0.65021,0.64166,0.63927,0.64234,0.00000/
c::::::::::::::
capt-02-01-block.f
c::::::::::::::
      Data ((CF(K,l, 1, 2),K=1,40),l=1,13)/
     &0.08468,0.10664,0.13500,0.16833,0.19311,0.23906,0.29699,0.24301,
     &0.13268,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08562,0.10967,0.13895,0.17666,0.21753,0.26946,0.32344,0.36261,
     &0.38865,0.39058,0.35685,0.32595,0.21465,0.14675,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08419,0.10468,0.13076,0.15858,0.18626,0.21659,0.24951,0.28093,
     &0.30949,0.33423,0.36002,0.38510,0.41449,0.44576,0.47694,0.50836,
     &0.54631,0.57041,0.57747,0.52380,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08352,0.10699,0.13358,0.15736,0.17935,0.20256,0.23026,0.24817,
     &0.28106,0.29762,0.31338,0.32841,0.34604,0.36333,0.38057,0.40165,
     &0.42167,0.44209,0.46408,0.48846,0.51392,0.53942,0.56676,0.58536,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08291,0.10621,0.13393,0.15608,0.17828,0.19997,0.22595,0.24728,
     &0.26546,0.26812,0.28912,0.30262,0.31509,0.32537,0.33613,0.34699,
     &0.35945,0.36921,0.38178,0.39368,0.41065,0.42476,0.44176,0.46183,
     &0.48890,0.52022,0.55276,0.58197,0.62256,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08234,0.10572,0.13475,0.15618,0.17686,0.19969,0.22438,0.24540,
     &0.26253,0.27328,0.28288,0.29353,0.29193,0.31213,0.32159,0.32953,
     &0.33736,0.34352,0.35149,0.35588,0.36620,0.37305,0.38181,0.39091,
     &0.40119,0.41485,0.42997,0.44952,0.47131,0.50090,0.53139,0.56807,
     &0.61257,0.65015,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08204,0.10602,0.13615,0.15556,0.17656,0.19884,0.22324,0.24409,
     &0.26102,0.27032,0.28164,0.28983,0.29868,0.30810,0.30791,0.31994,
     &0.32648,0.33210,0.33879,0.34280,0.34943,0.35290,0.35777,0.36133,
     &0.36667,0.37153,0.37803,0.38622,0.39519,0.40709,0.42233,0.43991,
     &0.46279,0.48888,0.51819,0.55219,0.58878,0.63356,0.67333,0.00000,
     &0.08179,0.10557,0.13712,0.15503,0.17667,0.19836,0.22216,0.24284,
     &0.25869,0.26934,0.27884,0.28622,0.29612,0.30414,0.31070,0.31735,
     &0.32347,0.32400,0.33251,0.33609,0.34101,0.34535,0.34784,0.35237,
     &0.35561,0.35889,0.36150,0.36329,0.37016,0.37344,0.38023,0.38666,
     &0.39391,0.40590,0.41974,0.43221,0.45170,0.47287,0.50186,0.00000,
     &0.08127,0.10580,0.13818,0.15574,0.17619,0.19827,0.22194,0.24216,
     &0.25726,0.26961,0.27823,0.28536,0.29588,0.30357,0.31152,0.31637,
     &0.32247,0.32725,0.32998,0.33351,0.33986,0.34373,0.34692,0.34988,
     &0.35411,0.35573,0.35825,0.36055,0.36446,0.36738,0.37052,0.37270,
     &0.37676,0.38228,0.38794,0.39368,0.39948,0.41113,0.41960,0.00000,
     &0.08100,0.10549,0.13944,0.15571,0.17685,0.19746,0.22201,0.24278,
     &0.25934,0.26728,0.27584,0.28527,0.29283,0.30327,0.31037,0.31630,
     &0.32075,0.32572,0.33114,0.33520,0.34297,0.34532,0.34746,0.35336,
     &0.35585,0.35831,0.36091,0.36326,0.36406,0.36774,0.36938,0.37195,
     &0.37539,0.37907,0.38120,0.38312,0.38620,0.39113,0.39603,0.00000,
     &0.08081,0.10547,0.14058,0.15589,0.17694,0.19977,0.22307,0.24271,
     &0.25715,0.26586,0.27429,0.28393,0.29323,0.30034,0.30777,0.31543,
     &0.32066,0.32591,0.33107,0.33681,0.34142,0.34748,0.35236,0.35681,
     &0.35798,0.36254,0.36521,0.36729,0.37029,0.37276,0.37516,0.37753,
     &0.37816,0.38083,0.38402,0.38776,0.38936,0.39209,0.39659,0.00000,
     &0.08059,0.10519,0.14205,0.15452,0.17603,0.19771,0.22353,0.24275,
     &0.25864,0.26632,0.27350,0.28354,0.29029,0.29809,0.30760,0.31250,
     &0.31881,0.32431,0.33111,0.33508,0.34160,0.34818,0.35191,0.35602,
     &0.36184,0.36588,0.36857,0.37033,0.37562,0.37845,0.38180,0.38248,
     &0.38514,0.38807,0.38815,0.39116,0.39658,0.39804,0.40110,0.00000,
     &0.08051,0.10501,0.14294,0.15530,0.17753,0.19836,0.22270,0.24264,
     &0.25904,0.26777,0.27466,0.28345,0.29170,0.29910,0.30517,0.31093,
     &0.31811,0.32474,0.32875,0.33579,0.34393,0.34762,0.35268,0.35751,
     &0.36253,0.36785,0.37097,0.37521,0.37925,0.38296,0.38746,0.39180,
     &0.39505,0.39561,0.39822,0.39937,0.40186,0.40266,0.40625,0.00000/
c::::::::::::::
capt-02-02-block.f
c::::::::::::::
      Data ((CF(K,l, 2, 2),K=1,40),l=1,13)/
     &0.08509,0.11080,0.13962,0.17403,0.21281,0.28895,0.37194,0.28929,
     &0.15763,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08867,0.10971,0.13607,0.17314,0.21904,0.26982,0.31751,0.35391,
     &0.38381,0.39068,0.33132,0.27519,0.23197,0.15387,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08766,0.10827,0.13503,0.16392,0.19426,0.22630,0.26533,0.29877,
     &0.32394,0.34803,0.37319,0.39761,0.42559,0.45156,0.47628,0.50610,
     &0.53392,0.55168,0.55042,0.52443,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08617,0.10952,0.13642,0.16240,0.18922,0.21736,0.24683,0.26730,
     &0.29847,0.32002,0.33736,0.35402,0.37093,0.38875,0.40525,0.42248,
     &0.43971,0.45576,0.47220,0.48885,0.51818,0.54033,0.57232,0.60255,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08267,0.10885,0.13754,0.16160,0.18766,0.21442,0.24272,0.26684,
     &0.28448,0.29570,0.30839,0.32812,0.34087,0.35325,0.36431,0.37403,
     &0.38337,0.39354,0.40485,0.41520,0.42982,0.44464,0.45551,0.47304,
     &0.49959,0.53008,0.56266,0.59478,0.65293,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08144,0.10800,0.13864,0.16093,0.18667,0.21233,0.24066,0.26325,
     &0.28132,0.29540,0.30784,0.31803,0.32052,0.34118,0.35160,0.35745,
     &0.36543,0.37229,0.37808,0.38412,0.39215,0.40004,0.40571,0.41515,
     &0.42405,0.43763,0.44829,0.46729,0.48459,0.51283,0.54707,0.57888,
     &0.62256,0.65182,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08098,0.10828,0.13970,0.16069,0.18571,0.21121,0.23721,0.25992,
     &0.27786,0.29211,0.30379,0.31531,0.32598,0.33516,0.33933,0.34497,
     &0.35608,0.36021,0.36573,0.37017,0.37656,0.38017,0.38317,0.38869,
     &0.39246,0.39801,0.40427,0.41177,0.42092,0.43091,0.44472,0.46065,
     &0.48230,0.50333,0.52849,0.56432,0.59688,0.63548,0.00000,0.00000,
     &0.08048,0.10805,0.14056,0.16012,0.18530,0.21001,0.23546,0.25886,
     &0.27528,0.28890,0.30095,0.31190,0.32089,0.32940,0.33771,0.34342,
     &0.34938,0.35048,0.36028,0.36352,0.36836,0.37290,0.37587,0.37912,
     &0.38092,0.38373,0.38829,0.39223,0.39640,0.40088,0.40567,0.41490,
     &0.41947,0.43042,0.44271,0.45570,0.47166,0.49478,0.51562,0.00000,
     &0.08029,0.10791,0.14153,0.15922,0.18445,0.20891,0.23467,0.25677,
     &0.27268,0.28563,0.29778,0.31007,0.31965,0.32720,0.33559,0.34232,
     &0.34934,0.35233,0.35805,0.36131,0.36724,0.37164,0.37502,0.37888,
     &0.37988,0.38323,0.38735,0.39074,0.39135,0.39293,0.39787,0.40139,
     &0.40404,0.40859,0.41488,0.41911,0.42554,0.43515,0.44519,0.00000,
     &0.08016,0.10782,0.14223,0.15957,0.18349,0.20977,0.23406,0.25550,
     &0.27068,0.28356,0.29376,0.30628,0.31769,0.32624,0.33472,0.34095,
     &0.34705,0.35310,0.35836,0.36122,0.36924,0.37214,0.37451,0.38010,
     &0.38423,0.38521,0.38847,0.39084,0.39273,0.39461,0.39672,0.39828,
     &0.40354,0.40414,0.41070,0.41190,0.41630,0.42093,0.42370,0.00000,
     &0.07997,0.10799,0.14330,0.15900,0.18456,0.20952,0.23287,0.25377,
     &0.26871,0.28115,0.29226,0.30263,0.31282,0.32320,0.33321,0.33917,
     &0.34542,0.35085,0.35650,0.36313,0.36922,0.37270,0.37799,0.38353,
     &0.38629,0.38837,0.39235,0.40622,0.39930,0.39931,0.40446,0.40439,
     &0.40670,0.41004,0.41116,0.41481,0.41882,0.42033,0.42527,0.00000,
     &0.07980,0.10797,0.14435,0.15924,0.18356,0.20619,0.23225,0.25398,
     &0.27076,0.28059,0.29336,0.30137,0.31219,0.31962,0.32891,0.33660,
     &0.34484,0.35070,0.35480,0.36087,0.36773,0.37418,0.37814,0.38300,
     &0.38883,0.39292,0.39786,0.39912,0.40526,0.40734,0.41104,0.41424,
     &0.41571,0.41436,0.41890,0.42177,0.42441,0.42848,0.43414,0.00000,
     &0.07978,0.10809,0.14529,0.15890,0.18401,0.20698,0.23297,0.25393,
     &0.26870,0.28217,0.29129,0.30432,0.31094,0.32007,0.32883,0.33514,
     &0.34214,0.34894,0.35560,0.36311,0.37093,0.37490,0.38025,0.38536,
     &0.39193,0.39423,0.39831,0.40477,0.40971,0.41124,0.41537,0.41943,
     &0.42343,0.42642,0.42765,0.42874,0.42950,0.42982,0.43485,0.00000/
c::::::::::::::
capt-02-03-block.f
c::::::::::::::
      Data ((CF(K,l, 3, 2),K=1,40),l=1,13)/
     &0.07817,0.09755,0.12299,0.14134,0.14277,0.15646,0.18627,0.25082,
     &0.15767,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08356,0.11177,0.14206,0.17530,0.21755,0.27464,0.33177,0.36991,
     &0.39403,0.39464,0.36375,0.31442,0.18246,0.14348,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08213,0.10914,0.13865,0.16535,0.19824,0.23252,0.26783,0.30025,
     &0.32989,0.35638,0.38396,0.41146,0.44182,0.47041,0.49413,0.51850,
     &0.55260,0.57582,0.56049,0.51452,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08133,0.10908,0.13916,0.16225,0.18912,0.21750,0.24785,0.26977,
     &0.29946,0.31710,0.33489,0.35188,0.36918,0.38616,0.40667,0.42579,
     &0.44547,0.46198,0.47802,0.49536,0.52003,0.53820,0.55845,0.56317,
     &0.53620,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08077,0.10814,0.13956,0.16101,0.18651,0.21282,0.24085,0.26589,
     &0.28219,0.29261,0.30737,0.32446,0.33551,0.34582,0.35847,0.37027,
     &0.38293,0.39467,0.40572,0.41580,0.43157,0.44307,0.45951,0.47617,
     &0.49610,0.51693,0.54867,0.57718,0.58730,0.55846,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08047,0.10830,0.14069,0.16021,0.18596,0.21183,0.23890,0.26172,
     &0.27842,0.29125,0.30387,0.31650,0.31773,0.33566,0.34439,0.35261,
     &0.36063,0.36706,0.37355,0.38159,0.38992,0.39683,0.40389,0.41190,
     &0.42155,0.43397,0.44546,0.45965,0.47931,0.50794,0.53628,0.56882,
     &0.60677,0.61332,0.56348,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08034,0.10793,0.14128,0.15978,0.18518,0.21069,0.23755,0.26000,
     &0.27665,0.29036,0.30154,0.31280,0.32190,0.33161,0.33638,0.34221,
     &0.35097,0.35674,0.36028,0.36502,0.37289,0.37698,0.38166,0.38617,
     &0.39039,0.39401,0.40084,0.40821,0.41751,0.42603,0.43861,0.45489,
     &0.47264,0.49427,0.51892,0.55420,0.59026,0.62285,0.62454,0.00000,
     &0.08020,0.10805,0.14216,0.15946,0.18501,0.20963,0.23436,0.25749,
     &0.27475,0.28714,0.29823,0.31108,0.32071,0.32752,0.33632,0.34295,
     &0.34900,0.35066,0.35781,0.36089,0.36663,0.36952,0.37269,0.37582,
     &0.37852,0.38193,0.38547,0.38871,0.39173,0.39618,0.40194,0.40752,
     &0.41477,0.42412,0.43563,0.44799,0.46466,0.48489,0.50779,0.00000,
     &0.07991,0.10836,0.14269,0.15983,0.18419,0.20915,0.23495,0.25649,
     &0.27224,0.28521,0.29748,0.30742,0.31933,0.32750,0.33572,0.34254,
     &0.34696,0.35263,0.35676,0.36111,0.36460,0.37016,0.37334,0.37507,
     &0.37914,0.38069,0.38334,0.38694,0.39047,0.39250,0.39402,0.39658,
     &0.40094,0.40468,0.40951,0.41659,0.42189,0.43007,0.43821,0.00000,
     &0.07994,0.10797,0.14312,0.15957,0.18398,0.20864,0.23322,0.25529,
     &0.27202,0.28328,0.29499,0.30649,0.31851,0.32599,0.33359,0.34188,
     &0.34759,0.35299,0.35910,0.36199,0.36777,0.37165,0.37403,0.37915,
     &0.38066,0.38521,0.38884,0.38915,0.39071,0.39300,0.39509,0.39776,
     &0.40175,0.40182,0.40478,0.40952,0.41218,0.41571,0.41732,0.00000,
     &0.07965,0.10825,0.14405,0.15918,0.18386,0.20772,0.23308,0.25292,
     &0.26993,0.28160,0.29216,0.30354,0.31326,0.32270,0.33182,0.34046,
     &0.34688,0.35294,0.35850,0.36346,0.36870,0.37506,0.37811,0.38259,
     &0.38627,0.38843,0.39331,0.39527,0.40001,0.40099,0.40297,0.40543,
     &0.40595,0.40858,0.41121,0.41554,0.41606,0.41985,0.42090,0.00000,
     &0.07969,0.10809,0.14475,0.15850,0.18323,0.20731,0.23139,0.25283,
     &0.26544,0.27867,0.29022,0.30018,0.31133,0.32160,0.32724,0.33586,
     &0.34582,0.35071,0.35548,0.36048,0.36973,0.37437,0.38136,0.38337,
     &0.38961,0.39442,0.39740,0.40192,0.40535,0.40723,0.41090,0.41285,
     &0.41433,0.41732,0.41864,0.41778,0.42517,0.42635,0.43131,0.00000,
     &0.07952,0.10819,0.14527,0.15924,0.18258,0.20642,0.23108,0.25321,
     &0.26648,0.27986,0.29303,0.30134,0.31196,0.32053,0.32740,0.33516,
     &0.34400,0.35130,0.35462,0.36172,0.36994,0.37630,0.38071,0.38536,
     &0.38941,0.39475,0.39913,0.40259,0.40632,0.41211,0.41637,0.41979,
     &0.42269,0.42574,0.42763,0.43013,0.43293,0.43300,0.43611,0.00000/
c::::::::::::::
capt-02-04-block.f
c::::::::::::::
      Data ((CF(K,l, 4, 2),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.09053,0.11100,0.13819,0.16831,0.19905,0.23732,0.27537,0.29050,
     &0.30589,0.30944,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08468,0.10514,0.13301,0.16522,0.20216,0.21913,0.22366,0.24783,
     &0.31565,0.38815,0.42451,0.42314,0.42001,0.41939,0.42897,0.44656,
     &0.46197,0.46847,0.48033,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08507,0.10574,0.13740,0.16194,0.19950,0.23735,0.26351,0.29441,
     &0.31901,0.33816,0.35274,0.36736,0.38523,0.40808,0.44399,0.48555,
     &0.51651,0.52424,0.51296,0.50745,0.51443,0.51890,0.53713,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.09420,0.10776,0.13410,0.16467,0.19747,0.23229,0.26524,0.28675,
     &0.31481,0.34218,0.35247,0.36717,0.37972,0.38923,0.39912,0.41245,
     &0.42670,0.43849,0.44464,0.45568,0.45763,0.47244,0.47201,0.47397,
     &0.48969,0.51373,0.53609,0.55610,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08547,0.10669,0.13243,0.16947,0.19131,0.23254,0.26400,0.29442,
     &0.31301,0.33364,0.35160,0.36384,0.37611,0.39137,0.39800,0.40503,
     &0.40930,0.41621,0.42136,0.42221,0.43042,0.43378,0.44165,0.44676,
     &0.45041,0.45886,0.46445,0.47522,0.48884,0.49814,0.53684,0.55437,
     &0.59772,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08509,0.10183,0.13150,0.16374,0.19605,0.22917,0.26400,0.29414,
     &0.31355,0.33608,0.35376,0.37075,0.37680,0.38895,0.39177,0.40124,
     &0.40081,0.40475,0.41421,0.41549,0.42024,0.41988,0.42521,0.43100,
     &0.43269,0.43121,0.43302,0.44072,0.44563,0.45097,0.45550,0.47126,
     &0.48507,0.49734,0.50808,0.53246,0.57631,0.60529,0.64091,0.00000,
     &0.09177,0.10333,0.13050,0.16532,0.20367,0.23054,0.26769,0.29796,
     &0.31537,0.33826,0.35429,0.36667,0.37938,0.38911,0.39333,0.40200,
     &0.40617,0.40926,0.41235,0.41455,0.41903,0.41908,0.42342,0.42382,
     &0.42416,0.42834,0.43476,0.43283,0.43714,0.43925,0.44106,0.44120,
     &0.44744,0.45831,0.46047,0.46180,0.48421,0.49464,0.51395,0.00000,
     &0.08545,0.11142,0.13869,0.16197,0.19934,0.23272,0.26716,0.29292,
     &0.31651,0.33890,0.35560,0.36725,0.38152,0.39366,0.39995,0.40250,
     &0.40815,0.41050,0.41678,0.42070,0.42242,0.42909,0.42948,0.43201,
     &0.43297,0.43309,0.43619,0.43874,0.44142,0.44018,0.44628,0.45210,
     &0.45121,0.45104,0.45334,0.46078,0.46574,0.46732,0.47350,0.00000,
     &0.09466,0.10843,0.13591,0.16643,0.19767,0.23130,0.26798,0.29854,
     &0.32500,0.34020,0.35579,0.36948,0.38019,0.39489,0.40375,0.41468,
     &0.41298,0.41881,0.42541,0.42834,0.43462,0.43453,0.43875,0.43771,
     &0.44538,0.44738,0.44170,0.44481,0.45223,0.45330,0.45732,0.45953,
     &0.46378,0.46349,0.46645,0.46414,0.46704,0.47176,0.46773,0.00000,
     &0.09130,0.10245,0.13690,0.16414,0.20115,0.23610,0.26474,0.29280,
     &0.32398,0.34099,0.36064,0.37089,0.38282,0.39445,0.40435,0.40925,
     &0.40962,0.42422,0.42727,0.42927,0.43907,0.44457,0.45161,0.45861,
     &0.46279,0.46070,0.47099,0.46843,0.46768,0.47369,0.47866,0.47640,
     &0.47862,0.47990,0.48030,0.48276,0.48274,0.48675,0.48987,0.00000,
     &0.08389,0.10816,0.13581,0.16186,0.19214,0.24402,0.26629,0.29036,
     &0.31845,0.33374,0.35436,0.37873,0.38689,0.39944,0.39482,0.40999,
     &0.41814,0.42675,0.42884,0.43189,0.44068,0.44912,0.46148,0.46014,
     &0.47230,0.48411,0.49689,0.49491,0.49332,0.49108,0.49864,0.49003,
     &0.49538,0.50044,0.49557,0.50088,0.49819,0.50612,0.51186,0.00000,
     &0.09046,0.10525,0.13495,0.16339,0.20254,0.24381,0.26348,0.30203,
     &0.31737,0.34118,0.35418,0.37081,0.38680,0.40218,0.39789,0.41354,
     &0.41353,0.42461,0.44013,0.44293,0.45326,0.45477,0.46785,0.47111,
     &0.48307,0.48036,0.49189,0.49845,0.49890,0.51213,0.51038,0.50752,
     &0.52112,0.52209,0.52718,0.52357,0.52793,0.51888,0.52576,0.00000/
c::::::::::::::
capt-02-05-block.f
c::::::::::::::
      Data ((CF(K,l, 5, 2),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08548,0.11174,0.13247,0.15582,0.19222,0.21933,0.25461,0.28609,
     &0.31039,0.34303,0.36581,0.39147,0.40771,0.42472,0.44486,0.47529,
     &0.51005,0.52757,0.53158,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08983,0.10282,0.13119,0.16106,0.19206,0.22342,0.25111,0.27627,
     &0.30073,0.31692,0.33209,0.34695,0.36674,0.38365,0.40474,0.42127,
     &0.43898,0.44347,0.46121,0.48054,0.49556,0.51149,0.53113,0.56083,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.09488,0.10492,0.13946,0.16417,0.19291,0.21537,0.24533,0.27546,
     &0.28821,0.31139,0.32713,0.35145,0.35606,0.37133,0.38116,0.38994,
     &0.40173,0.41059,0.41666,0.42854,0.43274,0.44935,0.45835,0.47924,
     &0.48967,0.51103,0.53460,0.57526,0.58645,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08627,0.10181,0.12253,0.16616,0.18988,0.22117,0.23876,0.26425,
     &0.29357,0.30351,0.32631,0.34723,0.35722,0.36877,0.37804,0.38480,
     &0.38872,0.40366,0.39850,0.40714,0.41131,0.41818,0.42676,0.42954,
     &0.43742,0.44813,0.45913,0.46730,0.49279,0.51132,0.52298,0.55987,
     &0.58489,0.63396,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08336,0.11402,0.13579,0.16505,0.19385,0.21613,0.24805,0.26891,
     &0.28707,0.30839,0.33027,0.34797,0.35908,0.37006,0.38077,0.38664,
     &0.39148,0.39699,0.39962,0.40391,0.40857,0.41325,0.41045,0.41748,
     &0.42405,0.42823,0.43242,0.44090,0.44163,0.45077,0.45762,0.46605,
     &0.48889,0.50320,0.52485,0.53738,0.56543,0.60684,0.65918,0.00000,
     &0.08462,0.10655,0.13285,0.16416,0.20139,0.22171,0.24204,0.27760,
     &0.29772,0.32056,0.33031,0.34532,0.36442,0.37577,0.38584,0.38575,
     &0.39068,0.39726,0.39934,0.40356,0.40056,0.40709,0.41387,0.41309,
     &0.41865,0.42052,0.42687,0.42661,0.43307,0.43385,0.44230,0.44295,
     &0.45217,0.45428,0.46156,0.47037,0.48347,0.49586,0.51902,0.00000,
     &0.08967,0.10477,0.12806,0.16497,0.19036,0.21911,0.25223,0.27725,
     &0.30333,0.31575,0.33261,0.35216,0.36953,0.37960,0.38712,0.39202,
     &0.40389,0.40631,0.41065,0.41037,0.41422,0.41612,0.41844,0.42326,
     &0.42362,0.42269,0.42894,0.42885,0.43490,0.43579,0.44164,0.44696,
     &0.44845,0.45192,0.45734,0.45915,0.46444,0.47120,0.47644,0.00000,
     &0.09135,0.11154,0.12037,0.16587,0.20364,0.21900,0.25747,0.28025,
     &0.30219,0.31443,0.32578,0.35676,0.36726,0.37856,0.39112,0.39538,
     &0.40348,0.40710,0.41724,0.41570,0.41845,0.42269,0.43107,0.43289,
     &0.43401,0.43656,0.44376,0.44143,0.43970,0.44726,0.44834,0.45059,
     &0.45423,0.45642,0.46397,0.46059,0.46248,0.47430,0.47419,0.00000,
     &0.09538,0.10575,0.12247,0.16533,0.19135,0.21771,0.23908,0.27679,
     &0.29909,0.31370,0.33266,0.35756,0.36737,0.38008,0.39177,0.39550,
     &0.39899,0.41405,0.41408,0.41721,0.42725,0.42488,0.43876,0.43800,
     &0.44655,0.45092,0.45440,0.45804,0.45455,0.46284,0.46652,0.46375,
     &0.47204,0.47509,0.47820,0.48081,0.48876,0.48908,0.48785,0.00000,
     &0.09358,0.11060,0.14709,0.16804,0.19442,0.21422,0.24262,0.26251,
     &0.28846,0.31372,0.32522,0.34605,0.35898,0.38475,0.39031,0.40156,
     &0.41015,0.40570,0.41148,0.42400,0.42429,0.43468,0.43728,0.44536,
     &0.45801,0.46628,0.47886,0.47711,0.47876,0.47886,0.48186,0.48626,
     &0.49682,0.48820,0.49702,0.49449,0.49961,0.50609,0.51240,0.00000,
     &0.09413,0.10478,0.13931,0.16196,0.18254,0.20858,0.25207,0.26353,
     &0.28414,0.30509,0.34093,0.33903,0.36464,0.38080,0.38873,0.39788,
     &0.39920,0.40720,0.41941,0.42317,0.43128,0.43928,0.44310,0.45247,
     &0.45995,0.46708,0.46916,0.47890,0.48853,0.48685,0.50312,0.50601,
     &0.51061,0.51168,0.51715,0.51745,0.52077,0.52799,0.53487,0.00000/
c::::::::::::::
capt-02-06-block.f
c::::::::::::::
      Data ((CF(K,l, 6, 2),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08972,0.11246,0.14093,0.17147,0.20519,0.24476,0.27965,0.30484,
     &0.31675,0.31124,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08474,0.10688,0.13204,0.16444,0.19822,0.21663,0.22750,0.25158,
     &0.31196,0.37732,0.40938,0.41377,0.41623,0.42429,0.43358,0.45093,
     &0.46410,0.47687,0.46665,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08533,0.10781,0.13160,0.16584,0.19534,0.23052,0.26318,0.28928,
     &0.31152,0.33601,0.34916,0.36467,0.38523,0.40311,0.43195,0.46489,
     &0.48689,0.48994,0.49151,0.48928,0.49382,0.50214,0.52141,0.52248,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08647,0.11018,0.13755,0.16447,0.19756,0.22800,0.25798,0.28309,
     &0.30864,0.32959,0.34827,0.36504,0.37376,0.38460,0.39696,0.40839,
     &0.41956,0.42928,0.43605,0.43883,0.45235,0.46063,0.46411,0.47675,
     &0.48851,0.50697,0.53243,0.56087,0.58619,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08987,0.10978,0.13495,0.16431,0.19908,0.22916,0.25861,0.28878,
     &0.30662,0.33150,0.34608,0.36267,0.37394,0.38778,0.39601,0.40065,
     &0.40278,0.40894,0.41547,0.41765,0.42396,0.42890,0.43311,0.43905,
     &0.44374,0.45254,0.46056,0.47268,0.48516,0.50520,0.52084,0.55035,
     &0.57905,0.61844,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08702,0.11297,0.13885,0.16581,0.20106,0.23438,0.25818,0.29072,
     &0.30821,0.32890,0.34781,0.36309,0.37587,0.38535,0.39287,0.39843,
     &0.40278,0.40625,0.40956,0.41019,0.41257,0.41775,0.42307,0.42325,
     &0.42843,0.43401,0.43967,0.44414,0.44753,0.45362,0.46251,0.47019,
     &0.48101,0.50376,0.52295,0.54294,0.56972,0.61688,0.62678,0.00000,
     &0.08658,0.11439,0.13601,0.15522,0.19610,0.22906,0.26321,0.28785,
     &0.30924,0.32917,0.34680,0.36310,0.37815,0.38797,0.39252,0.39985,
     &0.40400,0.40748,0.41053,0.41354,0.41551,0.41831,0.42110,0.42217,
     &0.42560,0.42622,0.43102,0.43403,0.43746,0.43826,0.44498,0.44798,
     &0.44992,0.45722,0.46523,0.47259,0.48250,0.49624,0.51250,0.00000,
     &0.08726,0.11057,0.13812,0.16104,0.20075,0.23256,0.26270,0.29116,
     &0.31149,0.33548,0.35108,0.36497,0.37887,0.39021,0.39550,0.40474,
     &0.40670,0.41076,0.41323,0.41607,0.42074,0.42468,0.42730,0.42881,
     &0.43169,0.43294,0.43655,0.43848,0.43980,0.44139,0.44703,0.44593,
     &0.45186,0.45280,0.45916,0.46131,0.46405,0.47040,0.47443,0.00000,
     &0.08708,0.11199,0.13287,0.16314,0.20368,0.23091,0.25918,0.28518,
     &0.30914,0.33014,0.35119,0.36699,0.38236,0.38884,0.40341,0.40717,
     &0.41592,0.41504,0.42074,0.42593,0.42744,0.43263,0.43689,0.43957,
     &0.44303,0.44458,0.44666,0.45212,0.44789,0.45117,0.45942,0.45762,
     &0.46351,0.46252,0.46515,0.47268,0.47356,0.47788,0.48164,0.00000,
     &0.09052,0.10502,0.13532,0.16205,0.19450,0.23119,0.26195,0.28747,
     &0.31014,0.33211,0.35435,0.36780,0.38306,0.39552,0.40325,0.40687,
     &0.41587,0.41744,0.42600,0.42942,0.43301,0.44117,0.44530,0.45194,
     &0.45423,0.46178,0.46577,0.46733,0.47010,0.47042,0.47367,0.47393,
     &0.47905,0.48025,0.48253,0.48888,0.48803,0.49040,0.50005,0.00000,
     &0.08245,0.11094,0.12836,0.16674,0.19848,0.22720,0.25924,0.28208,
     &0.31252,0.33549,0.35301,0.36410,0.38276,0.39461,0.39820,0.40828,
     &0.41957,0.41923,0.42821,0.43468,0.43940,0.44684,0.45794,0.46596,
     &0.47480,0.47639,0.49941,0.48582,0.49094,0.49306,0.49626,0.50063,
     &0.49963,0.49710,0.50197,0.50222,0.51035,0.51447,0.51851,0.00000,
     &0.08670,0.10665,0.13320,0.16202,0.19381,0.22570,0.26322,0.28298,
     &0.31413,0.33057,0.35041,0.36374,0.38004,0.39057,0.40465,0.41526,
     &0.41560,0.42548,0.43360,0.44094,0.44645,0.45461,0.45893,0.46379,
     &0.47623,0.48338,0.48671,0.48875,0.49382,0.50122,0.50531,0.51622,
     &0.51694,0.52320,0.52303,0.52507,0.52830,0.53287,0.53219,0.00000/
c::::::::::::::
capt-02-07-block.f
c::::::::::::::
      Data ((CF(K,l, 7, 2),K=1,40),l=1,13)/
     &0.08857,0.11173,0.14100,0.17769,0.22245,0.27810,0.34439,0.39570,
     &0.37192,0.45941,0.57098,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08837,0.11153,0.14112,0.17733,0.22229,0.27755,0.34242,0.39225,
     &0.36177,0.45700,0.53736,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08740,0.10937,0.13668,0.17087,0.21245,0.26111,0.31419,0.35775,
     &0.38868,0.43456,0.49396,0.53801,0.58304,0.63293,0.65872,0.68001,
     &0.67576,0.67052,0.65606,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08686,0.10794,0.13459,0.16763,0.20792,0.25547,0.30965,0.36164,
     &0.40099,0.43494,0.47350,0.51674,0.55937,0.59277,0.61336,0.62487,
     &0.62296,0.61501,0.59706,0.58126,0.56512,0.56497,0.55178,0.56450,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08668,0.10822,0.13455,0.16719,0.20672,0.25466,0.30825,0.35944,
     &0.40272,0.43975,0.48150,0.51799,0.55419,0.58412,0.59545,0.59422,
     &0.58686,0.56468,0.54498,0.53176,0.52985,0.53128,0.53447,0.55491,
     &0.57427,0.60695,0.60804,0.62578,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08659,0.10810,0.13458,0.16713,0.20682,0.25547,0.30945,0.36318,
     &0.40891,0.45050,0.49120,0.52756,0.56281,0.59061,0.60385,0.60541,
     &0.58629,0.56574,0.54013,0.52935,0.52746,0.52776,0.51957,0.51319,
     &0.52291,0.51898,0.53392,0.54964,0.57156,0.59622,0.63903,0.67016,
     &0.70639,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08673,0.10801,0.13437,0.16736,0.20765,0.25642,0.31321,0.36799,
     &0.41497,0.45888,0.50091,0.54153,0.57570,0.60166,0.61157,0.60901,
     &0.58741,0.56420,0.55061,0.54117,0.52795,0.52346,0.51119,0.51229,
     &0.50943,0.50685,0.51223,0.50763,0.51293,0.52018,0.52793,0.54527,
     &0.56043,0.59983,0.63950,0.67050,0.71262,0.74988,0.00000,0.00000,
     &0.08669,0.10802,0.13506,0.16838,0.20866,0.25696,0.31363,0.37097,
     &0.42171,0.46592,0.51176,0.54859,0.57832,0.60853,0.61687,0.61359,
     &0.60057,0.57301,0.55369,0.53894,0.53485,0.52746,0.51740,0.51481,
     &0.50783,0.50423,0.50072,0.50219,0.50206,0.49898,0.49956,0.50442,
     &0.51113,0.52106,0.52895,0.54555,0.56206,0.59315,0.61060,0.00000,
     &0.08670,0.10832,0.13511,0.16872,0.20891,0.25813,0.31508,0.37326,
     &0.42807,0.47294,0.51731,0.55304,0.58713,0.61079,0.62426,0.61880,
     &0.60848,0.57998,0.56072,0.54693,0.54191,0.53739,0.53038,0.52424,
     &0.52432,0.51688,0.51754,0.51147,0.50521,0.51124,0.50653,0.51674,
     &0.51624,0.51979,0.52360,0.52642,0.53005,0.53864,0.53658,0.00000,
     &0.08699,0.10819,0.13515,0.16864,0.20993,0.26088,0.31627,0.37536,
     &0.43086,0.47742,0.52003,0.55854,0.59202,0.60869,0.62952,0.63058,
     &0.61348,0.58460,0.57341,0.55848,0.55670,0.54529,0.54583,0.53641,
     &0.54489,0.53583,0.53520,0.53467,0.52811,0.53158,0.52605,0.52452,
     &0.53740,0.53003,0.54497,0.54339,0.54022,0.54963,0.54509,0.00000,
     &0.08663,0.10858,0.13586,0.16851,0.21052,0.26063,0.31731,0.37553,
     &0.42882,0.47919,0.52362,0.55986,0.59522,0.61795,0.63432,0.64010,
     &0.62473,0.59902,0.58058,0.57284,0.56305,0.55657,0.55079,0.56115,
     &0.55260,0.55250,0.56171,0.56388,0.55775,0.56566,0.56803,0.57096,
     &0.56059,0.57195,0.57204,0.58423,0.58209,0.58046,0.60171,0.00000,
     &0.08708,0.10790,0.13493,0.16905,0.21139,0.26058,0.31767,0.37507,
     &0.43086,0.48103,0.52403,0.56785,0.60130,0.62590,0.64614,0.65002,
     &0.63678,0.61738,0.59757,0.58203,0.56437,0.56921,0.56059,0.56794,
     &0.56459,0.57606,0.58124,0.58072,0.58434,0.58524,0.60158,0.61689,
     &0.60759,0.61460,0.60556,0.61300,0.63743,0.61621,0.63528,0.00000,
     &0.08654,0.10821,0.13483,0.16982,0.20830,0.25805,0.31525,0.37496,
     &0.43144,0.47732,0.52017,0.56330,0.59986,0.63624,0.66733,0.67008,
     &0.66268,0.63262,0.60916,0.59839,0.59286,0.58621,0.57754,0.57390,
     &0.58607,0.57651,0.59531,0.60221,0.61188,0.60834,0.61907,0.62079,
     &0.62840,0.63076,0.63960,0.63937,0.64888,0.65209,0.64904,0.00000/
c::::::::::::::
capt-02-08-block.f
c::::::::::::::
      Data ((CF(K,l, 8, 2),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.13940,0.19850,0.23387,0.20869,0.31061,0.31183,
     &0.30430,0.33283,0.34843,0.37279,0.39531,0.42556,0.43502,0.46561,
     &0.46729,0.47701,0.47392,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.18222,0.25043,0.24493,0.34171,0.34109,
     &0.36539,0.36440,0.36058,0.38447,0.38459,0.40840,0.42614,0.43203,
     &0.44804,0.45079,0.46530,0.47648,0.48909,0.49032,0.51360,0.54176,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.06700,0.08950,0.00000,0.16875,0.19314,0.28007,0.21868,0.31303,
     &0.36872,0.37267,0.38485,0.39714,0.42276,0.43158,0.45702,0.46249,
     &0.45895,0.45931,0.46386,0.46504,0.46551,0.48414,0.49759,0.51105,
     &0.52881,0.55101,0.55550,0.56022,0.57251,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.10633,0.11450,0.04367,0.25571,0.21973,0.28386,0.30408,
     &0.34580,0.39062,0.38622,0.40364,0.40536,0.42545,0.45683,0.46198,
     &0.47210,0.46120,0.45882,0.46615,0.46749,0.47058,0.47337,0.47360,
     &0.48572,0.49175,0.50552,0.52332,0.54557,0.57307,0.59490,0.60146,
     &0.64095,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.09700,0.13967,0.19350,0.12950,0.25645,0.30079,0.35288,
     &0.38785,0.37246,0.37747,0.42148,0.43188,0.43350,0.43690,0.45961,
     &0.45994,0.46585,0.46375,0.45917,0.46162,0.45530,0.46750,0.46943,
     &0.47158,0.47635,0.48147,0.48181,0.48990,0.50490,0.51812,0.53924,
     &0.55158,0.57855,0.61031,0.63518,0.65972,0.69318,0.00000,0.00000,
     &0.00000,0.00000,0.14700,0.12833,0.24291,0.21793,0.25792,0.35027,
     &0.36364,0.41379,0.38798,0.39335,0.42009,0.45478,0.43874,0.45578,
     &0.45825,0.46598,0.45876,0.45972,0.46249,0.46387,0.47105,0.46884,
     &0.46821,0.47462,0.47805,0.48037,0.48362,0.48585,0.48939,0.49483,
     &0.50577,0.51607,0.52236,0.53674,0.55780,0.58224,0.59488,0.00000,
     &0.00000,0.06000,0.14860,0.14317,0.27267,0.23412,0.32279,0.34685,
     &0.38592,0.36878,0.39621,0.38329,0.42030,0.43991,0.44662,0.45465,
     &0.46300,0.47085,0.46092,0.46751,0.47173,0.47363,0.46538,0.47562,
     &0.48036,0.48654,0.48871,0.49123,0.49365,0.49607,0.49444,0.49943,
     &0.50523,0.50498,0.51549,0.51668,0.52186,0.52843,0.54100,0.00000,
     &0.04900,0.00000,0.17350,0.00000,0.21333,0.16450,0.31560,0.32621,
     &0.38794,0.36670,0.40280,0.40401,0.42085,0.45531,0.45648,0.44737,
     &0.46731,0.46214,0.47077,0.47576,0.48255,0.48903,0.49117,0.49395,
     &0.50415,0.50867,0.50414,0.50618,0.51343,0.51450,0.51788,0.52466,
     &0.53491,0.53316,0.52909,0.53887,0.54005,0.53827,0.54162,0.00000,
     &0.00000,0.00000,0.00000,0.16100,0.11925,0.27740,0.36013,0.40987,
     &0.41728,0.36185,0.41262,0.41499,0.39395,0.43604,0.45019,0.46461,
     &0.45256,0.46145,0.46862,0.48408,0.48167,0.49385,0.50081,0.50710,
     &0.51193,0.53008,0.53979,0.53680,0.54162,0.54366,0.55215,0.55632,
     &0.56149,0.55836,0.56419,0.57928,0.56874,0.56154,0.57876,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.23475,0.29175,0.26650,0.38270,
     &0.35376,0.29553,0.39236,0.44138,0.41470,0.44365,0.47915,0.46274,
     &0.47304,0.47385,0.47602,0.48035,0.49539,0.50190,0.51613,0.52168,
     &0.52948,0.54430,0.55678,0.55729,0.57099,0.57050,0.57853,0.59194,
     &0.59001,0.59720,0.59230,0.59509,0.58989,0.59835,0.60429,0.00000,
     &0.00000,0.00000,0.13250,0.19850,0.24600,0.24520,0.29622,0.35271,
     &0.43340,0.34711,0.39561,0.40461,0.40110,0.44310,0.44353,0.46496,
     &0.47072,0.48244,0.48380,0.49581,0.50315,0.50809,0.51891,0.52285,
     &0.53758,0.55152,0.56706,0.59871,0.58497,0.58500,0.60428,0.62324,
     &0.62348,0.63454,0.64020,0.64774,0.64677,0.63563,0.63498,0.00000/
c::::::::::::::
capt-02-09-block.f
c::::::::::::::
      Data ((CF(K,l, 9, 2),K=1,40),l=1,13)/
     &0.08855,0.11182,0.14086,0.17716,0.22158,0.27704,0.34283,0.37885,
     &0.33604,0.39025,0.41057,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08828,0.11169,0.14109,0.17739,0.22236,0.27785,0.34314,0.38940,
     &0.34781,0.40646,0.48328,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08709,0.10887,0.13595,0.16966,0.21097,0.26012,0.31257,0.35704,
     &0.38779,0.43365,0.48896,0.54029,0.60054,0.67785,0.70518,0.69794,
     &0.66278,0.67680,0.63585,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08627,0.10781,0.13417,0.16668,0.20672,0.25366,0.30747,0.35923,
     &0.39735,0.43346,0.47280,0.51544,0.56103,0.59303,0.61771,0.63625,
     &0.64578,0.63277,0.60248,0.57594,0.54244,0.53133,0.52302,0.49475,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08592,0.10723,0.13294,0.16674,0.20532,0.25326,0.30637,0.35703,
     &0.39977,0.43627,0.47986,0.51656,0.55227,0.57894,0.58901,0.59702,
     &0.58369,0.58029,0.55794,0.55243,0.54505,0.53412,0.53160,0.53041,
     &0.55802,0.56029,0.56806,0.56571,0.59060,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08627,0.10741,0.13424,0.16600,0.20609,0.25399,0.30731,0.36166,
     &0.40668,0.44805,0.49066,0.52837,0.56530,0.58630,0.59935,0.60137,
     &0.58031,0.56276,0.54317,0.53488,0.53654,0.53425,0.52497,0.52802,
     &0.51898,0.51638,0.52000,0.53621,0.55223,0.57275,0.60582,0.61427,
     &0.61119,0.57897,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08631,0.10745,0.13371,0.16706,0.20726,0.25547,0.30945,0.36534,
     &0.41432,0.45900,0.50141,0.54205,0.57712,0.60148,0.60816,0.60883,
     &0.58928,0.56398,0.55004,0.53265,0.52369,0.52450,0.52068,0.51692,
     &0.51300,0.50945,0.51061,0.50754,0.51421,0.50915,0.52808,0.53348,
     &0.55785,0.57308,0.60063,0.63106,0.66631,0.65463,0.67476,0.00000,
     &0.08633,0.10801,0.13436,0.16754,0.20796,0.25664,0.31197,0.36968,
     &0.41983,0.46622,0.50722,0.54780,0.58332,0.61044,0.61640,0.61352,
     &0.59930,0.57189,0.55380,0.54090,0.53450,0.52211,0.52291,0.52073,
     &0.51182,0.51468,0.51090,0.50429,0.49950,0.50137,0.50436,0.51086,
     &0.51525,0.51776,0.53056,0.53651,0.54672,0.57057,0.59133,0.00000,
     &0.08634,0.10759,0.13394,0.16791,0.20862,0.25728,0.31373,0.37104,
     &0.42493,0.47158,0.51802,0.55456,0.58857,0.61211,0.62403,0.61879,
     &0.60430,0.58735,0.56818,0.55288,0.54497,0.53601,0.53360,0.52640,
     &0.52534,0.52183,0.51659,0.51053,0.51569,0.51254,0.51237,0.52129,
     &0.52318,0.52959,0.51661,0.51785,0.53008,0.52872,0.54810,0.00000,
     &0.08617,0.10775,0.13422,0.16760,0.20823,0.25790,0.31582,0.37403,
     &0.43061,0.47606,0.52025,0.55690,0.58787,0.61321,0.63114,0.63315,
     &0.61665,0.58879,0.57128,0.56664,0.56497,0.55086,0.54596,0.54006,
     &0.54034,0.54667,0.53941,0.53581,0.53482,0.53274,0.53425,0.54092,
     &0.53752,0.53966,0.54022,0.54723,0.54274,0.54210,0.54470,0.00000,
     &0.08632,0.10771,0.13435,0.16902,0.20934,0.25943,0.31771,0.37382,
     &0.43033,0.47685,0.52823,0.56447,0.59272,0.62062,0.63187,0.64312,
     &0.63093,0.60370,0.58526,0.56570,0.55482,0.56693,0.56476,0.56111,
     &0.56089,0.56236,0.56660,0.57097,0.56252,0.57264,0.56726,0.57487,
     &0.56934,0.57176,0.58106,0.58529,0.58346,0.57327,0.57827,0.00000,
     &0.08626,0.10796,0.13508,0.16825,0.20937,0.25936,0.31635,0.37708,
     &0.42889,0.47810,0.52655,0.56913,0.59696,0.62645,0.64131,0.65672,
     &0.64639,0.61740,0.60357,0.58588,0.57289,0.58075,0.57520,0.57022,
     &0.58179,0.57904,0.59249,0.57696,0.60355,0.59134,0.60089,0.61041,
     &0.60328,0.61140,0.62754,0.61600,0.61359,0.61093,0.62073,0.00000,
     &0.08630,0.10739,0.13457,0.16706,0.20872,0.25960,0.31615,0.37340,
     &0.42535,0.47240,0.52601,0.56215,0.60288,0.63252,0.66352,0.67659,
     &0.66588,0.63401,0.60545,0.58760,0.59113,0.58430,0.58705,0.57964,
     &0.59116,0.59624,0.60053,0.59919,0.62222,0.61224,0.61947,0.63274,
     &0.64068,0.64005,0.64660,0.65313,0.64849,0.65021,0.64753,0.00000/
c::::::::::::::
capt-02-10-block.f
c::::::::::::::
      Data ((CF(K,l,10, 2),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.12800,0.08633,0.19825,0.23180,0.31230,0.24124,0.34973,
     &0.31010,0.30531,0.34332,0.36639,0.39823,0.42550,0.44817,0.45028,
     &0.46239,0.47710,0.46541,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.08550,0.20440,0.21814,0.26575,0.30597,0.37303,
     &0.35260,0.35227,0.35519,0.35903,0.38931,0.40170,0.42529,0.44261,
     &0.44931,0.47058,0.48222,0.49805,0.50239,0.51889,0.51980,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.10700,0.00000,0.17600,0.16950,0.26233,0.27840,0.35771,
     &0.32111,0.36669,0.37568,0.38906,0.40504,0.42175,0.43993,0.46292,
     &0.47051,0.46399,0.47157,0.46114,0.47745,0.48692,0.49711,0.51324,
     &0.55118,0.56018,0.56814,0.58517,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.08767,0.14860,0.15850,0.22008,0.20062,0.25894,0.35846,
     &0.34815,0.37695,0.43455,0.39032,0.40761,0.41979,0.44772,0.46062,
     &0.46550,0.45982,0.46961,0.46728,0.46641,0.47453,0.47137,0.48280,
     &0.47880,0.49891,0.50780,0.54077,0.56342,0.59236,0.62707,0.64408,
     &0.68563,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.07120,0.12650,0.11925,0.18200,0.16713,0.24250,0.34295,0.35454,
     &0.34700,0.38684,0.37551,0.39118,0.41647,0.42075,0.44546,0.45616,
     &0.46497,0.46250,0.46317,0.46100,0.45852,0.46831,0.47032,0.46707,
     &0.47240,0.47613,0.48275,0.48691,0.49028,0.50951,0.52466,0.53805,
     &0.55637,0.59497,0.62680,0.66566,0.70547,0.71664,0.00000,0.00000,
     &0.00000,0.00000,0.09700,0.16860,0.24767,0.19611,0.29000,0.35354,
     &0.36978,0.42184,0.38324,0.41485,0.43209,0.43291,0.44449,0.46805,
     &0.46597,0.46407,0.46297,0.46233,0.46209,0.46833,0.47116,0.47448,
     &0.47327,0.47625,0.48061,0.48162,0.48575,0.48385,0.49350,0.49625,
     &0.50479,0.51702,0.53553,0.53382,0.56437,0.58390,0.61166,0.00000,
     &0.06950,0.12350,0.17450,0.00000,0.21000,0.25421,0.35732,0.37791,
     &0.35305,0.40313,0.39588,0.39259,0.40644,0.42677,0.46239,0.46381,
     &0.46647,0.46937,0.47107,0.47200,0.47494,0.47428,0.47754,0.48397,
     &0.48557,0.48911,0.48572,0.49174,0.49934,0.49487,0.50866,0.50654,
     &0.50536,0.51440,0.51277,0.52070,0.52524,0.52952,0.53904,0.00000,
     &0.00000,0.00000,0.00000,0.18167,0.16540,0.28237,0.29822,0.33935,
     &0.42024,0.33268,0.39991,0.39502,0.43872,0.43605,0.45527,0.47395,
     &0.46535,0.47326,0.46793,0.47500,0.47538,0.48436,0.49382,0.50067,
     &0.49964,0.50583,0.51286,0.52023,0.50964,0.52733,0.52440,0.53093,
     &0.52339,0.52718,0.53417,0.54143,0.54071,0.54295,0.54684,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.19133,0.00000,0.30987,0.35430,
     &0.36934,0.42766,0.39946,0.40046,0.41443,0.42544,0.44709,0.46422,
     &0.46261,0.46964,0.48884,0.47676,0.48824,0.49320,0.50329,0.51859,
     &0.51740,0.53345,0.53583,0.53961,0.53739,0.54728,0.55201,0.56019,
     &0.56461,0.55429,0.57181,0.57500,0.57344,0.57796,0.57384,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.18150,0.35100,0.27467,
     &0.37935,0.36977,0.40491,0.40817,0.41672,0.44469,0.45518,0.47323,
     &0.47080,0.48450,0.48477,0.48240,0.51050,0.51790,0.51774,0.52027,
     &0.53888,0.54750,0.56143,0.57099,0.58058,0.57263,0.58317,0.58627,
     &0.60654,0.60331,0.60678,0.59689,0.60848,0.61013,0.62232,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.32567,0.28400,0.35325,
     &0.36695,0.37229,0.41199,0.40952,0.43145,0.43230,0.43801,0.46131,
     &0.46825,0.48759,0.48996,0.50075,0.49971,0.52232,0.51963,0.53164,
     &0.54561,0.56550,0.56772,0.58107,0.58838,0.59148,0.61412,0.61573,
     &0.62459,0.63807,0.64197,0.64603,0.63798,0.64686,0.65230,0.00000/
c::::::::::::::
capt-07-01-block.f
c::::::::::::::
      Data ((CF(K,l, 1, 3),K=1,40),l=1,13)/
     &0.07713,0.10499,0.14554,0.19785,0.24046,0.27526,0.29664,0.26014,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08733,0.11093,0.14116,0.17695,0.21250,0.26665,0.32872,0.36369,
     &0.34839,0.28294,0.22318,0.22107,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08198,0.09958,0.13090,0.15748,0.18670,0.21824,0.25411,0.28627,
     &0.31278,0.33505,0.35308,0.36503,0.38581,0.41239,0.44046,0.46678,
     &0.49241,0.51047,0.51695,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08350,0.10773,0.13498,0.15791,0.18146,0.20572,0.23606,0.26315,
     &0.29040,0.30986,0.32462,0.34015,0.35542,0.36900,0.38363,0.40102,
     &0.41758,0.43463,0.45451,0.47857,0.51059,0.53345,0.53965,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08287,0.10639,0.13488,0.15681,0.17909,0.20193,0.22834,0.25118,
     &0.27053,0.28553,0.29881,0.31166,0.32496,0.33702,0.34820,0.35719,
     &0.36812,0.37859,0.38845,0.40048,0.41524,0.43143,0.44416,0.46501,
     &0.49136,0.52729,0.56255,0.59069,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08259,0.10586,0.13587,0.15592,0.17814,0.20010,0.22480,0.24649,
     &0.26371,0.27670,0.28696,0.29838,0.30762,0.32068,0.32935,0.33720,
     &0.34619,0.35386,0.36182,0.36872,0.37822,0.38633,0.39483,0.40477,
     &0.41514,0.42735,0.43988,0.45741,0.48407,0.51119,0.55319,0.59434,
     &0.63284,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08227,0.10585,0.13658,0.15534,0.17723,0.19835,0.22231,0.24300,
     &0.26052,0.27201,0.28198,0.29072,0.30072,0.31124,0.31700,0.32532,
     &0.33238,0.33824,0.34416,0.34963,0.35699,0.36391,0.36799,0.37339,
     &0.37998,0.38563,0.39414,0.40341,0.41067,0.42344,0.43912,0.45329,
     &0.47286,0.49693,0.53487,0.57507,0.61465,0.64554,0.69763,0.00000,
     &0.08227,0.10569,0.13772,0.15488,0.17652,0.19755,0.22133,0.24237,
     &0.25876,0.27062,0.27909,0.28902,0.29689,0.30537,0.31425,0.31989,
     &0.32636,0.33058,0.33554,0.34030,0.34703,0.35124,0.35525,0.35875,
     &0.36463,0.36765,0.37150,0.37779,0.38246,0.38885,0.39511,0.40284,
     &0.41284,0.42713,0.43760,0.45074,0.47090,0.49482,0.52249,0.00000,
     &0.08225,0.10580,0.13880,0.15516,0.17658,0.19731,0.22071,0.24172,
     &0.25739,0.26754,0.27641,0.28500,0.29565,0.30391,0.31119,0.31890,
     &0.32500,0.33018,0.33433,0.33865,0.34296,0.34776,0.35218,0.35555,
     &0.35912,0.36293,0.36447,0.36989,0.37172,0.37685,0.38144,0.38624,
     &0.39142,0.39727,0.40620,0.41225,0.41974,0.43007,0.44248,0.00000,
     &0.08205,0.10583,0.13967,0.15471,0.17651,0.19744,0.22026,0.24017,
     &0.25496,0.26583,0.27474,0.28481,0.29266,0.30296,0.31002,0.31675,
     &0.32231,0.32888,0.33449,0.33871,0.34512,0.34928,0.35222,0.35738,
     &0.36019,0.36249,0.36668,0.36926,0.37245,0.37466,0.37784,0.38204,
     &0.38596,0.38875,0.39329,0.39688,0.40405,0.40943,0.41581,0.00000,
     &0.08192,0.10578,0.14076,0.15464,0.17565,0.19695,0.22005,0.24046,
     &0.25506,0.26469,0.27322,0.28231,0.29053,0.29973,0.30702,0.31479,
     &0.32259,0.32835,0.33364,0.33948,0.34504,0.35070,0.35539,0.35970,
     &0.36238,0.36671,0.37004,0.37399,0.37585,0.38003,0.38254,0.38502,
     &0.38787,0.39121,0.39477,0.39856,0.40120,0.40547,0.40864,0.00000,
     &0.08188,0.10596,0.14196,0.15446,0.17530,0.19653,0.21963,0.23942,
     &0.25426,0.26346,0.27182,0.28036,0.28938,0.29716,0.30458,0.31229,
     &0.31913,0.32562,0.33288,0.33785,0.34612,0.35195,0.35753,0.36140,
     &0.36636,0.37023,0.37367,0.37576,0.38092,0.38356,0.38588,0.38912,
     &0.39279,0.39466,0.39806,0.40083,0.40299,0.40832,0.41140,0.00000,
     &0.08186,0.10588,0.14293,0.15408,0.17556,0.19693,0.21949,0.24092,
     &0.25427,0.26368,0.27224,0.27983,0.28858,0.29622,0.30342,0.31050,
     &0.31637,0.32330,0.32980,0.33676,0.34502,0.35106,0.35597,0.36387,
     &0.36808,0.37231,0.37627,0.37940,0.38290,0.38533,0.38886,0.39328,
     &0.39515,0.39789,0.40149,0.40581,0.40854,0.41027,0.41366,0.00000/
c::::::::::::::
capt-07-02-block.f
c::::::::::::::
      Data ((CF(K,l, 2, 3),K=1,40),l=1,13)/
     &0.07843,0.10670,0.14592,0.19559,0.23817,0.27817,0.30371,0.26559,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08756,0.11111,0.14086,0.17355,0.21203,0.26766,0.32936,0.36514,
     &0.34864,0.27955,0.21446,0.20638,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08642,0.10463,0.13486,0.16332,0.19424,0.22673,0.26671,0.29975,
     &0.32302,0.34397,0.36330,0.37595,0.39469,0.41788,0.44182,0.47009,
     &0.49455,0.50982,0.51747,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08753,0.10990,0.13782,0.16377,0.19116,0.21985,0.25273,0.27966,
     &0.30547,0.32696,0.34251,0.35743,0.37119,0.38320,0.39563,0.40874,
     &0.42433,0.43712,0.45410,0.48206,0.50910,0.53063,0.54759,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08267,0.10857,0.13811,0.16225,0.18889,0.21586,0.24528,0.27010,
     &0.29011,0.30475,0.31739,0.33347,0.34751,0.35628,0.36683,0.37628,
     &0.38620,0.39588,0.40322,0.41166,0.42418,0.43412,0.44734,0.46682,
     &0.49274,0.52487,0.55295,0.58628,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08135,0.10856,0.13915,0.16099,0.18704,0.21298,0.24056,0.26505,
     &0.28281,0.29682,0.30862,0.32131,0.33204,0.34339,0.35397,0.36128,
     &0.36906,0.37566,0.38186,0.38723,0.39575,0.40324,0.40883,0.41363,
     &0.42169,0.43387,0.44391,0.45818,0.48199,0.51177,0.54814,0.57984,
     &0.61059,0.65736,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08083,0.10842,0.14026,0.16000,0.18592,0.20979,0.23723,0.26042,
     &0.27910,0.29256,0.30370,0.31511,0.32718,0.33628,0.34327,0.34846,
     &0.35812,0.36245,0.36987,0.37297,0.38018,0.38617,0.38949,0.39271,
     &0.39849,0.40233,0.40741,0.41525,0.42175,0.43328,0.44540,0.45668,
     &0.47221,0.49284,0.52656,0.55778,0.60019,0.63592,0.65648,0.00000,
     &0.08054,0.10837,0.14113,0.16001,0.18535,0.21012,0.23541,0.25784,
     &0.27510,0.28852,0.30026,0.31245,0.32105,0.33131,0.33803,0.34671,
     &0.35237,0.35630,0.36024,0.36723,0.37197,0.37557,0.37939,0.38448,
     &0.38580,0.39008,0.39194,0.39751,0.40193,0.40715,0.41387,0.42038,
     &0.42839,0.43438,0.44730,0.45781,0.47229,0.49104,0.51497,0.00000,
     &0.08015,0.10773,0.14215,0.15928,0.18421,0.20839,0.23385,0.25644,
     &0.27384,0.28606,0.29813,0.30815,0.32025,0.32877,0.33715,0.34532,
     &0.35171,0.35510,0.36028,0.36425,0.36982,0.37522,0.37790,0.38092,
     &0.38441,0.38807,0.39091,0.39361,0.39661,0.40078,0.40494,0.40791,
     &0.41149,0.41895,0.42367,0.42840,0.43838,0.44523,0.45071,0.00000,
     &0.07999,0.10817,0.14314,0.15892,0.18385,0.20854,0.23216,0.25380,
     &0.27039,0.28274,0.29394,0.30708,0.31653,0.32644,0.33433,0.34145,
     &0.35061,0.35577,0.36113,0.36591,0.37233,0.37655,0.38058,0.38322,
     &0.38701,0.39159,0.39313,0.39621,0.39922,0.40277,0.40407,0.40698,
     &0.41220,0.41336,0.41735,0.42072,0.42555,0.43104,0.43611,0.00000,
     &0.07974,0.10818,0.14418,0.15928,0.18345,0.20643,0.23123,0.25268,
     &0.26868,0.27920,0.29129,0.30213,0.31322,0.32219,0.33144,0.33987,
     &0.34650,0.35497,0.36071,0.36679,0.37308,0.37890,0.38261,0.38715,
     &0.39176,0.39385,0.39807,0.40096,0.40352,0.40665,0.40915,0.41337,
     &0.41463,0.41770,0.42081,0.42459,0.42746,0.43117,0.43570,0.00000,
     &0.07955,0.10832,0.14516,0.15897,0.18343,0.20588,0.23039,0.25151,
     &0.26619,0.27800,0.28867,0.29972,0.30899,0.32001,0.32787,0.33650,
     &0.34473,0.35163,0.35816,0.36532,0.37340,0.37999,0.38588,0.38914,
     &0.39455,0.39760,0.40139,0.40507,0.40917,0.41228,0.41464,0.41906,
     &0.42120,0.42477,0.42600,0.43023,0.43255,0.43380,0.43932,0.00000,
     &0.07941,0.10827,0.14599,0.15879,0.18272,0.20536,0.22930,0.25013,
     &0.26594,0.27828,0.28937,0.30017,0.31032,0.31922,0.32599,0.33424,
     &0.34117,0.34943,0.35560,0.36344,0.37232,0.37955,0.38547,0.39134,
     &0.39617,0.40045,0.40491,0.40877,0.41270,0.41631,0.41787,0.42247,
     &0.42557,0.42938,0.43229,0.43488,0.43919,0.44154,0.44413,0.00000/
c::::::::::::::
capt-07-03-block.f
c::::::::::::::
      Data ((CF(K,l, 3, 3),K=1,40),l=1,13)/
     &0.08305,0.10781,0.14447,0.18920,0.22726,0.27539,0.32282,0.29802,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08789,0.11220,0.14262,0.17489,0.21287,0.27110,0.33011,0.36059,
     &0.33513,0.27765,0.24858,0.26047,0.30257,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08059,0.10512,0.13832,0.16428,0.19885,0.23566,0.27331,0.30823,
     &0.33571,0.36024,0.38393,0.40284,0.41809,0.43272,0.44991,0.47219,
     &0.48646,0.50577,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08082,0.10994,0.13995,0.16360,0.19184,0.22134,0.25459,0.28663,
     &0.31316,0.33387,0.35320,0.36921,0.38639,0.40115,0.41423,0.43101,
     &0.44565,0.46061,0.47614,0.49450,0.51047,0.53233,0.54857,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08031,0.10883,0.14002,0.16212,0.18902,0.21555,0.24554,0.27068,
     &0.29131,0.30951,0.32570,0.33909,0.35291,0.36477,0.37627,0.38690,
     &0.39738,0.40837,0.41908,0.43099,0.44489,0.45717,0.46892,0.48998,
     &0.51430,0.54125,0.57266,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08013,0.10837,0.14089,0.16083,0.18749,0.21296,0.23970,0.26543,
     &0.28390,0.29765,0.31028,0.32333,0.33634,0.34595,0.35692,0.36603,
     &0.37399,0.38160,0.38973,0.39785,0.40691,0.41528,0.42301,0.43212,
     &0.44154,0.45131,0.46676,0.48410,0.50635,0.53283,0.56145,0.60565,
     &0.63348,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.07991,0.10784,0.14149,0.16043,0.18588,0.21097,0.23788,0.26052,
     &0.27748,0.29138,0.30397,0.31605,0.32711,0.33712,0.34519,0.35321,
     &0.36018,0.36550,0.37192,0.37657,0.38320,0.38872,0.39589,0.40025,
     &0.40631,0.41268,0.42055,0.43063,0.43884,0.45212,0.46765,0.48370,
     &0.49909,0.52422,0.55443,0.58452,0.62760,0.66870,0.00000,0.00000,
     &0.07977,0.10826,0.14217,0.16006,0.18457,0.20980,0.23595,0.25867,
     &0.27567,0.28900,0.30047,0.31169,0.32163,0.33197,0.34011,0.34662,
     &0.35375,0.35890,0.36254,0.36774,0.37440,0.37776,0.38158,0.38534,
     &0.39078,0.39367,0.39792,0.40287,0.40798,0.41496,0.42306,0.43077,
     &0.44030,0.45105,0.46488,0.48157,0.49729,0.51908,0.54001,0.00000,
     &0.07965,0.10795,0.14297,0.15967,0.18437,0.20855,0.23413,0.25615,
     &0.27337,0.28547,0.29741,0.30910,0.31849,0.32811,0.33787,0.34360,
     &0.35135,0.35613,0.36112,0.36631,0.37131,0.37616,0.37908,0.38356,
     &0.38534,0.38940,0.39323,0.39580,0.39953,0.40340,0.40759,0.41330,
     &0.41809,0.42501,0.43005,0.43854,0.44612,0.45832,0.46834,0.00000,
     &0.07951,0.10829,0.14415,0.15905,0.18324,0.20674,0.23214,0.25350,
     &0.26875,0.28215,0.29425,0.30569,0.31747,0.32607,0.33476,0.34274,
     &0.34983,0.35562,0.36250,0.36629,0.37248,0.37749,0.38127,0.38407,
     &0.38711,0.39172,0.39370,0.39750,0.39971,0.40213,0.40495,0.40874,
     &0.41281,0.41716,0.42000,0.42581,0.43077,0.43657,0.44336,0.00000,
     &0.07952,0.10827,0.14510,0.15844,0.18310,0.20630,0.23170,0.25218,
     &0.26765,0.27978,0.29098,0.30283,0.31292,0.32312,0.33105,0.33975,
     &0.34768,0.35362,0.36043,0.36595,0.37365,0.37951,0.38326,0.38744,
     &0.39089,0.39514,0.39851,0.40211,0.40486,0.40672,0.41070,0.41223,
     &0.41605,0.41903,0.42261,0.42532,0.42966,0.43382,0.43670,0.00000,
     &0.07941,0.10838,0.14610,0.15819,0.18226,0.20551,0.22977,0.25090,
     &0.26566,0.27734,0.28973,0.30069,0.31105,0.31973,0.32752,0.33633,
     &0.34536,0.35175,0.35858,0.36427,0.37272,0.37941,0.38444,0.38958,
     &0.39546,0.39828,0.40220,0.40557,0.40949,0.41267,0.41588,0.41745,
     &0.42219,0.42548,0.42755,0.43019,0.43193,0.43691,0.44123,0.00000,
     &0.07934,0.10828,0.14644,0.15805,0.18248,0.20554,0.22925,0.25030,
     &0.26520,0.27846,0.28949,0.30007,0.30933,0.31865,0.32665,0.33397,
     &0.34159,0.34883,0.35587,0.36240,0.37135,0.37888,0.38463,0.39042,
     &0.39624,0.40128,0.40446,0.40867,0.41310,0.41583,0.41846,0.42140,
     &0.42502,0.42940,0.43265,0.43456,0.43823,0.44102,0.44364,0.00000/
c::::::::::::::
capt-07-04-block.f
c::::::::::::::
      Data ((CF(K,l, 4, 3),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.15650,0.15357,0.20525,0.19231,0.19774,0.28639,
     &0.29527,0.26544,0.31695,0.29046,0.39100,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08737,0.10755,0.13251,0.16558,0.18404,0.17101,0.18824,0.24352,
     &0.31727,0.38260,0.42966,0.45184,0.44507,0.44958,0.46810,0.46928,
     &0.47593,0.48515,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08679,0.11255,0.13555,0.16307,0.20244,0.23387,0.26658,0.29479,
     &0.32054,0.34290,0.35542,0.37560,0.39563,0.41654,0.46090,0.50054,
     &0.53594,0.54888,0.54834,0.54026,0.53673,0.52994,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08944,0.11007,0.13183,0.16592,0.19709,0.23572,0.26602,0.29605,
     &0.32319,0.33266,0.35571,0.37325,0.38325,0.39478,0.40779,0.42583,
     &0.43850,0.45666,0.47020,0.47082,0.48651,0.49025,0.50027,0.50541,
     &0.51543,0.53341,0.52578,0.59316,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08292,0.10673,0.13248,0.16567,0.19670,0.22870,0.26923,0.29198,
     &0.31930,0.33741,0.35317,0.36717,0.37865,0.39390,0.39643,0.40927,
     &0.41665,0.42248,0.42777,0.43486,0.44109,0.45105,0.45609,0.46226,
     &0.46771,0.47615,0.48382,0.49679,0.50432,0.52982,0.53583,0.57121,
     &0.61868,0.60316,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08924,0.10903,0.13916,0.16535,0.20067,0.23452,0.26492,0.29367,
     &0.31154,0.33851,0.35537,0.36624,0.37862,0.38746,0.39451,0.39885,
     &0.40717,0.40937,0.41372,0.41954,0.42442,0.42607,0.42895,0.43700,
     &0.44126,0.44563,0.45301,0.45246,0.46064,0.46911,0.47736,0.49031,
     &0.50787,0.53342,0.54069,0.57372,0.58412,0.60360,0.00000,0.00000,
     &0.08969,0.11123,0.13699,0.16630,0.19998,0.22944,0.26561,0.29456,
     &0.31625,0.33579,0.35019,0.36534,0.38056,0.38803,0.39519,0.39973,
     &0.40728,0.40863,0.41206,0.41683,0.42233,0.42294,0.42737,0.42967,
     &0.43188,0.43459,0.43978,0.44539,0.44738,0.45369,0.44967,0.46180,
     &0.46600,0.47692,0.48463,0.49490,0.50355,0.52231,0.53580,0.00000,
     &0.09262,0.10554,0.14234,0.16551,0.20167,0.23532,0.26319,0.29450,
     &0.31877,0.33927,0.35394,0.37126,0.38040,0.39190,0.39971,0.40403,
     &0.41026,0.41308,0.41961,0.42083,0.42596,0.43115,0.43198,0.43657,
     &0.43546,0.43881,0.44082,0.44580,0.44647,0.44798,0.45386,0.45308,
     &0.45878,0.46259,0.46838,0.47809,0.47569,0.49086,0.50181,0.00000,
     &0.09226,0.10758,0.12859,0.16638,0.19430,0.23386,0.26993,0.29182,
     &0.31922,0.33606,0.35622,0.37186,0.38202,0.39479,0.39875,0.40778,
     &0.41830,0.42292,0.42612,0.43037,0.43432,0.44176,0.44451,0.45073,
     &0.44869,0.45291,0.45165,0.45633,0.45915,0.45982,0.46607,0.46556,
     &0.47088,0.47200,0.47365,0.48215,0.47975,0.48273,0.48804,0.00000,
     &0.09139,0.10905,0.13078,0.16468,0.19755,0.23421,0.26997,0.29773,
     &0.32067,0.34206,0.35854,0.37526,0.38258,0.39158,0.40493,0.41069,
     &0.41979,0.42491,0.42899,0.44025,0.44676,0.45420,0.45577,0.46230,
     &0.46665,0.47105,0.47327,0.47578,0.47892,0.47922,0.48143,0.48076,
     &0.48708,0.48950,0.49385,0.49277,0.49572,0.49944,0.50182,0.00000,
     &0.08589,0.10925,0.13844,0.16506,0.20017,0.23195,0.26122,0.29424,
     &0.31829,0.34107,0.35725,0.37068,0.38020,0.39506,0.40379,0.41118,
     &0.41701,0.42564,0.43600,0.44151,0.45081,0.46067,0.46645,0.47364,
     &0.47986,0.48386,0.48910,0.49286,0.49209,0.49975,0.50047,0.50399,
     &0.50539,0.50655,0.51070,0.51493,0.51737,0.51728,0.52260,0.00000,
     &0.08730,0.11171,0.13205,0.16661,0.20157,0.23314,0.27045,0.28907,
     &0.32244,0.34378,0.35794,0.37500,0.38645,0.39867,0.40537,0.41384,
     &0.41819,0.42957,0.43568,0.44498,0.45651,0.46647,0.47434,0.48198,
     &0.48801,0.49319,0.50066,0.50433,0.50897,0.51130,0.51368,0.51931,
     &0.52066,0.52405,0.52920,0.53079,0.53315,0.53739,0.54198,0.00000/
c::::::::::::::
capt-07-05-block.f
c::::::::::::::
      Data ((CF(K,l, 5, 3),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08850,0.10246,0.13775,0.15926,0.18823,0.23440,0.26615,0.30101,
     &0.33828,0.37208,0.39143,0.40414,0.41967,0.42504,0.44446,0.44791,
     &0.45940,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08796,0.10800,0.13558,0.16501,0.19480,0.22741,0.25558,0.28355,
     &0.30589,0.33162,0.35073,0.37016,0.37869,0.39977,0.42095,0.43491,
     &0.44532,0.46422,0.47145,0.49152,0.51027,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08267,0.10935,0.13145,0.16018,0.19150,0.22411,0.25191,0.27677,
     &0.29320,0.31490,0.33227,0.34871,0.36673,0.37561,0.39200,0.40232,
     &0.40797,0.41744,0.42393,0.43335,0.44570,0.46334,0.47603,0.49543,
     &0.51355,0.56795,0.57363,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08844,0.11019,0.13294,0.16600,0.19518,0.22239,0.25138,0.28086,
     &0.29699,0.31576,0.32874,0.34795,0.35961,0.37401,0.38266,0.38660,
     &0.39776,0.40414,0.40710,0.41627,0.42243,0.42902,0.43455,0.44596,
     &0.45311,0.46468,0.48165,0.49027,0.50896,0.52123,0.55963,0.60274,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08819,0.10686,0.12994,0.16634,0.18495,0.22339,0.24883,0.27500,
     &0.29726,0.31181,0.32602,0.34930,0.36887,0.37087,0.38065,0.38931,
     &0.39189,0.39729,0.40369,0.40686,0.41281,0.41618,0.41912,0.42323,
     &0.42546,0.43446,0.43725,0.44736,0.45146,0.46392,0.48005,0.48748,
     &0.51268,0.53010,0.54780,0.59021,0.61645,0.00000,0.00000,0.00000,
     &0.09405,0.10858,0.14086,0.16656,0.19283,0.22086,0.24973,0.27445,
     &0.29781,0.32195,0.33100,0.34574,0.36260,0.37528,0.38402,0.39074,
     &0.39193,0.39809,0.40355,0.40655,0.40992,0.41182,0.41381,0.42091,
     &0.42070,0.42557,0.42847,0.43448,0.43959,0.44201,0.44952,0.45988,
     &0.46177,0.47463,0.48539,0.49322,0.51242,0.53144,0.56044,0.00000,
     &0.08488,0.10341,0.12396,0.16490,0.18609,0.23169,0.25361,0.27321,
     &0.29704,0.31757,0.33338,0.35180,0.36773,0.37839,0.38725,0.39258,
     &0.39979,0.40571,0.40899,0.41074,0.41777,0.42035,0.42487,0.42549,
     &0.43139,0.43418,0.43261,0.43694,0.43809,0.44669,0.45151,0.44870,
     &0.45433,0.46099,0.46250,0.46708,0.48221,0.48524,0.49257,0.00000,
     &0.08851,0.11435,0.13149,0.16778,0.18593,0.22034,0.26040,0.27133,
     &0.28609,0.31648,0.33164,0.35342,0.37001,0.38005,0.39012,0.39876,
     &0.40587,0.40338,0.41295,0.41875,0.42263,0.42733,0.43061,0.43381,
     &0.44287,0.44218,0.44634,0.44878,0.45493,0.45636,0.46053,0.46380,
     &0.46922,0.46880,0.47199,0.47944,0.47826,0.48177,0.48805,0.00000,
     &0.08095,0.10426,0.13446,0.16511,0.18764,0.22536,0.24313,0.27658,
     &0.29477,0.31624,0.33267,0.34853,0.36653,0.37870,0.38859,0.39957,
     &0.40259,0.41324,0.41890,0.42622,0.43224,0.43559,0.44557,0.44972,
     &0.45364,0.45682,0.46257,0.46358,0.46986,0.47096,0.47870,0.47962,
     &0.48671,0.48701,0.49119,0.49356,0.49438,0.49924,0.50041,0.00000,
     &0.08957,0.10883,0.12463,0.16432,0.19352,0.22223,0.24960,0.27091,
     &0.29524,0.31298,0.32986,0.34899,0.36471,0.37952,0.39002,0.39972,
     &0.40728,0.41431,0.42266,0.42834,0.43114,0.44038,0.45109,0.45691,
     &0.46214,0.46966,0.47440,0.47899,0.48333,0.49098,0.49284,0.49738,
     &0.50191,0.50500,0.50271,0.50917,0.51467,0.51524,0.51785,0.00000,
     &0.08971,0.10954,0.13862,0.16624,0.18460,0.21951,0.24735,0.26774,
     &0.29794,0.31441,0.32525,0.34854,0.36402,0.37985,0.38987,0.40069,
     &0.40557,0.41179,0.42202,0.43142,0.43805,0.44777,0.45447,0.46117,
     &0.47014,0.47553,0.48431,0.48885,0.49331,0.50350,0.50483,0.51198,
     &0.51725,0.52182,0.52487,0.52579,0.53014,0.53795,0.53307,0.00000/
c::::::::::::::
capt-07-06-block.f
c::::::::::::::
      Data ((CF(K,l, 6, 3),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.22550,0.12286,0.24158,0.22875,0.28505,
     &0.32284,0.22568,0.23233,0.25343,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08754,0.10787,0.13444,0.16579,0.18969,0.17251,0.18620,0.24102,
     &0.31634,0.38218,0.42945,0.45428,0.44946,0.44359,0.45805,0.46444,
     &0.47807,0.48673,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08977,0.10903,0.13472,0.16470,0.19821,0.23167,0.26476,0.29000,
     &0.31986,0.34197,0.36148,0.37604,0.39627,0.41722,0.44850,0.48979,
     &0.52099,0.53440,0.53513,0.53647,0.54030,0.53625,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.09001,0.11037,0.13382,0.16437,0.19614,0.22917,0.25839,0.28704,
     &0.31251,0.32983,0.35031,0.36734,0.38180,0.39497,0.40287,0.41810,
     &0.43548,0.44538,0.45574,0.46261,0.46765,0.48231,0.49092,0.50478,
     &0.51095,0.53867,0.56573,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08835,0.10908,0.13140,0.16059,0.19627,0.22708,0.25737,0.28310,
     &0.30996,0.32633,0.34701,0.36278,0.37755,0.38675,0.39631,0.40233,
     &0.41101,0.41895,0.42355,0.42893,0.43234,0.44241,0.44576,0.45512,
     &0.45900,0.47474,0.47876,0.49307,0.51580,0.53166,0.55411,0.59339,
     &0.61824,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08579,0.11072,0.13416,0.16511,0.19760,0.22960,0.26108,0.28292,
     &0.30626,0.32901,0.34663,0.35980,0.37348,0.38279,0.39188,0.39854,
     &0.40613,0.41028,0.41042,0.41752,0.42021,0.42442,0.42935,0.43355,
     &0.44085,0.44458,0.44690,0.45543,0.45729,0.46791,0.47716,0.49296,
     &0.51064,0.52593,0.55252,0.57469,0.61661,0.62094,0.00000,0.00000,
     &0.08920,0.11255,0.13261,0.16824,0.19456,0.22843,0.26027,0.28751,
     &0.30980,0.32801,0.34563,0.36269,0.37926,0.38588,0.39356,0.40206,
     &0.40617,0.40670,0.41347,0.41291,0.41552,0.42260,0.42386,0.42711,
     &0.43144,0.43469,0.43652,0.44521,0.44635,0.45307,0.45622,0.46070,
     &0.46661,0.47422,0.48292,0.49376,0.50760,0.52878,0.54739,0.00000,
     &0.08724,0.10804,0.13230,0.16436,0.19702,0.22529,0.26189,0.28729,
     &0.31184,0.33257,0.34681,0.36498,0.37953,0.38920,0.39845,0.40442,
     &0.40666,0.41445,0.41718,0.42366,0.42500,0.42826,0.43113,0.43010,
     &0.43612,0.43783,0.44023,0.44447,0.44605,0.44998,0.45362,0.45674,
     &0.46122,0.46494,0.47230,0.47137,0.48058,0.48777,0.49977,0.00000,
     &0.08505,0.11022,0.13451,0.16859,0.19192,0.23003,0.25883,0.28892,
     &0.31058,0.33178,0.34535,0.36605,0.37847,0.39004,0.39892,0.40801,
     &0.41117,0.41960,0.42421,0.42943,0.43331,0.43662,0.44134,0.44473,
     &0.44828,0.45150,0.45532,0.45837,0.45970,0.45996,0.46581,0.46769,
     &0.47206,0.47210,0.47800,0.48272,0.48253,0.48571,0.48982,0.00000,
     &0.08602,0.10899,0.13709,0.16216,0.19285,0.23112,0.26447,0.28682,
     &0.30678,0.33343,0.34594,0.36483,0.38023,0.39281,0.40291,0.40831,
     &0.41608,0.42195,0.42885,0.43591,0.44156,0.44756,0.45347,0.45715,
     &0.46029,0.46544,0.47057,0.47100,0.47644,0.48132,0.48156,0.48305,
     &0.48567,0.49032,0.49447,0.49774,0.49885,0.50024,0.50668,0.00000,
     &0.08876,0.10981,0.13231,0.16000,0.19483,0.22568,0.25952,0.28776,
     &0.30812,0.32620,0.34840,0.36868,0.38019,0.39002,0.40135,0.41188,
     &0.41780,0.42507,0.43470,0.43999,0.44760,0.45390,0.46232,0.47160,
     &0.47407,0.47774,0.48577,0.48961,0.49265,0.49646,0.50026,0.50591,
     &0.50821,0.51085,0.51515,0.51792,0.51893,0.52089,0.52560,0.00000,
     &0.08692,0.10660,0.13700,0.16216,0.19736,0.22801,0.26332,0.28666,
     &0.31325,0.33100,0.34661,0.36521,0.37972,0.39185,0.40155,0.41101,
     &0.42156,0.42341,0.43134,0.43957,0.45198,0.46028,0.46947,0.47604,
     &0.48233,0.48853,0.49623,0.50173,0.50411,0.51029,0.51345,0.51871,
     &0.52056,0.52598,0.52852,0.53332,0.53807,0.54028,0.54295,0.00000/
c::::::::::::::
capt-07-07-block.f
c::::::::::::::
      Data ((CF(K,l, 7, 3),K=1,40),l=1,13)/
     &0.08876,0.11175,0.14120,0.17789,0.22297,0.27756,0.33949,0.32750,
     &0.23769,0.26946,0.22940,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08861,0.11137,0.14072,0.17722,0.22233,0.27780,0.34411,0.39235,
     &0.35011,0.43763,0.53028,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08789,0.10962,0.13668,0.17022,0.21041,0.25749,0.30525,0.34495,
     &0.37922,0.43266,0.49130,0.54871,0.60521,0.64939,0.61375,0.60359,
     &0.65340,0.65700,0.65465,0.60596,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08772,0.10957,0.13682,0.17042,0.21128,0.26140,0.31788,0.37297,
     &0.40984,0.43897,0.47822,0.52594,0.57411,0.61520,0.63332,0.63140,
     &0.59365,0.54257,0.52814,0.52936,0.53841,0.55146,0.56667,0.57273,
     &0.48946,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08786,0.10963,0.13670,0.17034,0.21112,0.26033,0.31727,0.37126,
     &0.41086,0.44247,0.47968,0.51572,0.55412,0.58444,0.59356,0.59658,
     &0.58732,0.57230,0.55086,0.52242,0.51779,0.52186,0.51508,0.51475,
     &0.51237,0.51681,0.53490,0.56215,0.56943,0.49059,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08785,0.10959,0.13684,0.17079,0.21140,0.26089,0.31788,0.37377,
     &0.41986,0.45500,0.49017,0.52891,0.56285,0.58614,0.59493,0.59438,
     &0.58259,0.56227,0.55134,0.54359,0.53487,0.52460,0.52213,0.53133,
     &0.52425,0.51980,0.51877,0.51885,0.51852,0.52259,0.53655,0.55164,
     &0.57477,0.59254,0.50135,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08777,0.10987,0.13720,0.17090,0.21172,0.26274,0.31945,0.37689,
     &0.42407,0.46187,0.50175,0.54023,0.57242,0.60071,0.60812,0.60286,
     &0.58524,0.56594,0.54961,0.53581,0.52677,0.52526,0.51633,0.52005,
     &0.52199,0.52040,0.52594,0.52492,0.51848,0.52016,0.52325,0.52910,
     &0.52656,0.53550,0.54748,0.55655,0.57147,0.59954,0.60730,0.00000,
     &0.08784,0.10976,0.13734,0.17108,0.21258,0.26260,0.31968,0.37931,
     &0.42887,0.47074,0.51115,0.54895,0.57998,0.60569,0.61527,0.61557,
     &0.59477,0.57251,0.55698,0.54092,0.53199,0.52869,0.51810,0.51945,
     &0.51895,0.50607,0.51366,0.51433,0.52196,0.51279,0.51824,0.51658,
     &0.52200,0.52439,0.52572,0.53540,0.53954,0.54924,0.55605,0.00000,
     &0.08799,0.10984,0.13734,0.17080,0.21290,0.26284,0.32255,0.38062,
     &0.43232,0.47579,0.51527,0.55418,0.58247,0.60677,0.62461,0.62067,
     &0.60769,0.58572,0.56648,0.55524,0.54519,0.53969,0.52925,0.52840,
     &0.52988,0.52181,0.52265,0.51703,0.51699,0.51602,0.52419,0.52010,
     &0.52294,0.52746,0.52457,0.52603,0.53524,0.53555,0.54225,0.00000,
     &0.08788,0.11013,0.13743,0.17083,0.21302,0.26384,0.32281,0.38283,
     &0.43499,0.47735,0.51737,0.55350,0.58546,0.61340,0.62850,0.62928,
     &0.61796,0.59437,0.57909,0.56581,0.56082,0.55296,0.55271,0.54842,
     &0.54105,0.54079,0.53486,0.53682,0.53318,0.53833,0.53522,0.54667,
     &0.54676,0.54702,0.54843,0.54604,0.54879,0.54800,0.54823,0.00000,
     &0.08804,0.11034,0.13735,0.17165,0.21302,0.26446,0.32260,0.38235,
     &0.43487,0.47957,0.51866,0.55809,0.58938,0.61888,0.63496,0.63970,
     &0.62931,0.60814,0.58746,0.58056,0.57125,0.57342,0.56836,0.57007,
     &0.56116,0.56515,0.56611,0.56434,0.56613,0.57145,0.57130,0.57073,
     &0.56985,0.57426,0.57307,0.57883,0.58057,0.57906,0.57692,0.00000,
     &0.08815,0.11021,0.13794,0.17109,0.21371,0.26423,0.32363,0.38241,
     &0.43559,0.47745,0.51813,0.55799,0.59250,0.62125,0.64099,0.65264,
     &0.63812,0.62032,0.60617,0.59050,0.57920,0.57446,0.57807,0.57837,
     &0.58344,0.57855,0.58605,0.58634,0.59161,0.58853,0.59919,0.60168,
     &0.60968,0.60847,0.60968,0.61077,0.61469,0.61567,0.61960,0.00000,
     &0.08812,0.11013,0.13765,0.17159,0.21361,0.26433,0.32289,0.38159,
     &0.43227,0.47600,0.51802,0.55724,0.59461,0.63207,0.65430,0.67008,
     &0.65605,0.64446,0.61139,0.59698,0.59076,0.58744,0.58996,0.58644,
     &0.59102,0.59728,0.60092,0.60594,0.61022,0.61565,0.62329,0.62141,
     &0.63388,0.62862,0.63953,0.64231,0.64183,0.64243,0.65107,0.00000/
c::::::::::::::
capt-07-08-block.f
c::::::::::::::
      Data ((CF(K,l, 8, 3),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.15660,0.28883,0.23915,
     &0.31347,0.32167,0.34312,0.35846,0.38146,0.41545,0.40858,0.41115,
     &0.39614,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.12400,0.21700,0.16088,0.23269,0.28707,0.36183,
     &0.35076,0.36728,0.33623,0.36879,0.40032,0.40935,0.45062,0.45423,
     &0.46334,0.47418,0.47715,0.48920,0.49055,0.47895,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.15375,0.16740,0.32589,0.28446,0.32117,
     &0.38579,0.38637,0.38672,0.41243,0.41721,0.43209,0.47143,0.48160,
     &0.48184,0.47581,0.47436,0.48567,0.48765,0.48574,0.50504,0.51798,
     &0.55749,0.59073,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.07200,0.09350,0.14667,0.18725,0.22900,0.26815,0.31293,0.37136,
     &0.37706,0.37396,0.38879,0.39717,0.43569,0.42561,0.45898,0.47814,
     &0.47514,0.47154,0.47567,0.46878,0.47119,0.47760,0.47970,0.48346,
     &0.49842,0.50861,0.52485,0.54991,0.56908,0.60496,0.65312,0.72452,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.13950,0.15850,0.20833,0.23056,0.32354,0.34182,
     &0.36137,0.41044,0.39900,0.41242,0.41338,0.43422,0.45693,0.46233,
     &0.46688,0.46868,0.46736,0.46586,0.46839,0.46261,0.47342,0.47379,
     &0.47881,0.48249,0.48482,0.49438,0.50695,0.51949,0.52872,0.55632,
     &0.58402,0.60403,0.67237,0.71890,0.78867,0.00000,0.00000,0.00000,
     &0.10350,0.13050,0.16650,0.18120,0.24133,0.23792,0.33044,0.36959,
     &0.35198,0.37874,0.39926,0.39164,0.40147,0.44178,0.44371,0.45994,
     &0.46529,0.46065,0.46417,0.46358,0.46563,0.46863,0.47018,0.47719,
     &0.47605,0.47770,0.48637,0.48895,0.49110,0.49277,0.50150,0.50832,
     &0.51920,0.52982,0.54794,0.55133,0.58317,0.60672,0.64237,0.00000,
     &0.00000,0.00000,0.00000,0.17975,0.23233,0.29137,0.35147,0.36495,
     &0.39926,0.34400,0.39970,0.43616,0.41707,0.43609,0.46029,0.46502,
     &0.46514,0.46560,0.46774,0.46734,0.47196,0.47464,0.47488,0.48060,
     &0.48780,0.49090,0.49897,0.49765,0.50148,0.50007,0.51485,0.51310,
     &0.51269,0.52364,0.52183,0.52918,0.53820,0.54423,0.55825,0.00000,
     &0.00000,0.00000,0.11600,0.23400,0.21530,0.26686,0.30862,0.33396,
     &0.35990,0.38148,0.38986,0.40479,0.41767,0.42516,0.45051,0.46098,
     &0.46800,0.47390,0.47851,0.47542,0.48097,0.48907,0.49510,0.49351,
     &0.50223,0.50697,0.51292,0.51846,0.51818,0.52648,0.52338,0.53247,
     &0.53699,0.53847,0.54481,0.54675,0.54502,0.54674,0.55248,0.00000,
     &0.00000,0.00000,0.16967,0.00000,0.24033,0.27300,0.33297,0.36196,
     &0.42000,0.38723,0.38684,0.40704,0.41024,0.43599,0.44282,0.45959,
     &0.47050,0.47828,0.47862,0.47973,0.48827,0.49777,0.51354,0.51532,
     &0.51941,0.53043,0.53688,0.53924,0.54721,0.55289,0.56260,0.56302,
     &0.56601,0.56852,0.57498,0.57505,0.57731,0.58307,0.58510,0.00000,
     &0.00000,0.14000,0.17750,0.18440,0.25920,0.27915,0.33157,0.31971,
     &0.40524,0.40568,0.39901,0.40235,0.41511,0.42851,0.45043,0.45069,
     &0.46683,0.47390,0.48297,0.48940,0.49958,0.50523,0.52061,0.53371,
     &0.54202,0.54716,0.55446,0.57006,0.57233,0.58210,0.58747,0.59411,
     &0.60197,0.60354,0.60543,0.61050,0.61379,0.61620,0.62070,0.00000,
     &0.00000,0.00000,0.15967,0.19900,0.00000,0.26029,0.28800,0.35274,
     &0.41810,0.38734,0.41032,0.40756,0.41283,0.43418,0.44917,0.46663,
     &0.47415,0.47878,0.48141,0.49063,0.49932,0.51384,0.52106,0.53705,
     &0.55046,0.56604,0.57260,0.58453,0.58947,0.60062,0.60628,0.61286,
     &0.62130,0.62589,0.63504,0.64067,0.64368,0.64401,0.65308,0.00000/
c::::::::::::::
capt-07-09-block.f
c::::::::::::::
      Data ((CF(K,l, 9, 3),K=1,40),l=1,13)/
     &0.08867,0.11156,0.14099,0.17745,0.22254,0.27704,0.33969,0.33674,
     &0.24188,0.18184,0.13932,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08842,0.11130,0.14065,0.17710,0.22231,0.27771,0.34440,0.39415,
     &0.35649,0.40468,0.49216,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08736,0.10926,0.13592,0.16919,0.21004,0.25688,0.30491,0.34367,
     &0.38017,0.43494,0.49255,0.55023,0.60946,0.65532,0.62685,0.61394,
     &0.65765,0.65611,0.68032,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08738,0.10900,0.13589,0.16945,0.21095,0.26076,0.31725,0.36972,
     &0.40736,0.43825,0.47905,0.52478,0.57493,0.61535,0.63669,0.63729,
     &0.60566,0.55490,0.53533,0.53845,0.54890,0.56392,0.58474,0.61727,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08744,0.10915,0.13632,0.16907,0.21070,0.26056,0.31598,0.36938,
     &0.41037,0.44275,0.47831,0.51768,0.55322,0.58223,0.59364,0.59644,
     &0.59628,0.57096,0.54985,0.53038,0.52283,0.52104,0.52188,0.52536,
     &0.52358,0.53186,0.54433,0.57556,0.61537,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08731,0.10918,0.13628,0.16900,0.21053,0.26037,0.31718,0.37342,
     &0.41735,0.45449,0.49129,0.52983,0.56075,0.58820,0.59963,0.59491,
     &0.57918,0.56179,0.55146,0.54215,0.53550,0.52414,0.52711,0.52989,
     &0.52603,0.52666,0.52375,0.52306,0.52973,0.53624,0.54523,0.55792,
     &0.59102,0.63445,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08745,0.10933,0.13613,0.16964,0.21044,0.26076,0.31790,0.37563,
     &0.42432,0.46300,0.50147,0.54240,0.57236,0.59998,0.60552,0.60425,
     &0.58704,0.56843,0.54800,0.53264,0.52653,0.52359,0.52362,0.51559,
     &0.51813,0.52031,0.52296,0.52163,0.52060,0.52604,0.52521,0.53152,
     &0.53580,0.54591,0.55652,0.56666,0.58519,0.60854,0.65451,0.00000,
     &0.08753,0.10948,0.13614,0.16982,0.21123,0.26232,0.31951,0.37914,
     &0.42853,0.47034,0.50840,0.54879,0.58200,0.60458,0.61466,0.61430,
     &0.59830,0.57983,0.55660,0.54086,0.53457,0.52355,0.52095,0.51827,
     &0.51238,0.51194,0.51468,0.51849,0.51678,0.51973,0.51964,0.52483,
     &0.52560,0.52503,0.53243,0.54400,0.54644,0.55770,0.56033,0.00000,
     &0.08754,0.10945,0.13686,0.17018,0.21134,0.26290,0.32084,0.37898,
     &0.43226,0.47632,0.51677,0.55182,0.58505,0.60929,0.62188,0.62087,
     &0.60711,0.58862,0.56854,0.55508,0.54409,0.53803,0.53721,0.52564,
     &0.52364,0.52222,0.52415,0.52271,0.52554,0.52177,0.52126,0.51745,
     &0.52558,0.52396,0.53005,0.53309,0.53184,0.54019,0.55330,0.00000,
     &0.08761,0.10962,0.13687,0.17016,0.21228,0.26343,0.32218,0.38256,
     &0.43348,0.47696,0.51987,0.55577,0.58748,0.61316,0.63027,0.63171,
     &0.61363,0.59706,0.57557,0.56944,0.56011,0.55405,0.54861,0.54549,
     &0.54549,0.54017,0.54221,0.53628,0.54408,0.53970,0.53787,0.54205,
     &0.54036,0.54313,0.54750,0.54700,0.54815,0.55368,0.55577,0.00000,
     &0.08775,0.10968,0.13676,0.17064,0.21236,0.26326,0.32172,0.38281,
     &0.43351,0.47947,0.51929,0.55385,0.59113,0.61416,0.63243,0.63763,
     &0.62654,0.60960,0.59023,0.57741,0.57749,0.57004,0.56808,0.57150,
     &0.56405,0.57059,0.56623,0.56761,0.56807,0.56901,0.57142,0.57158,
     &0.57419,0.57252,0.57707,0.57930,0.58297,0.59001,0.58610,0.00000,
     &0.08767,0.10960,0.13693,0.17016,0.21259,0.26374,0.32187,0.38199,
     &0.43309,0.47652,0.51978,0.55753,0.59120,0.62227,0.64442,0.65117,
     &0.63658,0.62451,0.59753,0.58990,0.58266,0.58153,0.58040,0.58188,
     &0.58926,0.58876,0.58994,0.59295,0.59640,0.59689,0.60119,0.60768,
     &0.60791,0.61285,0.61135,0.61717,0.61177,0.62479,0.62567,0.00000,
     &0.08791,0.10977,0.13705,0.17011,0.21224,0.26327,0.32156,0.38099,
     &0.43214,0.47389,0.51535,0.55969,0.59738,0.63312,0.65979,0.66837,
     &0.65582,0.63836,0.61696,0.60345,0.59522,0.59394,0.58913,0.59783,
     &0.59648,0.60261,0.60219,0.61033,0.61032,0.61980,0.62468,0.62919,
     &0.63256,0.63491,0.64120,0.64119,0.64567,0.64962,0.65383,0.00000/
c::::::::::::::
capt-07-10-block.f
c::::::::::::::
      Data ((CF(K,l,10, 3),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.15600,0.00000,0.36440,0.32612,
     &0.27060,0.34627,0.40556,0.39879,0.40297,0.43958,0.38921,0.44803,
     &0.40380,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.23473,0.26617,0.25984,0.37081,
     &0.36554,0.35286,0.35847,0.37086,0.39752,0.42345,0.42753,0.45994,
     &0.47151,0.46285,0.48217,0.48086,0.49690,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.13467,0.11925,0.23333,0.22956,0.24025,0.27586,0.30592,
     &0.40881,0.38672,0.40419,0.39976,0.42302,0.43747,0.45487,0.47713,
     &0.48161,0.47754,0.47054,0.47290,0.48212,0.49239,0.49878,0.53713,
     &0.54428,0.58199,0.64288,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.12750,0.15500,0.12967,0.24060,0.28846,0.37329,0.34276,
     &0.38194,0.39828,0.38947,0.40323,0.40359,0.43078,0.45095,0.46984,
     &0.47746,0.46597,0.47085,0.47384,0.46556,0.47529,0.48193,0.47902,
     &0.49649,0.50738,0.52828,0.54978,0.57534,0.61432,0.64665,0.72495,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.14267,0.21225,0.20738,0.30737,0.29733,0.38061,
     &0.39247,0.36185,0.40472,0.41644,0.41498,0.42220,0.44118,0.46532,
     &0.46525,0.46264,0.46706,0.46237,0.46729,0.46876,0.47710,0.47594,
     &0.47603,0.48699,0.48879,0.49063,0.50725,0.51339,0.53015,0.55568,
     &0.56804,0.61141,0.65448,0.71194,0.77182,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.15733,0.22625,0.23010,0.27250,0.32217,0.33519,
     &0.40636,0.37334,0.37963,0.40198,0.42101,0.43015,0.44547,0.46014,
     &0.46585,0.46019,0.46455,0.46523,0.46894,0.47114,0.47183,0.47406,
     &0.47343,0.48398,0.48803,0.48824,0.49471,0.49784,0.50341,0.50884,
     &0.51903,0.52850,0.53635,0.54723,0.57519,0.60775,0.63854,0.00000,
     &0.10650,0.00000,0.09850,0.19050,0.22420,0.24129,0.29405,0.35974,
     &0.36435,0.37732,0.41649,0.40136,0.41137,0.43296,0.45367,0.45986,
     &0.47245,0.46828,0.46874,0.46600,0.47598,0.48049,0.48081,0.48641,
     &0.48780,0.48936,0.49435,0.50134,0.50404,0.50326,0.50458,0.51209,
     &0.51500,0.51785,0.52146,0.52704,0.53894,0.54290,0.54663,0.00000,
     &0.00000,0.14250,0.00000,0.18580,0.18820,0.26067,0.32470,0.33956,
     &0.40238,0.39368,0.37721,0.42894,0.41901,0.43896,0.45330,0.46560,
     &0.46805,0.47609,0.47224,0.47588,0.48100,0.49066,0.49591,0.49922,
     &0.49951,0.51037,0.51569,0.52052,0.52899,0.52400,0.52888,0.53331,
     &0.54075,0.53941,0.54226,0.55487,0.54480,0.54895,0.55085,0.00000,
     &0.00000,0.10067,0.00000,0.18440,0.21029,0.26433,0.30635,0.38217,
     &0.41185,0.35881,0.40507,0.41412,0.41598,0.43661,0.46259,0.46890,
     &0.47139,0.47909,0.47936,0.48409,0.49576,0.50439,0.51212,0.52457,
     &0.52646,0.53192,0.53888,0.54156,0.55393,0.55785,0.56365,0.56635,
     &0.56454,0.56402,0.57612,0.57619,0.58491,0.58360,0.58764,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.24100,0.27800,0.28400,0.35508,
     &0.40700,0.39187,0.40441,0.39887,0.43129,0.43974,0.46125,0.46360,
     &0.46843,0.48142,0.48086,0.49812,0.49346,0.50857,0.51844,0.53395,
     &0.54250,0.55194,0.56348,0.56995,0.57691,0.58273,0.58877,0.59177,
     &0.59986,0.60422,0.61202,0.61361,0.60981,0.62035,0.62458,0.00000,
     &0.00000,0.13525,0.00000,0.14833,0.24060,0.26127,0.31923,0.35031,
     &0.39002,0.38924,0.38521,0.40210,0.41426,0.43474,0.45961,0.46475,
     &0.46733,0.47782,0.48620,0.48656,0.49906,0.51288,0.52528,0.54046,
     &0.55226,0.56739,0.57638,0.58102,0.59823,0.59659,0.60639,0.61658,
     &0.62451,0.63233,0.62977,0.63690,0.64190,0.64527,0.65575,0.00000/
c::::::::::::::
capt-09-01-block.f
c::::::::::::::
      Data ((CF(K,l, 1, 4),K=1,40),l=1,13)/
     &0.07668,0.10494,0.14551,0.19842,0.24221,0.27472,0.29012,0.25367,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08725,0.11105,0.14158,0.17750,0.21087,0.26350,0.32983,0.36996,
     &0.36020,0.29438,0.22851,0.22233,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08233,0.09994,0.13026,0.15762,0.18635,0.21764,0.25349,0.28609,
     &0.31294,0.33503,0.35256,0.36389,0.38612,0.41226,0.43987,0.46432,
     &0.49476,0.50957,0.51705,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08367,0.10793,0.13419,0.15842,0.18135,0.20598,0.23559,0.26294,
     &0.29049,0.30935,0.32560,0.34123,0.35560,0.37046,0.38439,0.40106,
     &0.41752,0.43553,0.45416,0.47940,0.51055,0.53093,0.55146,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08277,0.10623,0.13416,0.15657,0.17995,0.20231,0.22868,0.25206,
     &0.27079,0.28494,0.29807,0.31329,0.32424,0.33640,0.34820,0.35922,
     &0.36810,0.37864,0.38920,0.40217,0.41710,0.43021,0.44716,0.46823,
     &0.50111,0.53121,0.55942,0.59919,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08262,0.10616,0.13499,0.15580,0.17821,0.19981,0.22529,0.24683,
     &0.26441,0.27684,0.28770,0.29867,0.30851,0.32080,0.33059,0.33693,
     &0.34489,0.35411,0.36208,0.36821,0.37897,0.38586,0.39601,0.40424,
     &0.41413,0.42885,0.44337,0.46153,0.48401,0.51559,0.55885,0.60017,
     &0.63058,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08244,0.10593,0.13621,0.15568,0.17731,0.19926,0.22195,0.24445,
     &0.26080,0.27273,0.28299,0.29265,0.30240,0.31009,0.31881,0.32497,
     &0.33318,0.33905,0.34417,0.34986,0.35666,0.36404,0.36767,0.37291,
     &0.37915,0.38487,0.39388,0.40250,0.41338,0.42516,0.43971,0.45575,
     &0.47843,0.50610,0.54123,0.57509,0.61282,0.64774,0.00000,0.00000,
     &0.08221,0.10584,0.13695,0.15525,0.17700,0.19849,0.22231,0.24327,
     &0.25879,0.27009,0.27950,0.28824,0.29801,0.30475,0.31282,0.32002,
     &0.32448,0.32835,0.33466,0.33885,0.34414,0.34782,0.35188,0.35576,
     &0.36093,0.36334,0.36814,0.37280,0.37832,0.38482,0.39040,0.40048,
     &0.40989,0.42056,0.43473,0.44959,0.46799,0.49103,0.51426,0.00000,
     &0.08218,0.10586,0.13786,0.15516,0.17741,0.19756,0.22229,0.24289,
     &0.25798,0.26959,0.27699,0.28605,0.29549,0.30335,0.30965,0.31698,
     &0.32150,0.32564,0.33094,0.33408,0.33958,0.34250,0.34648,0.34972,
     &0.35237,0.35537,0.35869,0.36246,0.36385,0.36880,0.37359,0.37693,
     &0.38315,0.38909,0.39486,0.40282,0.41278,0.42435,0.43548,0.00000,
     &0.08217,0.10576,0.13894,0.15586,0.17717,0.19809,0.22309,0.24284,
     &0.25717,0.26848,0.27616,0.28448,0.29345,0.30252,0.30796,0.31571,
     &0.31986,0.32636,0.32986,0.33311,0.34022,0.34317,0.34467,0.34927,
     &0.35198,0.35366,0.35724,0.35826,0.36201,0.36504,0.36733,0.37081,
     &0.37381,0.37656,0.38231,0.38618,0.39204,0.39611,0.40390,0.00000,
     &0.08205,0.10583,0.14011,0.15619,0.17744,0.20001,0.22404,0.24351,
     &0.25790,0.26702,0.27416,0.28127,0.29151,0.29918,0.30664,0.31320,
     &0.31890,0.32457,0.32960,0.33481,0.34133,0.34428,0.34764,0.35059,
     &0.35316,0.35599,0.35953,0.36201,0.36388,0.36622,0.37044,0.37158,
     &0.37387,0.37652,0.37965,0.38258,0.38651,0.38854,0.39505,0.00000,
     &0.08206,0.10612,0.14119,0.15609,0.17874,0.20083,0.22495,0.24471,
     &0.25756,0.26723,0.27309,0.28193,0.28958,0.29679,0.30592,0.31080,
     &0.31672,0.32278,0.32784,0.33528,0.34051,0.34476,0.34856,0.35402,
     &0.35708,0.35938,0.36217,0.36408,0.36722,0.37131,0.37431,0.37556,
     &0.37765,0.38108,0.38414,0.38569,0.38764,0.39102,0.39372,0.00000,
     &0.08199,0.10609,0.14209,0.15581,0.17891,0.20019,0.22468,0.24553,
     &0.25923,0.26822,0.27441,0.28300,0.28991,0.29729,0.30302,0.30964,
     &0.31565,0.32087,0.32683,0.33359,0.33981,0.34538,0.35061,0.35510,
     &0.35916,0.36236,0.36582,0.36877,0.37170,0.37443,0.37668,0.38107,
     &0.38311,0.38573,0.38756,0.38987,0.39304,0.39612,0.39883,0.00000/
c::::::::::::::
capt-09-02-block.f
c::::::::::::::
      Data ((CF(K,l, 2, 4),K=1,40),l=1,13)/
     &0.07873,0.10736,0.14520,0.18915,0.22294,0.28483,0.34844,0.32947,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08817,0.11100,0.13974,0.17269,0.21338,0.27175,0.33021,0.36110,
     &0.33602,0.27892,0.24492,0.25813,0.30360,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08696,0.10542,0.13499,0.16461,0.19672,0.23099,0.27322,0.30866,
     &0.33496,0.35955,0.38423,0.40057,0.41724,0.43417,0.45043,0.46874,
     &0.48900,0.50049,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08768,0.10982,0.13731,0.16405,0.19185,0.22144,0.25406,0.28238,
     &0.30999,0.33372,0.35257,0.37042,0.38556,0.40009,0.41589,0.43158,
     &0.44724,0.46347,0.47836,0.49424,0.51706,0.54052,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08283,0.10868,0.13763,0.16249,0.18861,0.21626,0.24581,0.27078,
     &0.29138,0.30633,0.32264,0.33973,0.35221,0.36517,0.37651,0.38568,
     &0.39979,0.40927,0.42117,0.43136,0.44515,0.45644,0.47541,0.48942,
     &0.51397,0.54044,0.56934,0.60025,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08169,0.10839,0.13864,0.16143,0.18743,0.21402,0.24106,0.26534,
     &0.28319,0.29873,0.31184,0.32402,0.33338,0.34687,0.35712,0.36601,
     &0.37353,0.38149,0.39005,0.39866,0.40571,0.41492,0.42207,0.43127,
     &0.44181,0.45426,0.46893,0.48270,0.50690,0.53549,0.56983,0.59283,
     &0.63768,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08103,0.10845,0.13978,0.16059,0.18650,0.21114,0.23815,0.26135,
     &0.27841,0.29321,0.30586,0.31704,0.32796,0.33746,0.34499,0.35104,
     &0.36051,0.36524,0.37133,0.37786,0.38403,0.38958,0.39376,0.40103,
     &0.40482,0.41124,0.41917,0.42819,0.43957,0.45207,0.46587,0.48099,
     &0.50162,0.52727,0.55806,0.58605,0.62402,0.66648,0.00000,0.00000,
     &0.08062,0.10858,0.14068,0.15995,0.18497,0.21005,0.23610,0.25915,
     &0.27655,0.28907,0.30072,0.31101,0.32230,0.33224,0.33962,0.34669,
     &0.35236,0.35556,0.36102,0.36485,0.37197,0.37468,0.37872,0.38161,
     &0.38480,0.39069,0.39499,0.39961,0.40554,0.41047,0.41768,0.42572,
     &0.43717,0.44628,0.45811,0.47351,0.49149,0.51622,0.53819,0.00000,
     &0.08028,0.10816,0.14167,0.16015,0.18562,0.20953,0.23423,0.25767,
     &0.27456,0.28738,0.29856,0.30896,0.31910,0.32789,0.33600,0.34176,
     &0.34892,0.35233,0.35679,0.36136,0.36530,0.36980,0.37421,0.37604,
     &0.37900,0.38213,0.38457,0.38825,0.39069,0.39471,0.39987,0.40369,
     &0.40997,0.41646,0.42259,0.42834,0.43956,0.44936,0.45848,0.00000,
     &0.07992,0.10830,0.14284,0.15963,0.18421,0.20851,0.23386,0.25552,
     &0.27011,0.28212,0.29433,0.30635,0.31651,0.32597,0.33416,0.34182,
     &0.34673,0.35232,0.35676,0.36091,0.36636,0.36946,0.37106,0.37493,
     &0.37973,0.38080,0.38364,0.38669,0.38921,0.39136,0.39507,0.39750,
     &0.40048,0.40598,0.41061,0.41328,0.41804,0.42406,0.43007,0.00000,
     &0.07977,0.10801,0.14376,0.15987,0.18529,0.20815,0.23348,0.25351,
     &0.26870,0.28106,0.29193,0.30207,0.31294,0.32233,0.33095,0.33851,
     &0.34441,0.35064,0.35635,0.36050,0.36732,0.37106,0.37519,0.37844,
     &0.38021,0.38280,0.38675,0.38919,0.39146,0.39563,0.39717,0.39949,
     &0.40253,0.40356,0.40700,0.41100,0.41364,0.41716,0.42131,0.00000,
     &0.07973,0.10817,0.14479,0.15994,0.18493,0.20904,0.23378,0.25396,
     &0.26948,0.27979,0.29030,0.30073,0.30950,0.31880,0.32706,0.33523,
     &0.34253,0.34773,0.35396,0.35990,0.36704,0.37137,0.37710,0.38043,
     &0.38436,0.38643,0.39076,0.39268,0.39603,0.39865,0.40127,0.40385,
     &0.40648,0.40923,0.41062,0.41378,0.41640,0.41994,0.42288,0.00000,
     &0.07957,0.10812,0.14560,0.15979,0.18441,0.20852,0.23363,0.25499,
     &0.27022,0.28135,0.29085,0.30146,0.30868,0.31855,0.32629,0.33241,
     &0.33911,0.34554,0.35246,0.35847,0.36694,0.37182,0.37875,0.38234,
     &0.38627,0.39040,0.39360,0.39804,0.40068,0.40285,0.40553,0.40940,
     &0.41224,0.41388,0.41645,0.42089,0.42267,0.42547,0.42860,0.00000/
c::::::::::::::
capt-09-03-block.f
c::::::::::::::
      Data ((CF(K,l, 3, 4),K=1,40),l=1,13)/
     &0.08179,0.10706,0.14453,0.19154,0.22966,0.26323,0.28484,0.26267,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08753,0.11188,0.14261,0.17494,0.21288,0.26931,0.32817,0.35808,
     &0.33585,0.26716,0.21089,0.20482,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08072,0.10537,0.13885,0.16288,0.19594,0.23086,0.26682,0.29957,
     &0.32329,0.34441,0.36285,0.37561,0.39386,0.41655,0.44265,0.46675,
     &0.49437,0.51035,0.51871,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08079,0.10983,0.14131,0.16359,0.19109,0.22056,0.25309,0.28302,
     &0.30697,0.32656,0.34309,0.35785,0.37148,0.38356,0.39596,0.40960,
     &0.42351,0.43984,0.45484,0.47945,0.50551,0.52728,0.54932,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08036,0.10871,0.14140,0.16189,0.18818,0.21529,0.24493,0.26875,
     &0.28940,0.30619,0.32118,0.33555,0.34655,0.35746,0.36799,0.37691,
     &0.38605,0.39325,0.40403,0.41194,0.42141,0.43578,0.44853,0.46609,
     &0.49033,0.52003,0.55603,0.59418,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08019,0.10823,0.14180,0.16046,0.18650,0.21235,0.24083,0.26471,
     &0.28230,0.29670,0.31061,0.32332,0.33533,0.34432,0.35320,0.36223,
     &0.36986,0.37669,0.38349,0.38819,0.39662,0.40227,0.40947,0.41593,
     &0.42380,0.43337,0.44192,0.46406,0.48151,0.50623,0.54787,0.58904,
     &0.61339,0.63902,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.07994,0.10820,0.14256,0.16013,0.18586,0.21105,0.23847,0.26064,
     &0.27828,0.29257,0.30363,0.31598,0.32583,0.33621,0.34350,0.35177,
     &0.35715,0.36408,0.36925,0.37364,0.38138,0.38517,0.38800,0.39409,
     &0.39896,0.40211,0.40974,0.41419,0.42158,0.43185,0.44285,0.45858,
     &0.47447,0.49441,0.52937,0.56599,0.61474,0.65171,0.66019,0.00000,
     &0.07982,0.10814,0.14350,0.16015,0.18490,0.20951,0.23663,0.25955,
     &0.27546,0.28738,0.30101,0.31178,0.32177,0.33044,0.33918,0.34645,
     &0.35145,0.35680,0.36132,0.36375,0.36880,0.37255,0.37685,0.38007,
     &0.38415,0.38531,0.39031,0.39447,0.39828,0.40304,0.40836,0.41504,
     &0.42358,0.43207,0.44130,0.45476,0.46990,0.49053,0.50719,0.00000,
     &0.07967,0.10844,0.14371,0.16000,0.18446,0.20908,0.23491,0.25737,
     &0.27279,0.28661,0.29783,0.30834,0.31889,0.32756,0.33534,0.34293,
     &0.34734,0.35228,0.35792,0.36129,0.36512,0.36874,0.37163,0.37521,
     &0.37761,0.38041,0.38395,0.38617,0.38931,0.39265,0.39617,0.39879,
     &0.40557,0.40890,0.41353,0.41979,0.42661,0.43550,0.44391,0.00000,
     &0.07962,0.10812,0.14439,0.15947,0.18384,0.20793,0.23401,0.25508,
     &0.27033,0.28310,0.29453,0.30464,0.31615,0.32548,0.33265,0.34030,
     &0.34753,0.35171,0.35595,0.36058,0.36588,0.36916,0.37224,0.37567,
     &0.37865,0.38129,0.38351,0.38531,0.38938,0.39128,0.39214,0.39627,
     &0.40015,0.40309,0.40682,0.40907,0.41333,0.41871,0.42468,0.00000,
     &0.07965,0.10829,0.14488,0.15958,0.18402,0.20864,0.23218,0.25358,
     &0.26880,0.28109,0.29151,0.30178,0.31169,0.32137,0.32953,0.33844,
     &0.34528,0.35081,0.35525,0.36031,0.36716,0.37172,0.37378,0.37753,
     &0.38089,0.38534,0.38611,0.38874,0.39173,0.39326,0.39665,0.39720,
     &0.40152,0.40451,0.40545,0.40913,0.41123,0.41530,0.41822,0.00000,
     &0.07952,0.10840,0.14564,0.15964,0.18406,0.20821,0.23312,0.25377,
     &0.26896,0.28032,0.29163,0.30109,0.30981,0.31817,0.32643,0.33455,
     &0.34175,0.34770,0.35407,0.35923,0.36704,0.37217,0.37598,0.38053,
     &0.38469,0.38708,0.39059,0.39391,0.39705,0.39859,0.40255,0.40380,
     &0.40528,0.40867,0.41097,0.41439,0.41582,0.41768,0.42072,0.00000,
     &0.07941,0.10831,0.14639,0.15961,0.18429,0.20842,0.23395,0.25330,
     &0.27004,0.28002,0.29103,0.30045,0.30925,0.31823,0.32538,0.33233,
     &0.33977,0.34535,0.35204,0.35791,0.36680,0.37213,0.37793,0.38105,
     &0.38615,0.38999,0.39435,0.39749,0.39931,0.40348,0.40593,0.40942,
     &0.41217,0.41427,0.41737,0.41955,0.42194,0.42536,0.42750,0.00000/
c::::::::::::::
capt-09-04-block.f
c::::::::::::::
      Data ((CF(K,l, 4, 4),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.18700,0.14767,0.19500,0.21120,0.22518,0.20660,
     &0.24200,0.27697,0.27857,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08559,0.10754,0.13329,0.16473,0.18722,0.17359,0.19117,0.24324,
     &0.31911,0.38220,0.42932,0.45199,0.44448,0.44945,0.46022,0.46428,
     &0.47665,0.48526,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08990,0.10694,0.13616,0.16229,0.20412,0.23264,0.26555,0.29963,
     &0.32324,0.34776,0.36077,0.37671,0.39459,0.41742,0.45608,0.49811,
     &0.54374,0.56415,0.55504,0.54855,0.54686,0.54140,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08309,0.10873,0.13100,0.16433,0.20355,0.23284,0.26139,0.29407,
     &0.31434,0.34013,0.35338,0.37192,0.38649,0.39808,0.41111,0.42345,
     &0.43848,0.46072,0.46506,0.47026,0.48051,0.48657,0.48862,0.49903,
     &0.51451,0.52657,0.54651,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08971,0.10722,0.13710,0.16462,0.19829,0.23503,0.26545,0.29598,
     &0.31765,0.33695,0.35026,0.37348,0.38065,0.39129,0.40019,0.41084,
     &0.40968,0.41716,0.42725,0.43335,0.44146,0.45038,0.45253,0.46043,
     &0.46409,0.47327,0.48793,0.49501,0.50829,0.51440,0.54074,0.58489,
     &0.61496,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08679,0.10621,0.13244,0.16711,0.20343,0.23200,0.26441,0.29244,
     &0.31963,0.33515,0.35532,0.37008,0.38028,0.38814,0.39649,0.39913,
     &0.40406,0.40946,0.41558,0.41915,0.42239,0.42669,0.43261,0.43655,
     &0.43720,0.44697,0.44631,0.45544,0.45512,0.46845,0.48016,0.48833,
     &0.49698,0.51544,0.54501,0.55238,0.58777,0.63164,0.00000,0.00000,
     &0.09163,0.10680,0.13201,0.16631,0.19690,0.23855,0.26946,0.29421,
     &0.31911,0.34112,0.35587,0.36624,0.37479,0.38829,0.39421,0.39912,
     &0.40629,0.40972,0.41187,0.41161,0.41497,0.41894,0.42332,0.42477,
     &0.42876,0.43126,0.43450,0.43438,0.44214,0.44881,0.44679,0.45402,
     &0.45900,0.47241,0.47630,0.48667,0.49780,0.51253,0.53567,0.00000,
     &0.08838,0.10825,0.13908,0.16951,0.19922,0.23265,0.26521,0.29732,
     &0.31478,0.33874,0.35723,0.36312,0.37803,0.38647,0.40141,0.40417,
     &0.40647,0.40878,0.41182,0.42012,0.42295,0.42396,0.42648,0.42722,
     &0.43369,0.43045,0.43074,0.43324,0.43516,0.44072,0.43810,0.44175,
     &0.44574,0.44997,0.45457,0.45360,0.46874,0.47376,0.47483,0.00000,
     &0.09049,0.11177,0.13484,0.16706,0.20050,0.23523,0.25781,0.29625,
     &0.31990,0.34486,0.35319,0.37285,0.38000,0.38980,0.39881,0.40292,
     &0.41285,0.41292,0.41851,0.42172,0.42472,0.42722,0.43319,0.43680,
     &0.43705,0.43939,0.44130,0.44165,0.44093,0.44865,0.45090,0.45041,
     &0.45624,0.45483,0.45712,0.46277,0.46341,0.47203,0.47664,0.00000,
     &0.08932,0.11235,0.13376,0.16526,0.20019,0.23979,0.25900,0.29477,
     &0.31916,0.34184,0.35566,0.37258,0.38266,0.39071,0.40231,0.40360,
     &0.41378,0.41990,0.42598,0.43127,0.43174,0.44070,0.44245,0.44890,
     &0.44707,0.45174,0.45319,0.45750,0.45628,0.46172,0.46159,0.46398,
     &0.46250,0.46727,0.47391,0.47172,0.47414,0.47874,0.47615,0.00000,
     &0.08834,0.10296,0.13262,0.16631,0.20045,0.22917,0.26935,0.29305,
     &0.31641,0.34150,0.35706,0.37251,0.38426,0.39503,0.40275,0.40689,
     &0.41297,0.42219,0.42803,0.43480,0.44035,0.44680,0.45204,0.45604,
     &0.46133,0.46735,0.46806,0.47033,0.47218,0.47727,0.48021,0.48238,
     &0.48265,0.48623,0.49006,0.49195,0.49388,0.49421,0.49637,0.00000,
     &0.07808,0.10359,0.13434,0.16679,0.20133,0.23386,0.27260,0.29894,
     &0.32030,0.34632,0.35792,0.37178,0.38230,0.39606,0.39902,0.40950,
     &0.41818,0.42296,0.42994,0.43570,0.44366,0.45231,0.45969,0.47027,
     &0.47362,0.47581,0.48282,0.48236,0.48914,0.49055,0.49750,0.49931,
     &0.50143,0.50195,0.50406,0.50929,0.51328,0.51419,0.51624,0.00000/
c::::::::::::::
capt-09-05-block.f
c::::::::::::::
      Data ((CF(K,l, 5, 4),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08058,0.10939,0.14073,0.16005,0.19493,0.23186,0.26451,0.29732,
     &0.33143,0.37356,0.40202,0.40644,0.42091,0.43156,0.43025,0.44869,
     &0.46254,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08952,0.11063,0.13313,0.15963,0.18699,0.22094,0.25339,0.27709,
     &0.30897,0.33298,0.34969,0.36570,0.38253,0.40231,0.41990,0.43302,
     &0.44786,0.46020,0.47548,0.48979,0.51898,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08895,0.10163,0.12900,0.16570,0.19388,0.22542,0.24752,0.28098,
     &0.29660,0.31766,0.33561,0.35263,0.36592,0.37734,0.39456,0.40139,
     &0.41038,0.41948,0.42603,0.43720,0.45436,0.46470,0.47532,0.50180,
     &0.50524,0.54757,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08412,0.10366,0.13064,0.16377,0.18607,0.21850,0.24757,0.27584,
     &0.29509,0.31103,0.33502,0.34873,0.36079,0.37542,0.38099,0.39064,
     &0.39743,0.40415,0.40723,0.41597,0.42195,0.43297,0.43668,0.44096,
     &0.45157,0.46775,0.48446,0.49546,0.52317,0.54526,0.55625,0.59489,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08467,0.10742,0.13193,0.16285,0.19798,0.22688,0.25314,0.27266,
     &0.29567,0.30970,0.32501,0.34570,0.35999,0.37334,0.38731,0.38618,
     &0.39173,0.39683,0.40358,0.40890,0.41074,0.41091,0.41997,0.41847,
     &0.42666,0.43368,0.43840,0.44786,0.45524,0.46332,0.48693,0.49556,
     &0.51904,0.54004,0.54496,0.59115,0.63670,0.00000,0.00000,0.00000,
     &0.08210,0.11283,0.13061,0.16205,0.19098,0.22930,0.25309,0.27600,
     &0.29483,0.31796,0.33692,0.34992,0.36364,0.37062,0.37771,0.38648,
     &0.39036,0.39831,0.40127,0.40817,0.41109,0.41220,0.41227,0.41781,
     &0.41931,0.42162,0.42619,0.42772,0.43186,0.43721,0.44547,0.44732,
     &0.45455,0.46436,0.47581,0.49250,0.51147,0.52861,0.54894,0.00000,
     &0.07825,0.10406,0.13532,0.16723,0.19246,0.22609,0.25827,0.27104,
     &0.30302,0.31625,0.33240,0.35411,0.36711,0.37804,0.38355,0.39498,
     &0.39349,0.40014,0.40227,0.40851,0.41466,0.41865,0.41264,0.41755,
     &0.41977,0.42230,0.42631,0.42760,0.43134,0.43456,0.43691,0.44319,
     &0.44300,0.44884,0.45250,0.45699,0.46741,0.47366,0.48106,0.00000,
     &0.08505,0.10281,0.13023,0.16590,0.19411,0.23045,0.24884,0.27386,
     &0.29322,0.31390,0.33552,0.34980,0.36395,0.37450,0.38753,0.39312,
     &0.39980,0.40546,0.40628,0.41034,0.41587,0.41761,0.42173,0.42611,
     &0.42877,0.43026,0.43101,0.43506,0.43877,0.44309,0.44361,0.44811,
     &0.45132,0.45157,0.45369,0.46220,0.46042,0.46559,0.46717,0.00000,
     &0.09400,0.10213,0.12837,0.16783,0.18326,0.21759,0.25205,0.27269,
     &0.30301,0.31004,0.33292,0.34447,0.36522,0.37623,0.38831,0.39632,
     &0.40291,0.40457,0.41256,0.41576,0.42092,0.42449,0.43335,0.43537,
     &0.43800,0.44199,0.44652,0.44843,0.45231,0.45624,0.45514,0.45939,
     &0.46162,0.46797,0.46694,0.47096,0.47100,0.47557,0.47688,0.00000,
     &0.07565,0.10093,0.13712,0.16601,0.19194,0.22008,0.24922,0.26888,
     &0.28802,0.31565,0.33339,0.34818,0.36557,0.37479,0.38607,0.39763,
     &0.40360,0.40987,0.41758,0.42123,0.42699,0.43092,0.44225,0.44153,
     &0.44531,0.45650,0.45739,0.45926,0.46427,0.46846,0.47179,0.47487,
     &0.47831,0.47495,0.48507,0.48772,0.48998,0.48980,0.49585,0.00000,
     &0.09530,0.10118,0.14097,0.16739,0.18808,0.22329,0.25140,0.26871,
     &0.29485,0.31504,0.32353,0.34996,0.36424,0.37490,0.38732,0.39344,
     &0.40223,0.41212,0.41529,0.42153,0.43217,0.43479,0.44599,0.44997,
     &0.45600,0.46484,0.46715,0.47038,0.47991,0.48413,0.48405,0.49099,
     &0.49836,0.49788,0.50221,0.50556,0.50799,0.51277,0.51121,0.00000/
c::::::::::::::
capt-09-06-block.f
c::::::::::::::
      Data ((CF(K,l, 6, 4),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.09900,0.15500,0.19109,0.18408,0.18933,0.27822,
     &0.28571,0.27415,0.29239,0.27060,0.26062,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08758,0.10965,0.13343,0.16509,0.19044,0.17925,0.19382,0.24501,
     &0.31611,0.38041,0.43055,0.44890,0.44393,0.44636,0.46206,0.46541,
     &0.48038,0.48526,0.48250,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08665,0.10885,0.13353,0.16467,0.19724,0.22882,0.26480,0.29191,
     &0.31970,0.34240,0.36105,0.37833,0.39561,0.41680,0.45030,0.48914,
     &0.51972,0.53409,0.52500,0.52656,0.52773,0.53680,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.09161,0.10903,0.13530,0.16665,0.19573,0.22762,0.25976,0.28624,
     &0.30872,0.33054,0.35351,0.36776,0.38390,0.39837,0.40808,0.41871,
     &0.43672,0.44770,0.45603,0.45995,0.46878,0.48051,0.49108,0.50169,
     &0.52204,0.53803,0.55612,0.58805,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08382,0.10937,0.13552,0.16439,0.19456,0.22660,0.25659,0.28458,
     &0.31102,0.32536,0.34953,0.36419,0.37751,0.39018,0.39881,0.40427,
     &0.41208,0.41930,0.42490,0.43097,0.43772,0.44238,0.45191,0.45761,
     &0.46441,0.47253,0.48266,0.50128,0.51025,0.53411,0.56545,0.58008,
     &0.59852,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.09282,0.11033,0.13553,0.16532,0.19663,0.22743,0.25911,0.28506,
     &0.30988,0.33004,0.34761,0.36094,0.37443,0.38399,0.39383,0.40170,
     &0.40593,0.41190,0.41534,0.41833,0.42101,0.42668,0.42694,0.43150,
     &0.43760,0.44056,0.44789,0.45245,0.46220,0.46846,0.47991,0.49911,
     &0.51258,0.52770,0.54731,0.58370,0.59830,0.61642,0.00000,0.00000,
     &0.09018,0.10840,0.13443,0.16289,0.19374,0.22957,0.26061,0.28427,
     &0.31166,0.32783,0.34658,0.36210,0.37582,0.38670,0.39385,0.39774,
     &0.40063,0.40738,0.40845,0.41180,0.41536,0.41722,0.41980,0.42249,
     &0.42741,0.43094,0.43263,0.43663,0.44021,0.44143,0.44960,0.45364,
     &0.45890,0.46651,0.47885,0.48847,0.50557,0.52523,0.54604,0.00000,
     &0.08254,0.10942,0.13452,0.16262,0.19767,0.22954,0.26163,0.28621,
     &0.30949,0.32719,0.34674,0.36408,0.37451,0.38733,0.39520,0.39960,
     &0.40440,0.40926,0.41315,0.41590,0.41605,0.42170,0.42054,0.42508,
     &0.42532,0.42865,0.43187,0.43261,0.43485,0.44082,0.44203,0.44725,
     &0.44769,0.45641,0.45638,0.46255,0.46547,0.47443,0.48126,0.00000,
     &0.08893,0.10850,0.13609,0.16493,0.19940,0.23447,0.26430,0.28623,
     &0.31028,0.33279,0.34915,0.36415,0.37999,0.38917,0.39799,0.40367,
     &0.40926,0.41395,0.41943,0.42010,0.42267,0.42747,0.43073,0.43043,
     &0.43435,0.43706,0.44083,0.44095,0.44393,0.45010,0.44994,0.45057,
     &0.45589,0.45795,0.45761,0.46165,0.46318,0.46887,0.47326,0.00000,
     &0.09287,0.11081,0.13162,0.16331,0.19811,0.23193,0.26245,0.28741,
     &0.30865,0.33091,0.34940,0.36740,0.38060,0.38759,0.39637,0.40711,
     &0.41364,0.41735,0.42177,0.42596,0.43148,0.43488,0.44105,0.44413,
     &0.45042,0.44865,0.45379,0.45456,0.45795,0.46167,0.46441,0.46380,
     &0.46797,0.46853,0.47023,0.47357,0.47591,0.47751,0.47893,0.00000,
     &0.09138,0.10791,0.13951,0.16541,0.19659,0.23320,0.25656,0.28922,
     &0.31048,0.33192,0.34756,0.36388,0.37964,0.39322,0.39995,0.40545,
     &0.41186,0.42056,0.42534,0.43114,0.43927,0.44189,0.44983,0.45508,
     &0.45855,0.46203,0.46792,0.46969,0.47381,0.47267,0.47742,0.48085,
     &0.48553,0.48142,0.48729,0.49183,0.49346,0.49522,0.49825,0.00000,
     &0.08343,0.11076,0.13600,0.16143,0.19560,0.23218,0.26040,0.28544,
     &0.31422,0.33057,0.35308,0.36367,0.38075,0.39005,0.40007,0.40496,
     &0.41008,0.41782,0.42472,0.43604,0.44274,0.44834,0.45662,0.46268,
     &0.47067,0.47513,0.47846,0.48225,0.48861,0.49222,0.49655,0.49948,
     &0.50158,0.50658,0.50669,0.50766,0.51334,0.51135,0.51856,0.00000/
c::::::::::::::
capt-09-07-block.f
c::::::::::::::
      Data ((CF(K,l, 7, 4),K=1,40),l=1,13)/
     &0.08867,0.11160,0.14094,0.17766,0.22263,0.27703,0.33904,0.33920,
     &0.25525,0.29294,0.23498,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08853,0.11141,0.14072,0.17731,0.22226,0.27780,0.34378,0.39467,
     &0.35959,0.45160,0.54900,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08782,0.10962,0.13696,0.17033,0.21125,0.25876,0.30680,0.34620,
     &0.38138,0.43543,0.49347,0.55000,0.60690,0.65464,0.62667,0.61243,
     &0.65449,0.65335,0.67737,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08786,0.10961,0.13679,0.17035,0.21165,0.26121,0.31752,0.37144,
     &0.41090,0.44001,0.47857,0.52379,0.57761,0.61822,0.63838,0.63809,
     &0.60452,0.55760,0.53457,0.53520,0.54632,0.55964,0.58410,0.61495,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08778,0.10946,0.13678,0.17007,0.21134,0.26120,0.31736,0.37163,
     &0.41258,0.44317,0.47872,0.51964,0.55542,0.58428,0.60095,0.60544,
     &0.59350,0.57936,0.55215,0.52671,0.52331,0.52314,0.52553,0.52595,
     &0.52753,0.53052,0.54945,0.57450,0.61034,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08767,0.10964,0.13677,0.17046,0.21186,0.26176,0.31825,0.37503,
     &0.41907,0.45595,0.49342,0.52972,0.56659,0.58667,0.59882,0.59888,
     &0.58168,0.56940,0.55271,0.54566,0.53510,0.52808,0.52424,0.52959,
     &0.52244,0.52705,0.52556,0.52765,0.52785,0.53814,0.54452,0.55991,
     &0.58962,0.63116,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08785,0.10983,0.13703,0.17110,0.21189,0.26250,0.31987,0.37824,
     &0.42870,0.46655,0.50625,0.54198,0.57589,0.59698,0.60913,0.60550,
     &0.58876,0.56765,0.54820,0.53616,0.52943,0.52809,0.52270,0.52376,
     &0.51940,0.52500,0.51689,0.52290,0.52601,0.51855,0.52571,0.53579,
     &0.53942,0.55261,0.55397,0.56528,0.58162,0.60839,0.65221,0.00000,
     &0.08788,0.10990,0.13726,0.17151,0.21276,0.26398,0.32233,0.38258,
     &0.43484,0.47574,0.51483,0.55235,0.58217,0.60143,0.61969,0.61413,
     &0.59468,0.57417,0.55281,0.54049,0.53292,0.52633,0.51610,0.51470,
     &0.51343,0.51112,0.50843,0.51132,0.50962,0.51619,0.51045,0.51172,
     &0.51641,0.52676,0.52911,0.53524,0.54567,0.55563,0.56243,0.00000,
     &0.08791,0.10995,0.13783,0.17177,0.21428,0.26586,0.32462,0.38504,
     &0.43983,0.48520,0.52289,0.55682,0.58544,0.60711,0.61302,0.61659,
     &0.59784,0.58176,0.56708,0.55356,0.54240,0.53644,0.52566,0.51984,
     &0.51487,0.51356,0.51029,0.50967,0.51146,0.51107,0.51303,0.51730,
     &0.51085,0.51938,0.51533,0.52234,0.52511,0.52809,0.53862,0.00000,
     &0.08809,0.11011,0.13767,0.17214,0.21458,0.26685,0.32663,0.38863,
     &0.44526,0.49127,0.52893,0.55859,0.58703,0.60786,0.61724,0.62146,
     &0.60454,0.58704,0.57114,0.56027,0.55631,0.54325,0.54037,0.53403,
     &0.53392,0.53415,0.52678,0.52464,0.52420,0.51879,0.52566,0.52216,
     &0.52493,0.52760,0.52600,0.52862,0.52630,0.53289,0.53563,0.00000,
     &0.08830,0.11036,0.13800,0.17236,0.21499,0.26800,0.32768,0.39162,
     &0.45104,0.49590,0.53442,0.56545,0.59225,0.60748,0.61898,0.62219,
     &0.61629,0.59331,0.58413,0.56951,0.56923,0.55444,0.55271,0.55217,
     &0.55433,0.54710,0.54570,0.54799,0.54506,0.54349,0.54584,0.54741,
     &0.54418,0.55381,0.54639,0.54875,0.54469,0.55186,0.55274,0.00000,
     &0.08830,0.11030,0.13825,0.17296,0.21589,0.26766,0.32908,0.39412,
     &0.45106,0.49881,0.53503,0.56824,0.59437,0.61706,0.63016,0.63606,
     &0.62214,0.60109,0.59367,0.58024,0.57410,0.56770,0.56943,0.57250,
     &0.56979,0.57186,0.56489,0.57406,0.56850,0.57175,0.56838,0.57513,
     &0.57567,0.58243,0.57845,0.58215,0.58442,0.58362,0.58707,0.00000,
     &0.08816,0.11043,0.13828,0.17292,0.21572,0.26969,0.32995,0.39336,
     &0.45386,0.49964,0.54130,0.57149,0.59786,0.62116,0.64073,0.64216,
     &0.63487,0.61093,0.59850,0.59187,0.57537,0.57867,0.57837,0.57904,
     &0.57646,0.59130,0.57977,0.58680,0.59234,0.59628,0.60096,0.60551,
     &0.60708,0.60773,0.61456,0.61606,0.61507,0.62322,0.61605,0.00000/
c::::::::::::::
capt-09-08-block.f
c::::::::::::::
      Data ((CF(K,l, 8, 4),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.25740,0.00000,0.28300,0.31942,
     &0.24150,0.38450,0.39521,0.36295,0.41123,0.42322,0.41614,0.39225,
     &0.42000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.13700,0.00000,0.19433,0.21867,0.23750,0.29433,0.27204,
     &0.35893,0.38356,0.36294,0.36533,0.40068,0.41166,0.43462,0.44813,
     &0.45438,0.47670,0.48592,0.46404,0.49867,0.53882,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.12533,0.16533,0.19700,0.19975,0.26232,0.33900,0.30203,
     &0.39484,0.36461,0.39054,0.37474,0.42089,0.43429,0.46643,0.48016,
     &0.48175,0.48022,0.47086,0.47613,0.48618,0.50199,0.50493,0.53044,
     &0.55660,0.58317,0.60762,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.10150,0.10575,0.13750,0.16357,0.25820,0.29120,0.31588,0.31914,
     &0.41984,0.39746,0.39211,0.38733,0.41870,0.42751,0.45726,0.48015,
     &0.48052,0.48126,0.46676,0.47342,0.46838,0.47777,0.47757,0.48436,
     &0.48779,0.50157,0.52279,0.54976,0.57155,0.62307,0.66375,0.71303,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.14100,0.00000,0.18500,0.20025,0.27356,0.34272,0.32494,
     &0.35270,0.40677,0.38080,0.39994,0.42137,0.43106,0.45043,0.46748,
     &0.46386,0.46933,0.46324,0.46564,0.46988,0.47190,0.46930,0.47345,
     &0.47741,0.48580,0.48827,0.49650,0.50036,0.51590,0.53992,0.55276,
     &0.58284,0.61472,0.67718,0.72782,0.77833,0.00000,0.00000,0.00000,
     &0.00000,0.11000,0.12900,0.21350,0.20236,0.30860,0.30800,0.37284,
     &0.34247,0.37837,0.37026,0.40849,0.42115,0.43796,0.44866,0.46277,
     &0.46367,0.46294,0.45658,0.45869,0.46610,0.46275,0.46317,0.47326,
     &0.47596,0.47928,0.47711,0.48440,0.48601,0.49073,0.49945,0.50297,
     &0.51049,0.52613,0.53246,0.55351,0.58178,0.60241,0.64397,0.00000,
     &0.00000,0.00000,0.18150,0.17267,0.23055,0.28173,0.32707,0.32486,
     &0.37135,0.38453,0.39147,0.41871,0.42857,0.42551,0.45216,0.45464,
     &0.46476,0.46158,0.46202,0.45999,0.47473,0.46538,0.47210,0.48098,
     &0.47778,0.47801,0.48043,0.48677,0.48937,0.48884,0.48802,0.49542,
     &0.50302,0.49964,0.51144,0.50551,0.52124,0.52826,0.53890,0.00000,
     &0.00000,0.11167,0.16300,0.15450,0.00000,0.31957,0.29731,0.41888,
     &0.42947,0.37813,0.39883,0.39082,0.42732,0.43335,0.43794,0.45619,
     &0.46937,0.46696,0.46999,0.47335,0.47087,0.47860,0.48284,0.48894,
     &0.49422,0.49350,0.49794,0.50290,0.50263,0.50464,0.50154,0.50932,
     &0.51455,0.52058,0.52031,0.51942,0.52273,0.52771,0.53383,0.00000,
     &0.00000,0.12167,0.00000,0.21920,0.17725,0.26810,0.32336,0.35737,
     &0.38891,0.37116,0.42679,0.40030,0.43162,0.44188,0.44119,0.45350,
     &0.46716,0.46294,0.47314,0.48182,0.48721,0.48801,0.49545,0.50232,
     &0.50661,0.51119,0.52027,0.52465,0.52781,0.53225,0.53143,0.52930,
     &0.53912,0.54365,0.54650,0.54374,0.54621,0.55279,0.55701,0.00000,
     &0.00000,0.00000,0.17800,0.16960,0.20400,0.26720,0.33293,0.36995,
     &0.40187,0.39471,0.40843,0.42414,0.42052,0.44435,0.44454,0.45405,
     &0.46799,0.46806,0.47680,0.47004,0.48332,0.49848,0.50854,0.51643,
     &0.52572,0.53168,0.53889,0.54607,0.54684,0.55603,0.56273,0.56578,
     &0.57096,0.57905,0.57479,0.58169,0.58903,0.58090,0.58952,0.00000,
     &0.00000,0.00000,0.00000,0.16820,0.00000,0.25933,0.33747,0.32962,
     &0.40580,0.43724,0.38063,0.41236,0.41750,0.41682,0.45344,0.45160,
     &0.46594,0.46961,0.47440,0.47785,0.49034,0.50304,0.52257,0.53109,
     &0.53796,0.55278,0.55560,0.56454,0.57691,0.58075,0.59269,0.59256,
     &0.59773,0.60717,0.60578,0.61298,0.62704,0.61158,0.62654,0.00000/
c::::::::::::::
capt-09-09-block.f
c::::::::::::::
      Data ((CF(K,l, 9, 4),K=1,40),l=1,13)/
     &0.08859,0.11171,0.14097,0.17762,0.22268,0.27721,0.33890,0.32055,
     &0.23115,0.19401,0.14530,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08844,0.11120,0.14035,0.17713,0.22230,0.27753,0.34363,0.38797,
     &0.34375,0.39305,0.47023,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08748,0.10920,0.13611,0.16906,0.21026,0.25682,0.30598,0.34616,
     &0.38129,0.43383,0.49222,0.54922,0.60543,0.64736,0.61529,0.60404,
     &0.65062,0.65561,0.65640,0.59897,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08744,0.10920,0.13608,0.16937,0.21082,0.26032,0.31684,0.37062,
     &0.40903,0.43896,0.47898,0.52506,0.57425,0.61406,0.63458,0.62862,
     &0.59220,0.53596,0.52295,0.52947,0.53990,0.55066,0.56513,0.57119,
     &0.48121,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08740,0.10941,0.13627,0.16930,0.21002,0.26019,0.31593,0.37089,
     &0.41119,0.44260,0.47973,0.51776,0.55589,0.58038,0.59556,0.59651,
     &0.59467,0.57353,0.54675,0.52457,0.51929,0.52184,0.51493,0.51288,
     &0.51224,0.51683,0.53460,0.56162,0.57032,0.48203,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08751,0.10931,0.13612,0.16922,0.21094,0.26072,0.31743,0.37445,
     &0.41804,0.45670,0.49305,0.53005,0.56350,0.59046,0.60284,0.59837,
     &0.57958,0.56228,0.55147,0.53887,0.53172,0.52766,0.52798,0.53303,
     &0.52761,0.51605,0.51739,0.52001,0.51751,0.52366,0.52902,0.55177,
     &0.57931,0.58817,0.49507,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.08742,0.10948,0.13641,0.17017,0.21105,0.26274,0.31947,0.37741,
     &0.42517,0.46616,0.50643,0.54267,0.57359,0.60058,0.60762,0.60561,
     &0.58679,0.56386,0.54816,0.53610,0.52506,0.52308,0.51604,0.51398,
     &0.51770,0.52124,0.52193,0.52118,0.51817,0.51745,0.51660,0.51800,
     &0.52821,0.53513,0.54430,0.55646,0.57384,0.59583,0.59984,0.00000,
     &0.08746,0.10979,0.13659,0.17002,0.21176,0.26353,0.32119,0.38218,
     &0.43328,0.47473,0.51655,0.55163,0.58162,0.60422,0.61737,0.61481,
     &0.59182,0.57739,0.56089,0.54049,0.53568,0.53036,0.51433,0.51856,
     &0.51263,0.50595,0.50695,0.51178,0.51787,0.51268,0.50857,0.51290,
     &0.51376,0.51508,0.51896,0.52684,0.53555,0.54320,0.55354,0.00000,
     &0.08755,0.10957,0.13683,0.17046,0.21225,0.26460,0.32321,0.38361,
     &0.44045,0.48360,0.52214,0.55804,0.58716,0.60731,0.61649,0.61943,
     &0.60507,0.58190,0.56453,0.55323,0.53866,0.53556,0.52607,0.52087,
     &0.51664,0.51530,0.50790,0.50847,0.50666,0.50594,0.51172,0.50941,
     &0.51109,0.51232,0.51465,0.51377,0.52470,0.52699,0.52733,0.00000,
     &0.08782,0.10986,0.13724,0.17078,0.21404,0.26603,0.32520,0.38766,
     &0.44514,0.48952,0.52479,0.56088,0.58659,0.60987,0.61946,0.61768,
     &0.60813,0.58872,0.57001,0.55699,0.55366,0.54588,0.53800,0.54014,
     &0.53384,0.52780,0.53030,0.52370,0.52223,0.52212,0.52487,0.52017,
     &0.51836,0.53182,0.52880,0.52378,0.52841,0.53332,0.53150,0.00000,
     &0.08793,0.11000,0.13734,0.17145,0.21461,0.26733,0.32668,0.39021,
     &0.44841,0.49635,0.53130,0.56706,0.59079,0.60811,0.61886,0.62594,
     &0.61087,0.59756,0.57873,0.56443,0.56510,0.55794,0.55579,0.55360,
     &0.55145,0.55071,0.54242,0.54459,0.54669,0.54423,0.54565,0.55293,
     &0.54496,0.54866,0.54448,0.55506,0.55318,0.55401,0.55551,0.00000,
     &0.08800,0.10989,0.13768,0.17186,0.21495,0.26841,0.32830,0.39156,
     &0.44969,0.49670,0.53600,0.56937,0.59606,0.61502,0.62902,0.63208,
     &0.61748,0.60290,0.58649,0.58460,0.57387,0.56661,0.56873,0.56523,
     &0.56499,0.56737,0.57222,0.56923,0.57788,0.57410,0.57489,0.57344,
     &0.58043,0.57635,0.57788,0.58909,0.58109,0.58904,0.59349,0.00000,
     &0.08778,0.10984,0.13739,0.17188,0.21493,0.26845,0.32918,0.39274,
     &0.45259,0.49868,0.53641,0.56923,0.59685,0.62352,0.63699,0.64771,
     &0.62961,0.62187,0.59679,0.58312,0.58234,0.57512,0.57704,0.57806,
     &0.58256,0.57584,0.58732,0.58774,0.59575,0.59869,0.60646,0.60768,
     &0.61012,0.60713,0.61769,0.61925,0.62399,0.62795,0.62461,0.00000/
c::::::::::::::
capt-09-10-block.f
c::::::::::::::
      Data ((CF(K,l,10, 4),K=1,40),l=1,13)/
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.19450,0.00000,0.22225,0.25300,0.37717,
     &0.38672,0.31982,0.42065,0.36900,0.42996,0.38301,0.40358,0.42035,
     &0.37926,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.09250,0.00000,0.10800,0.22040,0.25389,0.28344,0.35431,
     &0.31318,0.33164,0.35645,0.37385,0.38556,0.42170,0.43263,0.45372,
     &0.46782,0.47193,0.48680,0.48569,0.48228,0.48807,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.17200,0.17620,0.21150,0.26560,0.32332,0.37594,
     &0.35717,0.36905,0.37943,0.38321,0.40519,0.44008,0.47141,0.47184,
     &0.47766,0.47402,0.47672,0.47183,0.47770,0.49181,0.50085,0.53269,
     &0.56264,0.58776,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.10750,0.12800,0.15200,0.00000,0.24620,0.21562,0.35542,0.29913,
     &0.32447,0.40315,0.38229,0.39718,0.41932,0.43345,0.45091,0.46483,
     &0.47821,0.47765,0.46959,0.46733,0.47533,0.48087,0.47801,0.49188,
     &0.49668,0.50761,0.52626,0.54598,0.57373,0.62081,0.66778,0.73194,
     &0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &0.05850,0.00000,0.13950,0.16220,0.19640,0.25777,0.29200,0.35664,
     &0.39517,0.40506,0.39576,0.41269,0.41572,0.43198,0.45605,0.47021,
     &0.46729,0.46124,0.47160,0.46606,0.46729,0.47128,0.47058,0.47251,
     &0.47931,0.48124,0.49093,0.48628,0.50064,0.51390,0.52771,0.55261,
     &0.58511,0.60094,0.64941,0.71596,0.79548,0.00000,0.00000,0.00000,
     &0.07000,0.10900,0.09900,0.17500,0.21107,0.24900,0.33087,0.38564,
     &0.38814,0.41216,0.42771,0.40272,0.40727,0.43699,0.44774,0.47101,
     &0.45983,0.46417,0.45823,0.46645,0.46928,0.46456,0.46557,0.47234,
     &0.47362,0.47285,0.47836,0.48624,0.48417,0.49661,0.49174,0.50584,
     &0.50728,0.52404,0.52690,0.55326,0.57259,0.60686,0.64367,0.00000,
     &0.00000,0.00000,0.00000,0.15750,0.25433,0.29742,0.32546,0.42716,
     &0.35747,0.40127,0.39903,0.41892,0.42959,0.44317,0.44570,0.46249,
     &0.46170,0.46533,0.46940,0.46587,0.46944,0.47014,0.47367,0.47266,
     &0.47982,0.48279,0.48323,0.48775,0.48859,0.49328,0.49688,0.49804,
     &0.49930,0.51119,0.51222,0.51043,0.51496,0.52747,0.53676,0.00000,
     &0.00000,0.00000,0.15200,0.20100,0.24071,0.28867,0.33300,0.39527,
     &0.38014,0.42895,0.40447,0.40526,0.40848,0.44584,0.43922,0.46025,
     &0.46574,0.47436,0.46967,0.47099,0.47235,0.48088,0.48068,0.48829,
     &0.49802,0.49434,0.49540,0.50355,0.50093,0.50569,0.50750,0.50794,
     &0.51920,0.51373,0.51996,0.52274,0.52182,0.52970,0.53390,0.00000,
     &0.00000,0.00000,0.13167,0.20667,0.26320,0.29280,0.30381,0.30714,
     &0.39349,0.37201,0.41033,0.41216,0.41584,0.43571,0.44238,0.46548,
     &0.46467,0.47213,0.47098,0.47843,0.48299,0.49244,0.49397,0.50310,
     &0.50717,0.51803,0.52436,0.51916,0.53128,0.53098,0.53389,0.53391,
     &0.53858,0.54665,0.54837,0.54392,0.55053,0.55125,0.54967,0.00000,
     &0.00000,0.00000,0.00000,0.00000,0.14878,0.25612,0.34770,0.37679,
     &0.37360,0.38596,0.39977,0.42082,0.42348,0.43561,0.45239,0.45306,
     &0.46425,0.47303,0.47399,0.48883,0.48609,0.50519,0.51208,0.51634,
     &0.52153,0.53696,0.54196,0.54476,0.55098,0.55303,0.56161,0.56438,
     &0.57029,0.57758,0.57734,0.58151,0.58484,0.59205,0.59498,0.00000,
     &0.00000,0.00000,0.00000,0.18500,0.23400,0.27323,0.27046,0.34100,
     &0.39220,0.42645,0.43124,0.39671,0.39967,0.43972,0.44890,0.46146,
     &0.46794,0.47348,0.47780,0.47886,0.49337,0.50396,0.51785,0.52385,
     &0.54114,0.55296,0.55787,0.57076,0.57485,0.58186,0.58842,0.59874,
     &0.59635,0.60358,0.61132,0.61488,0.61571,0.62219,0.62889,0.00000/
      end
