#include "../cmain.f"
#include "chookHybAS.f"
#include "../ctemplCeren.f"
c
c  *************************************** hook for Beginning of a Run
c  * At this moment, all (system-level) initialization for this run
c  * has been ended.  After this routine is executed, the system goes into the
c  * event creation loop.
c  *
      subroutine chookBgRun
      implicit none
#include "Zmanagerp.h"
#include "Zprivate.h"

      real*8  temp
      character*100 msg
      integer klena
      integer i
c     ==================================================
      
      integer seed(2)
c     ==================================================

      EventNo = 0
      RealBegin = .true.
      TopOfNode = .true.

c            namelist output
      call cwriteParam(ErrorOut, 0)
c            primary information
      call cprintPrim(ErrorOut)
c            observation level information
      call cprintObs(ErrorOut)

      call cqUHooki(1, Mdev)      ! get skeleton memo dev #
      call cqUHooki(6, HowFlesh)  ! how to flesh. non zero-->orthodox
      call cqUHookc(1, msg)       ! get file name for sekelton memo
      call cgetfname(msg, Mskel)  ! add host name etc if needed

c      do i = 1, NoOfSites
c         write(*, *) ' depth ',
c     *    sngl(ObsSites(i).pos.depth/10.)
c      enddo

      open(Mdev, file=Mskel(1:klena(Mskel)), form='unformatted',
     *  status='old' )

      end

c     *********************************** hook for Beginning of  1 event
c     *  All system-level initialization for 1 event generation has been
c     *  eneded at this moment.
c     *  After this is executed, event generation starts.
c     *
      subroutine chookBgEvent
      implicit none
#include "Zprivate.h"


      integer nomore
      if( RealBegin ) then
         call cbegin1ev( nomore )
         if( nomore .eq. 1) then
            call cerrorMsg('all events are fleshed', 1)
            stop  !!!!!!!!!!!!  
         endif
         TopOfNode = .true.
      endif
      call c1by1


      end
      subroutine cbegin1ev(nomore)
      implicit none
#include "Zprivate.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Ztrackp.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"
#include "Zcode.h"
#include "Zmanager.h"
#include "Zmanagerp.h"
      
      integer nomore       !  output. 0 still there  are showers
                           !          1 no more skeleton showers to be fleshed
c          event number, primary      

      record /track/ incident, zsave
      record /coord/ angle
      
      integer i
      integer seed(2)
      integer cumnum, num, jeof, fin
      read( Mdev, end=1000 ) cumnum, num, SeedSave, Zfirst

      EventsInTheRun = EventsInTheRun + 1
      EventNo = EventNo + 1
c          get random seed at skelton making; this can work
c          if seed file is supplied
c      call creadSeed(SeedSave, EventNo, jeof)
c      if( jeof .ne. 0 ) goto 1000

c                 reset the seed.
      call rnd1r(SeedSave)

c         next incident; confirmed to be the same one as preserved one
      call cmkIncident(incident, fin)

      if(fin .ne. 0 ) goto 1000
      zsave = Zfirst    ! save;  this is reset in next 
      call ciniTracking( incident )   
c          set first interaction pos
      Zfirst = zsave
      call cresetTimer(Zfirst)

      RealBegin = .false.

c          do your own init for a one event here
c      ==========================================================
         call cqIncident( incident, angle)
      write(*,999) 
     *    EventNo, 
     *    incident.p.code,
     *    incident.p.subcode,
     *    incident.p.charge, 
     *    incident.p.fm.e,
     *    -angle.r(1),
     *    -angle.r(2),
     *    -angle.r(3)
 999      format(i9,3i4,e15.5,3(1x,f12.8))


c      ==========================================================
c

      call cgetHES(Mdev)  ! get high energy ptlcs
      call cobsHES        ! imitate their observation
      nomore = 0
      return

 1000 continue
      nomore = 1
      end

c     ************************************ hook for observation
c     *  One particel information is brought here by the system.
c     *  All information of the particle is in aTrack
c     *
      subroutine chookObs(aTrack, id)
c
c     Note that every real variable is in double  precision so
c     that you may output it in sigle precision to save the memory.
c     In some cases it is essential to put it in sigle (say,
c     for gnuplot).
c 
      implicit none
#include "Zcode.h"
#include "Ztrack.h"
#include "Zprivate.h"
      integer id  ! input.  2 ==> reached at an observation level
c                           1 ==> aTrack is going out from
c                                 outer boundery.
c                           2 ==> reached at an observation level
c                           3 ==> reached at inner boundery.
      record /track/ aTrack
c
c     For id =2, you need not output the z value, because it is always
c     0 (within the computational accuracy).
c
      if(id .eq. 2 .and. aTrack.p.code .ne. kneumu .and.
     *   aTrack.p.code .ne. kneue) then

c     ===================================================

       if( aTrack.p.code .le. 6 .and. aTrack.p.code .ne. 3 ) then
c         write(*, 959) 
c     *  aTrack.where,   
c     *  aTrack.p.code,   
c     *  aTrack.p.charge,  
c     *  sngl( aTrack.p.fm.p(4) - aTrack.p.mass ),  
c     *  sngl( aTrack.pos.xyz.r(1) ), 
c     *  sngl( aTrack.pos.xyz.r(2) ) ,  
c     *  sngl( aTrack.vec.w.r(1) ),   
c     *  sngl( aTrack.vec.w.r(2) ),  
c     *  sngl( aTrack.vec.w.r(3) ),  
c     *  sngl( aTrack.vec.coszenith )  
c 959      format(3i3,f12.3,2f16.6,4(1x,f12.8))
      endif

c     ===================================================

c         write(*,'(4i5, g15.4,g15.3)') 
c     *   aTrack.where, aTrack.p.code, aTrack.p.subcode,
c     *   aTrack.p.charge, sngl( aTrack.t ),
c     *   sngl( aTrack.p.fm.p(4) - aTrack.p.mass)
c     *   sngl( aTrack.pos.xyz.r(1) ), sngl( aTrack.pos.xyz.r(2) ),
c     *   sngl( aTrack.vec.w.r(1) ), sngl(aTrack.vec.w.r(2) ),
c     *   sngl(aTrack.vec.w.r(3) ), 
c     *   sngl(aTrack.vec.coszenith)

      endif
      end

c    *********************************** hook for end of 1 event
c    * At this moment, 1 event generation has been ended.
c    *
      subroutine chookEnEvent

      implicit none
#include "Zprivate.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"

      integer i
      
      if(RealEnd) then
         call cfinTracking
c           real end of 1 event; if you need to do some here is
c           the place
c         ========================================================

         if(ObserveAS) then
c                   electron size in B approx.
            do i = 1, NoOfASSites
               write(*, *) ASObsSites(i).age, ASObsSites(i).esize
            enddo
         endif



c        ========================================================
c  
      else
c           there is still low energy skeleton ptcls
c           nothing to do here
      endif

      end


c     ********************************* hook for end of a run
c     *  all events have been created or time lacks
c     *
      subroutine chookEnRun
      implicit none
#include "Zprivate.h"
c     =========================================================

c     =========================================================
      call  cprintStatus   ! if don't like,  comment out
      end
c     ********************************* hook for trace
c     *  This is called only when trace > 100
c     *  User should manage the trace information here.
c     *  If you use this, you may need some output for trace
c     *  at the beginning of 1 event generatio and at the end of  1 event
c     *  generation so that you can identfy each event.
c     *
c     *
      subroutine chookTrace
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsv.h"

       real*4 h1,  h2
c
c    Every time a particle is moved in the atmosphere, this routine is called,
c    if trace > 100
c         For a one track segment,
c     TrackBefMove  has  track information at the beginning of the segment.
c     MoveTrack    has   track information at the end of the segment.
c   
c     You can know the  information a track contains in the 
c     chookObs routine. (Note however, no conversion of coordinate
c     has been done.  The values are in the Earth xyz system.)
c     Besides quantities explained there, you can use, for a  given 'track'
c
c     atrack.pos.xyz.x, atrack.pos.xyz.y, atrack.pos.xyz.z    (x,y.z)
c     atrack.pos.radiallen   (distance from the center of the earth)
c     atrack.pos.depth       (vertical depth)
c     atrack.pos.height      (vertical heigth from sea level)  
c

      h1 = TrackBefMove.pos.height- ObsSites(NoOfSites).pos.height
      h2 = MovedTrack.pos.height - ObsSites(NoOfSites).pos.height

      end
c     ********************* this is the hook called when
c       an electron made an interaction.
c
      subroutine chookEInt(never)
      implicit none
      integer never             ! input & output
      never = 1
      end

c     ********************* this is the hook called when
c       a gamma ray made an interaction.
c
      subroutine chookGInt(never)
      implicit none
      integer never   ! input & output
      never = 1
      end

c     ********************* this is the hook called when
c       non e-g particle made an interaction.
c
      subroutine chookNEPInt(never)
      implicit none
      integer never   ! input & output
      never = 1
      end


      subroutine cgetHES(from)
      implicit none
#include "Zprivate.h"
      integer from

      integer i

      read(from)  Np
      do i = 1, Np
         read(from) o(i)
      enddo
      end

      subroutine cobsHES
      implicit none
#include "Zprivate.h"
#include "Ztrack.h"
c
c           memorized high energy showers at the skeleton making
c     time is put into the chookObs as if they are really observed
      record /track/ aTrack

      integer i

      do i = 1, Np
         aTrack.where =  o(i).where 
         aTrack.p.code =  o(i).code 
         aTrack.p.subcode = o(i).subcode 
         aTrack.p.charge = o(i).charge 
         aTrack.t = o(i).atime 
         aTrack.p.fm.p(4) = o(i).erg
         aTrack.p.mass = o(i).mass 
         aTrack.pos.xyz.r(1) = o(i).x 
         aTrack.pos.xyz.r(2) = o(i).y 
         aTrack.vec.w.r(1) = o(i).wx
         aTrack.vec.w.r(2) = o(i).wy
         aTrack.vec.w.r(3) = o(i).wz
         aTrack.vec.coszenith = o(i).zenith 
         call chookObs(aTrack, 2)
      enddo
      end


c        process low energy partilces in the skeleton 1 by 1

      subroutine c1by1
      implicit none
#include "Zprivate.h"
#include "Ztrack.h"
#include "Ztrackv.h"

      character*100 msg

      call cinitStack  ! empty the stack

      if( TopOfNode ) then
         read(Mdev)  NoOfLowE,  p
         if( p.asflag .eq. -1 .and. ObserveAS 
     *      .and. HowFlesh .ne. 0 )  then
            call embedAS
         endif
         NLowCounter = 0
         if( NoOfLowE .eq. -1 ) then
            RealEnd = .true.
            RealBegin = .true.
            return    ! ************
         endif
      endif

      RealBegin = .false.
      RealEnd = .false.


      if( NLowCounter .eq. NoOfLowE ) then
         TopOfNode =.true.
         return   ! **************
      endif

      TopOfNode = .false.
c         still not the  end of 1 event

      read(Mdev)  c

      NLowCounter = NLowCounter + 1
      call cmove_c_stack   ! move c into stack

      end
c
      subroutine embedAS
      implicit none
#include "Zprivate.h"
#include "Ztrack.h"
#include "Zearth.h"

      record /track/ el
      
      el.pos.depth = p.depth
      el.vec.coszenith = p.coszenith
      el.pos.radiallen = p.height + Eradius
      el.pos.height = p.height
      el.p.fm.p(4) = p.erg
      el.wgt = 1.0
      call cobAS(el)
      end

      
      

      subroutine cmove_c_stack
      implicit none

#include "Zprivate.h"
#include "Ztrack.h"
#include "Zearth.h"

      record /track/ aTrack
c
c          a child of the current parent is moved to stack
c      as a track info.
c
      aTrack.pos.xyz.r(1) = p.posx
      aTrack.pos.xyz.r(2) = p.posy 
      aTrack.pos.xyz.r(3) = p.posz
      aTrack.pos.depth = p.depth 
      aTrack.pos.height = p.height
      aTrack.pos.colheight = p.colHeight 
      aTrack.t = p.atime 

      aTrack.where = p.where 

      aTrack.p.code = c.code 
      aTrack.p.subcode = c.subcode
      aTrack.p.charge  = c.charge
      aTrack.p.fm.p(1) = c.fm(1) 
      aTrack.p.fm.p(2) = c.fm(2) 
      aTrack.p.fm.p(3) = c.fm(3) 
      aTrack.p.fm.p(4) = c.fm(4) 
      aTrack.p.mass = c.mass

c        --------------- next must be compute here

      aTrack.pos.radiallen = Eradius +aTrack.pos.height
      aTrack.pos.xyz.sys = 'xyz'
      aTrack.vec.w.sys = 'xyz'
      aTrack.wgt = 1.0
      if(p.asflag .ne. 0 .and. HowFlesh .ne. 0 ) then 
c           asflag=   -1 or -2 may happen
         aTrack.asflag = 1
      else
c           parent is made to be unconceivable, so
c           don't put flag for AS generation
         aTrack.asflag =  0
      endif


         

      call cresetDirec( aTrack )    ! set vec.w and coszenith 

      call cpush(aTrack)
      end
