#!/bin/bash
if [ "$COSMOSTOP" == "" ]; then
    echo "Env. variable COSMOSTOP is empty"
    exit
fi

cat <<EOF
***************************************************************
   To make one of the following interaction models selectable.
1) qgsjetII-04 or qgsjetII-03
2) epos-lhc-v3700 or epos199 or epos-lhc-v3400
  Current model selection status is as follows:
EOF
$COSMOSTOP/Scrpt/showIntModel.sh

cat <<EOF

Enter 1 or 2.
**NOTE: epos199/epos-lhc-v3400 cannot be used for EPICS
     if projectile/target contains A>56 **
If you need to use  both 1 and 2, do  fixIntModel.sh 2 times.
Also note that this script only remake the library, so your
executalbe must be re-made by, say, make clean; make, in your app.

EOF

read ans
if [ -z $ans ]; then
    echo Enter 1 or 2
    exit
fi

echo "you selection is " $ans
echo "Is it OK ?, then simply push Enter else enter n"
read yes
if [  ! -z $yes ]; then
    exit
fi
if [ $ans == 1 ]; then
    $COSMOSTOP/Scrpt/fixQGSII.sh
elif [ $ans == 2 ]; then
    $COSMOSTOP/Scrpt/fixEPOS.sh
else
    echo your number, $ans,  is invalid
    exit
fi
cat <<EOF
*********** NOTE **********
The procedure so far only re-built the library
Your application must be re-made by, say, make clean; make
in your application folder.
EOF
