      subroutine csibyllinit
      implicit none
c
      COMMON /S_CLDIF/ LDIFF
      INTEGER          LDIFF
      COMMON /S_CSYDEC/IDB(49), CBR(102), KDEC(612), LBARP(49)
      REAL             CBR
      INTEGER          IDB,KDEC,LBARP
      integer  KODFRAG                  
      COMMON /CKFRAG/ KODFRAG                  


      KODFRAG =0  ! complex fragmentation by Abrasion-ablation model
      LDIFF = 0   ! mix diff and non-diff
      call SIBYLL_INI
      call SIGMA_INI   ! p-/pi-/K-Air  sigma and mfp
                   ! 
      call NUC_NUC_INI  ! A-A' xsec.  init.  seems false.
            ! NUC_NUC_INI calls sigma_ini agian; is it ok?
!      call INI_WRITE(0) !!!!! print pAir xsec.
c        don't let mu, pi, K decay;
!           for AA' col.
!       call SIGNUC_INI(...) !  this is almost useless
!                    so we make cgetAAXsSib for each
!                    AA' col.

      IDB(4:12) = -IDB(4:12)

c            short life particle decay is managed by us
c          
c       same for eta
      IDB(23)  = -IDB(23)
c       same for  SIGMA, XI, LAMBDA
c      do  i = 34, 39
      IDB(34:36) = -IDB(34:36)
      IDB(39) = -IDB(39)
c/////////
c      IDB(34) = abs(IDB(34))
c///////
      end
c     ****************
      subroutine  csibyllevent(pj, ia, iz, a, ntp)
      implicit none
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        klight: light normally 100 nm~1000 nm
c             subcode: kscinit scintillation light
c                      kceren  Cerekov light
c                      ksycn   synchrotron light
c        kEdepo: energy deposit in a small cell from whcih
c                scintillation lightis produced.
c        kchgPath: charged particle path form wich Cerenkov
c               light is generated.
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.
c  #ifndef Zptcl_
c  #define Zptcl_


c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum
          union
              map
                  real*8 p(4)
              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   
      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c  #endif  /* Zptcl.h */

c               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=768.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
c        masddb and masnnb are the minimum value.
c
      record /ptcl/ pj  ! input projectile particle
      integer,intent(in):: ia, iz  ! target A,Z (Z will not be
                  ! used)
      record /ptcl/ a(*)
      integer,intent(out)::ntp  ! # of ptcls produced in a.

      integer k, i, L
      integer::  icp, iat
      integer::  j
      real*8::  E0, Ecm, g, beta, Eg
      integer::icon

      real  sqs
c            not used
c      record /ptcl/pjcms, tgcms, tgrest
c      data tgrest.fm.p(1:4)/0.d0,0.d0,0.d0,masp/
c      data tgrest.mass/masp/
c      record /ptcl/Cmsp
c      record /ptcl/pjpnlab  ! proj. /n in lab 
c      data pjpnlab.fm.p(1:2)/0.d0, 0.d0/


!       call csibyllIniEvent   ! no need at presnt
      call ccoscode2sibyll(pj, icp)  ! get sibyll code of pj
      iat =  ia !  target mass number
      if(pj.code .eq. kgnuc) then
         E0 = pj.fm.p(4)/pj.subcode !  GeV/n in Lab
         Ecm = sqrt( ( E0 +masp )*2*masp )  ! nn system
      else
         if( pj.code == klambda ) then
            icp = 14 ! n
         endif
         E0 = pj.fm.p(4)
         Ecm = sqrt( E0*2*masp + pj.mass**2 + masp**2)
      endif
      sqs = Ecm
      g = (E0 + masp)/Ecm  ! cms gamma factor  !=sqs/2/mp for pi/K
      beta = sqrt( (g-1.d0) * (g + 1.d0)) /g
      if( pj.code /= kgnuc ) then
         call SIBYLL(icp, iat, sqs)  ! event generator
              ! icp = 7,8, 9,10, 11,12, 13,14, -13,-14       
              !   pi+-,K+-,  KL,KS, p,n,  pbar,nbar
              !  The output is contained in COMMON /S_PLIST/
              ! iat= 0--> Air . sqs = root(s) in GeV for pj-nucleon system.
         call DECSIB            !  all unfamilier ptcls should decay
      else
         call SIBNUC( icp, iat, sqs)  !A-A' col. icp  sqs is n-n system.
                            ! icp=A, iat= A', iat= 0 is for Air
      endif

      if( pj.code /= kgnuc ) then
         call csibhA2coscode(g, beta, a, ntp)
      else
         call csibAA2coscode(g, beta, a, ntp)
      endif
      call crot3mom(pj, a, ntp)
      end

      subroutine csibyllIniEvent
!        at present nothing to do 
      implicit none
      integer:: NP, LLIST
      real::   P
      COMMON /S_PLIST/ NP, P(8000,5), LLIST(8000)
      REAL             PA
      INTEGER          LLA,NPA
      COMMON /S_PLNUC/ NPA, PA(5,40000), LLA(40000)

      end      subroutine csibyllIniEvent


      subroutine csibhA2coscode(g, beta, a, ntp)
      implicit none
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        klight: light normally 100 nm~1000 nm
c             subcode: kscinit scintillation light
c                      kceren  Cerekov light
c                      ksycn   synchrotron light
c        kEdepo: energy deposit in a small cell from whcih
c                scintillation lightis produced.
c        kchgPath: charged particle path form wich Cerenkov
c               light is generated.
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.
c  #ifndef Zptcl_
c  #define Zptcl_


c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum
          union
              map
                  real*8 p(4)
              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   
      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c  #endif  /* Zptcl.h */

c               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=768.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
c        masddb and masnnb are the minimum value.
c
      real(8),intent(in):: g  ! cms g factor
      real(8),intent(in):: beta  ! its beta 
      record /ptcl/a(*)  ! output patlcs
      integer,intent(out):: ntp  ! # of ptcls put in a

      integer:: NP, LLIST
      real::   P
      COMMON /S_PLIST/ NP, P(8000,5), LLIST(8000)

      integer:: j, L
      
      ntp = 0
      do  j = 1, NP
         if(abs(LLIST(j)) .lt. 10000) then
            ntp = ntp + 1   
            a(ntp).fm.p(1:2)=P(j, 1:2)
            a(ntp).fm.p(3) = g* (P(j,3) +
     *              beta*P(j,4))
            a(ntp).fm.p(4) = g* (P(j,4) +
     *              beta*P(j,3))
            L = mod(LLIST(j), 10000)
!            L = LLIST(j)
            call csibyllcode2cos(L, a(ntp))
         endif
      enddo
      end      subroutine csibhA2coscode
      subroutine csibAA2coscode(g, beta, a, ntp)
      implicit none
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        klight: light normally 100 nm~1000 nm
c             subcode: kscinit scintillation light
c                      kceren  Cerekov light
c                      ksycn   synchrotron light
c        kEdepo: energy deposit in a small cell from whcih
c                scintillation lightis produced.
c        kchgPath: charged particle path form wich Cerenkov
c               light is generated.
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.
c  #ifndef Zptcl_
c  #define Zptcl_


c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum
          union
              map
                  real*8 p(4)
              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   
      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c  #endif  /* Zptcl.h */

c               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=768.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
c        masddb and masnnb are the minimum value.
c     
      real(8),intent(in):: g  ! cms gamma factor
      real(8),intent(in):: beta ! its beta
      record /ptcl/a(*)  ! output. ptcls stored here
      integer,intent(out):: ntp  ! # of ptlcs in a

      REAL             PA
      INTEGER          LLA,NPA
      COMMON /S_PLNUC/ NPA, PA(5,40000), LLA(40000)

      integer:: L
      integer:: j
      
      ntp = 0
      do  j = 1, NPA
         if(abs(LLA(j)) .lt. 10000) then
            ntp = ntp + 1   
            a(ntp).fm.p(1:2)=PA(1:2,j)
            a(ntp).fm.p(3) = g* (PA(3,j) + beta*PA(4,j))
            a(ntp).fm.p(4) = g* (PA(4,j) + beta*PA(3,j))
            L = mod(LLA(j), 10000)
            call csibyllcode2cos(L, a(ntp))
         endif
      enddo
      end      subroutine csibAA2coscode

       real  function  S_RNDM(X)
       integer  X  !  not used
       real*8 u
       call rndc(u)
       S_RNDM = u
       end
       subroutine ccoscode2sibyll(pj, ksib)
       implicit none
c  #ifndef Zptcl_
c  #define Zptcl_


c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum
          union
              map
                  real*8 p(4)
              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   
      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c  #endif  /* Zptcl.h */
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        klight: light normally 100 nm~1000 nm
c             subcode: kscinit scintillation light
c                      kceren  Cerekov light
c                      ksycn   synchrotron light
c        kEdepo: energy deposit in a small cell from whcih
c                scintillation lightis produced.
c        kchgPath: charged particle path form wich Cerenkov
c               light is generated.
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.
      record /ptcl/ pj
      integer ksib
c
c      projectiel 7,8,  9,10, 11,12, 13,14, -13,-14
c                 pi+-,  K+-,  KL,KS, p,n,  pbar,nbar
      
      if( pj.code .eq. knuc ) then
         if( pj.charge .eq. 1) then
            ksib = 13
         elseif(pj.charge .eq. -1) then
            ksib = -13
         elseif( pj.charge .eq. 0) then
            if( pj.subcode .eq. antip ) then
               ksib = -14
            else
               ksib = 14
            endif
         endif
      elseif( pj.code .eq. kpion ) then
         if( pj.charge .eq. 1 ) then
            ksib = 7
         elseif( pj.charge .eq. -1 ) then
            ksib = 8
         else
            ksib = 6
         endif
      elseif( pj.code .eq. kkaon ) then
c   9 K+    10 K-  11  K0L   12 K0s
         if( pj.charge .eq. 1 ) then
            ksib= 9
         elseif( pj.charge .eq. -1 ) then
            ksib = 10
         elseif( pj.subcode .eq. k0s ) then
            ksib = 12
         else
            ksib = 11
         endif
      elseif( pj.code == kgnuc) then
         ksib = pj.subcode   ! if 0, assumed to be  Air
      elseif( pj.code == klambda) then
         ksib = 39
      else
         write(0,*) 
     *    ' code =',pj.code, ' not acceptable in sibyll'
         stop 12345
      endif
      end
      subroutine csibyllcode2cos(ksibin, pj)
      implicit none
c  #ifndef Zptcl_
c  #define Zptcl_


c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum
          union
              map
                  real*8 p(4)
              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   
      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c  #endif  /* Zptcl.h */
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        klight: light normally 100 nm~1000 nm
c             subcode: kscinit scintillation light
c                      kceren  Cerekov light
c                      ksycn   synchrotron light
c        kEdepo: energy deposit in a small cell from whcih
c                scintillation lightis produced.
c        kchgPath: charged particle path form wich Cerenkov
c               light is generated.
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.
      integer,intent(in):: ksibin  ! sibyll code
      record /ptcl/ pj    !   output cos code is put here
c
      real*8 u 
      integer ksib, code, subcode, charge

      ksib = abs(ksibin)
      subcode = regptcl
      if(ksib .eq. 1) then
         code = kphoton
         charge = 0
      elseif(ksib .eq. 2) then
         code = kelec
         charge = 1
      elseif(ksib .eq. 3) then
         code = kelec
         charge = -1
      elseif(ksib .eq. 4) then
         code = kmuon
         charge = 1
      elseif(ksib .eq. 5) then
         code = kmuon
         charge = -1
      elseif(ksib .eq. 6) then
         code = kpion
         charge = 0
      elseif(ksib .eq. 7) then
         code = kpion
         charge = 1
      elseif(ksib .eq. 8) then
         code = kpion
         charge = -1
      elseif(ksib .eq. 9) then
         code = kkaon
         charge = 1
      elseif(ksib .eq. 10) then
         code = kkaon
         charge = -1
      elseif(ksib .eq. 11) then
         code = kkaon
         charge = 0
         subcode = k0l
      elseif(ksib .eq. 12) then
         code = kkaon
         charge = 0
         subcode = k0s
      elseif(ksib .eq. 13) then
         code = knuc
         subcode = regptcl
         charge = 1
      elseif(ksib .eq. 14) then
         code = knuc
         charge = 0
         subcode = regptcl
      elseif(ksib .eq. 15) then
         code = kneue
         subcode = regptcl
         charge = 0
      elseif(ksib .eq. 16) then
         code = kneue
         subcode = antip
         charge = 0
      elseif(ksib .eq. 17) then
         code = kneumu
         subcode = regptcl
         charge = 0
      elseif(ksib .eq. 18) then
         code = kneumu
         charge = 0
         subcode = antip
      elseif(ksib .eq. 19) then
         code = knuc
         charge = -1
         subcode = antip
      elseif(ksib .eq. 20) then
         code = knuc
         charge = 0
         subcode = antip
      elseif(ksib .eq. 21) then
         code = kkaon
         call rndc(u)
         charge = 0
         if(u .lt. 0.5) then 
            subcode = k0s
         else
            subcode = k0l
         endif
      elseif(ksib .eq. 22) then
         code = kkaon
         charge = 0
         if(u .lt. 0.5) then 
            subcode = k0s
         else
            subcode = k0l
         endif
      elseif(ksib .eq. 23) then
         code = keta
         charge = 0
      elseif(ksib .eq. 25) then
         code = krho
         charge = 1
      elseif(ksib .eq. 26) then
         code = krho
         charge = -1
      elseif(ksib .eq. 27) then
         code = krho
         charge = 0
      elseif(ksib .eq. 33) then
         code = kphi
         subcode = regptcl
         charge = 0
      elseif(ksib .eq. 34) then
         code = ksigma
         subcode = regptcl
         charge = 1
      elseif(ksib .eq. 35) then
         code = ksigma
         subcode = regptcl
         charge = 0
      elseif(ksib .eq. 36) then
         code = ksigma
         subcode = regptcl
         charge = -1
      elseif(ksib .eq. 37) then
         code = kgzai
         subcode = regptcl
         charge = 0
      elseif(ksib .eq. 38) then
         code = kgzai
         subcode = regptcl
         charge = -1
      elseif(ksib .eq. 39) then
         code = klambda
         subcode = regptcl
         charge = 0
      elseif( ksib > 1000) then
         subcode = ksib- 1000
         if( subcode > 1 ) then
            code = kgnuc
            charge = subcode/2.15 +0.7 ! some plausible Z
         else
            code  = knuc
            call rndc(u)
            if(u < 0.6) then
               charge = 0
            else
               charge = 1
            endif
            subcode = -1
         endif
      else
         write(0,*) ' ****************sibyllcode=',ksib, ksibin
         code = krare
         charge = 0
         subcode = regptcl
      endif
      if(ksibin .lt. 0) then
         subcode = antip
         charge = - charge
      endif
      call cmkptc(code, subcode, charge, pj)
      end
      subroutine csibylGetDiffCode(nwout, difcode)
      implicit none
c    in case of nuclei for each interaction]. The meaning is
C.       JDIF(JW)  = diffraction code    !!!! changed to field !!!!
C.                  (0 : non-diffractive interaction) 
C.                  (1 : forward diffraction)     
C.                  (2 : backward diffraction) 
C.                  (3 : double diffraction)  
      integer,intent(out):: nwout !    
      integer,intent(out):: difcode(20)
c          for p/n projectile,nw =1, difcode(1) shows the                      
c          diffraction state.                                                  
      integer NW_max, NS_max, NH_max, NJ_max
      PARAMETER (NW_max = 20)
      PARAMETER (NS_max = 20, NH_max = 50)
      PARAMETER (NJ_max = (NS_max+NH_max)*NW_max)
      real(4):: X1J, X2J, X1JSUM, X2JSUM, PTJET, PHIJET
      integer:: NNPJET, NNPSTR, NNSOF, NNJET, JDIF, NW, NJET, NSOF

      COMMON /S_CHIST/ X1J(NJ_max),X2J(NJ_max),
     &    X1JSUM(NW_max),X2JSUM(NW_max),PTJET(NJ_max),PHIJET(NJ_max),
     &    NNPJET(NJ_max),NNPSTR(2*NW_max),NNSOF(NW_max),NNJET(NW_max),
     &    JDIF(NW_max),NW,NJET,NSOF

      nwout = NW
      difcode(1:nwout)=JDIF(1:nwout)
      end

