      module modqgsjet2  ! instead of using common or entry
                        ! inside this interface routines

      implicit none
      real(8),save::  ke0n
      integer,save::  kicz 
      integer,save::  kiap 
      integer,save::   kicp 
      integer,save::   kiat
      integer,save:: check=0
      end module  modqgsjet2 

      subroutine cQGSjet(pj, iat, iz,  a, ntp)
      implicit none
c  #ifndef Zptcl_
c  #define Zptcl_


c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum
          union
              map
                  real*8 p(4)
              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   
      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c  #endif  /* Zptcl.h */
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        klight: light normally 100 nm~1000 nm
c             subcode: kscinit scintillation light
c                      kceren  Cerekov light
c                      ksycn   synchrotron light
c        kEdepo: energy deposit in a small cell from whcih
c                scintillation lightis produced.
c        kchgPath: charged particle path form wich Cerenkov
c               light is generated.
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.

c               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=768.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
c        masddb and masnnb are the minimum value.
c ------------------------
      record /ptcl/pj  ! input .projectile
      integer iat  !  input target mass number
      integer iz     ! input. charge no. of target
      integer ntp    ! output.produced ptcls number
      record /ptcl/ a(*)  ! produced ptlcs' a(ntp)
      record /ptcl/ ldcy(2)
      real*8 xs
      integer ngen, i, ngen2
c   if  next is 1:  at collision point forced decay and decay prod
c                   is made to collide
c               2:  collision is manage by dpmjet3
c               3:  collision is replaced by proton. 
      if(pj.code .eq. klambda) then
c           regard it as neutron
      call cmkptc(knuc, -1, 0, pj)
      call cadjm(pj, pj)
      call cxsecQGS( pj, iat,   xs )
      call cQGSjet0( pj, iat, iz, a, ntp)

      elseif( pj.code .eq. ksigma .or. pj.code .eq. kgzai
     * .or. pj.code .eq. kbomega) then
c        althogh qgsjet dose not generate sigma and gzai, bomega
c        klambda treatment above generates these; 
c          eventuall they will be treated by ad-hoc.
c          bomega is very rare 1 or 2 during one 10^20 eV proton event
         call cdpmjet(pj, iat, iz,  a, ntp)
      elseif( pj.code .eq. keta) then
c          same as above; but use ad-hoc
c                  at Ultra H.E, eta may collide.
         call chAcolAdhoc(pj, iat, iz, a, ntp)
      else
c          intrinsic qgsjet2
         call cQGSjet0(pj, iat, iz, a, ntp)
      endif
      end

      subroutine ciniQGS
      implicit none
c   make next as large as 1~2 milion for practical case
c  (for general MPI application)



c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
c  #ifndef Zptcl_
c  #define Zptcl_


c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum
          union
              map
                  real*8 p(4)
              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   
      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c  #endif  /* Zptcl.h */
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        klight: light normally 100 nm~1000 nm
c             subcode: kscinit scintillation light
c                      kceren  Cerekov light
c                      ksycn   synchrotron light
c        kEdepo: energy deposit in a small cell from whcih
c                scintillation lightis produced.
c        kchgPath: charged particle path form wich Cerenkov
c               light is generated.
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.

c               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=768.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
c        masddb and masnnb are the minimum value.
c  #include "Zair.h"
c           dummy ptcl and target for init
      record /ptcl/pj  !  dummy projectile
      integer ia  !  target mass number
      integer iz     ! charge no. of target
      integer ntp    ! output.produced ptcls number
      record /ptcl/ a(100)  ! produced ptlcs' a(ntp)


!      integer debug        
!      common /debug/   debug !-04  /qgdebug/.  default is 
                        ! so don't touch it
      integer moniou
      common /qgarr43/ moniou

      logical,save::  first=.true.

      integer iseq, j


      real*8 u, xs
!//////////// file management for qgsjetII-04
      common/producetab/ producetables !used to link with CRMC
      logical producetables
      character*500 fnIIdat,fnIIncs !used to link with nexus ?
      integer ifIIdat, ifIIncs
      common/qgsIIfname/fnIIdat, fnIIncs, ifIIdat, ifIIncs 
!////////////////
      character*(132):: cosmostop
      integer:: leng, kgetenv2

      if( first ) then
         call qgset     !set model parameters (moniou is 6)
         moniou = 0     ! reset moniou(=errout) to 0 
         producetables = .false.  ! x sec. table exists so read it 

         ifIIdat = 0     ! read qgsdat-II-04 from logical dev # 1
         ifIIncs = 0     ! read ectnu-II-04 from # 2
         leng = kgetenv2("COSMOSTOP", cosmostop)
         if( leng == 0 ) then
            write(0,*)
     *      ' Env. Variable  COSMOSTOP is enmpty'
            stop
         endif
!           they are assumed to be in  the following dir.
         cosmostop=trim(cosmostop)//"/Import/QGS/"
         call qgaini(cosmostop)   !initialize QGSJET-II 

c             dummy collision for init. without this,
c          first event will be biased. (why?)
         call cmkptc(knuc, -1, 1, pj)
         pj.fm.p(1)=0.
         pj.fm.p(2)=0.
         pj.fm.p(3)=100.
         pj.fm.p(4)=sqrt(pj.fm.p(3)**2 + pj.mass**2)
c         ia = TargetMassN
c         iz = TargetAtomicN
         ia = 4
         iz = 2
         call cxsecQGS(pj, ia, xs)
         call cQGSjet0( pj, ia, iz, a, ntp)
         if(ntp .gt. 100) then
            write(0,*) ' too many ptcls at init of qgs2'
            stop
         endif
         first = .false.
      endif
      end

      subroutine cxsecQGS( pj, iat,   xs )
      use modqgsjet2
      implicit none
c  #ifndef Zptcl_
c  #define Zptcl_


c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum
          union
              map
                  real*8 p(4)
              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   
      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c  #endif  /* Zptcl.h */
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        klight: light normally 100 nm~1000 nm
c             subcode: kscinit scintillation light
c                      kceren  Cerekov light
c                      ksycn   synchrotron light
c        kEdepo: energy deposit in a small cell from whcih
c                scintillation lightis produced.
c        kchgPath: charged particle path form wich Cerenkov
c               light is generated.
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.

c               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=768.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
c        masddb and masnnb are the minimum value.

c      real*8  ep, ebal
c    ****************** important *****
c    if you increase iapmax, changes are also needed in qgsjet and
c    207 in Epics/prog/epixsec.f 
C      parameter(iapmax=209,nptmax=50000) ! -03

      integer iapmax, nptmax, nsp, nsf, iaf, ich
      real*8  esp 
      parameter(iapmax=209,nptmax=95000)  !!!!!!/// -04
c      dimension ep(4),ebal(4)
      common /qgarr12/ nsp                       !number of secondaries
      common /qgarr13/ nsf,iaf(iapmax)           !number of nuclear fragments,
      common /qgarr14/ esp(4,nptmax),ich(nptmax) !4-momenta and types of second.

      record /ptcl/pj  ! input .projectile
      integer,intent(in):: iat  !  target mass number

      real(8),intent(out):: xs  !  xsection in mb  



      real*8  qgsect  

      if( pj.code .ne. kgnuc ) then
         kiap = 1     !set proj. mass number (1-for hadron)
      else
         kiap = pj.subcode
      endif
      call ccoscode2QGS( pj, kicp )
      if(kicp .eq. 0) then
         xs = 1.d-30
      else
         ke0n = pj.fm.p(4)/kiap !to get energy per nucleon
         kiat = iat

         kicz=iabs(kicp)/2+1    !primary particle class (1- pion, 2 - nucleon, 3 - kaon)
         xs=qgsect(ke0n,kicz,kiap,kiat) !get particle production cross sectio
      endif
      check= 1
      end
c     *********************************
      subroutine cqQGSint( e0n, icz, iap, icp, iat )
c        inquire current interacion conditions
c     *********************************
      use modqgsjet2
      implicit none
      real(8),intent(out):: e0n !  E0/N (for Nuc) or E0 (for had)
      integer,intent(out):: icz ! 1ry class
      integer,intent(out):: iap ! projectile mass number. (1 for had)
      integer,intent(out):: icp ! projectile QGS code  (2 for heavy)
      integer,intent(out):: iat ! target mass number

c  
      e0n = ke0n
      icz = kicz
      iap = kiap
      icp = kicp
      iat = kiat
      end      subroutine cqQGSint
c     ***********************************
      subroutine  cQGSjet0(pj, iat, iz,  a, ntp)
      use modqgsjet2
c     ***********************************
      implicit none
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        klight: light normally 100 nm~1000 nm
c             subcode: kscinit scintillation light
c                      kceren  Cerekov light
c                      ksycn   synchrotron light
c        kEdepo: energy deposit in a small cell from whcih
c                scintillation lightis produced.
c        kchgPath: charged particle path form wich Cerenkov
c               light is generated.
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.
c  #ifndef Zptcl_
c  #define Zptcl_


c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum
          union
              map
                  real*8 p(4)
              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   
      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c  #endif  /* Zptcl.h */
      record /ptcl/pj  ! input .projectile
      integer,intent(in):: iat  ! target mass number
      integer,intent(in):: iz   !  charge no. of target
      record /ptcl/ a(*)  ! produced ptlcs' a(ntp)
      integer,intent(out)::ntp    !  produced ptcls number
c ------------------------
      integer iapmax, nptmax, nsp, nsf, iaf, ich
      real*8  esp 
      parameter(iapmax=209,nptmax=95000)  !!!!!!/// -04
c      dimension ep(4),ebal(4)
      common /qgarr12/ nsp                       !number of secondaries
      common /qgarr13/ nsf,iaf(iapmax)           !number of nuclear fragments,
      common /qgarr14/ esp(4,nptmax),ich(nptmax) !4-momenta and types of second.



      integer::ic
      integer:: isf, i, is
      integer zfrag, mfrag


c      ebal(1)=e0n*iap+.939d0*iat           
c      ebal(2)=dsqrt(e0n**2-.939d0**2)*iap
c      ebal(3)=0.d0
c      ebal(4)=0.d0
c      aknn=0.d0
c      ach=0.d0

c           check below will not be 0 but 1,   if projectile Xsection 
c           is calculable by cxsecQGS.  0 means special case 
c           where particles generated by qgsjet2 cannout use cxsecQGS
c           and qgsjet2 cannot be used for particle generation by
c           such a partilce
      if(check .eq. 0) then
c          now   should not come here
         write(0,*) ' check=0 in  qgsjet interface'
         write(0,*) ' pj=',pj.code,pj.subcode,pj.charge,pj.fm.p(4)
         stop
c         if(pj.code .eq. klambda) then
c            call chAcolAdhoc(pj, iat, iz, a, ntp)
c         elseif(pj.code .eq. keta) then
c                  at Ultra H.E, eta may collide.
c            call chAcolAdhoc(pj, iat, iz, a, ntp)
c         else           
c            write(0,*) ' check=0 in  qgsjet interface'
c            write(0,*) ' pj=',pj.code,pj.subcode,pj.charge,pj.fm.p(4)
c         endif
      endif
      if(check .eq. 1) then
         kiat = iat             ! may not be the same as iat from cxsecqgs

         call qgini( ke0n, kicp, kiap, iat) !initialize current interaction
         call qgconf            !inelastic interaction
c           next is projectile fragments
         ntp = 0
         do isf = 1, nsf        !loop over produced fragments
            mfrag = iaf(isf)    !fragment mass number
!!            zfrag = pj.charge*mfrag/kiap ! fragment charge
!!           by this, He --> charge 1 so updated
!!            2013/Apr/25
            call csetFragChg(kiap,  mfrag,  zfrag)  
            ntp = ntp + 1
c                set this heavy in a
            if( mfrag == 1 ) then
               call cmkptc( knuc, regptcl, zfrag, a(ntp) )
            else
               call cmkptc(kgnuc, mfrag, zfrag, a(ntp))
            endif
            a(ntp).fm.p(4) = ke0n*mfrag
         enddo
c          set fragment Pt
         call csampFragMom( a, ntp )
         do  is = 1, nsp        !loop over produced particles
            ntp = ntp + 1
            ic=ich(is)    
            call cQGScode2cos(ic, a(ntp))
            do i=1,4
               a(ntp).fm.p(5-i)=esp(i,is) !particle 4-vector
            enddo 
         enddo
         check = 0
      endif
         
c     -------------- rotate so that we get the same coordinate as pj
       call crot3mom( pj, a, ntp ) 
       if( pj.code .eq. kpion .and. pj.charge .eq. 0) then
c            pi0 is projectile.  we have been using pi+/- as
c            projectile so we wil replace the leading particle by pi+/pi-
c            kicp =1 is pi+/ kicp=-1 is pi- so we regard it as charge of pi
          call cfindHighestPi( kicp, a, ntp, i )
          if(i .gt.  0) then
             call cmkptc( kpion, 0, 0, a(i) )
          endif
       endif
      end


      subroutine ccoscode2QGS(pj, icp)
c  #ifndef Zptcl_
c  #define Zptcl_


c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum
          union
              map
                  real*8 p(4)
              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   
      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c  #endif  /* Zptcl.h */
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        klight: light normally 100 nm~1000 nm
c             subcode: kscinit scintillation light
c                      kceren  Cerekov light
c                      ksycn   synchrotron light
c        kEdepo: energy deposit in a small cell from whcih
c                scintillation lightis produced.
c        kchgPath: charged particle path form wich Cerenkov
c               light is generated.
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.
      record /ptcl/ pj  ! input. cosmos ptcl 
      integer icp       ! output. code for qgsjet

      real*8 u
      character*80 msg

      if(pj.code  .eq. kpion) then
         if(pj.charge .eq.  -1) then
            icp = -1
         elseif( pj.charge .eq. 1) then
            icp = 1
         else
c            pi0, first assign it to pi+ pr pi- and later replace the leading ptcl
c            by pi0
            call rndc(u) 
            if(u .lt. 0.5) then
               icp =1
            else
               icp =-1
            endif
         endif
      elseif(pj.code .eq.  knuc ) then
         if(pj.charge .eq. 1 ) then
            icp = 2
         elseif( pj.charge .eq. -1) then
            icp = -2
         else
            if(pj.subcode .eq. antip ) then
               icp = -3
            else
               icp = 3
            endif
         endif
      elseif(pj.code .eq. kkaon) then
         if(pj.charge .eq. 1) then
            icp = 4
         elseif( pj.charge .eq. -1) then
            icp = -4
         else
            if(pj.subcode .eq. antip) then
               icp = -5
            else
               icp = 5
            endif
         endif
      elseif( pj.code .eq. kgnuc ) then
         icp = 2
      elseif( pj.code .eq. kdmes ) then
         icp = 0
      else 
         write(msg,
     *   '("ptcl code=",i3," charge=",i3,"not supported in QGSII")') 
     *    pj.code, pj.charge
         call cerrorMsg(msg, 0)
      endif
c        set proj. type (-1 - pi^-, 1 - pi+,
c       -2 - p~, 2 - p, -3 - n~, 3 - n, -4 - k^-, 4 - k+, -5 - k0~, 5 - k0)
      end
      subroutine cQGScode2cos(icp, pj)
      implicit none
c  #ifndef Zptcl_
c  #define Zptcl_


c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum
          union
              map
                  real*8 p(4)
              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   
      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c  #endif  /* Zptcl.h */
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        klight: light normally 100 nm~1000 nm
c             subcode: kscinit scintillation light
c                      kceren  Cerekov light
c                      ksycn   synchrotron light
c        kEdepo: energy deposit in a small cell from whcih
c                scintillation lightis produced.
c        kchgPath: charged particle path form wich Cerenkov
c               light is generated.
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.
      integer icp    ! input qgs code
      record /ptcl/ pj  ! output.  cosmos ptcl to get code

      integer  code, subcode, charge 

      character*80 msg

      if(icp .eq. -1) then
         code = kpion
          charge = -1
      elseif(icp .eq. 1) then
         code = kpion
         charge = 1
      elseif(icp .eq. 0 ) then
         code = kpion
         charge = 0
      elseif(icp .eq.  2 ) then
         code = knuc
         charge = 1
      elseif(icp .eq. -2) then
         code = knuc
         charge = -1
      elseif(icp .eq. 3) then
         code = knuc
         charge = 0
         subcode = regptcl
      elseif(icp .eq. -3) then
         code = knuc
         charge = 0
         subcode = antip
      elseif( icp .eq. 4 ) then
         code = kkaon
         charge = 1
      elseif( icp .eq. -4) then
         code  = kkaon
         charge = -1
      elseif( icp .eq. 5 )  then
         code = kkaon
         charge = 0
         subcode = k0s
      elseif( icp .eq. -5) then
         code = kkaon
         charge = 0
         subcode = k0l
      elseif( icp .eq.  -6) then
         code = klambda
         subcode = antip
         charge = 0
      elseif( icp .eq. 6 ) then
         code = klambda
         subcode = regptcl
         charge = 0
      elseif( abs(icp) .eq. 10 ) then
         code = keta
         subcode = 0
         charge = 0
      else
         write(msg,
     *   '("ptcl code from QGSII =",i3," is unknown")') 
     *    icp
         call cerrorMsg(msg, 0)
      endif
c          ((0 - pi0, -1 - pi^-, 1 - pi+,-2 - p~, 2 - p, -3 - n~, 3 - n,
c         -4 - k^-, 4 - k+, -5 - k0l, 5 - k0s, 6 - eta, -10 - lambda~, 10 - lambda)
      call cmkptc(code, subcode, charge, pj)
      end   subroutine cQGScode2cos

      subroutine cfindHighestPi(chg, a, ntp, n)
c           find highest enrgy Pi+ (if chg =1)  of  Pi- (if chg=-1)
c     and return its index n
      implicit none
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare, klight, kEdepo, kchgPath,
     5  kdeuteron
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     2  kneutronb, kd0, kd0b, kdirectg, kcasg,
     3  kscinti, kceren, ksync

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  khvymax = kiron, kdeuteron=keta+1,
     a  klast=kdeuteron+3,  ! 3 is next 3 items
     b  klight=-1, kEdepo=-2, KchgPath=-3)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3, 
     3  k0s = 4,  k0l= 5, kscinti=1, kceren=2, ksync=3,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        klight: light normally 100 nm~1000 nm
c             subcode: kscinit scintillation light
c                      kceren  Cerekov light
c                      ksycn   synchrotron light
c        kEdepo: energy deposit in a small cell from whcih
c                scintillation lightis produced.
c        kchgPath: charged particle path form wich Cerenkov
c               light is generated.
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.
c  #ifndef Zptcl_
c  #define Zptcl_


c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum
          union
              map
                  real*8 p(4)
              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   
      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c  #endif  /* Zptcl.h */
      integer chg  !  input   incident is +  / or -
      integer ntp  ! input  total number of ptcls
      record /ptcl/ a(ntp)  ! input
      integer n   ! output  n-th ptcl is highest energy if 0, no ptcl

      integer i
      real*8 erg

      n = 0
      erg = 0.
      do i = 1, ntp
         if( a(i).code .eq. kpion ) then
            if( a(i).charge .eq. chg ) then
               if( erg .lt. a(i).fm.p(4) ) then
                  erg = a(i).fm.p(4)
                  n = i
               endif
            endif
         endif
      enddo
      end
!         -04 does not supply random # generator
!       
      function  qgran(X) result(ans)
      real(8),intent(in):: X                 !  not used

      real(8):: u
      real(8):: ans
      call rndc(u)
      ans= u
      end

      subroutine cqgsFragChg(ia, iz, fm, fc)
!      fix   projectile fragment charge
      implicit none
      integer,intent(in):: ia  ! heavy proj. mass #
      integer,intent(in):: iz  ! heavy proj. charge
      integer,intent(in):: fm !  fragment mass #
      integer,intent(out):: fc !  fragment charge

      real(8):: pprob, u

      if( fm  == 1 ) then
         if( ia > 29 ) then
            pprob = 0.4         ! proton prob.
         else
            pprob = 0.5
         endif
         call rndc(u)
         if(u < pprob ) then
            fc = 1
         else
            fc = 0
         endif
      elseif( fm == 2 ) then
         fc = 1
      elseif( fm <= 4 ) then
         fc = 2
      elseif( fm < 29 ) then
         if( fm == 27) then
            fc = 13
         elseif( fm == 19 ) then
            fc = 9
         else
            fc = fm*0.5
         endif
      else
         if( fm == 56 ) then
            fc = 26
         elseif( fm == 40 ) then
            fc = 18
         elseif( fm == 48 )  then
            fc = 22
         elseif( fm < 70 ) then
            fc = fm*0.47
         else 
            fc =fm*0.4
         endif
      endif
      end   subroutine cqgsFragChg


      
      
      
