c     ****************************************
c     *                                                          *
c     * cmulScat: multiple Coulomb scattering
c     *                                                          *
c     ****************************************
c
c
      subroutine cmulScat(theta)
      implicit none
c       Using  cTrack and Move, compute scattering angle 
c
#include "Zglobalc.h"
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zelemagp.h"

      real*8 theta         ! output. sampled angle in radian.
c
c            
c
      integer cond

      integer ic

c             sample theta
      if(IntInfArray(ProcessNo).length .gt. 0.) then
         if(abs(Moliere) .gt. 1)  then
            call cmulScat1(theta)
         elseif(abs(Moliere) .eq. 1 .and.
     *       MovedTrack.p.code .ne. kelec) then
            call cmulScat1(theta)
         else
            call cmulScat2(theta)
         endif
      else
         theta = 0.
      endif
      end
c     **************************
      subroutine cmulScat2(theta)
      implicit none
c       Gaussian scattring
c
#include  "Zglobalc.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zelemagp.h"

      

      real*8 theta ! output. sampled spatial angle in radain.

      real*8 tetarms, g1, g2, u, beta2, dt
      integer nc
      
      real*8 hpi 
      parameter(hpi = pi/2.)

      g1 = TrackBefMove.p.fm.p(4)/MovedTrack.p.mass
      g2 = MovedTrack.p.fm.p(4)/MovedTrack.p.mass
      beta2 = 1.d0 - 1.d0/g1/g2
      if(beta2 .le. 0.) then
         tetarms = 0.
      else
         dt = IntInfArray(ProcessNo).thickness/ X0  ! r.l
         if(dt .gt. 1.d-3) then
            tetarms = Es/TrackBefMove.p.fm.p(4)*
     *       abs(MovedTrack.p.charge) *
     *       sqrt(dt/beta2)*(1.0 + 0.038*log(dt))
         else
            tetarms = Es/TrackBefMove.p.fm.p(4)*
     *      abs(MovedTrack.p.charge) * sqrt(dt/beta2)
         endif
      endif
      theta = pi
      nc = 0
      do while(theta .gt. hpi)
         if(nc .gt. 10) then
c              tetarms seems too large
            theta = u**0.1 * hpi  ! give some value 
         else
            call rndc(u)
            theta = sqrt(-log(u))* tetarms
            nc = nc +1
         endif
      enddo
      end
      subroutine cmulScat1(theta)
      implicit none
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zelemagp.h"
c           by Moliere thoery 

      real*8 theta
      
      real*8 g1, g2, leng
      integer cond

      real*8 t, tmp, avx, avy, disp, cs, sn, e1, e2, d1, d2
      real*8 rho, cvh2den
      integer chg
 
      e1 = TrackBefMove.p.fm.p(4)
      g1 = e1/TrackBefMove.p.mass
      e2 = MovedTrack.p.fm.p(4)
      g2 = e2/MovedTrack.p.mass
      rho = cvh2den(
     *      (TrackBefMove.pos.height+MovedTrack.pos.height)/2.d0
     *      )

      leng = IntInfArray(ProcessNo).length  ! in m

      chg =  MovedTrack.p.charge
      call cmoliere(rho,  chg, MovedTrack.p.mass, g1, g2,
     *     leng, theta, cond)
      if(cond .ne. 0) then
c           Moliere theory cannot be applied
         call cmulScat2(theta)
      endif
      end
