c make next 1 if vector meson after collsion is to be decayed
c else put 0 then, vector meson is replaced by photon
#define VECMESDECAY   1
c  uncomment until   cgpHad and use make -f test.mk
c
c #include "BlockData/cblkGene.h"
c      program main
c#include "ZcosmosExt.h"
c      call testprog
c      end
      

c            test cgpHad
c      subroutine testprog
c        implicit none
c#include  "Zptcl.h"
c#include  "Zmass.h"
c#include  "Zcode.h"

c     integer  massN
c      integer atomicN
c      integer icin
c      integer ntp
c      record /ptcl/ pj
c      integer  nmax
c      parameter (nmax=5000)
c      record /ptcl/a(nmax)
c      real*8  sumP(4), Eg
c      integer i, j, k

c      massN=14
c      atomicN=7
c      icin = 2
c      call cmkptc(kphoton, 0, 0, pj)
c      write(0,*) 'Enter Eg'
c      read(*,*) Eg
c      pj.fm.p(4)=Eg
c
c      pj.fm.p(1)= 0.
c      pj.fm.p(2)= 0.
c      pj.fm.p(3)=Eg
c      do i = 1, 10000
c         call cgpHad(massN, atomicN, pj, icin, a, ntp)
c         do j= 1, 4
c            sumP(j) = 0.
c         enddo
c         do j = 1, ntp
c            do k = 1, 4
c               sumP(k)  = sumP(k) + a(j).fm.p(k) 
c            enddo
c            write(*,'(2i3, 4g12.3)') a(j).code, a(j).charge,
c     *                      (a(j).fm.p(k),k=1,4)
c         enddo
c         write(*,'(4g12.3)') (sumP(k), k=1,4)
c         write(*,*)
c         write(*,*) 'n= ', ntp-1
c      enddo
      
c      end
c         gamma-n(p or A)-->hadrons
c       This cgpHad is called when whichcode = "current"
c       in cphotop. 
c       "current" means if Eg < 2.5, experimetnal data is used
c        Eg>2.5 GeV, current Active interaction model is 
c        basically used with the following  projectile which is
c        made from incident photon.
c       rho, omega or phi.  if the model can accept one of these
c       pi0                 if not, if the model accept  this
c       pi+/-               if not, use this and leading pi+/- is
c                           replaced by pi0 in the collision prod.

c          a: /ptcl/ output. container of produced ptcls
c        ntp: integer. output. # of produced ptcls.
        subroutine cgpHad(massN, atomicN, pj, a, ntp)
        implicit none
#include  "Zptcl.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
#include  "Zmass.h"
#include  "Zcode.h"

        integer ntp, icin
        record /ptcl/ pj,  a(*)
        integer  massN, atomicN

        if( pj.fm.p(4) < 2.5 ) then
           call cgpLowExp(pj, massN, atomicN,  a, ntp)
        else
           call cfakeGH(pj, massN, atomicN,  a, ntp)
        endif
        end


      subroutine cgpLowExp(pj, massN, atomicN,  a, ntp)
!          basically Eg < 2.5 GeV.  use exp. data
      implicit none
#include  "Zptcl.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
#include  "Zmass.h"
#include  "Zcode.h"
      record /ptcl/ pj          ! input projectile photon
      integer,intent(in):: massN ! target A
      integer,intent(in):: atomicN ! target Z


      integer,intent(out):: ntp ! # of ptcls produced
      record /ptcl/ a(*)        ! output produced particles


      record /ptcl/pic

      integer ic                ! target N charge
      logical fermim
      record /ptcl/ tgt
      record /ptcl/  pjx
      integer icon
      integer jtype
      integer k

      if( massN >= 2 ) then
c           fix target charge (n or p)
         call cfxTgtChg(massN, atomicN, ic)
      else
         ic=atomicN
      endif
c          make target
      call cmkptc(knuc, regptcl, ic, tgt)
      fermim=(pj.fm.p(4) -pj.mass) .lt. Efermi
     *          .and. massN >= 2
      if(fermim) then
         call csampFermiM(tgt.fm) ! 4 mom. has been  set
c              boost the projectile into target
c              rest system (trs).
         call cbst1(1, tgt, pj,  pjx)
      else
         pjx = pj
c            rest target
         tgt.fm.p(1) = 0.
         tgt.fm.p(2) = 0.
         tgt.fm.p(3) = 0.
         tgt.fm.p(4) = tgt.mass
      endif
c             make cm ptcl
      call  cgeqm(pj, tgt, Cmsp, icon) ! not pjx
      if(icon /= 0  ) then
         write(0,*) ' cms cannot be formed in cgpLowExp'
         stop
      endif
c            fix collision type
      call cghCollType(pjx, jtype)
      if(jtype .eq. 0) then     ! will not happen
         ntp=1                  !   older version  0 and no product
         a(1)=pj                ! gamma 
      elseif(jtype .eq. 1) then
c           gp-->p+pi0 or gn-->n+pi0
c           'a' gets particles at target rest system
         call cg1pi0(pjx, ic, a, ntp)
      elseif(jtype. eq. 2) then
c           gp-->n+pi+ or gn-->p+pi-;  at target rest system
         call cg1pic(pjx, ic,  a, ntp)
      elseif(jtype .eq. 3) then
c           gp-->p pi+ pi- or gn --> n pi+ pi- at  CMS
         call cg2pi(ic,  a, ntp) 
      elseif(jtype .eq. 4) then
c                'a' gets CMS ptcls
         call cg3pi(ic, a, ntp)
      elseif(jtype .eq. 5) then ! will not come in our setting
c               vector meson type.  ptcls produced  in lab.
         call cfakeGH(pj, massN, atomicN, a, ntp)
      else
         write(0,*) ' strage jtype=',jtype, ' from cghCollType'
      endif
      if(fermim .and. jtype .le. 2) then
c            boost ptcls back to lab. 
         do   k=1, ntp
            call cibst1(k, tgt, a(k), a(k))
         enddo
      elseif(jtype .eq.  3 .or. jtype .eq. 4) then
c              now in cms. boost to lab
         do k =1, ntp
            call cibst1(k, Cmsp, a(k), a(k))
         enddo
      else
c          jtype =1 or 2 and fermin=F; then a is already in lab.
      endif
      end
c      ****************************************************************
c         fix g--->hadrons interaction type
c        jtype=1   gp-->p+pi0 or gn-->n+pi0
c   
c        jtype=2   gp-->n+pi+ or gn-->p+pi-
c                
c        jtype=3   gp --> p pi+ pi- pi0 or  gn n pi+pi- pi0
c
c        jtype=4   vector meson collision
c        jtype=5
c        jtype=0  no-production
c      ****************************************************************
      subroutine cghCollType(pj, jtype)
      implicit none
#include  "Zptcl.h"
       record /ptcl/ pj
       integer jtype

       real*8 egl, xs1, xs2, xs3, xs4, xso, xst, u
       real*8 xs
       if(pj.fm.p(4) .lt. 5.) then ! actually come here when < 2.5 GeV
c             log10(Eg/MeV); xs in micro barn
          egl=log10(pj.fm.p(4)) + 3
          call cgppi0(egl, xs1)
          call cgppip(egl, xs2)
          call cgppi2(egl, xs3)
          call cgppi3(egl, xs4)
       else
          xs1=0.
          xs2=0.
          xs3=0.
          xs4=0.
       endif
c            gp total x-section  xs in mb
       call cgpxs1(pj.fm.p(4),   xs)
       xs=xs*1000.              ! in micro barn
       xso=max(0.d0, xs-(xs1+xs2+xs3+xs4) ) ! other channel
       if(pj.fm.p(4) .lt. 2.5) xso=0.
       xst=xs1+xs2+xs3+xs4+xso
       if(xst .gt. 0.) then
          call rndc(u)
          if(u .lt. xs1/xst) then
c              gp-->p+pi0 or gn-->n+pi0
             jtype=1
          elseif(u .lt. (xs1+xs2)/xst) then
c                   gp-->n+pi+ or gn-->p+pi-
             jtype=2
          elseif(u .lt. (xs1+xs2+xs3)/xst) then
c                   gp-->p pi+ pi- or gn --> n pi+ pi-
             jtype=3
          elseif( u .lt.  (xs1+xs2+xs3+xs4)/xst) then
             jtype=4
          else
c                  vector meson collision
             jtype=5
          endif
       else
          jtype=0
       endif
       end
c          gn --> resonance production
       subroutine cg1pi0(pj, ic, a, ntp)
       implicit none
#include  "Zptcl.h"
#include  "Zmass.h"
#include  "Zcode.h"
#include  "Zevhnv.h"

       record /ptcl/ pj, a(*)
       integer ic, ntp
c

        real*8 cs, tmass
        record /ptcl/ eres
        save
c
        tmass=masp
c                   gp-->p+pi0 or gn-->n+pi0; sample cos of pi0 in cms
        call csPiAngOfPiN(Cmsp.mass, 1, 0, cs)
c          resonance energy in trs
        eres.fm.p(1) = 0.
        eres.fm.p(2) = 0.
        eres.fm.p(4) = pj.fm.p(4) + tmass
        eres.mass = Cmsp.mass
        eres.fm.p(3) = sqrt(eres.fm.p(4)**2 - eres.mass**2)
        call cmkptc(kpion, 0, 0, a(1))        
        call cmkptc(knuc, regptcl, ic, a(2))
        call c2bdcp(eres, a(1), cs, a(2))
c        call c2bdcp(Cmsp,  a(1), cs, a(2))
        ntp=2
        end
c       **************
        subroutine cg1pic(pj, ic, a, ntp)
       implicit none
#include  "Zptcl.h"
#include  "Zmass.h"
#include  "Zcode.h"
#include  "Zevhnv.h"

       record /ptcl/ pj, a(*)
       integer ic, ntp
c


        real*8 cs, tmass
        record /ptcl/ eres
        save

c       **************
c                   gp-->n+pi+ or gn-->p+pi-; sample cos of pi in cms
        tmass = masp
        call csPiAngOfPiN(Cmsp.mass, 0, 1, cs)
        eres.fm.p(4)=pj.fm.p(4) + tmass
        eres.mass = Cmsp.mass
        eres.fm.p(3) = sqrt(eres.fm.p(4)**2 - eres.mass**2)
        call cmkptc(kpion, 0, ic, a(1))
        call cmkptc(knuc, regptcl, (1-ic)/2, a(2))
        call c2bdcp(eres, a(1), cs, a(2))
c        call c2bdcp(Cmsp, a(1), cs, a(2))
        ntp=2
        end
c       **************
        subroutine cg2pi(ic, a, ntp)
c       **************
c          particles are produced in cms.
       implicit none
#include  "Zptcl.h"
#include  "Zcode.h"
#include  "Zevhnv.h"

       record /ptcl/ a(*)

       integer ic, ntp

        real*8 w
        integer icon
c                   gp-->p pi+ pi- or gn --> n pi+ pi-
       
       call cmkptc(knuc, regptcl, ic, a(1))
       call cmkptc(kpion, 0, 1, a(2))
       call cmkptc(kpion, 0, -1, a(3))

       call cnbdcy(3, Cmsp.mass, a,  0, w, icon)
       if(icon .eq. 1) then
          write(0, *)
     *    ' cnbdcy fails in gp-->p pi+ pi- ', 
     *    ' roots=',Cmsp.mass, ' icon=',icon
          ntp=0
       else
          ntp=3
       endif
       end
c       **************
       subroutine cg3pi(ic, a, ntp)
       implicit none
#include  "Zptcl.h"
#include  "Zmass.h"
#include  "Zcode.h"
#include  "Zevhnv.h"

       record /ptcl/ a(*)
       integer ic, ntp, icon
       real*8 w
c
c       **************
c                   gp-->p pi+ pi- pi0 or gn-> 3pi
c            in cms.
       call cmkptc(knuc, regptcl, ic, a(1))
       call cmkptc(kpion, 0, -1, a(2))
       call cmkptc(kpion, 0, 0, a(3))
       call cmkptc(kpion, 0, 1, a(4))
       call cnbdcy(4, Cmsp.mass, a,  0, w, icon)
       if(icon .eq. 1) then
           write(0,*) ' cnbdcy fails in gp--> p + 3pi ',
     *     ' roots=',  Cmsp.mass, ' icon=',icon
           ntp=0
       else
c          icon =2 comes here. no problem statistically.
c            few percent cases for mass=1.6 to 3 GeV happens to be icon=2
c            (icon = 2 means rejection after 20 trials due to wight problem)
          ntp=4
       endif
       end
c      ************************************************************
c         neutral  meson collision.
       subroutine cfakeGH(pj, massN, atomicN, a, ntp)
       implicit none
#include  "Zcode.h"
#include  "Zptcl.h"
#include  "Zevhnv.h"
#include  "Zair.h"


       record /ptcl/ pj   ! input. photon
       integer,intent(in):: massN ! target  A
       integer,intent(in):: atomicN ! target Z
       record /ptcl/ a(*)  ! produced ptcls
       integer,intent(out)::ntp  ! # of ptcls produced

c
       record /ptcl/ vm
       integer jcon

       real(8)::u
       real(8)::xs
       integer nout
       integer::pichg
       record /ptcl/ pix

c           make pi+ or -    
       call rndc(u)
       
       pix = pj  

       if(ActiveMdl == "qgsjet2") then
          pichg = 0
          call cmkptc(kpion, 0, 0, pix)  ! can accept pi0
          call cadjm(pix, pix)  ! adjust momenutm
          call cxsecQGS(pix, massN,   xs )  ! not for xs 
!          TargetXs = xs  ??
          call chAcol(pix, massN, atomicN, a, ntp)
       elseif (ActiveMdl /= "ad-hoc" ) then
          if(u < 0.5 ) then
             pichg = -1
          else
             pichg = 1
          endif
          call cmkptc(kpion, 0, pichg, pix)
          call cadjm(pix, pix)
c             some model(JAM) needs xs. for safety get xs 
          call cinelx(pix, massN, atomicN, xs)
          TargetXs = xs
          call chAcol(pix, massN, atomicN, a, ntp)
          call cLeadingPiAfterCol(pix, a, ntp)
       else
          call cmkVectorMeson(pj, vm, jcon)
          if(jcon /= 0) then
             write(0,*) "cmkVectorMeson failed"
             ntp=1
             a(1) = pj
          else
             call chAcol(vm, massN, atomicN, a, ntp)
             call cVecMesonAfterCol(vm, a, ntp, nout)
             ntp = nout
          endif
       endif
       
       end

      subroutine  cmkVectorMeson(pj,  vm, jcon)
      implicit none
#include  "Zptcl.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
#include  "Zmass.h"
#include  "Zcode.h"
      record /ptcl/ pj          ! input. photon
      record /ptcl/ vm          ! output
      integer,intent(out):: jcon !

      real(8):: p, alfa
c         fix vector meson (rho, omega, or phai)
c                              46  46         8 %
      call cfixVectorMeson(pj.fm.p(4), vm, jcon)
c     make vector meson proj.
      p=sqrt(pj.fm.p(4)**2 - vm.mass**2)
      alfa=p/pj.fm.p(4)
      vm.fm.p(1) = pj.fm.p(1)*alfa
      vm.fm.p(2) = pj.fm.p(2)*alfa
      vm.fm.p(3) = pj.fm.p(3)*alfa
      vm.fm.p(4) = pj.fm.p(4)
      end

      subroutine cVecMesonAfterCol(vm, a, nin, nout)
      implicit none
#include  "Zptcl.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
#include  "Zmass.h"
#include  "Zcode.h"
      record /ptcl/ vm          ! input. vector meson
      integer,intent(in):: nin  ! # of ptcls in a
      record /ptcl/ a(nin)      ! ptcls generated by col.
      integer,intent(out)::nout ! after vm treatment, # of ptcls in a
      record /ptcl/ b(10)
      integer i, nx, j
      real(8):: p, alfa
      nout  = nin
      do i = 1, nin
         if( a(i).code == vm.code ) then
#if VECMESDECAY == 1
            call cvmdcy(a(i), b, nx)
            a(i) = b(1)
            do j = 2,  nx
               a(j+nout-1) = b(j)
            enddo
            nout = nout + nx -1
#else
            a(i).code = kphoton
            a(i).mass = 0.
            p=a(i).fm.p(4)
            alfa=sqrt(dot_product( a(i).fm.p(1:3),a(i).fm.p(1:3)))
     *         /p
            a(i).fm.p(1:3) = a(i:3).fm.p(1)/alfa
#endif
         endif
      enddo
      end
      subroutine  cLeadingPiAfterCol(pix, a, ntp)
      implicit none
c         replace max energy pi with same type of pix
c      by pi0
#include  "Zptcl.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
#include  "Zmass.h"
#include  "Zcode.h"
      record /ptcl/ pix
      integer,intent(in):: ntp
      record /ptcl/ a(ntp)
      
      integer i, maxi
      real(8)::maxE
      maxE=-1.0
      maxi =0
      do i = 1, ntp
         if( pix.code == a(i).code ) then
            if( pix.charge == a(i).charge ) then
               if(maxE < a(i).fm.p(4)) then
                  maxE = a(i).fm.p(4)
                  maxi = i
               endif
            endif
         endif
      enddo
      if( maxi > 0 ) then
         call cmkptc(kpion, 0, 0, a(maxi))
         call cadjm(a(maxi),a(maxi))
      endif
      end
c      *****************************************
       subroutine cfixVectorMeson(e, vm, icon)
c      *****************************************
       implicit none

#include  "Zptcl.h"
#include  "Zcode.h"
#include  "Zmass.h"
       real*8 e
       record /ptcl/ vm
       integer icon
c       
       integer nc
       real*8 u, amass, w
c
       nc=0
c         *** until loop*** 
       do while (.true.)
          nc=nc+1
          call rndc(u)
          if(u .lt. .46) then
             call cmkptc(krho, 0, 0, vm)
             w=wrho
          elseif(u .lt. .92) then
             call cmkptc(komega, 0, 0, vm)
             w=womega
          else
             call cmkptc(kphi, 0, 0, vm)
             w=wphai
          endif
c              *** until loop*** 
          do while (.true.)
             call ksbwig(vm.mass, w, amass)
             if (amass .gt. vm.mass-w .and. amass .lt. vm.mass+w)
     *                           goto 10
          enddo
 10       continue
          if(e .le. amass) then
             icon=1
          else
             icon=0
          endif
          if  (icon .eq. 0 .or. nc .gt. 10)
     *                      goto 100
       enddo
       vm.mass = amass
 100   continue
       
       end
c      *****************************************************************
c          make decay of a vector meson
c      *****************************************************************
       subroutine cvmdcy(vm, a, np)
       implicit none
#include  "Zptcl.h"
#include  "Zcode.h"
       record /ptcl/ vm, a(*)
       integer np
c
       if(vm.code .eq. krho) then
          call crhodc(vm, a, np)
       elseif(vm.code .eq. komega) then
          call comgdc(vm, a, np)
       elseif(vm.code .eq. kphi) then
          call cphidc(vm, a, np)
       endif
       end
