cc         test c2lowerCase
c      character*15  cu/'Ab~} C-_De'/
c      character*15  cl/'Xc~+D-_DE'/
c       write(*, *) cu, cl, '/'
c       call c2lowerCase(cu, cl)
c       write(*, *) cu, cl, '/'
c       call c2upperCase(cl, cu)
c       write(*, *) cl, cu, '/'
c       end
      subroutine c2lowerCase(cu, cl)
c       
c        convert [A-Z] in "cu" into [a-z] and put it in "cl"
c        This is for standard ASCII.
c
c    cu: character string. input
c    cl: //              . output.  cl may be cu.
c
c             if cl is shorter than cu, overflowing part
c          is not moved.
c
      implicit none
      character*(*) cu, cl
c
      integer i, ic, imax
c

      imax =  min(len(cu), len(cl))
      do i = 1, imax
         ic = ichar( cu(i:i) )
         if(  ic .ge. 65 .and. ic .le. 90 ) then  ! A-Z
             cl(i:i) = char(ic+32)
         else
             cl(i:i) = cu(i:i)
         endif
      enddo
      end
      subroutine c2upperCase(cl, cu)
c       
c        convert [a-z] in "cl" into [A-Z] and put it in "cu"
c        This is for standard ASCII.
c
c    cl: character string. input
c    cu: //              . output.  cu may be cl.
c
c             if cu is shorter than cl, overflowing part
c          is not moved.
c
      implicit none
      character*(*) cl, cu
c
      integer i, ic, imax
c

      imax =  min(len(cu), len(cl))
      do i = 1, imax
         ic = ichar( cl(i:i) )
         if(  ic .ge. 97 .and. ic .le. 122 ) then  ! a-z
             cu(i:i) = char(ic-32)
         else
             cu(i:i) = cl(i:i)
         endif
      enddo
      end

