
          !---------------------------------------------------------
          !    in URQMD directory replace input.f by empty file
          !---------------------------------------------------------

c----------------------------------------------------------------------------------
c   urqmdinit ... transfer EPOS -> UrQMD
c   urqmdepos ... main uUrQMD routine
c                    essentially copied from urqmdepos (urqmd.f)
c   urqmdexit ... transfer UrQMD -> EPOS
c   file14outx .. analysis, essentially copied from file14out (output.f)
c----------------------------------------------------------------------------------
c modifs of urqmd routines:
c   upmerge.f: 
c      comment the line "write(6,*) '(Info) pdg2ityp: ..."
c----------------------------------------------------------------------------------


c#####################################################################################
c#####################################################################################

                        subroutine urqmdinit

c#####################################################################################
c#####################################################################################

      implicit none

      
      
      !urqmd common block

c     debug and validity range

      integer nmax, nspl
      real*8 hit_sphere
      parameter (nmax = 40000) ! maximum number of particles
      parameter (nspl = 500)  ! dimension of spline arrays
      parameter (hit_sphere = 8.d0)  ! hard collision cutoff: 251 mbarn

      integer Ap, At, Zp, Zt, npart, nbar, nmes, ctag
      integer nsteps,ranseed,event,eos,dectag,uid_cnt
      integer NHardRes,NSoftRes,NDecRes,NElColl,NBlColl
      real*8  time,  acttime, bdist, ebeam, bimp,bmin,ecm
c 7 integer

      common /sys/ npart, nbar, nmes, ctag,nsteps,uid_cnt,
     +             ranseed,event,Ap,At,Zp,Zt,eos,dectag,
     +             NHardRes,NSoftRes,NDecRes,NElColl,NBlColl
      common /rsys/ time,acttime,bdist,bimp,bmin,ebeam,ecm



      real*8 
     +     gw, sgw, delr, fdel, dt,
     +     da, db,
     +     Cb0, Yuk0, Pau0, Sky20, Sky30, gamSky, gamYuk, drPau, dpPau,
     +     dtimestep
c 19 real*8
     
      real*8 cutmax, cutPau, cutCb, cutYuk, cutSky, cutdww
      common /cuts/ cutmax, cutPau, cutCb, cutYuk, cutSky, cutdww

      real*8 spx(nspl), spPauy(nspl), outPau(nspl), 
     +                spCby(nspl),  outCb(nspl),
     +                spYuky(nspl), outYuk(nspl),
     +                spSkyy(nspl), outSky(nspl),
     +                spdwwy(nspl), outdww(nspl)

      common /spdata/ spx, spPauy, outPau, spCby,  outCb,
     +                     spYuky, outYuk, spSkyy, outSky,
     +                     spdwwy, outdww

      real*8 
     +     r0(nmax), rx(nmax), ry(nmax), rz(nmax),
     +     p0(nmax), px(nmax), py(nmax), pz(nmax),
     +     airx(nmax), airy(nmax), airz(nmax),
     +     aipx(nmax), aipy(nmax), aipz(nmax),
     +     aorx(nmax,4), aory(nmax,4), aorz(nmax,4),
     +     aopx(nmax,4), aopy(nmax,4), aopz(nmax,4),
     +     fmass(nmax), rww(nmax), 
     +     dectime(nmax), tform(nmax), xtotfac(nmax)
      
      
      integer spin(nmax),ncoll(nmax),charge(nmax),strid(nmax),
     +        ityp(nmax),lstcoll(nmax),iso3(nmax),origin(nmax),uid(nmax)
      common/isys/spin,ncoll,charge,ityp,lstcoll,iso3,origin,strid,
     +            uid
     
      common /coor/ r0, rx, ry, rz, p0, px, py, pz, fmass, rww, dectime
      common /frag/ tform, xtotfac


      common /aios/ airx, airy, airz, aipx, aipy, aipz,
     +              aorx, aory, aorz, aopx, aopy, aopz

      common /pots/ Cb0, Yuk0, Pau0, Sky20, Sky30, gamSky, 
     +              gamYuk, drPau, dpPau, gw, sgw, delr, fdel,
     +              dt,da, db,dtimestep


c spectator arrays
	integer smax
	parameter(smax=500)  ! maximum number of spectators
	real*8 r0s(smax), rxs(smax), rys(smax), rzs(smax),
     +	       p0s(smax), pxs(smax), pys(smax), pzs(smax),
     +	       sfmass(smax)
	

        integer sspin(smax), scharge(smax), sityp(smax), siso3(smax),
     +          suid(smax)

	integer nspec

	common /scoor/ r0s, rxs, rys, rzs, p0s, pxs ,pys, pzs, sfmass

	common /sisys/ sspin, scharge, sityp, siso3, suid

	common /ssys/ nspec


        real*8 p0td(2,nmax),pxtd(2,nmax),pytd(2,nmax),pztd(2,nmax),
     +         fmasstd(2,nmax)
        integer ityptd(2,nmax),iso3td(2,nmax)
        integer itypt(2),uidt(2),origint(2),iso3t(2)

        common /rtdelay/p0td,pxtd,pytd,pztd,fmasstd
        common /itdelay/ityptd,iso3td
        common /svinfo/itypt,uidt,origint,iso3t
        real*8 ffermpx(nmax), ffermpy(nmax), ffermpz(nmax)
        real*8 peq1, peq2
        common /ffermi/ ffermpx, ffermpy, ffermpz
        common /peq/ peq1,peq2
        
	
	integer numcto,numctp,maxstables
        parameter(numcto=400) ! maximum number of options
        parameter(numctp=400) ! maximum number of parameters
        parameter(maxstables=20) ! maximum number of stable particles
	integer   CTOption(numcto)
	real*8    CTParam(numctp)
        common /options/CTOption,CTParam
	
	real*8 frr0(nmax), frrx(nmax), frry(nmax), frrz(nmax),
     +     frp0(nmax), frpx(nmax), frpy(nmax), frpz(nmax)

      common /frcoor/ frr0, frrx, frry, frrz, frp0, frpx, frpy, frpz 
	      integer maxbar,maxbra,minbar
      integer offmeson,maxmeson,pimeson,maxbrm,minnuc,mindel
      integer maxbrs1,maxbrs2
      integer numnuc,numdel,nucleon,maxnuc,maxdel
      integer minmes,maxmes


      parameter (minnuc=1) ! lowest baryon particle ID 
      parameter (minmes=100) ! lowest meson particle ID
      parameter (maxmes=132) ! hightest meson particle ID

c number of resonances of a kind
      parameter (numnuc=16) ! number of nucleon resonances
      parameter (numdel=10) ! number of delta resonances
c indices of minimal and maximal itype of a kind (redundant but nice)
      parameter (maxnuc=minnuc+numnuc-1) ! highest nucleon ID
      parameter (mindel=minnuc+maxnuc)   ! lowest delta ID
      parameter (maxdel=mindel+numdel-1) ! highest delta ID

c minres & maxres define the range of nonstable & nonstrange baryons
      integer minres,maxres
      parameter (minres=minnuc+1) ! lowest baryon resonance ID
      parameter (maxres=maxdel)   ! highest (nonstrange) baryon 
                                  ! resonance ID

c strangenes.ne.0 baryon resonances
      integer minlam,minsig,mincas,minome
      integer numlam,numsig,numcas,numome
      integer maxlam,maxsig,maxcas,maxome
      parameter (numlam=13) ! number of lambda states
      parameter (numsig=9)  ! number of sigma states
      parameter (numcas=6)  ! number of cascade states
      parameter (numome=1)  ! number of omega states
      parameter (minlam=mindel+numdel)   ! ID of lowest lambda state
      parameter (maxlam=minlam+numlam-1) ! ID of highest lambda state
      parameter (minsig=minlam+numlam)   ! ID of lowest sigma state
      parameter (maxsig=minsig+numsig-1) ! ID of highest sigma state
      parameter (mincas=minsig+numsig)   ! ID of lowest cascade state
      parameter (maxcas=mincas+numcas-1) ! ID of highest cascade state
      parameter (minome=mincas+numcas)   ! ID of lowest omega state
      parameter (maxome=minome+numome-1) ! ID of highest omega state

c minbar & maxbar define the range of all baryons
      parameter (minbar=minnuc) ! ID of lowest baryon state
      parameter (maxbar=maxome) ! ID of highest baryon state

      parameter (offmeson=minmes) ! offset between zero and lowest 
                                  ! meson state
      parameter (maxmeson=maxmes) ! ID of highest meson state
c... these variables are in principal obsolete and should be exchanged 
c were referenced 

c... avoid hard coded itypes
      integer itrho,itome,iteta,itkaon,itphi,itetapr
      parameter (itkaon=106)   ! ID of kaon
      parameter (itrho=104)    ! ID of rho meson 
      parameter (itome=103)    ! ID of omega meson
      parameter (iteta=102)    ! ID of eta
      parameter (itphi=109)    ! ID of phi
      parameter (itetapr=107)  ! ID of eta'
      parameter (pimeson=101)  ! ID of $\pi$
      parameter (nucleon=minnuc) ! ID of nucleon

      integer itmin,itmax
      parameter (itmin=minnuc)  ! lowest defined ID
      parameter (itmax=maxmes)  ! highest defined ID
c
      parameter (maxbra=11)  ! decay channels for $s=0$ baryon resonances
      parameter (maxbrm=25) ! decay channels for meson resonances
      parameter (maxbrs1=10)! decay channels for $s=1$ baryon resonances
      parameter (maxbrs2=3) ! decay channels for $s=2$ baryon resonances

c 
       integer mlt2it(maxmes-minmes) ! meson IDs sorted by multipletts


      real*8 massoff,mresmin,mresmax
      parameter (massoff=1d-4)      ! offset for mass generation
      parameter (mresmin=1.0765d0)  ! minimum baryon resonance mass
      parameter (mresmax=5d0)       ! maximum baryon resonance mass

      character*45 versiontag
      common /versioning/ versiontag

      real*8 massres(minbar:maxbar),widres(minbar:maxbar)
      real*8 branmes(0:maxbrm,minmes+1:maxmes)
      real*8 branres(0:maxbra,minnuc+1:maxdel)
      real*8 branbs1(0:maxbrs1,minlam+1:maxsig)
      real*8 branbs2(0:maxbrs2,mincas+1:maxcas)
      integer Jres(minbar:maxbar)
      integer Jmes(minmes:maxmes)
      integer pares(minbar:maxbar),pames(minmes:maxmes)
      integer Isores(minbar:maxbar), Isomes(minmes:maxmes)
      integer brtype(4,0:maxbra),bmtype(4,0:maxbrm)
      integer bs1type(4,0:maxbrs1),bs2type(4,0:maxbrs2)
      real*8 massmes(minmes:maxmes)
      real*8 mmesmn(minmes:maxmes)
      real*8 widmes(minmes:maxmes)
      integer strres(minbar:maxbar),strmes(minmes:maxmes)

      integer lbr(0:maxbra,minnuc+1:maxdel)
      integer lbs1(0:maxbrs1,minlam+1:maxsig)
      integer lbs2(0:maxbrs2,mincas+1:maxcas)
      integer lbm(0:maxbrm,minmes+1:maxmes)

      common /resonances/ massres,widres,massmes,widmes,mmesmn,
     ,                    branres,branmes,branbs1,branbs2,
     ,                    bs1type,bs2type,lbs1,lbs2,lbm,
     ,                    jres,jmes,lbr,brtype,pares,pames,
     ,                    bmtype,
     ,                    Isores,Isomes,strres,strmes,mlt2it
     
     
     
     
     
 
      !----------------------------------------------------------------------------     
      !epos common blocks for particle list
      !----------------------------------------------------------------------------     

      integer iappl,model,nptlpt     
      common/appli/iappl,model
      
      integer mmry,mxptl
      parameter (mmry=1)   !memory saving factor
      parameter (mxptl=200000/mmry) !max nr of particles in epos ptl list

      integer iorptl(mxptl),idptl(mxptl),istptl(mxptl),
     *  ifrptl(2,mxptl),jorptl(mxptl),ibptl(4,mxptl),ityptl(mxptl)
      real pptl(5,mxptl),tivptl(2,mxptl),xorptl(4,mxptl)

      common/cptl/nptl,pptl,iorptl,idptl
     *,istptl,tivptl,ifrptl,jorptl
     *,xorptl,ibptl,ityptl
   
      integer nptl
   
      integer nevt,kolevt,koievt,npjevt,ntgevt,npnevt,nppevt,
     *        ntnevt,ntpevt,jpnevt,jppevt,jtnevt,jtpevt,
     *        nglevt,minfra,maxfra
      real phievt,bimevt,pmxevt,egyevt,xbjevt,qsqevt,zppevt,zptevt
   
      common/cevt/phievt,nevt,bimevt,kolevt,koievt,pmxevt,egyevt,npjevt
     *,ntgevt,npnevt,nppevt,ntnevt,ntpevt,jpnevt,jppevt,jtnevt,jtpevt
     *,xbjevt,qsqevt,nglevt,zppevt,zptevt,minfra,maxfra

      integer laproj,maproj,latarg,matarg,nptlbd
      real core,fctrmx
      common/nucl1/laproj,maproj,latarg,matarg,core,fctrmx
      common/c4ptl/nptlbd
      
      integer istore,istmax,irescl,ntrymx,nclean,iopdg,ioidch
      real gaumx
      common/othe1/istore,istmax,gaumx,irescl,ntrymx,nclean,iopdg,ioidch
      !-----------------------------------------------------------------------------     
      
      integer i,nn,idtmp,ityptmp,iso3tmp,itmp
      


      integer idtrafo
      external idtrafo
      integer fchg
      external fchg
      real*8 dectim
      external dectim

      real*8 mintime,eb
      integer j,k,icount,npold
      integer strcount
      common /inewpartxx/ strcount
      real*8 etot
      integer nui
      data nui/0/
      save nui
      nui=nui+1
      if(nui.eq.1)write(6,'(a,50a1)')' (info)',('u',i=1,50)
       
      call uinit(0)
      call osc_header
      call osc99_header

      npart = 0
      npold = 0
      nbar=0
      nmes=0
      uid_cnt=0
c reset counters
c     all collisions/decays
      ctag  = 0
c     all decays
      dectag = 0
c     number of prod. hard resonances
      NHardRes=0
c     number of prod. soft resonances
      NSoftRes=0
c     number of prod. resonances via decay
      NDecRes=0
c     number of blocked collisions
      NBlColl=0
c     number of elastic collisions
      NElColl=0
c     number of strings
      strcount=1
c
      eb=0D0
c icount is the number of EXTRAordinary pro/tar combinations (i.e. pion ...)
      icount = 0
c reset particle vectors
      do 20 j=1,nmax
	spin(j)  = 0
	ncoll(j) = 0
	lstcoll(j)=0
	r0(j) = 0.0
	rx(j)	 = 0.0
	ry(j)	 = 0.0
	rz(j)	 = 0.0
	p0(j)	 = 0.0
	px(j)	 = 0.0
	py(j)	 = 0.0
	pz(j)	 = 0.0
	frr0(j) = 0.0
	frrx(j)    = 0.0
	frry(j)    = 0.0
	frrz(j)    = 0.0
	frp0(j)    = 0.0
	frpx(j)    = 0.0
	frpy(j)    = 0.0
	frpz(j)    = 0.0
	fmass(j) = 0.0
	charge(j)= 0
	iso3(j)  = 0
	ityp(j)  = 0
	dectime(j)= 0.0
	origin(j)=0
	tform(j)=0.0
	xtotfac(j)=1.0
	strid(j)=0
	uid(j)=0
	 ffermpx(j) = 0.0
	 ffermpy(j) = 0.0
	 ffermpz(j) = 0.0

	 do 21 k=1,2
	    p0td(k,j)=0.d0
	    pxtd(k,j)=0.d0
	    pytd(k,j)=0.d0
	    pztd(k,j)=0.d0
	    fmasstd(k,j)=0.d0
	    ityptd(k,j)=0
	   iso3td(k,j)=0
 21	 continue
 20   continue


c epos event info to urqmd event info      
      bimp = bimevt
      
c initialise
      npart=0  !number of particles transferred to urqmd
      mintime = 1d2 !the minimum formation time

c proj/targ
      nptlpt=maproj+matarg
      if(iappl.eq.9)nptlpt=0

c energy of spectators
      etot=0 
      do nn=1,nptlpt      
        if(istptl(nn).eq.0)etot=etot+pptl(4,nn)
      enddo

c keep special objects in epos ptl list  
      nptl=0
      do nn=1,nptlbd       
        if(nn.le.nptlpt
     .  .or.istptl(nn).gt.10.and.ityptl(nn).eq.60  )then
          nptl=nptl+1
          if(nptl.lt.nn)call utrepl(nptl,nn)
        endif
      enddo
      
c fill in the baryons first     
      nbar = 0
      do nn=nptlpt+1,nptlbd       
        if(istptl(nn).eq.0)then
           idtmp=idtrafo('nxs','pdg',idptl(nn))
           call pdg2id(ityptmp,iso3tmp,idtmp)
           if(abs(ityptmp).le.maxbar) then
               etot=etot+pptl(4,nn)
               nbar=nbar+1
               r0(nbar)=xorptl(4,nn)
               rx(nbar)=xorptl(1,nn)
               ry(nbar)=xorptl(2,nn)
               rz(nbar)=xorptl(3,nn)
               p0(nbar)=pptl(4,nn)
               px(nbar)=pptl(1,nn)
               py(nbar)=pptl(2,nn)
               pz(nbar)=pptl(3,nn)
               fmass(nbar)=pptl(5,nn)
               ityp(nbar)=ityptmp
               iso3(nbar)=iso3tmp
               charge(nbar)=fchg(iso3(nbar),ityp(nbar))
               lstcoll(nbar)=0
               ncoll(nbar)=0
               origin(nbar)=0
               tform(nbar)=r0(nbar)
               dectime(nbar)=dectim(nbar,1)+tform(nbar)
               xtotfac(nbar)=0d0
               if(r0(nbar).lt.mintime) mintime = r0(nbar)
           endif
        endif
      enddo

c then fill in the mesons
      nmes = 0
      do nn=nptlpt+1,nptlbd
        if(istptl(nn).eq.0)then
           idtmp=idtrafo('nxs','pdg',idptl(nn))
           call pdg2id(ityptmp,iso3tmp,idtmp)
           if(abs(ityptmp).ge.minmes) then
               nmes=nmes+1
               etot=etot+pptl(4,nn)
               itmp=nbar+nmes
               r0(itmp)=xorptl(4,nn)
               rx(itmp)=xorptl(1,nn)
               ry(itmp)=xorptl(2,nn)
               rz(itmp)=xorptl(3,nn)
               p0(itmp)=pptl(4,nn)
               px(itmp)=pptl(1,nn)
               py(itmp)=pptl(2,nn)
               pz(itmp)=pptl(3,nn)
               fmass(itmp)=pptl(5,nn)
               ityp(itmp)=ityptmp
               iso3(itmp)=iso3tmp
               charge(itmp)=fchg(iso3(itmp),ityp(itmp))
               lstcoll(itmp)=0
               ncoll(itmp)=0
               origin(itmp)=0
               tform(itmp)=r0(itmp)
               dectime(itmp)=dectim(itmp,1)+tform(itmp)
               xtotfac(itmp)=0d0
               if(r0(itmp).lt.mintime) mintime = r0(itmp)
           endif
        endif
      enddo
      !print*,'+++++ etot/eini=',etot/(197*200.)

      npart = nbar + nmes

      if(npart.eq.0)stop
     . '\n \n    ***** STOP in urqmdepos: no particles (1) *****  \n\n'

c back to the same starting time
      do i = 1, npart
         !save freeze-out configuration, in case of no further
         !rescatterings
         frr0(i) = r0(i)
         frrx(i) = rx(i)
         frry(i) = ry(i)
         frrz(i) = rz(i)
         frp0(i) = p0(i)
         frpx(i) = px(i)
         frpy(i) = py(i)
         frpz(i) = pz(i)
         rx(i)=rx(i)-px(i)/p0(i)*(r0(i)-mintime)
         ry(i)=ry(i)-py(i)/p0(i)*(r0(i)-mintime)
         rz(i)=rz(i)-pz(i)/p0(i)*(r0(i)-mintime)
         r0(i)=mintime
      enddo
      
      acttime=mintime

c      write(*,*)'DEBUG INFO (epos.f): ',mintime,npart,istmax,nbar,nmes

      if(nui.eq.1)write(6,'(a,50a1)')' (info)',('u',i=1,50)
      return
      end


c#####################################################################################
c#####################################################################################

                        subroutine urqmdexit

c#####################################################################################
c#####################################################################################

c----------------------------------------------------------------------------------
c  transfer UrQMD -> EPOS
c----------------------------------------------------------------------------------

      implicit none


!urqmd common block

c     debug and validity range

      integer nmax, nspl
      real*8 hit_sphere
      parameter (nmax = 40000) ! maximum number of particles
      parameter (nspl = 500)  ! dimension of spline arrays
      parameter (hit_sphere = 8.d0)  ! hard collision cutoff: 251 mbarn

      integer Ap, At, Zp, Zt, npart, nbar, nmes, ctag
      integer nsteps,ranseed,event,eos,dectag,uid_cnt
      integer NHardRes,NSoftRes,NDecRes,NElColl,NBlColl
      real*8  time,  acttime, bdist, ebeam, bimp,bmin,ecm
c 7 integer

      common /sys/ npart, nbar, nmes, ctag,nsteps,uid_cnt,
     +             ranseed,event,Ap,At,Zp,Zt,eos,dectag,
     +             NHardRes,NSoftRes,NDecRes,NElColl,NBlColl
      common /rsys/ time,acttime,bdist,bimp,bmin,ebeam,ecm



      real*8 
     +     gw, sgw, delr, fdel, dt,
     +     da, db,
     +     Cb0, Yuk0, Pau0, Sky20, Sky30, gamSky, gamYuk, drPau, dpPau,
     +     dtimestep
c 19 real*8
     
      real*8 cutmax, cutPau, cutCb, cutYuk, cutSky, cutdww
      common /cuts/ cutmax, cutPau, cutCb, cutYuk, cutSky, cutdww

      real*8 spx(nspl), spPauy(nspl), outPau(nspl), 
     +                spCby(nspl),  outCb(nspl),
     +                spYuky(nspl), outYuk(nspl),
     +                spSkyy(nspl), outSky(nspl),
     +                spdwwy(nspl), outdww(nspl)

      common /spdata/ spx, spPauy, outPau, spCby,  outCb,
     +                     spYuky, outYuk, spSkyy, outSky,
     +                     spdwwy, outdww

      real*8 
     +     r0(nmax), rx(nmax), ry(nmax), rz(nmax),
     +     p0(nmax), px(nmax), py(nmax), pz(nmax),
     +     airx(nmax), airy(nmax), airz(nmax),
     +     aipx(nmax), aipy(nmax), aipz(nmax),
     +     aorx(nmax,4), aory(nmax,4), aorz(nmax,4),
     +     aopx(nmax,4), aopy(nmax,4), aopz(nmax,4),
     +     fmass(nmax), rww(nmax), 
     +     dectime(nmax), tform(nmax), xtotfac(nmax)
      
      
      integer spin(nmax),ncoll(nmax),charge(nmax),strid(nmax),
     +        ityp(nmax),lstcoll(nmax),iso3(nmax),origin(nmax),uid(nmax)
      common/isys/spin,ncoll,charge,ityp,lstcoll,iso3,origin,strid,
     +            uid
     
      common /coor/ r0, rx, ry, rz, p0, px, py, pz, fmass, rww, dectime
      common /frag/ tform, xtotfac


      common /aios/ airx, airy, airz, aipx, aipy, aipz,
     +              aorx, aory, aorz, aopx, aopy, aopz

      common /pots/ Cb0, Yuk0, Pau0, Sky20, Sky30, gamSky, 
     +              gamYuk, drPau, dpPau, gw, sgw, delr, fdel,
     +              dt,da, db,dtimestep


c spectator arrays
	integer smax
	parameter(smax=500)  ! maximum number of spectators
	real*8 r0s(smax), rxs(smax), rys(smax), rzs(smax),
     +	       p0s(smax), pxs(smax), pys(smax), pzs(smax),
     +	       sfmass(smax)
	

        integer sspin(smax), scharge(smax), sityp(smax), siso3(smax),
     +          suid(smax)

	integer nspec

	common /scoor/ r0s, rxs, rys, rzs, p0s, pxs ,pys, pzs, sfmass

	common /sisys/ sspin, scharge, sityp, siso3, suid

	common /ssys/ nspec


        real*8 p0td(2,nmax),pxtd(2,nmax),pytd(2,nmax),pztd(2,nmax),
     +         fmasstd(2,nmax)
        integer ityptd(2,nmax),iso3td(2,nmax)
        integer itypt(2),uidt(2),origint(2),iso3t(2)

        common /rtdelay/p0td,pxtd,pytd,pztd,fmasstd
        common /itdelay/ityptd,iso3td
        common /svinfo/itypt,uidt,origint,iso3t
        real*8 ffermpx(nmax), ffermpy(nmax), ffermpz(nmax)
        real*8 peq1, peq2
        common /ffermi/ ffermpx, ffermpy, ffermpz
        common /peq/ peq1,peq2
        
	
	integer numcto,numctp,maxstables
        parameter(numcto=400) ! maximum number of options
        parameter(numctp=400) ! maximum number of parameters
        parameter(maxstables=20) ! maximum number of stable particles
	integer   CTOption(numcto)
	real*8    CTParam(numctp)
        common /options/CTOption,CTParam
	
	real*8 frr0(nmax), frrx(nmax), frry(nmax), frrz(nmax),
     +     frp0(nmax), frpx(nmax), frpy(nmax), frpz(nmax)

      common /frcoor/ frr0, frrx, frry, frrz, frp0, frpx, frpy, frpz 
	      integer maxbar,maxbra,minbar
      integer offmeson,maxmeson,pimeson,maxbrm,minnuc,mindel
      integer maxbrs1,maxbrs2
      integer numnuc,numdel,nucleon,maxnuc,maxdel
      integer minmes,maxmes


      parameter (minnuc=1) ! lowest baryon particle ID 
      parameter (minmes=100) ! lowest meson particle ID
      parameter (maxmes=132) ! hightest meson particle ID

c number of resonances of a kind
      parameter (numnuc=16) ! number of nucleon resonances
      parameter (numdel=10) ! number of delta resonances
c indices of minimal and maximal itype of a kind (redundant but nice)
      parameter (maxnuc=minnuc+numnuc-1) ! highest nucleon ID
      parameter (mindel=minnuc+maxnuc)   ! lowest delta ID
      parameter (maxdel=mindel+numdel-1) ! highest delta ID

c minres & maxres define the range of nonstable & nonstrange baryons
      integer minres,maxres
      parameter (minres=minnuc+1) ! lowest baryon resonance ID
      parameter (maxres=maxdel)   ! highest (nonstrange) baryon 
                                  ! resonance ID

c strangenes.ne.0 baryon resonances
      integer minlam,minsig,mincas,minome
      integer numlam,numsig,numcas,numome
      integer maxlam,maxsig,maxcas,maxome
      parameter (numlam=13) ! number of lambda states
      parameter (numsig=9)  ! number of sigma states
      parameter (numcas=6)  ! number of cascade states
      parameter (numome=1)  ! number of omega states
      parameter (minlam=mindel+numdel)   ! ID of lowest lambda state
      parameter (maxlam=minlam+numlam-1) ! ID of highest lambda state
      parameter (minsig=minlam+numlam)   ! ID of lowest sigma state
      parameter (maxsig=minsig+numsig-1) ! ID of highest sigma state
      parameter (mincas=minsig+numsig)   ! ID of lowest cascade state
      parameter (maxcas=mincas+numcas-1) ! ID of highest cascade state
      parameter (minome=mincas+numcas)   ! ID of lowest omega state
      parameter (maxome=minome+numome-1) ! ID of highest omega state

c minbar & maxbar define the range of all baryons
      parameter (minbar=minnuc) ! ID of lowest baryon state
      parameter (maxbar=maxome) ! ID of highest baryon state

      parameter (offmeson=minmes) ! offset between zero and lowest 
                                  ! meson state
      parameter (maxmeson=maxmes) ! ID of highest meson state
c... these variables are in principal obsolete and should be exchanged 
c were referenced 

c... avoid hard coded itypes
      integer itrho,itome,iteta,itkaon,itphi,itetapr
      parameter (itkaon=106)   ! ID of kaon
      parameter (itrho=104)    ! ID of rho meson 
      parameter (itome=103)    ! ID of omega meson
      parameter (iteta=102)    ! ID of eta
      parameter (itphi=109)    ! ID of phi
      parameter (itetapr=107)  ! ID of eta'
      parameter (pimeson=101)  ! ID of $\pi$
      parameter (nucleon=minnuc) ! ID of nucleon

      integer itmin,itmax
      parameter (itmin=minnuc)  ! lowest defined ID
      parameter (itmax=maxmes)  ! highest defined ID
c
      parameter (maxbra=11)  ! decay channels for $s=0$ baryon resonances
      parameter (maxbrm=25) ! decay channels for meson resonances
      parameter (maxbrs1=10)! decay channels for $s=1$ baryon resonances
      parameter (maxbrs2=3) ! decay channels for $s=2$ baryon resonances

c 
       integer mlt2it(maxmes-minmes) ! meson IDs sorted by multipletts


      real*8 massoff,mresmin,mresmax
      parameter (massoff=1d-4)      ! offset for mass generation
      parameter (mresmin=1.0765d0)  ! minimum baryon resonance mass
      parameter (mresmax=5d0)       ! maximum baryon resonance mass

      character*45 versiontag
      common /versioning/ versiontag

      real*8 massres(minbar:maxbar),widres(minbar:maxbar)
      real*8 branmes(0:maxbrm,minmes+1:maxmes)
      real*8 branres(0:maxbra,minnuc+1:maxdel)
      real*8 branbs1(0:maxbrs1,minlam+1:maxsig)
      real*8 branbs2(0:maxbrs2,mincas+1:maxcas)
      integer Jres(minbar:maxbar)
      integer Jmes(minmes:maxmes)
      integer pares(minbar:maxbar),pames(minmes:maxmes)
      integer Isores(minbar:maxbar), Isomes(minmes:maxmes)
      integer brtype(4,0:maxbra),bmtype(4,0:maxbrm)
      integer bs1type(4,0:maxbrs1),bs2type(4,0:maxbrs2)
      real*8 massmes(minmes:maxmes)
      real*8 mmesmn(minmes:maxmes)
      real*8 widmes(minmes:maxmes)
      integer strres(minbar:maxbar),strmes(minmes:maxmes)

      integer lbr(0:maxbra,minnuc+1:maxdel)
      integer lbs1(0:maxbrs1,minlam+1:maxsig)
      integer lbs2(0:maxbrs2,mincas+1:maxcas)
      integer lbm(0:maxbrm,minmes+1:maxmes)

      common /resonances/ massres,widres,massmes,widmes,mmesmn,
     ,                    branres,branmes,branbs1,branbs2,
     ,                    bs1type,bs2type,lbs1,lbs2,lbm,
     ,                    jres,jmes,lbr,brtype,pares,pames,
     ,                    bmtype,
     ,                    Isores,Isomes,strres,strmes,mlt2it

      
      !epos common blocks for particle list
      integer mmry,mxptl
      parameter (mmry=1)   !memory saving factor
      parameter (mxptl=200000/mmry) !max nr of particles in epos ptl list

      integer iorptl(mxptl),idptl(mxptl),istptl(mxptl),
     *  ifrptl(2,mxptl),jorptl(mxptl),ibptl(4,mxptl),ityptl(mxptl)
      real pptl(5,mxptl),tivptl(2,mxptl),xorptl(4,mxptl)

      common/cptl/nptl,pptl,iorptl,idptl
     *,istptl,tivptl,ifrptl,jorptl
     *,xorptl,ibptl,ityptl
     
      integer inbxxx
      real rinptl(mxptl),vrad
      common/c6ptl/rinptl,vrad,inbxxx
      
      integer nptl
      
      
      integer nevt,kolevt,koievt,npjevt,ntgevt,npnevt,nppevt,
     *        ntnevt,ntpevt,jpnevt,jppevt,jtnevt,jtpevt,
     *        nglevt,minfra,maxfra
      real phievt,bimevt,pmxevt,egyevt,xbjevt,qsqevt,zppevt,zptevt
      
      common/cevt/phievt,nevt,bimevt,kolevt,koievt,pmxevt,egyevt,npjevt
     *,ntgevt,npnevt,nppevt,ntnevt,ntpevt,jpnevt,jppevt,jtnevt,jtpevt
     *,xbjevt,qsqevt,nglevt,zppevt,zptevt,minfra,maxfra
      
      integer istore,istmax,irescl,ntrymx,nclean,iopdg,ioidch
      real gaumx
      common/othe1/istore,istmax,gaumx,irescl,ntrymx,nclean,iopdg,ioidch
      
      integer nn,idpdgg,idepos  ,nptlep
      


      integer idtrafo
      external idtrafo
      integer fchg
      external fchg
      integer pdgid
      external pdgid
      real*8 dectim
      external dectim

      nptlep=nptl
      do nn=1,npart  
	   idpdgg=pdgid(ityp(nn),iso3(nn))
           idepos=idtrafo('pdg','nxs',idpdgg)
              
	       nptl=nptl+1
               
               iorptl(nptl)=0
               jorptl(nptl)=0
               istptl(nptl)=0
               xorptl(4,nptl)= r0(nn)
               xorptl(1,nptl)=rx(nn)
               xorptl(2,nptl)=ry(nn)
               xorptl(3,nptl)=rz(nn)
               pptl(4,nptl)= p0(nn)
               pptl(1,nptl)=px(nn)
               pptl(2,nptl)=py(nn)
               pptl(3,nptl)=pz(nn)
               pptl(5,nptl)=fmass(nn)
               idptl(nptl)=idepos
               istptl(nptl)=0
               ityptl(nptl)=0
               rinptl(nptl)=-9999
                                  
      enddo
      
      end

c####################################################################################
c####################################################################################

                     subroutine  urqmdepos

c####################################################################################
c####################################################################################

c----------------------------------------------------------------------------------
c   main urqmd modul, essentially copied from urqmdepos (urqmd.f)
c----------------------------------------------------------------------------------

      implicit none
      include '../urqmd23/coms.f'
      include '../urqmd23/comres.f'
      include '../urqmd23/options.f'
      include '../urqmd23/colltab.f'
      include '../urqmd23/inputs.f'
      include '../urqmd23/newpart.f'
      include '../urqmd23/boxinc.f'
      integer i,j,k,steps,ii,ocharge,ncharge, mc, mp, noc, it1,it2
      real*8 sqrts,otime,xdummy,st
      logical isstable
      integer stidx
      real*8 Ekinbar, Ekinmes, ESky2, ESky3, EYuk, ECb, EPau
      common /energies/ Ekinbar, Ekinmes, ESky2, ESky3, EYuk, ECb, EPau
      integer cti1sav,cti2sav
      integer nuj
      data nuj/0/
      save nuj
      nuj=nuj+1

      mc=0
      mp=0
      noc=0

      time = 0.0  !time is the system time at the BEGINNING of every timestep

      !initialize random number generator
      !call auto-seed generator only for first event and if no seed was fixed
      if(.not.firstseed.and.(.not.fixedseed)) then
         ranseed=-(1*abs(ranseed))
         call sseed(ranseed)
      else
         firstseed=.false.
      endif

      !old time if an old fort.14 is used 
      if(CTOption(40).eq.1)time=acttime
      if(CTOption(40).eq.3)time=acttime

      !write headers to file
      call output(13)
      !call output(14)
      call output(15)
      call output(16)
      !if(event.eq.1)call output(17)
      call osc99_event(-1)

      !for CTOption(4)=1 : output of initialization configuration
      if(CTOption(4).eq.1)call file14out(0)
      !participant/spectator model:
      if(CTOption(28).ne.0) call rmspec(0.5d0*bimp,-(0.5d0*bimp))

      otime = outsteps*dtimestep  !compute time of output

      steps = 0  !reset time step counter

  !~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  ! loop over all timesteps
  !~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  
      do 20  steps=1,nsteps  

         if (eos.ne.0) then
           do j=1,npart
               r0_t(j) = r0(j)
               rx_t(j) = rx(j)
               ry_t(j) = ry(j)
               rz_t(j) = rz(j)
           enddo
         end if

         !we are at the beginning of the timestep, set current time (acttime)
         acttime = time

         if(CTOption(16).ne.0) goto 103  !option for MD without collision term

         call colload  ! Load collision table with next collisions in current timestep

         ! check for collisions in time-step, nct = # of collisions in table
         if (nct.gt.0) then
 101        continue              !entry-point for collision loop in case  
            k = 0                 !      of full colload after every coll
 100        continue              !normal entry-point for collision loop 
            call getnext(k)       !get next collision
            if (k.eq.0) goto 102  !exit collision loop if no collisions are left

            !propagate all particles to next collision time
            !store actual time in acttime, propagation time st=cttime(k)-acttime
	    st=cttime(k)-acttime
            call cascstep(acttime,st)
            acttime = cttime(k)   !new actual time (for upcoming collision)

            !perform collision 

            if(cti2(k).gt.0.and.
     .           abs(sqrts(cti1(k),cti2(k))-ctsqrts(k)).gt.1d-3)then
               write(6,*)' ***(E) wrong collision update (col) ***'
               write(6,*)cti1(k),cti2(k),
     .              ctsqrts(k),sqrts(cti1(k),cti2(k))
            else if(cti2(k).eq.0.and.
     .              abs(fmass(cti1(k))-ctsqrts(k)).gt.1d-3) then
               write(6,*)' *** main(W) wrong collision update (decay)'
               write(6,*)ctag,cti1(k),ityp(cti1(k)),dectime(cti1(k)),
     .              fmass(cti1(k)),ctsqrts(k)
            endif

            ocharge=charge(cti1(k))
            if(cti2(k).gt.0) ocharge=ocharge+charge(cti2(k))

            !store quantities in local variables for charge conservation check
            it1= ityp(cti1(k))
            if(cti2(k).gt.0)it2= ityp(cti2(k))

            !increment "dirty" collision counter
            if(cti2(k).gt.0)then !scatter
               mc=mc+1
            endif
            !perform scattering/decay
            cti1sav = cti1(k)                       
            cti2sav = cti2(k)    
            call scatter(cti1(k),cti2(k),ctsigtot(k),ctsqrts(k),
     &                   ctcolfluc(k))

            !update collision table 

            !normal update mode
            if(CTOption(17).eq.0) then
               if(nexit.eq.0) then
                 !new collision partners for pauli-blocked states (nexit=0)
                 if (cti1(k).ne.cti1sav.or.cti2(k).ne.cti2sav) then
                   cti1(k) = cti1sav 
                   cti2(k) = cti2sav 
                 endif

                 call collupd(cti1(k),1)
                 if(cti2(k).gt.0) call collupd(cti2(k),1)
               else
                 ncharge=0
                 !new collision partners for scattered/produced particles (nexit><0)
                 do i=1,nexit
                   !ncharge is used for charge conservation check
                   ncharge=ncharge+charge(inew(i))
                   call collupd(inew(i),1)
                 enddo
               endif
               !update collisions for partners of annihilated particles
               do ii=1,nsav
                  call collupd(ctsav(ii),1)
               enddo
               nsav=0
            else ! (CTOption(17).ne.0)
              !full collision load
              call colload
            endif

            if (CTOption(17).eq.0) goto 100
            goto 101

            !this is the point to jump to after all collisions in the timestep
            !have been taken care of
 102        continue

         endif ! (nct.gt.0)


         !After all collisions in the timestep are done, propagate to end of 
         !the timestep.

         !point to jump to in case of MD without collision term
 103     continue

         time = time+dtimestep  !increment timestep

         !After all collisions in the timestep are done, propagate to end of 
         !the timestep.
         call cascstep(acttime,time-acttime)

         !in case of potential interaction, do MD propagation step
         if (eos.ne.0) then
            ! set initial conditions for MD propagation-step
            do j=1,npart
               r0(j) = r0_t(j)
               rx(j) = rx_t(j)
               ry(j) = ry_t(j)
               rz(j) = rz_t(j)
            enddo
            !now molecular dynamics trajectories
            call proprk(time,dtimestep)
         endif ! (eos.ne.0)

         !perform output if desired
         if(mod(steps,outsteps).eq.0.and.steps.lt.nsteps)then 
            if(CTOption(28).eq.2)call spectrans(otime)
            call file14outx(steps/outsteps)
         endif ! output handling

 20   continue ! time step loop

      acttime=time
      
      if(npart.eq.0)stop
     . '\n \n    ***** STOP in urqmdepos: no particles (2) *****  \n\n'
      
  !~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  ! optional decay of all unstable 
  !  particles before final output
  !~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      
      !DANGER: pauli-blocked decays are not performed !!!
      if(CTOption(18).eq.0.and.CTOption(51).eq.0) then
         !print*,'(info) npart=',npart,' before final decay' !----------
         !no do-loop is used because npart changes in loop-structure
         i=0
         nct=0
         actcol=0
         CTOption(10)=1  !disable Pauli-Blocker for final decays
 40      continue  !decay loop structure starts here
         i=i+1
         if(dectime(i).lt.1.d30) then !if particle unstable
 41         continue
            isstable = .false.
            do stidx=1,nstable
               if (ityp(i).eq.stabvec(stidx)) then
                  !write (6,*) 'no decay of particle ',ityp(i)
                  isstable = .true.
               endif
            enddo
            if (.not.isstable) then
               call scatter(i,0,0.d0,fmass(i),xdummy) !perform decay
               !backtracing if decay-product is unstable itself
               if(dectime(i).lt.1.d30) goto 41
            endif
         endif
         !check next particle
         if(i.lt.npart) goto 40
         !print*,'(info) npart=',npart,' after final decay'  !---------------
      endif ! final decay

  !~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  !     final output
  !~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      if(CTOption(28).eq.2)call spectrans(otime)

      call file13out(nsteps)
      !call file14out(nsteps)
      call file16out
      call osc_event
      call osc99_event(1)
      call osc99_eoe
      
      mp=mp+npart
      if(ctag.eq.0)then
         write(*,*)'(W) No collision in event ',event
         noc=noc+1
      endif

      if(nuj.eq.1)write(6,'(a,50a1)')' (info)',('u',i=1,50)
      end

c######################################################################################
c######################################################################################

                  subroutine file14outx(itime)

c######################################################################################
c######################################################################################

      implicit none
      include '../urqmd23/comres.f'
      include '../urqmd23/coms.f'
      include '../urqmd23/options.f'
      include '../urqmd23/inputs.f'
      include '../urqmd23/newpart.f'
      include '../urqmd23/freezeout.f'
      include '../urqmd23/boxinc.f'
      integer i,itotcoll,iinelcoll,ii,ix,iy,itime,ncnt
      integer nexpart,idpdgg,idepos,idtrafo,pdgid,neta,ij,nrap,nrapid
      integer zeta(2,-10:10,-6:6,40),zetasum(-6:6,40),zrapsum(-6:6,40)
      common /czeta/zeta,zetasum,zrapsum
      real*8 sigmatot,t,tf,z,x,y,p1,p2,p3,p4
      logical go
      common /outco2/sigmatot
      include '../urqmd23/outcom.f'
      data ncnt /0/
      save 

      if(bf14)return
      itotcoll=ctag-dectag
      iinelcoll=itotcoll-NBlColl-NElColl
      ! print*,'(file14outx)',ttime,npart
      !@ ,itotcoll,NElColl,iinelcoll,NBlColl,dectag,
      !@     NHardRes,NSoftRes,NDecRes
       !----------------------------------------------------------------------------
       !  r0(i), rx(i), ry(i), rz(i)   ........................................ x4
       !  p0(i),px(i)+ffermpx(i),py(i)+ffermpy(i),pz(i)+ffermpz(i),fmass(i) ... p5
       !  ityp(i)  ..... particle id (listed in the urqmd user guide)
       !  iso3(i) ...... 2 times the isospin of a particle
       !  charge(i) .... charge of the particle
       !  lstcoll(i) ... index of last collision partner
       !  ncoll(i) ..... number of collisions
       !  origin(i) ....
       !  dectime(i) ...
       !  tform(i) ..... formation time
       !  xtotfac(i) ... cross section (zero if the particle is not yet formed)
       !  uid(i) ......
       !---------------------------------------------------------------------------
       nexpart=0
       ncnt=ncnt+1
       if(ncnt.eq.1)then
       do neta=-6,6
        zetasum(neta,itime)=0
       enddo
       do nrap=-6,6
        zrapsum(nrap,itime)=0
       enddo
       do ii=1,2
       do ij=-10,10
       do neta=-6,6
        zeta(ii,ij,neta,itime)=0
       enddo
       enddo
       enddo
       endif
       do i=1,npart
         t=r0(i)
         tf=tform(i)
         if(t.gt.tf)then
          nexpart=nexpart+1
	  idpdgg=pdgid(ityp(i),iso3(i))
          idepos=idtrafo('pdg','nxs',idpdgg)
          ! some codes like 40323 are not in list -> idepos=0
          z=rz(i)
          x=rx(i)
          y=ry(i)
          ix=-10+(x+10.5)
          iy=-10+(y+10.5)
          p4=p0(i)
          p1=px(i)+ffermpx(i)
          p2=py(i)+ffermpy(i)
          p3=pz(i)+ffermpz(i)
          nrap=nrapid(p3,p4)
          zrapsum(nrap,itime)=zrapsum(nrap,itime)+1
          neta=nrapid(z,t)
          zetasum(neta,itime)=zetasum(neta,itime)+1
          do ii=1,2
           go=.false.
           if(ii.eq.1.and.abs(y).le.1.)go=.true.
           if(ii.eq.2.and.abs(x).le.1.)go=.true.
           if(go)then
            if(ii.eq.1)ij=ix
            if(ii.eq.2)ij=iy
            if(ij.ge.-10.and.ij.le.10)then
             zeta(ii,ij,neta,itime)=zeta(ii,ij,neta,itime)+1
            endif
           endif
          enddo
         endif  
       enddo
       
       !write(6,'(a,2i3,i6)')'(file14outx)',itime,nsteps,nexpart
       
       !do ii=1,2
       !print*,' '
       !do neta=-6,6
       !write(6,'(3x,13i4)')(zeta(ii,ij,neta,itime),ij=-5,5)
       !enddo
       !enddo

      end

c-------------------------------------------------------------------------------------
      subroutine urqmdplot
c-------------------------------------------------------------------------------------
      include '../urqmd23/coms.f'
      if(nsteps.gt.1)call urqmdplot3
      end
      
c-------------------------------------------------------------------------------------
      subroutine urqmdplot3
c-------------------------------------------------------------------------------------
      include 'epos.inc'
      integer zeta(2,-10:10,-6:6,40),zetasum(-6:6,40),zrapsum(-6:6,40)
      common /czeta/zeta,zetasum,zrapsum
      character*4 ch
      write(ifhi,'(a)')    '!----------------------------------------'
      write(ifhi,'(a,i3)') '!   urqmdplot2     '
      write(ifhi,'(a)')    '!----------------------------------------'
      print*,'nevent=',nevent
      do itime=1,31,2
       call getchar(itime,ch)
       write(ifhi,'(a)')       '!newpage'
       write(ifhi,'(a)')'openhisto htyp his name u2-'//ch
       write(ifhi,'(a,f4.1)')'xmod lin xrange -5 5'
       write(ifhi,'(a)')    'txt  "xaxis y "'              
       write(ifhi,'(a)') 'ymod lin yrange auto auto '
       write(ifhi,'(a,i2,a)')'text 0.6 0.9 "  [t]=',itime,'"'
       write(ifhi,'(a)')'txt "yaxis dn/dy "'
       write(ifhi,'(a)')'array 2'
       do nrap=-5,5
        x=nrap
        y=zrapsum(nrap,itime)
        write(ifhi,'(2e13.5)')x,y/nevent
       enddo
       write(ifhi,'(a)') 'endarray closehisto plot 0'
      enddo
      end 

c-------------------------------------------------------------------------------------
      subroutine urqmdplot2
c-------------------------------------------------------------------------------------
      include 'epos.inc'
      integer zeta(2,-10:10,-6:6,40),zetasum(-6:6,40),zrapsum(-6:6,40)
      common /czeta/zeta,zetasum,zrapsum
      character*4 ch
      write(ifhi,'(a)')    '!----------------------------------------'
      write(ifhi,'(a,i3)') '!   urqmdplot2     '
      write(ifhi,'(a)')    '!----------------------------------------'
      print*,'nevent=',nevent
      do itime=1,31,2
       call getchar(itime,ch)
       write(ifhi,'(a)')       '!newpage'
       write(ifhi,'(a)')'openhisto htyp his name u2-'//ch
       write(ifhi,'(a,f4.1)')'xmod lin xrange -5 5'
       write(ifhi,'(a)')    'txt  "xaxis [c] "'              
       write(ifhi,'(a)') 'ymod lin yrange auto auto '
       write(ifhi,'(a,i2,a)')'text 0.6 0.9 "  [t]=',itime,'"'
       write(ifhi,'(a)')'txt "yaxis dn/d[c] "'
       write(ifhi,'(a)')'array 2'
       do neta=-5,5
        x=neta
        y=zetasum(neta,itime)
        write(ifhi,'(2e13.5)')x,y/nevent
       enddo
       write(ifhi,'(a)') 'endarray closehisto plot 0'
      enddo
      end 
      
c-------------------------------------------------------------------------------------
      subroutine urqmdplot1
c-------------------------------------------------------------------------------------
      include 'epos.inc'
      integer zeta(2,-10:10,-6:6,40),zetasum(-6:6,40),zrapsum(-6:6,40)
      common /czeta/zeta,zetasum,zrapsum
      character*4 ch
      write(ifhi,'(a)')    '!----------------------------------------'
      write(ifhi,'(a,i3)') '!   urqmdplot1    '
      write(ifhi,'(a)')    '!----------------------------------------'
      np=0
      do neta=-4,4,2
      do ii=1,2
      do itime=1,31,2
       np=np+1
       call getchar(np,ch)
       write(ifhi,'(a)')       '!newpage'
       write(ifhi,'(a)')'openhisto htyp his name u2-'//ch
       write(ifhi,'(a,f4.1)')'xmod lin xrange -10 10'
       if(ii.eq.1)write(ifhi,'(a)')    'txt  "xaxis x (fm)"'              
       if(ii.eq.2)write(ifhi,'(a)')    'txt  "xaxis y (fm)"'              
       write(ifhi,'(a)') 'ymod lin yrange auto auto '
       write(ifhi,'(a,i2,a)')'text 0.1 0.9 "  [c]=',neta,'"'
       write(ifhi,'(a,i2,a)')'text 0.6 0.9 "  [t]=',itime,'"'
       write(ifhi,'(a)')'txt "yaxis ptl density "'
       write(ifhi,'(a)')'array 2'
       do ij=-10,10
        x=ij
        y=zeta(ii,ij,neta,itime)
        write(ifhi,'(2e13.5)')x,y/nevent/2.
       enddo
       write(ifhi,'(a)') 'endarray closehisto plot 0'
      enddo
      enddo
      enddo
      end 

c-------------------------------------------------------------------------------------
      subroutine getchar(np,ch)
c-------------------------------------------------------------------------------------
      character*4 ch
      ch='    '
      if(np.le.9)then
       write(ch,'(a,i1)')np
      elseif(np.le.99)then
       write(ch,'(a,i2)')np
      elseif(np.le.999)then
       write(ch,'(a,i3)')np
      else
       ch='????'
      endif 
      end
c----------------------------------------------------------------------------------
          integer function nrapid(p3,p4)
c----------------------------------------------------------------------------------
      real*8 p3,p4
      if(p4-p3.le.0.)then
      nrapid=1000
      elseif(p4+p3.le.0.)then
      nrapid=-1000
      else
      rap=0.5*log((p4+p3)/(p4-p3))
      nrapid=-5+(rap+5.5)
      endif
      nrapid=max(nrapid,-6)
      nrapid=min(nrapid, 6)
      end
     
c###################################################################################
c###################################################################################

                       subroutine input(io)

c###################################################################################
c###################################################################################

c-----------------------------------------------------------------------
c     This subroutine reads the UQMD input file (unit=9) 
c
c input : for ({\\tt io=0} input-file will be processed, 
c         else default values assumed 
c output: information in common-block coms.f
c
c-----------------------------------------------------------------------

      implicit none

      include '../urqmd23/coms.f'
      include '../urqmd23/options.f'
      include '../urqmd23/comres.f'
      include '../urqmd23/inputs.f'
      include '../urqmd23/boxinc.f'
      
      integer laproj,maproj,latarg,matarg
      real core,fctrmx
      common/nucl1/laproj,maproj,latarg,matarg,core,fctrmx
      integer icinpu
      real engy,elepti,elepto,angmue
      common/lept1/engy,elepti,elepto,angmue,icinpu

      character*3 flag
      character*77 inputstr,file9,fheader,file14,file15,file16,file17
      character*77 file13,file10,file19,file20
      integer line,proflg,tarflg,impflg,beamflg,inx,ival,partid
      integer eosflg,i,io
      real*8 rval,caltim,outtim
      logical dtflag,bret

      character CTOStrng(numcto)*60
      character CTPStrg(numctp)*60

c setting of internal parameters values:
      real*8 valint(1)
      common /values/ valint
      
      logical infu
      
      integer ncnt
      data ncnt /0/

      save

      ncnt=ncnt+1
      infu=info
      if(ncnt.gt.1)infu=.false.


      valint(1)=0.d0    

      bret=io.ne.0
      goto 108

      entry inpini  
c  called by some test programs

      bret=.true.
 108  continue
  
c initialize counters
      line=0
      boxflag=0
      mbflag=0
      edens=0.d0
      para=0
      solid=0
      mbox=0

c the following flags check, wether all necessary input is given 
c projectile
      proflg=0
      prspflg=0
c target
      tarflg=0
      trspflg=0
c impact parameter
      impflg=0
c incident beam energy
      beamflg=0
      srtflag=0
      firstev=0
c equation of state
      eosflg=0
c excitation function
      nsrt=1
	 npb=1
      efuncflag=0
c default number of events
      nevents=1
c default seed for random number generator
      ranseed=0
c default number of timesteps
      nsteps=1000
c use standard time-step
      dtflag=.false.
c skip conditions on unit 14, 15, 16 & 18
      bf13=.false.
      bf14=.false.
      bf15=.false.
      bf16=.false.
      bf18=.false.
      bf19=.false.
      bf20=.false.
      do 111 i=1,numcto
         CTOdc(i)='  '
 111  continue
      do 112 i=1,numctp
         CTPdc(i)='  '
 112  continue
      do 113 i=1,maxstables
         stabvec(i)=0
 113  continue
      nstable = 0

c default settings for CTParam and CTOption cccccccccccccccccccccccccccccc
      CTParam(1)=1.d0  
      CTPStrg(1)='scaling factor for decay-width'
      CTParam(2)=0.52d0 
      CTPStrg(2)='used for minimal stringmass & el/inel cut in makestr'
      CTParam(3)=2d0 
      CTPStrg(3)='velocity exponent for modified AQM'  
      CTParam(4)=0.3d0 
      CTPStrg(4)='transverse pion mass, used in make22 & strexct'
      CTParam(5)=0d0 
      CTPStrg(5)='probabil. for quark rearrangement in cluster'
      CTParam(6)=0.4d0  
      CTPstrg(6)='strangeness probability'
      CTParam(7)=0.d0 
      CTPStrg(7)='charm probability (not yet implemented in UQMD)'
      CTParam(8)=0.093d0 
      CTPStrg(8)='probability to create a diquark'
      CTParam(9)=0.35d0 
      CTPStrg(9)='kinetic energy cut off for last string break'
      CTParam(10)=0.25d0 
      CTPStrg(10)='min. kinetic energy for hadron in string'
      CTParam(11)=0.d0 
      CTPStrg(11)='fraction of non groundstate resonances'
      CTParam(12)=.5d0  
      CTPStrg(12)='probability for rho 770 in String'
      CTParam(13)=.27d0 
      CTPStrg(13)='probability for rho 1450 (rest->rho1700)'
      CTParam(14)=.49d0 
      CTPStrg(14)='probability for omega 782'
      CTParam(15)=.27d0 
      CTPStrg(15)='probability for omega 1420(rest->om1600)'
      CTParam(16)=1.0d0 
      CTPStrg(16)='mass cut betw. rho770 and rho 1450'
      CTParam(17)=1.6d0 
      CTPSTRG(17)='mass cut betw. rho1450 and rho1700'
      CTParam(18)=.85d0 
      CTPStrg(18)='mass cut betw. om 782 and om1420'
      CTParam(19)=1.55d0
      CTPStrg(19)='mass cut betw. om1420 and om1600'
      CTParam(20)=0.0d0
      CTPStrg(20)=' distance for second projectile'
      CTParam(21)=0.0d0
      CTPStrg(21)=' deformation parameter'
      CTParam(25)=.9d0 
      CTPStrg(25)=' probability for diquark not to break'
      CTParam(26)=50d0 
      CTPStrg(26)=' maximum trials to get string masses'
      CTParam(27)=1d0 
      CTPStrg(27)=' scaling factor for xmin in string excitation'
      CTParam(28)=1d0 
      CTPStrg(28)=' scaling factor for transverse fermi motion'
      CTParam(29)=0.4 
      CTPStrg(29)=' single strange di-quark suppression factor '
      CTParam(30)=1.5 
      CTPStrg(30)=' radius offset for initialisation  '
      CTParam(31)=1.6d0 
      CTPStrg(31)=' sigma of gaussian for tranverse momentum tranfer '
      CTParam(32)=0d0
      CTPStrg(32)=' alpha-1 for valence quark distribution  '
      CTParam(33)=2.5d0
      CTPStrg(33)=' betav for valence quark distribution  (DPM)'
      CTParam(34)=0.1
      CTPStrg(34)=' minimal x multiplied with ecm  '
      CTParam(35)=3.0
      CTPStrg(35)=' offset for cut for the FSM '
      CTParam(36)=0.275d0
      CTPStrg(36)=' fragmentation function parameter a  '
      CTParam(37)=0.42d0
      CTPStrg(37)=' fragmentation function parameter b  '
      CTParam(38)=1.08d0
      CTPStrg(38)=' diquark pt scaling factor '
      CTParam(39)=0.8d0
      CTPStrg(39)=' strange quark pt scaling factor '
      CTParam(40)=0.5d0
      CTPStrg(40)=' betas-1 for valence quark distribution (LEM)'
      CTParam(41)=0.0
      CTPStrg(41)=' distance of initialisation'
      CTParam(42)=0.55d0
      CTPStrg(42)=' width of gaussian -> pt in string-fragmentation '
      CTParam(43)=5.d0
      CTPStrg(43)=' maximum kinetic energy in mesonic clustr '
      CTParam(44)=.8d0
      CTPStrg(44)=' prob. of double vs. single excitation for AQM inel.'
      CTParam(45)=0.5
      CTPStrg(45)=' offset for minimal mass generation of strings'
      CTParam(46)=800000
      CTPStrg(46)=' maximal number of rejections for initialisation'
      CTParam(47)=1.0
      CTPStrg(47)=' field feynman fragmentation funct. param. a'
      CTParam(48)=2.0
      CTPStrg(48)=' field feynman fragmentation funct. param. b'
      CTParam(49)=50.5
      CTPStrg(49)=' Energy cut-off for exclusive PYTHIA use'
      CTParam(50)=1d0 
      CTPStrg(50)=' enhancement factor for 0- mesons'
      CTParam(51)=1d0 
      CTPStrg(51)=' enhancement factor for 1- mesons'
      CTParam(52)=1d0
      CTPStrg(52)=' enhancement factor for 0+ mesons'
      CTParam(53)=1d0
      CTPStrg(53)=' enhancement factor for 1+ mesons'   
      CTParam(54)=1d0 
      CTPStrg(54)=' enhancement factor for 2+ mesons'   
      CTParam(55)=1d0
      CTPStrg(55)=' enhancement factor for 1+-mesons'   
      CTParam(56)=1d0
      CTPStrg(56)=' enhancement factor for 1-*mesons'   
      CTParam(57)=1d0
      CTPStrg(57)=' enhancement factor for 1-*mesons'    
      CTParam(58)=1.d0
      CTPStrg(58)=' scaling factor for DP time-delay'

cc
      CTOption(1)=0  
      CTOStrng(1)=' resonance widths are mass dependent '
      CTOption(2)=0
      CTOStrng(2)=' conservation of scattering plane'
      CTOption(3)=0  
      CTOStrng(3)=' use modified detailed balance'
      CTOption(4)=0  
      CTOStrng(4)=' no initial conf. output '
      CTOption(5)=0  
      CTOStrng(5)=' fixed impact parameter'
      CTOption(6)=0  
      CTOStrng(6)=' no first collisions inside proj/target'
      CTOption(7)=0  
      CTOStrng(7)=' elastic cross section enabled (<>0:total=inelast)'
      CTOption(8)=0  
      CTOStrng(8)=' extrapolate branching ratios '
      CToption(9)=0  
      CTOStrng(9)=' use tabulated pp cross sections ' 
      CTOption(10)=0 
      CTOStrng(10)=' enable Pauli Blocker'
      CTOption(11)=0 
      CTOStrng(11)=' mass reduction for cascade initialisation' 
      CTOption(12)=0 
      CTOStrng(12)=' string condition =0 (.ne.0 no strings)'
      CTOption(13)=0 
      CTOStrng(13)=' enhanced file16 output '
      CTOption(14)=0 
      CTOStrng(14)=' cos(the) is distributet between -1..1 '
      CTOption(15)=0 
      CTOStrng(15)=' allow mm&mb-scattering'
      CTOption(16)=0 
      CTOStrng(16)=' propagate without collisions'
      CTOption(17)=0 
      CTOStrng(17)=' colload after every timestep '
      CTOption(18)=0 
      CTOStrng(18)=' final decay of unstable particles'
      CTOption(19)=0  
      CTOStrng(19)=' allow bbar annihilaion'
      CTOption(20)=0
      CTOStrng(20)=' dont generate e+e- instead of bbar'
      CTOption(21)=0
      CTOStrng(21)=' use field feynman frgm. function'
      CTOption(22)=1
      CTOStrng(22)=' use lund excitation function'
      CTOption(23)=0
      CTOStrng(23)=' lorentz contraction of projectile & targed'
      CTOption(24)=1
      CTOStrng(24)=' Wood-Saxon initialization'
      CTOption(25)=0
      CTOStrng(25)=' phase space corrections for resonance mass'
      CTOption(26)=0
      CTOStrng(26)=' use z -> 1-z for diquark-pairs'
      CTOption(27)=0 
      CTOStrng(27)=' reference frame (1=target, 2=projectile, else=cms)'
      CTOption(28)=0
      CTOStrng(28)=' propagate spectators also '
      CTOption(29)=2
      CTOStrng(29)=' no transverse momentum in clustr '
      CTOption(30)=1
      CTOStrng(30)=' frozen fermi motion '
      CTOption(31)=0
      CTOStrng(31)=' reduced mass spectrum in string'
      CTOption(32)=0
      CTOStrng(32)=' masses are distributed acc. to m-dep. widths'
      CTOption(33)=0
      CTOStrng(33)=' use tables & m-dep. for pmean in fprwdt & fwidth'
      CTOption(34)=1
      CTOStrng(34)=' lifetme according to m-dep. width'
      CTOption(35)=1
      CTOStrng(35)=' generate high precision tables'
      CTOption(36)=0
      CTOStrng(36)=' normalize Breit-Wigners with m.dep. widths '
      CTOption(37)=1
      CTOStrng(37)=' heavy quarks form di-quark clusters'
      CTOption(38)=0
      CTOStrng(38)=' scale p-pbar to b-bbar with equal p_lab '
      CTOption(39)=0
      CTOStrng(39)=' dont call pauliblocker'
      CTOption(40)=0
      CTOStrng(40)=' read old fort.14 file '
      CTOption(41)=0
      CTOStrng(41)=' generate extended output for cto40'
      CTOption(42)=0
      CTOStrng(42)=' hadrons now have color fluctuations'
      CTOption(43)=0
      CTOStrng(43)=" don't generate dimuon intead of dielectron output"
      CTOption(44)=0
      CTOStrng(44)=' PYTHIA for hard scatterings also at low energies'
      CTOption(45)=0
      CTOStrng(45)=' not used at the moment'

      CTOption(50)=0
      CTOStrng(50)=' two-body rescatterings are not allowed'
      CTOption(51)=0
      CTOStrng(51)=' decays are not allowed'
      
      if(bret)return

c initialize arrays for special PRO/TAR combinations
      do 10 i=1,2
         spityp(i)=0
         spiso3(i)=0
 10   continue
c header for output files
      fheader=' this is the default uqmd-fileheader'

c open fortran-unit 9 for input
c and units 14, 15 for output
      call getenv('ftn09',file9)
      call getenv('ftn10',file10)
      call getenv('ftn13',file13)
      call getenv('ftn14',file14)
      call getenv('ftn15',file15)
      call getenv('ftn16',file16)
      call getenv('ftn17',file17)
      call getenv('ftn19',file19)
      call getenv('ftn20',file20)
ckw      if (file9(1:4).ne.'    ') then
ckw         OPEN(UNIT=9,FILE=file9,STATUS='OLD',FORM='FORMATTED')
ckw      endif
      if (file10(1:4).ne.'    ') then
         OPEN(UNIT=10,FILE=file10,STATUS='OLD',FORM='FORMATTED')
         CTOption(40)=1
         nevents=100000
      endif
      if (file13(1:4).ne.'    ') then
         OPEN(UNIT=13,FILE=file13,STATUS='unknown',FORM='FORMATTED')
      endif
      if (file14(1:4).ne.'    ') then
         OPEN(UNIT=14,FILE=file14,STATUS='unknown',FORM='FORMATTED')
      endif
      if (file15(1:4).ne.'    ') then
         OPEN(UNIT=15,FILE=file15,STATUS='unknown',FORM='FORMATTED')
      endif
      if (file16(1:4).ne.'    ') then
         OPEN(UNIT=16,FILE=file16,STATUS='unknown',FORM='FORMATTED')
      endif
      if (file17(1:4).ne.'    ') then
         OPEN(UNIT=17,FILE=file17,STATUS='unknown',FORM='FORMATTED')
      endif
      if (file19(1:4).ne.'    ') then
         OPEN(UNIT=19,FILE=file19,STATUS='unknown',FORM='FORMATTED')
      endif
      if (file20(1:4).ne.'    ') then
         OPEN(UNIT=20,FILE=file20,STATUS='unknown',FORM='FORMATTED')
      endif
c
 99   format(1A3,1A77)

c stop input if old event is read in
      if(CTOption(40).eq.1) return


c this entry is used to read cto,ctp and tim statements
c in case of old event readin
      entry getparams
      
ckw      close(9)
ckw      OPEN(UNIT=9,FILE=file9,STATUS='OLD',FORM='FORMATTED')
 
c read input lines
 1    continue
      line=line+1
ckw      read(9,99) flag,inputstr
       
      inputstr( 1:40)='                                        '
      inputstr(41:77)='                                     '
      !~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      !    settings
      !~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      if(line.eq.1)then
        flag='pro'                         !~~~~projectile (Ap, Zp)
        write(inputstr(1:8),'(2i4)')maproj,laproj
      elseif(line.eq.2)then              
        flag='tar'                         !~~~~target (Ap, Zp)
        write(inputstr(1:8),'(2i4)')matarg,latarg
      elseif(line.eq.3)then     
        flag='nev'                         !~~~~number of events
        inputstr(1:2)=' 1'
      elseif(line.eq.4)then 
        flag='tim'    !~~~~propagation time, output time step (in fm/c)
        inputstr(1:8)=' 400 400'
      elseif(line.eq.5)then 
        flag='ecm'                         !~~~~cms energy in AGeV
        write(inputstr(1:5),'(i5)')nint(engy)
      elseif(line.eq.6)then 
        flag='imp'                         !~~~~impact parameter (in fm)
        inputstr(1:2)=' 0'
      elseif(line.eq.7)then 
        flag='   '                         !~~~~random number seed
        !inputstr(1:11)=' 1134570653'
      elseif(line.eq.8)then 
        flag='eos'                         !~~~~equation of state
        inputstr(1:2)=' 0'
      elseif(line.eq.9)then 
        flag='cto'                     
        inputstr(1:4)=' 5 1'
      elseif(line.eq.10)then 
        flag='cto'                     
        inputstr(1:5)=' 40 3'
      elseif(line.eq.11)then 
        flag='f13'                     
        inputstr(1:1)=' '
      elseif(line.eq.12)then 
        flag='   '   !'f14'             !~~~~~~~~~suppress output                 
        inputstr(1:1)=' '
      elseif(line.eq.13)then 
        flag='f15'                     
        inputstr(1:1)=' '
      elseif(line.eq.14)then 
        flag='f16'                     
        inputstr(1:1)=' '
      elseif(line.eq.15)then 
        flag='f19'                     
        inputstr(1:1)=' '
      elseif(line.eq.16)then 
        flag='f20'                     
        inputstr(1:1)=' '
c      elseif(line.eq.17)then  !~~~~~for fast run comment the following flags!!!!
c        flag='cdt'                 !~~~~~~~~~  timestep        
c        inputstr(1:1)='1'
c      elseif(line.eq.18)then 
c        flag='tim'                 !~~~~~~~~~ caltim, outtim    
c        inputstr(1:6)='400 20'
      else
        goto2
      endif
      !~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

 3    continue
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c select action according to flag:
c #  : treat line as a comment
      if(flag(1:1).eq.'#') goto 1
c blanks are comments, too
      if(flag(1:1).eq.' ') goto 1
c xxx: treat line as end of input marker
      if(flag.eq.'xxx'.or.flag.eq.'end') then
         goto 2
cc cal: header for output-files
c      if(flag.eq.'cal') then
c         fheader=inputstr
c pro: define projectile
      elseif(flag.eq.'pro') then
         proflg=proflg+1
         read(inputstr,fmt=*,err=88,end=88) Ap,Zp
         if(proflg.gt.1) then
            write(6,*)'multiple definitions for projectile system:'
            write(6,*)'-> last entry will be used'
         endif
c PRO: define special projectile
      elseif(flag.eq.'PRO') then
         proflg=proflg+1
         prspflg=1
         read(inputstr,fmt=*,err=88,end=88) spityp(1),spiso3(1)
         Ap=1
         if(proflg.gt.1) then
            write(6,*)'multiple definitions for projectile system:'
            write(6,*)'-> last entry will be used'
         endif
c tar: define target
      elseif(flag.eq.'tar') then
         tarflg=tarflg+1
         read(inputstr,fmt=*,err=88,end=88) At,Zt
         if(tarflg.gt.1) then
            write(6,*)'multiple definitions for target system:'
            write(6,*)'-> last entry will be used'
         endif
c TAR: define special target
      elseif(flag.eq.'TAR') then
         tarflg=tarflg+1
         trspflg=1
         read(inputstr,fmt=*,err=88,end=88) spityp(2),spiso3(2)
         At=1
         if(tarflg.gt.1) then
            write(6,*)'multiple definitions for target system:'
            write(6,*)'-> last entry will be used'
         endif
c box: define a box with a length in fm
c	parameters: 2: energie
c		    3: 1 =solid		
c		    4: 1 = walls
        elseif(flag.eq.'box') then          
           boxflag=boxflag+1                     
          read(inputstr,fmt=*,err=88,end=88) lbox,edens,solid,para
	   if (edens.gt.0.d0) edensflag=1
		
           if (lbox.le.0) then
              write(6,*) 'Error, lenght<=0'
              stop                          
           endif                            
           lboxhalbe=lbox/2.d0
           lboxd=lbox*2.d0

 	   if (edens.lt.0.d0) then 
	      write(6,*) 'Error, a negativ energy '
	      stop
	   endif
           
           if(boxflag.gt.1) then            
            write(6,*)'multiple boxes are defined'
            stop                            
        endif                  
c bpt: define particles in the box
c parameters: ityp, iso3, mpart, pmax
	elseif(flag.eq.'bpt') then
	   if (edens.gt.0.d0) then
	      write(6,*) 'Error, energie is already defined'
	      stop
	   endif
           mbox=mbox+1
           read(inputstr,fmt=*,err=88,end=88) 
     &     bptityp(mbox),bptiso3(mbox),bptpart(mbox),bptpmax(mbox)
	   edensflag=0 
 	   if (bptpart(mbox).le.0) then 
	      write(6,*) 'Error, a negativ particle number'
	      stop
	   endif
           if(boxflag.lt.1) then
            write(6,*)'no box is defined'          
	    stop
        endif
c bpe: define particles in the box with a given energy
c parameters: ityp, iso3, mpart, 
	elseif(flag.eq.'bpe') then
	   if (edens.le.0) then
	      write(6,*) 'Error, no energie is defined'
	      stop
	   endif
           mbox=mbox+1
	   read(inputstr,fmt=*,err=88,end=88) 
     &     bptityp(mbox),bptiso3(mbox),bptpart(mbox)
           if(boxflag.lt.1) then
            write(6,*)'no box is defined'          
	    stop
        endif
c ene: beam energy (lab-system)
      elseif(flag.eq.'ene'.or.flag.eq.'elb') then
         beamflg=beamflg+1
         read(inputstr,fmt=*,err=88,end=88) ebeam 
         if(beamflg.gt.1) then
            write(6,*)'multiple definitions for beam-energy:'
            write(6,*)'-> last entry will be used'
         endif
         if (ebeam.le.200) then
           write(6,*)'Calculation at ebeam.le.200 A GeV:'
           write(6,*)'parameter nmax in coms.f may be decreased!'
         endif
c plb: beam momentum (lab-system)
      elseif(flag.eq.'plb') then
         beamflg=beamflg+1
         srtflag=2
         read(inputstr,fmt=*,err=88,end=88) pbeam 
         if(beamflg.gt.1) then
            write(6,*)'multiple definitions for beam-energy:'
            write(6,*)'-> last entry will be used'
         endif
       if (pbeam.le.200) then
            write(6,*)'Calculation at pbeam.le.200 A GeV:'
            write(6,*)'parameter nmax in coms.f may be decreased!'
       endif
c PLB: beam momentum ( LAb-system, excitation function possible)
      elseif(flag.eq.'PLB'.or.flag.eq.'PLG') then
         beamflg=beamflg+1
         srtflag=2
         read(inputstr,fmt=*,err=88,end=88) pbmin,pbmax,npb 
         pbeam=pbmin
         if(beamflg.gt.1) then
            write(6,*)'multiple definitions for beam-energy:'
            write(6,*)'-> last entry will be used'
         endif
         if(npb.gt.1.and.flag.eq.'PLB') efuncflag=1
         if(npb.gt.1.and.flag.eq.'PLG') efuncflag=2
         if(abs(pbmax-pbmin).le.1.d-6) then
            npb=1
            efuncflag=0
         endif
         if (pbmax.le.200) then
            write(6,*)'Calculations at pbmax.le.200 A GeV:'
            write(6,*)'parameter nmax in coms.f may be decreased!'
         endif
c ecm:  c.m.energy 
      elseif(flag.eq.'ecm') then
         beamflg=beamflg+1
         srtflag=1
         read(inputstr,fmt=*,err=88,end=88) ecm 
         srtmin=ecm
         srtmax=ecm
         nsrt=1
         efuncflag=0 
         if(beamflg.gt.1) then
            write(6,*)'multiple definitions for beam-energy:'
            write(6,*)'-> last entry will be used'
         endif
         if (ecm.le.20) then 
          if(infu)then
           write(6,*)'(info) Calculation at sroot.le.20 A GeV:'
           write(6,*)'(info) parameter nmax in coms.f may be decreased!'
          endif
         endif
c ENE: beam energy (sqrt(s): CM-system, excitation function possible)
      elseif(flag.eq.'ENE'.or.flag.eq.'ELG') then
         beamflg=beamflg+1
         srtflag=1
         read(inputstr,fmt=*,err=88,end=88) srtmin,srtmax,nsrt 
         ecm=srtmin
c        if(flag.eq.'ELG')ecm=1d1**dlog10(srtmin)
         if(beamflg.gt.1) then
            write(6,*)'multiple definitions for beam-energy:'
            write(6,*)'-> last entry will be used'
         endif
         if(nsrt.gt.1.and.flag.eq.'ENE') efuncflag=1
         if(nsrt.gt.1.and.flag.eq.'ELG') efuncflag=2
         if(abs(srtmax-srtmin).le.1.d-6) then
            nsrt=1
            efuncflag=0
         endif
         if (srtmax.le.20) then
            write(6,*)'Calculations at srootmax.le.20 A GeV:'
            write(6,*)'parameter nmax in coms.f may be decreased!'
         endif
c imp: impact parameter
      elseif(flag.eq.'imp') then
         bmin=0.d0
         impflg=impflg+1
         read(inputstr,fmt=*,err=88,end=88) bdist 
         if(bdist.lt.0d0)then
           CTOption(5)=1
           bdist=abs(bdist)
           write(6,*)'randomly choosen impact parameter:',
     ,             ' CTOption(5) is set to 1'
         end if
         if(impflg.gt.1) then
            write(6,*)'multiple definitions for impact parameter:'
            write(6,*)'-> last entry will be used'
         endif
c IMP: impact parameter
      elseif(flag.eq.'IMP') then
         impflg=impflg+1
         read(inputstr,fmt=*,err=88,end=88) bmin,bdist 
         CTOption(5)=1
         if(impflg.gt.1) then
            write(6,*)'multiple definitions for impact parameter:'
            write(6,*)'-> last entry will be used'
         endif
c eos: impact parameter
      elseif(flag.eq.'eos') then
         eosflg=eosflg+1
         read(inputstr,fmt=*,err=88,end=88) eos 
         if(eosflg.gt.1) then
            write(6,*)'multiple definitions for equation of state:'
            write(6,*)'-> last entry will be used'
         endif
         if (eos.ne.0) then
            CTOption(24)=0
         endif
c nev: number of events
      elseif(flag.eq.'nev') then
         read(inputstr,fmt=*,err=88,end=88) nevents 
c rsd: 
      elseif(flag.eq.'rsd') then
         read(inputstr,fmt=*,err=88,end=88) ranseed
c cdt: collision time step
      elseif(flag.eq.'cdt') then
         read(inputstr,fmt=*,err=88,end=88) dtimestep
         dtflag=.true.
c tim: time of propatation
      elseif(flag.eq.'tim') then
         read(inputstr,fmt=*,err=88,end=88) caltim, outtim 
c stb: keep particle stable
      elseif(flag.eq.'stb') then
         read(inputstr,fmt=*,err=88,end=88) partid
         if (nstable.lt.maxstables) then
            nstable = nstable + 1
            stabvec(nstable) = partid
         else
            write(6,*) 'Warning: too many stable particles defined!'
         endif
c cto: collision term options
      elseif(flag.eq.'cto') then
         read(inputstr,fmt=*,err=88,end=88) inx,ival
         if(ncnt.eq.1)
     &    write(6,*)'(info) CTOption(',inx,')=',CTOption(inx)
     &        ,CTOStrng(inx)(1:index(CTOStrng(inx),' '))
     &      ,'is changed to',ival
         CTOption(inx)=ival
         CTOdc(inx)=' *'
c ctp: collision term parameter
      elseif(flag.eq.'ctp') then
         read(inputstr,fmt=*,err=88,end=88) inx,rval
         CTParam(inx)=rval
         CTPdc(inx)=' *'
         write(6,*)'CTParam(',inx,'):   ',CTPStrg(inx)
     ,             ,'is changed to',rval
      elseif (flag.eq.'f13') then
         bf13=.true.
         if (infu) write(6,*)'(info) no output on unit 13'
      elseif (flag.eq.'f14') then
         bf14=.true.
         if (infu) write(6,*)'(info) no output on unit 14'
      elseif (flag.eq.'f15') then
         bf15=.true.
         if (infu) write(6,*)'(info) no output on unit 15'
      elseif (flag.eq.'iou') then
         read(inputstr,fmt=*,err=88,end=88) inx,ival
         call uounit(inx,ival)
         write(6,*)'file',inx,'will be written on unit',ival
      elseif (flag.eq.'f16') then
         bf16=.true.
         if (infu) write(6,*)'(info) no output on unit 16'
      elseif (flag.eq.'f18') then
          bf18=.true.
          if (infu) write(6,*)'(info) no output on unit 18'
      elseif (flag.eq.'f19') then
          bf19=.true.
          if (infu) write(6,*)'(info) no output on unit 19'
      elseif (flag.eq.'f20') then
          bf20=.true.
          if (infu) write(6,*)'(info) no output on unit 20'
      else
         write(6,*)'undefined opcode in input-file on line',line
         stop
      endif
      goto 1
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 2    continue


c fast CASCADE mode
      if(.not.dtflag.and.eos.eq.0) dtimestep=outtim
c
      nsteps=int(0.01+caltim/dtimestep)
      outsteps=int(0.01+outtim/dtimestep)
      if(infu)print*,'(info) nsteps, outsteps, dtimestep :'
     . ,nsteps, outsteps,dtimestep

c stop input if old event is read in
      if(CTOption(40).eq.1) return


c here some validity checks of the input should be performed
	if (boxflag.eq.1.and.mbox.eq.0) then
	    Write(6,*) 'Error: no particles in the box.'
	    stop
	ElseIf (boxflag.eq.0) then
      if(proflg.eq.0) then
         write(6,*)'Error: no projectile specified in input.'
         stop
      elseif(tarflg.eq.0) then
         write(6,*)'Error: no target specified in input.'
         stop
      elseif((impflg.eq.0)) then
         write(6,*)'Error: no impact parameter in input.'
         stop
      elseif(beamflg.eq.0.and.prspflg.eq.0) then
         write(6,*)'Error: no incident beam energy specified.'
         stop
      endif
c EndIf for the Box
	EndIf      
      if (efuncflag.ne.0.and.
     &    mod(nevents,max(nsrt,npb)).ne.0) then
         write(6,*)'INPUT: the number of events divided by the ',
     ,   'number of energies requested is no integer.'
      end if      
c
c constraints for skyrme pots:
      if(eos.ne.0.and.((srtflag.eq.0.and.ebeam.gt.4d0)
     &             .or.(srtflag.eq.1.and.srtmax.gt.3.3d0)
     &             .or.(srtflag.eq.2.and.pbeam.gt.4.9))) then
         write(6,*)'***(W) I switched off the potentials'
         eos=0
      end if
      if(eos.ne.0) then
         CTOption(11)=1
         CTOption(28)=0
         CTOption(30)=0
      endif
c

c now print the selected analysis

c...some input combinations should be avoided and/or commented
      if(CTOption(7).ne.0.and.At*Ap.ne.1)then
        write(6,*)'Warning: CTOption(7)=',CTOption(7), 
     ,  ' no elastic collisions in NN',
     ,  ' should not be used for serious calculations!'
      end if

      if(CTOption(18).ne.0)then
        write(6,*)'Warning: CTOption(18)=',CToption(18),': ',
     ,  'unstable particles will not decay after propagation.'
      end if


      if(CTOption(31).ne.0)then
        write(6,*)'Warning: CTOption(31)=',CToption(31),': ',
     ,  "Not yet completly implemented. Don't use for serious",
     ,  'calculations (not yet..).' 
      end if

      if(CTParam(28).lt.0d0.or.CTParam(28).gt.1d0)then
        write(6,*)'Warning: CTParam(28)=',CTParam(28),': ',
     ,  'should be between 0 and 1. it will be corrected.'
        CTParam(28)=min(1d0,max(0d0,CTParam(28)))
      end if
      
      return

 88   write(6,*) 'syntax-error in input-file on line ',line
     .   ,'   flag ',flag
      write(6,*)inputstr
      stop
      end







