      subroutine cthinning(Tracks, n, iTrack, nout)
c
c       The user may replace this routine by his/her own  thinning method.
c       For 'n' tracks in 'Tracks', change weight if necessary or remove it.
c       If a track is removed, the user must move the remaining tracks
c       to the upper position in Tracks.
c       This will be done simply as
c          nout = 0
c          do i = 1, n
c            Examine Tracks(i)
c            if it is accepted, (do neceeary weight change)
c                nout++
c                store it in Tracks(nout)
c            else do nothing
c          enddo
c
c   The standard thinning routine is supploed as csetThinwgt
c   A paremeter in $Hparam, EthinRatio, is used as follows.
c   EthinRation(1) to (4) are used as (Ethin, MaxWgt) for e/g
c   and for mu/had.  If EthiRatio(3) and (4) are not given
c   (1)/10 and (2)/10 are used.
c   Others are hard wired and can be chaged in csetThinwgt
c   (see  top part of csetThinwgt.  They  are in the lines
c   above ^^^^^^^^^^^^^^^^^^^^^^^^^.
c

      implicit none
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zincidentv.h"
      integer n     ! input. no. of produced particles and stored in Tracks
      record /track/ Tracks(n)  ! input and outut.  track info.
      record /track/ iTrack  ! input. incident particle track info. for the coll.
      integer  nout  !  output.  number of particles accepted in the
                     !     thinning
c
c       
      integer i
      record /track/ aTrack
      integer icon

      nout = 0
      do i = 1, n
         aTrack=Tracks(i)
         call csetThinwgt(iTrack, aTrack, icon)
         if(icon .eq. 0 )  then
            nout = nout +1
            Tracks(nout)=aTrack
         endif
      enddo
      end

      subroutine csetThinwgt(iTrack, aTrack, icon)
      implicit none
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zincidentv.h"
#include  "Zelemagp.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
c
c **************** if you want to limit the max wwight exactly 
c                  give 1 to the next line
c                  else give 0.
c                  For exact max limit, you  have to give larger 
c                  weight in EthinRatio(2) and EthinRatio(4) for
c                  defending cpu time increase. (~10 times) 
c            If you give  0 then  if the weight is > the max weight,
c            no more  thinning is tried. However, if the weight is < max,
c            thinning is tried and resultant weight may be
c            larger than max limit.
c            If 1, the weight managed so that it never exceeds
c            the max.  0 has probably better performance.
#define EXACTWGT 0
c           Define `far` by DETAILFAR.  (particle location is far
c           from the axis or not.)
c            0:  far is judged at  depeth1<depth<depth2 for e/g
c                and mu/h 
c            1:  far is judged at depeth1<depth<depth2 for e/g
c                              at all depths < depth2 for mu/h
#define DETAILFAR 0

      real*8 big  ! if you don't want to control the thinnig
                  ! by the distance of the current particle
                  ! from the shower axis, give big to rfar 
      parameter (big=1.d20)
c   ******************************************************************
c   **************************** fix the following *******************
c
      real*8 depth1/4000.d0/  ! between depth1 and depth2, check if
      real*8 depth2/8750.d0/  ! a ptcl is far from the core. If  so 
             ! we employ lesser thinning or no thinning.
             ! depth2  should be the last obs. depth where lateral
             ! information is taken. 
             ! the unit is kg/m2 (devide by 10 for g/cm2)
      real*8 rfar       ! r>rfar is regared as "far from axis" (m).
                 ! if want to skip distance dependent thinning
                 !  set this to be "big" (see below)
      real*8 rfar2      ! rfar**2
      parameter (rfar =20.0, rfar2= rfar*rfar)
      real*8 deepfactor/10./  ! at depth  > depht2, stronger thinning
               !      by factor 'deepfactor' than standard thinning
               !      specified by EthinRatio.  
               !  Ethin and Weight are multiplied by this factor.
      real*8 farfactor/0.01/  ! thinning factor is weekened by this factor
                  ! than standard one at far points.  
                  !  Ethin and Weight are multiplied by this factor.
c
c   
c     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
c




      record /track/ iTrack   ! input  parent particle
      record /track/ aTrack  ! input   child particle
c                            ! output.    wgt
      integer icon           ! output.  0 if this is not tobe discarded
                             !          1 if this is to be discarded
      real*8 u, p 
      real*8 iergpn, aergpn
      logical dothin
      real*8 dd, rhoE
      real*8 cvh2den
      real*8 Z1, E0
      integer ii, jj  ! ii is for incident and jj is for child; for e/g 1,  for mu/had 3
      data Z1/-1./, E0/-1./
      save Z1, E0, rhoE, dd
      record /coord/ oxyz, axisxyz
      real*8 len, h, relax, dist
      logical far
c
c          
      if(IncidentCopy.p.code .eq. kphoton  .and.
     *    PhotoProd )  then
c            photon  primary and muon is interested
c            so thinsamling must be carfull
c            we apply thinning only if current depth is
c            > 120 g/cm2 from the first col. point.
         if(Z1 .ne.  Zfirst.pos.depth  .or.
     *      E0 .ne.  IncidentCopy.p.fm.p(4) ) then
            Z1 = Zfirst.pos.depth 
            E0 = IncidentCopy.p.fm.p(4) 
            if( LpmEffect ) then
               rhoE=cvh2den( Zfirst.pos.height )* 1.e-3 * 
     *             IncidentCopy.p.fm.p(4) 
               if(rhoE .lt. 1.e6)  then
                  dd = 200.
               else
                  dd =min( 200.* sqrt(rhoE/1.e6), 1000.d0)
               endif
            else
               dd = 200.
            endif
         endif

         if(  MagBrem .eq. 2 .and.   Z1 .lt. 1.e-6 ) then
            dothin = iTrack.pos.depth/Zfirst.vec.coszenith
     *           .gt. 300.
         else
            dothin=( iTrack.pos.depth-Zfirst.pos.depth)/
     *           Zfirst.vec.coszenith .gt. (1000.+ dd)
         endif
      else
         dothin = .true.
      endif
c
c
c          
c
c     
#if DETAILFAR == 0
      if( dothin .and. rfar .lt. big .and.
     *    iTrack.pos.depth .lt. depth2 .and.
     *    iTrack.pos.depth .gt. depth1  ) then
#elif DETAILFAR == 1
      if( dothin .and. rfar .lt. big .and.
     *    iTrack.pos.depth .lt. depth2 .and.
     *    (iTrack.p.code .gt. kelec  .or.
     *     iTrack.pos.depth .gt. depth1 ) ) then
#endif
c            compute distance form the shower axis
        h = iTrack.pos.height - ObsSites(aTrack.where).pos.height
        len = h / (-AngleAtObsCopy.r(3))
         axisxyz.x = ObsSites(aTrack.where).pos.xyz.x -
     *                      len*DcAtObsXyz.r(1)
         axisxyz.y = ObsSites(aTrack.where).pos.xyz.y -
     *                      len*DcAtObsXyz.r(2)
         axisxyz.z = ObsSites(aTrack.where).pos.xyz.z -
     *                      len*DcAtObsXyz.r(3)
c              
cok             write(0,*) ' h=',h, ' len =',len, ' cos=',
cok     *               -AngleAtObsCopy.r(3)
cok             write(0,*) ' axis at  depth =',
cok     *               ObsSites(aTrack.where).pos.depth
cok             write(0,*) ' is  x,y,z=', ObsSites(aTrack.where).pos.xyz.x,
cok     *             ObsSites(aTrack.where).pos.xyz.y,
cok     *             ObsSites(aTrack.where).pos.xyz.z
cok             write(0,*) ' ptcl pos=',iTrack.pos.xyz.x,
cok     *           iTrack.pos.xyz.y, iTrack.pos.xyz.z
cok             write(0,*) ' dz=',DcAtObsXyz.r(3)
cok             write(0,*) ' axisxyz.x, y, z=', axisxyz.x, 
cok     *                   axisxyz.y, axisxyz.z

         if(ObsPlane .eq. horizontal) then
            call cxyz2det(axisxyz,
     *                 aTrack.pos.xyz, oxyz)
         elseif(ObsPlane .eq. perpendicular) then
            call cxyz2prim(axisxyz,
     *                 aTrack.pos.xyz, oxyz)
         endif
         dist = sqrt( oxyz.x**2+ oxyz.y**2)
         far= dist  .gt. rfar
      else
         far=.false.
      endif
c           ////////////////

      if(dothin) then 
         if(iTrack.pos.depth .gt. depth2) then
            relax = deepfactor
         elseif(far) then
             relax = farfactor
c            if( dist .lt. 10.) then
c               relax = farfactor
c            elseif ( dist .lt. 20.) then
c               relax = farfactor*0.3
c            elseif ( dist .lt. 100.) then
c               relax = farfactor*0.1
c            else
c               relax = farfactor*0.03
c            endif
         else
            relax = 1.
         endif
         iergpn = iTrack.p.fm.p(4)
ccc               kinetic or total  energy ?
ccc           by 100 TeV e- pirmary  case, total seems better.
ccc         if( iTrack.p.code .eq. knuc .and. 
ccc     *       iTrack.p.subcode .ne. antip) then
ccc            iergpn = iTrack.p.fm.p(4) - iTrack.p.mass
        if(iTrack.p.code .eq. kgnuc) then
c            iergpn = (iergpn-iTrack.p.mass)/iTrack.p.subcode
            iergpn = iergpn/iTrack.p.subcode
        endif

c         if(aTrack.p.code .eq. knuc .and.
c     *      aTrack.p.subcode .ne. antip) then
c            aergpn = aTrack.p.fm.p(4) - aTrack.p.mass
c         elseif(aTrack.p.code .eq. kgnuc) then
         aergpn = aTrack.p.fm.p(4) 
         if(aTrack.p.code .eq. kgnuc) then
c            aergpn = (aergpn-aTrack.p.mass) / aTrack.p.subcode
            aergpn = aergpn / aTrack.p.subcode
         endif
c        ----------------
         if( aTrack.p.code .le. kelec ) then
            jj = 1
         else
            jj = 3
         endif
         if( iTrack.p.code .le. kelec ) then
            ii = 1
         else
            ii = 3
         endif
c      
c      
         if(iergpn .gt. Ethin(ii)*relax ) then
            if(aergpn .gt. Ethin(jj)*relax) then
c                    Both   Ei, Ec> Ethin1; no thinning
               icon = 0
               aTrack.wgt = iTrack.wgt
c         elseif(aergpn .gt. Ethin(2)) then 
            else
#if EXACTWGT == 1
               p = aergpn/(Ethin(jj)*relax)
               if( iTrack.wgt/p .lt. Ethin(jj+1)*relax) then
#else
               if( aTrack.wgt .lt. Ethin(jj+1)*relax) then
                  p = aergpn/(Ethin(jj)*relax)
#endif

                  call rndc(u)
                  if(u .lt. p)  then
                     icon = 0
                     aTrack.wgt = iTrack.wgt / p
                  else
                     icon = 1
                  endif
               else
                  icon = 0
                  aTrack.wgt = iTrack.wgt 
               endif
            endif
         else
            if(aergpn .gt. Ethin(jj)*relax) then
               aTrack.wgt = iTrack.wgt
               icon = 0
            else
#if EXACTWGT == 1
               p = aergpn/iergpn
               if( iTrack.wgt/p .lt. Ethin(jj+1)*relax ) then
#else  
               if( aTrack.wgt .lt. Ethin(jj+1)*relax ) then
                  p = aergpn/iergpn
#endif

                  call rndc(u)
                  if(u .lt. p ) then
                     icon = 0
                     aTrack.wgt = iTrack.wgt / p
                  else
                     icon = 1
                  endif
               else
                  icon =0
                  aTrack.wgt = iTrack.wgt
               endif
            endif
         endif
      else
         icon = 0
         aTrack.wgt = iTrack.wgt
      endif

      end
