c     ******************************************************************
c     *                                                                *
c     * cobAS: creates air shower from a given electron and observes it*
c     *                                                                *
c     ******************************************************************
c
c
      subroutine cobAS(el)
      implicit none
#include "Ztrack.h"
#include "Zobs.h"
#include "Zobsv.h"
#include "Zelemagp.h"

      record /track/ el    ! an electron to produce A.S

      integer l, j
      integer never
      real*8  zobas, zp,  clenbetween2h, length, clen2thick
      real*8  t, elog, eno, age
      real*8  enoc/1./
c /////////
      real*8 sintemp1, sintemp2
c ///////
      logical downgoing
      integer lb, le, ls
      save never
      data never/0/

      zp = el.pos.depth      ! depth of electron
      downgoing = el.vec.coszenith .gt. 0.d0
      if(downgoing) then
         lb = 1
         le = NoOfASSites
         ls = 1
      else
         lb = NoOfASSites
         le = 1
         ls = -1
      endif
      do   l=lb, le, ls
c           vertical depth kg/m2
        zobas=ASObsSites(l).pos.depth

        if( (zp .lt. zobas  .and. downgoing)
     *   .or. ( zp .gt. zobas .and. .not. downgoing) ) then
c            electron will cross A.S site.
c               thickness to r.l
            if(abs(el.vec.coszenith) .gt. 0.5) then
               t=abs(zobas-zp)/X0/abs(el.vec.coszenith)
            else
c                  error check: since A.S plane is
c                  spherical surface, particle may not pass
c                  the next surface.  (if completely horizontal,
c                  it should pass)
               sintemp1 = sqrt(1.d0-  el.vec.coszenith**2)
               sintemp2 = el.pos.radiallen * sintemp1/
     *                    ASObsSites(l).pos.radiallen
               if( sintemp2 .le. 1.d0) then
c                 slant length between two depths
                  length = clenbetween2h(el.pos.radiallen, 
     *                  ASObsSites(l).pos.radiallen,
     *                  el.vec.coszenith)
                  t = clen2thick(el.pos.height, el.vec.coszenith,
     *                        length) / X0
               else
c                   particle dose not cross the surface. neglect A.S
                  CompASNe(l) = 0.
                  CompASAge(l) = 0.
                  goto 500
               endif
            endif
c                log of electron energy in unit of critical energy
            elog = log10(el.p.fm.p(4)/Ecrit) 
c                        !-get ne and age
            call cNeByApproxB(3, elog, t,   eno, age)
c                 count ne
c                 if thins=T, wgt may be diff. from 1.
            eno=eno*el.wgt
c
            CompASNe(l) = eno
            CompASAge(l) = age
c
            ASObsSites(l).esize=ASObsSites(l).esize + eno
            ASObsSites(l).age = ASObsSites(l).age + eno*age
            if(eno .lt. enoc) then
c             ne is very small
               if( age .gt. 1.) then
c                     old so that cannot become larger; discard it
                  do j = l+ls, le, ls
                     CompASNe(j) = 0.
                     CompASAge(j) = 2.
                  enddo
                  goto 600
               else
c                    age is young, a.s might become larger
               endif
            else
c                  ne is large.  if needed, lateral obs.
            endif
         else
            CompASNe(l) = 0.
            CompASAge(l) = 0.
         endif
 500     continue
      enddo
  600 continue
      if(never .ne. 1) then
         call chookHybAS(el, never)
      endif
      end
