#include "ZcheckPHITS.h"
      subroutine cphits(pj0, ia0, iz0, sig, a, ntp)
      implicit none
#include "Zcode.h"
#include "Zptcl.h"
      record /ptcl/pj0           ! input. projectile.
      integer,intent(in)::ia0    ! target A (nucleon #)
      integer,intent(in)::iz0    ! target Z
      real(8),intent(in)::sig   ! cross-setion (mb) on this target
                         ! current  qmd00  dose not use but may  be
                         ! better to give it
	record /ptcl/ a(*)  ! output. produced particles
	      ! supoose Fe+Bi collsion.  If all Fe 
              ! nucleon of energy 4 GeV collide and produce
              !( 2pions + n  )*56 + 200 n; 3*56+200 = 380; max size of a.

	integer,intent(out):: ntp   ! total number of produced ptcls
	integer n, i, j

	integer code, subcode, charge
	integer ityp,ktyp
	real(8):: KEpn
        real(8):: u
        real(8):: totxs,  elaxs
        integer:: icon
        integer:: inela  ! used to select only inela event for Jam

        record /ptcl/tgt, pj
        integer ia, iz
        logical exchange

        real(8),parameter::KEpnB=1.500  ! GeV/n (KE). below this pA or Ap
                                        ! Bertin is usd. 
        real(8),parameter::KEneucpro=1.0  ! n+p, use Bertin below this and Jqmd above this
                !        for  np use jqmd

        KEpn =( pj0.fm.p(4) - pj0.mass )
        if( pj0.code == kgnuc) then
           KEpn= KEpn/pj0.subcode
        endif


        if( pj0.code == kgnuc .and.  ia0 == 1 ) then
!             Ap or An collision. treat it as pA or nA 
           exchange = .true.
!             reverse the Pj and Traget;
!              first,  make tgt
           call cmkptc(knuc, -1, iz0, tgt)
           tgt.fm.p(1:3)= 0.
           tgt.fm.p(4) = tgt.mass
!              see tgt from pj0 and save it in pj
           call cbst1(1, pj0, tgt, pj)
c/////////////
c           write(0,*) ' proton seen from pj0 '
c           write(0,'(4f8.1)') pj.fm.p(1:3)*1000., 
c     *                       (pj.fm.p(4)-pj.mass)*1000
c///////////////////
!              make tgt
           ia = pj0.subcode
           iz = pj0.charge
        else
           exchange =.false.
           pj = pj0
           ia = ia0
           iz = iz0
        endif
           

	code = pj.code
	subcode  = pj.subcode
	charge = pj.charge


	call ccos2phits(code, subcode, charge, ityp, ktyp)
        if( code == knuc  ) then
           if( subcode /= antip ) then
              call rndc(u)
              call cphitsXs(pj, ia, iz, elaxs, totxs,icon)
              if(icon == -1) then
                 ntp = 0
              else 
                 if(u < elaxs/totxs .and. .not. exchange ) then
                     ! elastic. for Ap or An case, only inela. 

#if defined (CHECKPHITS)
                    write(0,*) ' entering elastic: pj=',
     *                  pj.code, pj.charge
#endif
                    call cnelas(pj, ia, iz, a, ntp)

#if defined (CHECKPHITS)
                    call cprintptcl(1,'after cnelas')
#endif
                 else

                    if( ( KEpn < KEpnB .and. ia > 1)  .or.
     *                  ( ia == 1 .and.  KEpn < KEneucpro) ) then

#if defined (CHECKPHITS)
                       write(0,'(a, 3i6, 1p,g12.4)')
     *                 ' entering cbertin pj code & KE(MeV)=',pj.code,
     *                  pj.subcode, pj.charge, (pj.fm.p(4)-pj.mass)*1.e3
                       write(0,*) ' target A,Z=', ia, iz
#endif

                       call cbertini(pj, ia, iz, sig, a, ntp)

#if defined (CHECKPHITS)
                       call cprintptcl(2, 'after cbertini 1')
#endif

                    else
                       call cjqmd(pj, ia, iz, sig, a, ntp)

#if defined (CHECKPHITS)
                       call cprintptcl(2, 'after cjqmd 2')
#endif

                    endif
                 endif
              endif
           else

#if defined (CHECKPHITS)
              write(0,'(a, 3i6, 1p,g12.4)')
     *             ' entering cbertin pj code & KE(MeV)=',pj.code,
     *             pj.subcode, pj.charge, (pj.fm.p(4)-pj.mass)*1.e3
              write(0,*) ' target A,Z=', ia, iz
#endif
              call cjqmd(pj, ia, iz, sig, a, ntp)

#if defined (CHECKPHITS)
              call cprintptcl(2, 'after cjqmd 1')
#endif
c////////////////
c           if( pj.code == 6 .and. pj.subcode == antip .and.
c     *        pj.charge == -1 .and. pj.fm.p(4) - pj.mass <= 0.)
c     *         then
c              write(0,*) '1  sig=',sig, ' ntp=',ntp
c              do i = 1, ntp
c                 write(0,*)  a(i).code, a(i).fm.p(4)
c              enddo
c           endif
c//////////////
           endif
        elseif( code == kpion ) then

#if defined (CHECKPHITS)
           write(0,*) ' pion enters cbertini'
           write(0,'(a, i3, 1p,g12.4)') ' chg  KE(MeV)=', pj.charge, 
     *         (pj.fm.p(4)-pj.mass)*1.e3
           write(0,*) ' target,A,Z=', ia, iz
#endif

           call cbertini(pj, ia, iz, sig, a, ntp)

#if defined (CHECKPHITS)
           call cprintptcl(2,'after cbertini 2')
#endif

        else

#if defined (CHECKPHITS)
           write(0,'(a, 3i6, 1p, g12.4)')
     *        ' Entering jqmd, pj & KE(MeV)=',pj.code,
     *         pj.subcode, pj.charge,
     *         (pj.fm.p(4)-pj.mass)*1.e3
           write(0,*) ' target,A,Z=', ia, iz
#endif

           call cjqmd(pj, ia, iz, sig, a, ntp)

#if defined (CHECKPHITS)
           call cprintptcl(2, 'after cjqmd 2')
#endif

c////////////////
c           if( pj.code == 6 .and. pj.subcode == antip .and.
c     *        pj.charge == -1 .and. pj.fm.p(4) - pj.mass <= 0.)
c     *         then
c              write(0,*) '2 sig=',sig, ' ntp=',ntp
c              do i = 1, ntp
c                 write(0,*)  a(i).code, a(i).fm.p(4)
c              enddo
c           endif
c//////////////
        endif
        if( exchange ) then
           !    move to reset system of pj0
           do i = 1, ntp
#if defined (CHECKPHITS)
              write(0,'(a,1p,4g12.4)') 'bef ibst: pj0 rest system', 
     *          a(i).fm.p(1:3)*1000., 
     *          (a(i).fm.p(4)-a(i).mass)*1000.
#endif
              call cibstPol(i, pj0, a(i), a(i))  ! output canbe a(i)

#if defined (CHECKPHITS)
              write(0,'(a,4f7.1)') 'aft ibst;orig sys. ', 
     *          a(i).fm.p(1:3)*1000., 
     *          (a(i).fm.p(4)-a(i).mass)*1000.
#endif

           enddo
        endif

        end subroutine
      subroutine cphitsXs(pj, ia, iz, elaxs, totxs, icon)
      use jqmd
      use bertini
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zmass.h"

      record /ptcl/ pj  ! input projectile
      integer,intent(in)::ia,iz  ! target A,Z
      real(8), intent(out):: elaxs
      real(8),intent(out):: totxs   ! xs in mb
                                 ! for p,n total (inela + elaxs)
                                 ! for Heavy  inela, elaxs =
      integer,intent(out):: icon ! =0; oK =-1; N.G

      integer::incp
      real(8),save:: EkMeV, inelaxs
      real(8)::ap,zp,ep,at,zt,bmax

c            used to judge elastic or inela in cphits
      integer,save:: nstrange=0



      if(pj.code == knuc ) then
         EkMeV =( pj.fm.p(4) - pj.mass) *  1000.d0
         if(pj.charge == 1 ) then
            incp = 1
         elseif(pj.charge == 0 .and. pj.subcode == regptcl) then
            incp = 2
         else
            nstrange = nstrange + 1
            if( nstrange < 10) then
               write(0,*) 'in cphits: code, subc, charge=', pj.code,
     *             pj.subcode, pj.charge
               write(0,*) ' strange; neglect  '
            elseif( nstrange > 100 ) then
               write(0,*) ' too many strange ptcl in cphits'
               stop
            endif
            inelaxs = 0.
            elaxs = 0.
            icon = -1
            return
         endif
         call sigrc(incp, EkMeV, ia, iz, totxs, inelaxs, elaxs)
c             abvoe xs is in b.
      elseif(pj.code == kgnuc ) then
         ap = pj.subcode
         zp = pj.charge
         ep = pj.fm.p(4) * 1000.d0   ! total E in MeV
         at = ia
         zt = iz
!                use Shen's (or nasa) cross-section. (icrhi=0 in cprephists
!                  choose Shen's one (if it is  1-->Nasa XS)
!                elaxs = 0 always. bmax not used
         call sighi(ap,zp,ep,at,zt,inelaxs, elaxs,bmax)
         totxs =  inelaxs + elaxs
      else
         nstrange = nstrange + 1
         if( nstrange < 10 ) then
            write(0,*) 'in cphits: code, subc, charge=', pj.code,
     *        pj.subcode, pj.charge
            write(0,*) ' strange; neglected'
         elseif ( nstrange > 100) then
            write(0,*) ' too many strange ptcl in cphits'
            stop
         endif
         inelaxs = 0.
         elaxs = 0.
         icon = -1
      endif
      totxs  = totxs*1000.
      inelaxs = inelaxs *1000.
      elaxs = elaxs *1000.
      end subroutine
