c      *******************
      subroutine cintModels(from)
c
c           establish the energy bound for the given interaction model.
c          and corresponding init.
      implicit none
#include  "Zmanagerp.h"
#include  "Zmanager.h"
#include  "Zevhnp.h"
#include  "Zptcl.h"
#include  "Zevhnv.h"
      
      character*(*)  from  ! input. cosmos or epics ; from which 

      integer i, j
      character*100 path

      CosOrEpi = from
      call cgetTopDir   ! get Cosmos top dir and set it in Zmanager.h

      do i = 1, MaxIntMdls
         ModelList(i) = ' '
         InteErg(i) = 2.d12  ! GeV 10^21 eV
      enddo
c             ModelList       InteErg
c              "xxx"            100.
c              "yyy"            1.d12      ====>  xxx if E< 100  else yyy
c
c              "xxx"            1.d12      ====>  xxx at entier energy.
c
      IntModel(64:64) = '/'


      read(IntModel, *, Err=100)
     *    (ModelList(i), InteErg(i), i=1, MaxIntMdls)
      do i = 1, MaxIntMdls
         if(ModelList(i) .eq. ' ') then
            NoOfMdls = i-1
            goto 10
         endif
      enddo
      NoOfMdls = MaxIntMdls
 10   continue
      do i = 1, NoOfMdls-1
         if(InteErg(i) .ge. InteErg(i+1)) then
c                 energy region invalid
            call cerrorMsg(
     *           'IntModle is invalid; energy region not ascending', 1)
            call cerrorMsg(IntModel, 0)
         endif
      enddo
c         exam models
      do i = 1, NoOfMdls
         do j = 1, nmdls
            if( ModelList(i) .eq.  RegMdls(j) ) goto 20
         enddo
         call cerrorMsg( ModelList(i),  1)
         call cerrorMsg('above model is not yet registered', 0)
 20      continue
      enddo
c
      if( index(IntModel, 'fritiof1.6') .gt. 0 .or.
     *    index(IntModel, 'nucrin') .gt. 0  .or.
     *    index(IntModel, 'dpmjet3') .gt. 0  .or.
     *    index(IntModel, 'incdpm3') .gt. 0  .or.
     *    index(IntModel, 'jam') .gt. 0  ) then

c           for Lund init.  dpm may use Lund at low energy or
c                                    for some particles
         call haddenC
         call chanwnC
      endif
      if( index(IntModel, 'phits') .gt. 0  ) then
         call cprePhits
      endif
      if( index(IntModel, 'qgsjet2') .gt. 0 ) then
         call ciniQGS
      endif
      if( index(IntModel, 'epos') .gt. 0 ) then
         call ceposIniAll
      endif

      if( index(IntModel, 'incdpm3') .gt. 0 ) then
         call ciniincdpm3
      endif

      if( index(IntModel, 'gheisha' ) .gt. 0) then
c         Gheisha; init. Gheisha cannot use hadrin/nucrin in Cosmos
         call gpart
         call gheini
      endif
      if( index(IntModel, 'jam' ) .gt. 0) then
         ! nothing to do ?
      endif
      if( index(IntModel, 'dpmjet3') .gt. 0 .or.
     *    index(IntModel, 'incdpm3') .gt. 0  ) then
         if(from .eq. 'cosmos') then
            ! init for dpmjet.  for Cosmos
            ! If DpmFile is ' ',
            ! $COSMOSTOP/Data/atmos.inp is the control card for dpmjet3.
            If( DpmFile  .eq.  ' ' ) then
               call cformFullPath('atmos.inp', path)
               call cinidpmjet(path)
            else
               call cinidpmjet(DpmFile)
            endif
         elseif(from .eq. 'check') then
c           it is assumed that the Glauber file is
c           specified by prefix/...GLB

         elseif(from .eq. 'epics') then
c              dpmjet.inp is assumed in the same directory
c              as config file.
            call cformFullPath('dpmjet.inp', path)
            call cinidpmjet(path)
         else
            call cerrorMsg(from, 1)
            call cerrorMsg('above "from" in cintModels invalid',0)
         endif
      endif
      return

 100  continue
      call cerrorMsg(
     * 'IntModel syntax error; prob.missing " mark'//
     * ' for string; IntModel is', 1)
      call cerrorMsg(IntModel, 0)
      end

c           
c          next is for dpmjet file management.
c          dpmfiles for Epcis is assumed to be in the
c          same directory as config file resides so
c          extract the directory where the config file is.
      subroutine cfixPrefix(dsn)
      implicit none
#include "Zmanager.h"
      character*(*) dsn   ! input. config file name or path
c            output. PrefixConf= './' or '/.../.../' where
c                              config file exist.
c                    PrefixLeng is it's length. 
c      
c
      integer i, j, klena, k

      if( index(dsn, '/') .eq. 0 ) then
         PrefixConf = './'
         PrefixLeng = 2
      else
c             find last '/'
         i = klena(dsn)
         do j = i, 1, -1
            k = index(dsn(j:j), '/')
            if( k .gt. 0 ) then
               PrefixConf = dsn(1:j)
               PrefixLeng = j
               goto 33
            endif
         enddo
      endif
 33   continue
      end
c         ***********  get Cosmos Top director
c             and set it in TopDir in Zmanager.h
      subroutine cgetTopDir
      implicit none
#include "Zmanager.h"


      character*1 NULL
      integer  kgetenv

      NULL = char(0)
      TopDir = ' '
      TopDirLeng = kgetenv("COSMOSTOP"//NULL, TopDir)
      end

      subroutine csetCosOrEpi(from)
      implicit none
#include "Zmanager.h"
      character*(*) from   !  input. cosmos or epics
       CosOrEpi = from
       end

      subroutine cformFullPath(file, path)
      implicit none
#include "Zmanager.h"
      character*(*) file   !  input. file name
      character*(*) path   ! output. $COSMOSTOP/Data/DPM/file  
      integer klena

      path = ' '

      if(CosOrEpi .eq. 'cosmos') then
         path = TopDir(1:TopDirLeng)//'/Data/DPM/'
     *     //file(1:klena(file))
      elseif(CosOrEpi .eq. 'epics' .or. CosOrEpi .eq. 'check') then
         path = PrefixConf(1:PrefixLeng)//file(1:klena(file))
      else
         call cerrorMsg(
     *   "cintModels('cosmos') or cintModels('epics')"//
     *   " must have been called ", 0)
      endif

      end
