c       mu---> e + neue + neumu; inclusive treatment 
c      some kind of Exclusive treatment
c     
      subroutine cmuNeuDcy(pj, polari, inclusive, a, np)
      implicit none

#include  "Zptcl.h"
#include  "Zmass.h"
#include  "Zcode.h"
      
      integer np     ! output.  no. of produced particles
      real*8 polari  ! input.   muon polarization
      integer inclusive !input.  0--> inclusive treatment
                        !       >0--> Exclusive treatment
                        !   Only Electron is correctly sampled
                        !   4 momenta of two neutrinos are sampled
                        !   so that the total 4 momentum be conserved.
                        !   Since the formula assumes Me=0, we 
                        !   add electron mass to the total energy
      record /ptcl/pj  ! input. muon
      record /ptcl/ a(*)  ! output.  produced ptcls
c
      record /ptcl/ twoNeu
      real*8 po, f, ecm, cosa, lam
      integer  i, charge, subcode
      logical  try
   
      real*8 pab

      try = .true.
c           make 3 ptcls; neu_e, neu_mu, e
      subcode = -pj.charge
      call cmkptc(kneue, subcode, 0, a(1))
      subcode = pj.charge
      call cmkptc(kneumu, subcode, 0, a(2))
      charge = pj.charge
      call cmkptc(kelec, 0, charge,  a(3))
      if(pj.charge .eq. 1) then
c                for mu+, polarization should be made to inverse sign
c                because e+ goes same as mu+ polarizaion while
c                neue trino opposit.
         po=-polari
      else
         po=polari
      endif
      do while ( try )
c           we fix electron first which is detectabl
c               electron ; paralell to neu_mu
c         x^2(3-2x + (1-2x)Pcos) dxdcos
c            first integrate by cos and get energy distribution
c         x^2(3-2x) dx =2x^2(1-x)+x^2: this is the same as  neu_mu energy
c            (f=x=2E/Mmu)

         call csNeumuEMu(f)
         ecm=f*pj.mass/2
         if(ecm .le. a(3).mass) cycle
            
c         angluar distribution is
c        ( 1 + lam* cos ) dcos type
c
         lam = (1.-2*f)/(3.-2*f) *po

         call ksampLin(lam, 1.d0, -1.d0, 1.d0, cosa)
c             set px,py,pz
         pab =sqrt( ecm**2 - a(3).mass**2 )
         call cpCos2pxyz(cosa, pab, a(3).fm)
         a(3).fm.p(4) = ecm
c         -------------
         if( inclusive .eq. 0 ) then
c            inclusive treatment
c           sample energy in f=2e*/mmu: e* is at muon rest sytem
c           of neue
            call csampNeueEMu(f)
            ecm=f*pj.mass/2 
c              sample decay angle of neue at muon rest system
c            (1+Pcos)dcos
            call ksampLin(po, 1.d0, -1.d0, 1.d0, cosa)
c              set random momentum about azimuth (px,py,pz)
            call cpCos2pxyz(cosa, ecm, a(1).fm)
            a(1).fm.p(4) = ecm
c                 since inclusive, no conservation tried
c          neumu; sample energy in f=2e*/mmu: e* is at muon rest sytem
            call csNeumuEMu(f)
            ecm=f*pj.mass/2
c              sample decay angle of neumu at muon rest system
c             (1+lambda P cos) dcos with
c             lambda = (1-2f)/(3-2f)
            lam=(1.-2*f)/(3.-2*f)
            call ksampLin(lam*po, 1.d0, -1.d0, 1.d0, cosa)
c             set px,py,pz
            call cpCos2pxyz(cosa, ecm, a(2).fm)
            a(2).fm.p(4) = ecm
         else
c             exclusive; but not possible
c             we are interested in only electron energy so that
c             other two neus are sampled from remaining  4 momenta
            twoNeu.fm.p(4) = pj.mass - a(3).fm.p(4)
            if(twoNeu.fm.p(4) .le.  0.) cycle
            twoNeu.fm.p(1) = - a(3).fm.p(1)
            twoNeu.fm.p(2) = - a(3).fm.p(2)
            twoNeu.fm.p(3) = - a(3).fm.p(3)
            twoNeu.mass =
     *        sqrt( pj.mass**2 -2*pj.mass*a(3).fm.p(4) + a(3).mass**2)

            call c2bdcy(twoNeu, a(1), a(2))

c              another choice may be to sample all 3 by inclusive way
c           and forced conservation by next conformal transformation
c            call cnbdc2(3, pj.mass, a)
c             since we assume massless ; no further transformation
c             is needed
         endif
c **************
c         pab =sqrt(a(3).fm.p(1)**2 + a(3).fm.p(2)**2
c     *   + a(3).fm.p(3)**2 )
c         write(*,'("cm ",5G14.5)' ) 
c     *   a(1).fm.p(4)+a(2).fm.p(4)+a(3).fm.p(4),
c     *   2* a(3).fm.p(4)/pj.mass, a(3).fm.p(3)/pab,
c     *   po, lam
c     *   a(1).fm.p(1)+a(2).fm.p(1)+a(3).fm.p(1),
c     *   a(1).fm.p(2)+a(2).fm.p(2)+a(3).fm.p(2),
c     *   a(1).fm.p(3)+a(2).fm.p(3)+a(3).fm.p(3)
c *************
         np = 3
c               boost to lab.
         do i = 1, np
            call cibstPol(i, pj, a(i), a(i) )
         enddo
c  ***************
c         write(*,'("lb ",4G14.5)' ) 
c     *   a(1).fm.p(4), a(2).fm.p(4), a(3).fm.p(4), 
c     *   a(1).fm.p(4)+a(2).fm.p(4)+a(3).fm.p(4)
c ***************
c         since approximation here is to assume Me=0
c         we get Ee < Me sometimes (normally 5/10^5 or less )
c         so we reject such an event
         try =  a(3).fm.p(4) .le. a(3).mass
      enddo
      end
