      subroutine sibyllinit
      implicit none
#include "Zcode.h"
#include "Zptcl.h"
#include "Zmass.h"
c
c
      record /ptcl/ pj
      integer ntp
      integer ia, iz
      record /ptcl/ a(8000)
      integer NP, LLIST
      real   P
      COMMON /S_PLIST/ NP, P(8000,5), LLIST(8000)
      COMMON /S_CLDIF/ LDIFF
      INTEGER          LDIFF
      COMMON /S_CSYDEC/IDB(49), CBR(102), KDEC(612), LBARP(49)
      REAL             CBR
      INTEGER          IDB,KDEC,LBARP
      integer  KODFRAG                  
      COMMON /CKFRAG/ KODFRAG                  

      record /ptcl/b(5)
      integer k, i, L

      integer  icp, iat
      integer  j
      real*8  E0, Ecm, g, beta, Eg
      real  sqs

      KODFRAG =3  ! complex fragmentation by Abrasion-ablation model
      LDIFF = 0   ! mix diff and non-diff
      call SIBYLL_INI
      call SIGMA_INI
      call NUC_NUC_INI
!      call INI_WRITE(0) !!!!! print pAir xsec.
c        don't let mu, pi, K decay;
      do  i = 4, 12
         IDB(i) = -IDB(i)
      enddo
c            short life particle decay is managed by Gencol2
c          
c       same for eta
      IDB(23)  = -IDB(23)
c       same for  SIGMA, XI, LAMBDA
c      do  i = 34, 39
      do  i = 34, 36
         IDB(i) = -IDB(i)
      enddo
      IDB(39) = -IDB(39)
c/////////
c      IDB(34) = abs(IDB(34))
c///////
      return
c     ****************
      entry  sibyllevent(pj, ia, iz, a, ntp)

      call ccoscode2sibyll(pj, icp)

      iat =  ia !  target mass number
      if(pj.code .eq. kgnuc) then
         E0 = pj.fm.p(4)/pj.subcode !  GeV in Lab
         Ecm = sqrt( ( E0 +masp )*2*masp )
      else
         E0 = pj.fm.p(4)
         Ecm = sqrt( E0*2*masp + pj.mass**2 + masp**2)
      endif

      sqs = Ecm
      g = (E0 + masp)/Ecm
      beta = sqrt( (g-1.d0) * (g + 1.d0)) /g
      if( pj.code /= kgnuc ) then
         call SIBYLL(icp, iat, sqs)
      else
         call SIBNUC( icp, iat, sqs)
      endif
      call DECSIB               !  all unfamilier ptcls should decay
      ntp = 0 
      do  j = 1, NP
         if(abs(LLIST(j)) .lt. 10000) then
            ntp = ntp + 1   
            a(ntp).fm.p(1)=P(j, 1)
            a(ntp).fm.p(2)=P(j, 2)
            a(ntp).fm.p(3)=P(j, 3)
            a(ntp).fm.p(4)=P(j, 4)
            a(ntp).fm.p(3) = g* (P(j, 3) + beta*P(j, 4)) 
            a(ntp).fm.p(4) = g* (P(j, 4) + beta*P(j, 3))
c            L = mod(LLIST(j), 10000)
            L = LLIST(j)
            call csibyllcode2cos(L, a(ntp))
         endif
      enddo
      call crot3mom(pj, a, ntp)
      end
       real  function  S_RNDM(X)
       integer  X  !  not used
       real*8 u
       call rndc(u)
       S_RNDM = u
       end
       subroutine ccoscode2sibyll(pj, ksib)
#include "Zptcl.h"
#include "Zcode.h"
      record /ptcl/ pj
      integer ksib
c
c      projectiel 7,8,  9,10, 11,12, 13,14, -13,-14
c                 pi+-,  K+-,  KL,KS, p,n,  pbar,nbar
      
      if( pj.code .eq. knuc ) then
         if( pj.charge .eq. 1) then
            ksib = 13
         elseif(pj.charge .eq. -1) then
            ksib = -13
         elseif( pj.charge .eq. 0) then
            if( pj.subcode .eq. antip ) then
               ksib = -14
            else
               ksib = 14
            endif
         endif
      elseif( pj.code .eq. kpion ) then
         if( pj.charge .eq. 1 ) then
            ksib = 7
         elseif( pj.charge .eq. -1 ) then
            ksib = 8
         else
            ksib = 6
         endif
      elseif( pj.code .eq. kkaon ) then
c   9 K+    10 K-  11  K0L   12 K0s
         if( pj.charge .eq. 1 ) then
            ksib= 9
         elseif( pj.charge .eq. -1 ) then
            ksib = 10
         elseif( ksubcode .eq. k0s ) then
            ksib = 12
         else
            ksib = 11
         endif
      elseif( pj.code == kgnuc) then
         ksib = pj.subcode
      else
         write(0,*) 
     *    ' code =',pj.code, ' not acceptable in sibyll'
         stop 12345
      endif
      end
      subroutine csibyllcode2cos(ksibin, pj)
#include "Zptcl.h"
#include "Zcode.h"
      integer ksibin
      record /ptcl/ pj
c
      real*8 u 
      integer ksib, code, subcode, charge

      ksib = abs(ksibin)
      subcode = regptcl
      if(ksib .eq. 1) then
         code = kphoton
         charge = 0
      elseif(ksib .eq. 2) then
         code = kelec
         charge = 1
      elseif(ksib .eq. 3) then
         code = kelec
         charge = -1
      elseif(ksib .eq. 4) then
         code = kmuon
         charge = 1
      elseif(ksib .eq. 5) then
         code = kmuon
         charge = -1
      elseif(ksib .eq. 6) then
         code = kpion
         charge = 0
      elseif(ksib .eq. 7) then
         code = kpion
         charge = 1
      elseif(ksib .eq. 8) then
         code = kpion
         charge = -1
      elseif(ksib .eq. 9) then
         code = kkaon
         charge = 1
      elseif(ksib .eq. 10) then
         code = kkaon
         charge = -1
      elseif(ksib .eq. 11) then
         code = kkaon
         charge = 0
         subcode = k0l
      elseif(ksib .eq. 12) then
         code = kkaon
         charge = 0
         subcode = k0s
      elseif(ksib .eq. 13) then
         code = knuc
         subcode = regptcl
         charge = 1
      elseif(ksib .eq. 14) then
         code = knuc
         charge = 0
         subcode = regptcl
      elseif(ksib .eq. 15) then
         code = knue
         subcode = regptcl
         charge = 0
      elseif(ksib .eq. 16) then
         code = knue
         subcode = antip
         charge = 0
      elseif(ksib .eq. 17) then
         code = knumu
         subcode = regptcl
         charge = 0
      elseif(ksib .eq. 18) then
         code = knumu
         charge = 0
         subcode = antip
      elseif(ksib .eq. 19) then
         code = knuc
         charge = -1
         subcode = antip
      elseif(ksib .eq. 20) then
         code = knuc
         charge = 0
         subcode = antip
      elseif(ksib .eq. 21) then
         code = k0
         call rndc(u)
         charge = 0
         if(u .lt. 0.5) then 
            subcode = k0s
         else
            subcode = k0l
         endif
      elseif(ksib .eq. 22) then
         code = k0
         charge = 0
         if(u .lt. 0.5) then 
            subcode = k0s
         else
            subcode = k0l
         endif
      elseif(ksib .eq. 23) then
         code = keta
         charge = 0
      elseif(ksib .eq. 25) then
         code = krho
         charge = 1
      elseif(ksib .eq. 26) then
         code = krho
         charge = -1
      elseif(ksib .eq. 27) then
         code = krho
         charge = 0
      elseif(ksib .eq. 33) then
         code = kphi
         subcode = regptcl
         charge = 0
      elseif(ksib .eq. 34) then
         code = ksigma
         subcode = regptcl
         charge = 1
      elseif(ksib .eq. 35) then
         code = ksigma
         subcode = regptcl
         charge = 0
      elseif(ksib .eq. 36) then
         code = ksigma
         subcode = regptcl
         charge = -1
      elseif(ksib .eq. 37) then
         code = kgzai
         subcode = regptcl
         charge = 0
      elseif(ksib .eq. 38) then
         code = kgzai
         subcode = regptcl
         charge = -1
      elseif(ksib .eq. 39) then
         code = klambda
         subcode = regptcl
         charge = 0
      else
         write(0,*) ' ****************sibyllcode=',ksib, ksibin
         code = krare
         charge = 0
         subcode = regptcl
      endif
      if(ksibin .lt. 0) then
         subcode = antip
         charge = - charge
      endif
      call cmkptc(code, subcode, charge, pj)
      end
      subroutine sibylGetDiffCode(nwout, difcode)
      implicit none
c    in case of nuclei for each interaction]. The meaning is
C.       JDIF(JW)  = diffraction code    !!!! changed to field !!!!
C.                  (0 : non-diffractive interaction) 
C.                  (1 : forward diffraction)     
C.                  (2 : backward diffraction) 
C.                  (3 : double diffraction)  
      integer,intent(out):: nwout !    
      integer,intent(out):: difcode(20)
c          for p/n projectile,nw =1, difcode(1) shows the                      
c          diffraction state.                                                  
      integer NW_max, NS_max, NH_max, NJ_max
      PARAMETER (NW_max = 20)
      PARAMETER (NS_max = 20, NH_max = 50)
      PARAMETER (NJ_max = (NS_max+NH_max)*NW_max)
      real(4):: X1J, X2J, X1JSUM, X2JSUM, PTJET, PHIJET
      integer:: NNPJET, NNPSTR, NNSOF, NNJET, JDIF, NW, NJET, NSOF

      COMMON /S_CHIST/ X1J(NJ_max),X2J(NJ_max),
     &    X1JSUM(NW_max),X2JSUM(NW_max),PTJET(NJ_max),PHIJET(NJ_max),
     &    NNPJET(NJ_max),NNPSTR(2*NW_max),NNSOF(NW_max),NNJET(NW_max),
     &    JDIF(NW_max),NW,NJET,NSOF

      nwout = NW
      difcode(1:nwout)=JDIF(1:nwout)
      end
