c      Calculate standard atmospher constants.
c   stdatmos1.d is used to compute the consts.
c
c    This program outputs the following quantity, which may be saved in
c    stdatmos2.d which in turn is used by cstdatmos0.f to manage
c    atmosphere in the vertical direction.
c
c     height, temperature, pressure, rho, Anode, d0, dsum, H
c
c     all in mks unit.
c       dsum:  amount of atmospher above the node.
c       d0:    see the formula below.
c       Anode:  a in the formula below.
c
c     The scale height is approximated by a
c   number of stright lines as a function of height. The data in
c   stdatmos1.d gives height, temperatur, etc at  each nodal point.
c
c         The scale height, H, is expressed by H = H0 + a(z-z0)
c                                                = kT/mg      
c   in each region.
c   We neglect height dependence of gravitational accelleration g,
c   and the average mass of  air molecules, m.   
c   Since the data table gives T(z)= T0 + b(z-z0) at the nodal points, 
c   we can first get b,
c   and then a by a = dH/dz = k/mg * b.  H at a nodal point, z,  
c   is obtained as H(z) =kT(z)/mg.
c   The density is given by
c              rho = rho0 * (1+ a(z-z0)/H(z0))**(-1-1/a)      (a != 0)
c                  = rho0 * exp(- (z-z0)/H)            (a =0; hence H is const)
c
c   (We employ H(z0) as the scale height in the segment)
c   The gramage between  given heights, z1 and z2  is by
c
c              d = d0 *(fd(z1) - fd(z2))  where
c         
c            fd(z) = (1+ a(z-z0)/H(z0))**(-1/a)                   (a != 0)
c
c                  =  exp(-(z-z0)/H )                             (a = 0)
c
c   where  d0 = rho0*H(z0)
c
c    
      implicit none

#include  "Zmanagerp.h"
#include  "Zglobalc.h"
#include  "Zearth.h"
#include  "Zatmos.h"

      integer icon, i,ios

      

      real*8 m, g, k, nuc, c2, kbymg, dtdz
c      m: avrage molecule mass number of air
c      g: gravitational acceleration.
c      k: Boltzman's const.
c     c2: c**2
      parameter( m=14.5 *2, nuc =938.3e6, g=9.80665, c2=c*c,
     *          k= 8.617e-5, kbymg = k*c2/(m*nuc*g))

#include  "Zstdatmosf.h"


c        read basic data
      call copenf(TempDev, "../Data/Atmos/stdatmos1.d", icon)
      if(icon .ne. 0) stop 9999
      call cskipComment(TempDev, icon)
      if(icon .ne. 0) stop 9999
c
      nodes = 0
      do while(1 .gt. 0 )
         read(TempDev, *, iostat=ios)
     *   Znode(nodes+1), Tnode(nodes+1), Pnode(nodes+1),
     *   Rhonode(nodes+1)
         if(ios .ne. 0) goto 10
         nodes = nodes + 1
      enddo
 10   continue
      close(TempDev)
      write(*, *) "# of nodal points =", nodes, " kbymg=", kbymg

      do i = 1, nodes-1
         dtdz = (Tnode(i+1) - Tnode(i))/ (Znode(i+1) - Znode(i))
         Scalehnode(i) = kbymg * Tnode(i)                 ! at Znode(i)
         Bnode(i) = dtdz
         Anode(i) = kbymg * Bnode(i)
         D0node(i) = Rhonode(i) * Scalehnode(i)
c        write(*, *)
c    * Znode(i), D0node(i), Anode(i), Bnode(i), Scalehnode(i)
      enddo

      Dsumnode(nodes) =  0.

      do i = nodes-1, 1, -1
         if(Anode(i) .eq. 0.) then
c              exponential atmosphere
            Dsumnode(i) = Dsumnode(i+1) +
     *       D0node(i)*
c     *       (1.0- exp(-(Znode(i+1) - Znode(i))/Scalehnode(i)))
     *       (1.0- fd0(Znode(i+1), Znode(i), Scalehnode(i)))
         else
            Dsumnode(i) = Dsumnode(i+1) +
     *        D0node(i)*
     *        (1.0 -
     *          fd1(Znode(i+1), Anode(i),Znode(i), Scalehnode(i) ) )

c     *        (1.0+Anode(i)*(Znode(i+1) -Znode(i))/Scalehnode(i))
c     *        **(-1./Anode(i))
c     *         )
         endif
      enddo
c          height, temp, pres, Rhonode, Anode, D0node, Dsumnode, H
c       Dsumnode is the grammage above the node. all in mks unit.
      write(*,'(a)')
     * "# Height    Temp     Press   Rhonode',
     * '     Anode   D0node  Dsumnode    H"
      write(*,'(a)') "#-----------------------------------------"
      do i = 1, nodes-1
         write(*,
     *   '(8g14.5)')
     *   sngl(Znode(i)), sngl(Tnode(i)), sngl( Pnode(i)),
     *   sngl(Rhonode(i)), sngl(Anode(i)), sngl( D0node(i)),
     *   sngl(Dsumnode(i)), sngl(Scalehnode(i))
      enddo
      end


