      subroutine cfixModel( aPtcl )
      implicit none
c
c        fix hadronic interaction model (including 
c        photoproduction of hadrons, and possibly
c        muon nucear interaction).
c        and set ActiveMdl
c
#include "Zptcl.h"
#include "Zevhnp.h"
#include "Zevhnv.h"
#include "Zcode.h"

      record /ptcl/ aPtcl ! input. particle for hadronic interaction

      real*8 kepn 
      integer i

      kepn= aPtcl.fm.p(4)- aPtcl.mass
      if( aPtcl.code .eq. kgnuc ) then
         kepn =  kepn / aPtcl.subcode
      endif

      do i = 1, NoOfMdls
         if( kepn  .lt. InteErg(i)) then
            ActiveMdl = ModelList(i)
            goto 10
         endif
      enddo

      call cerrorMsg('IntModel list shown below is strange', 1)
      call cerrorMsg(IntModel, 1)
      call cpdpmjetinp
      write(0,*) ' current K.E/n=',kepn,
     *  ' code=',aPtcl.code, ' subcode=',
     *  aPtcl.subcode, ' charge=',aPtcl.charge
      write(0,*) '  NoOfMdls=', NoOfMdls
      do i = 1,  NoOfMdls
         write(0,*) ' i=', i, ' InteErg(i)=',
     *   InteErg(i)
      enddo
      stop 12345
 10   continue
c          for pbar or nbar, phits must be avoided (
c          dpmjet3 or jam is used instead)
      if( aPtcl.code == knuc .and.  aPtcl.subcode == antip ) then
         if(ActiveMdl == "phits" ) then
c             see if jam or dpmjet3 can be used, if not error
            do i = 1, NoOfMdls
               if(ModelList(i) == "jam") then
                  ActiveMdl= "jam"
                  goto 20
               elseif( ModelList(i) == "dpmjet3") then
                  ActiveMdl= "dpmjet3"
                  goto 20
               elseif( ModelList(i) == "nucrin") then
                  ActiveMdl= "nucrin"
                  goto 20
               endif
            enddo
c              error            
            write(0,*) ' for p-bar or n-bar, phits cannot be used'
            write(0,*) ' so that jam or dpmjet3 must be given in '
            write(0,*) ' the IntModel list: '
            write(0,*) ' jam or dpmjet3 is used even the ptcl '
            write(0,*) ' energy is lower than the one in IntModel'
            write(0,*) ' ptcl code=',aPtcl.code
            write(0,*) '  charge  =',aPtcl.charge
            write(0,*) '  subcode =',aPtcl.subcode
            write(0,*) '  Ek      =', kepn, ' GeV'
            stop 77777
         endif
      endif
 20   continue      
      end
c       
      subroutine cqActiveMdl(model)
      implicit none
c
c        inquire the current active model
c
#include "Zptcl.h"
#include "Zevhnv.h"

      character*16 model
      model = ActiveMdl
      end
