      subroutine ckf2cos(kf, code, subcode, chg)
c        kf code to cosmos code.
      implicit none
#include "Zcode.h"
#include "Zkfcode.h"

      integer kf   ! input
      integer code, subcode, chg  ! output. For spectator kf, code=krare
c                                           for tau neutrio,  code =krare
      character*80 msg
      real(8)::u
      integer kfabs
      kfabs = abs(kf)
      if( kfabs == 311 ) then  ! K0 : 50% K0s; 50 % K0L
         call rndc(u)
         if(u < 0.5 ) then
            kfabs = kfk0s
         else
            kfabs = kfk0l
         endif
      endif
      if(kfabs .eq. kfpion) then
         code = kpion
         subcode = sign(1, -kf)
         chg = sign(1, kf)
      elseif(kfabs .eq. kfpi0) then
         code = kpion
         subcode = 0
         chg = 0
      elseif( kfabs .eq. kfkaon ) then
         code = kkaon
         subcode =sign(1, -kf)
         chg = sign(1, kf)
      elseif(kfabs .eq.  kfk0l) then
         code =kkaon
         subcode =sign( k0l, kf)
         chg = 0
      elseif(kfabs .eq.  kfk0s) then
         code = kkaon
         subcode =sign( k0s, kf)
         chg = 0
      elseif(kfabs .eq. kfneutron) then
         code =knuc
         if(kf .gt. 0) then
            subcode = kneutron
         else
            subcode = kneutronb
         endif
         chg = 0
      elseif(kfabs .eq. kfproton) then
         code = knuc
         if(kf .gt. 0) then
            subcode = regptcl
         else
            subcode = antip
         endif
         chg =sign(1, kf)
      elseif(kfabs .ge. 10000) then
         code = krare   ! target spectator. neglect
c         p(i,5) has mass. kfabs-10000=Z
c  &&&&&&&&&&&&&&&&&&
c         write(msg, *) 'kf code=',kf, ' not treatable'
c         call cerrorMsg(msg, 1)
c         call cerrorMsg('the particle is neglected',1)
c   &&&&&&&&&&&&&&&&
      elseif(kfabs  .eq. kfeta) then
         code= keta
         subcode = 0
         chg = 0
      elseif(kfabs .eq. kfelec) then
         code = kelec
         subcode = sign(1, -kf)
         chg = sign(1, -kf)
      elseif(kfabs .eq. kfmuon) then
         code = kmuon
         subcode = sign(1, -kf)
         chg = sign(1, -kf)
      elseif(kfabs .eq. kfneue) then
         code = kneue
         subcode =sign(1, -kf)
         chg = 0
      elseif(kfabs .eq. kfneumu) then
        code = kneumu
        subcode =sign(1, -kf)
        chg = 0
      elseif( kf .eq.  kfphoton ) then
         code = kphoton
         subcode = 0
         chg = 0
      elseif(kfabs .eq. kfdmes) then
         code = kdmes
         subcode = sign(1, -kf)
         chg = sign(1, kf)
      elseif(kfabs .eq. kfd0) then
         code =kdmes
         subcode = sign(1, -kf)
         chg = 0
      elseif(kfabs .eq. kflambda) then
         code = klambda
         subcode = sign(1, -kf)
         chg = 0
      elseif(kfabs .eq. kfsigma0) then
         code = ksigma
         subcode = sign(1, -kf)
         chg = 0
      elseif(kfabs .eq. kfsigmap) then
         code = ksigma
         subcode = sign(1, -kf)
         chg = sign(1, kf)
      elseif(kfabs .eq. kfsigmam) then
         code = ksigma
         subcode = sign(1, -kf)
         chg = sign(1, -kf)
      elseif(kfabs .eq. kfgzai0 ) then
         code = kgzai
         subcode = sign(1, -kf)
         chg = 0
      elseif(kfabs .eq. kfgzai ) then
         code = kgzai
         subcode = sign(1, -kf)
         chg = sign(1, -kf)
      elseif(kfabs .eq. kflambdac) then
         code = klambdac
         subcode = sign(1, -kf)
         chg = sign(1, kf)
      elseif(kfabs .eq. kfbomega ) then
         code = kbomega
         subcode = sign(1, -kf)
         chg =  sign(1, -kf)
      elseif(kfabs .eq. 16) then
         code = krare    !  tau neutrion. neglect 
      elseif(kfabs .eq. 113) then  ! rho
         code = krho
         subcode = 0
         chg = 0
      elseif(kfabs .eq. 223) then   ! omega
         code = komega
         subcode = 0
         chg = 0
      elseif( kfabs .eq. 333 ) then  ! phi
         code = kphi
         subcode = 0
         chg = 0
      elseif( kfabs .ge. 1000010020 .and. kfabs .le. 1000922350 ) then
c           nucleus is  10LZZZAAAI where L=0 (if not containing strangeness)
c           ZZZ is 3 digits of charge, AAA 3digits of mass no. I=0 for
c           gound state; so for our case, 1000010020 is minimum for deuteron
c           and 1000922350 is max for U(235)
         if(kf .lt. 0) then
            write(0,*) ' anti nuclues is not yet supported '
            code = krare
         else
            code=kgnuc
            subcode =( (kfabs/10)*10-(kfabs/10000)*10000 )/10
            chg =( (kfabs/10000)*10000 - (kfabs/1000000)*1000000 )
     *        /10000     
         endif
      else
         code = krare
         write(msg, *) 'not implemented kf code=', kf
         call cerrorMsg(msg, 1)
         call cerrorMsg('we neglect this particle',1)
      endif
      end

      subroutine ccos2kf(code, subcode, chg, kf)
c         cosmos code to kf code
c         only hadronic interacting particles are treaed.
      implicit none
#include "Zcode.h"
#include "Zkfcode.h"
      integer code, subcode, chg  ! input
      integer kf   ! output

      character*80 msg


      if(code .eq. kelec) then
         kf = sign(kfelec, -chg)
      elseif(code .eq. kphoton) then
         kf = kfphoton
      elseif(code .eq. kpion) then
         if(chg .eq. 0) then
            kf = kfpi0
         else
            kf = sign(kfpion, chg)
         endif
      elseif(code .eq. kkaon) then
         if(chg .eq. 0) then
            if(abs(subcode) .eq. k0l) then
               kf = sign( kfk0l, subcode)
            else
               kf =sign( kfk0s,  subcode)
            endif
         else
            kf = sign(kfkaon, chg)
         endif
      elseif(code .eq. knuc) then
         if(chg .eq. 0) then
            kf = sign( kfneutron, -subcode)
         else
            kf = sign(kfproton, chg)
         endif
      elseif(code .eq. kmuon) then
         kf = sign(kfmuon, -chg)
      elseif(code .eq. kneue ) then
         kf = sign(kfneue, -subcode)
      elseif(code .eq. kneumu) then
         kf = sign(kfneumu, -subcode)
      elseif(code .eq. kdmes) then
         if(chg .eq. 0) then
            kf = sign(kfd0, -subcode)
         else
            kf = sign(kfdmes, -chg)
         endif
      elseif(code .eq. klambda) then
         kf = sign(kflambda, -subcode)
      elseif(code .eq. ksigma) then
         if(chg .eq. 1) then
            kf = sign(kfsigmap, -subcode)
         elseif(chg .eq. 0) then
            kf = sign(kfsigma0, -subcode)
         else
            kf = sign(kfsigmam, -subcode)
         endif
      elseif(code .eq. kgzai) then
         if(chg .eq. 0) then
            kf = sign(kfgzai0, -subcode)
         else
            kf = sign(kfgzai, -chg)
         endif
      elseif(code .eq. klambdac) then
         kf =sign(kflambdac, -subcode)
      elseif(code .eq. kbomega ) then
         kf = sign(kfbomega, -chg)
      elseif(code .eq. kgnuc ) then
         kf = 1000000000 + abs(chg)*10000 + subcode*10
         kf = sign(kf, chg)
      elseif( code == keta ) then
         kf = kfeta
      else
         write(msg, *) 'code, subcode, chg to  ccos2kf=', 
     &      code, subcode, chg  
         call cerrorMsg(msg, 1)
         call cerrorMsg(' cannot be converted to kf code',1)
         kf=10000
      endif
      end





