c    ******************************************************************
c    *                                                                *
c    *  prompt muon decay  mode is important.
c    *     others are roughly introduced to keep the energy conservation
c    *
c
c    ******************************************************************
c
      subroutine cdDecay(pj, a, np)
      implicit none
#include  "Zptcl.h"
#include  "Zcode.h"

      record /ptcl/ pj   ! input. demeson
      integer np                ! output. # of ptcls stored in a
      record /ptcl/ a(*)  ! output. to store produced ptcls

      real*8 u, sumbr


      call rndc(u)
      if(pj.charge .ne. 0) then
         if(u .lt. 0.093d0 ) then
c                   K0b + mu + neu    9.3%
            call cdDecay1( pj, a, np)
         elseif(u .lt. 0.132d0) then
c                   K + pi + mu + neumu 3.9 %  13.2
            call cdDecay2(pj,  a, np)
         else
            sumbr=0.4179  ! the total % below)/100. 
c                    K 2pi         9.22        9.22
c                    K0b + e  + neu   8.6 %   17.82
c                     K0s + 2pi    6.8        24.62
c                     K+3pi        6.0        30.62
c                     K + pi+ e+ neue  4.1 %  34.72  
c                     K0s + 3pi     3.02      37.74   
c                     K0L + pi      1.46      39.20
c                     K0s + pi      1.45      40.65
c                     3pi + pi0     1.14      41.79
            call rndc(u)
            u=u*sumbr
            if(u .lt.  0.0922)  then
c                D+    K- pi+ p+         9.22        9.22
               call cdDecay3(pj, a, np)
            elseif(u .lt. 0.1782) then
c                    K0b  e+  neu   8.6 %   17.82
               call cdDecay4(pj, a, np)
            elseif(u .lt. 0.2462) then
c                     K0s + 2pi    6.8        24.62
               call cdDecay5( pj, a, np)
            elseif(u .lt. 0.3062) then
c                     K+3pi        6.0        30.62
               call cdDecay6(pj, a, np)
            elseif(u .lt. 0.3472) then
c                     K + pi+ e+ neue  4.1 %  34.72  
               call cdDecay7( pj, a, np)
            elseif( u .lt. 0.3774) then
c                     K0s + 3pi     3.02      37.74   
               call cdDecay8(pj, a, np)
            elseif( u .lt. 0.3920) then
c                     K0L + pi      1.46      39.20
               call cdDecay9(pj, a, np)
            elseif( u .lt. 0.4065) then
c                     K0s + pi      1.45      40.65
               call cdDecay10(pj, a, np)
            else
c                     3pi + pi0     1.14      41.79
               call cdDecay11(pj, a, np)
            endif
         endif
      else
c            D0           into   K + mu + neu  3.31
c                       -----------------------
c                          K- pi+ pi-       13.9   13.9
c                          K-+2pi+ pi-       5.4   19.3
c                          K-2pi+ pi- pi0    4.2   23.5
c                          K-+pi+           3.89   27.39
c                          K + e  + neue    3.58   30.97
c                          K0s + pi+ pi-    2.99   33.96
c                          K0s + pi+ pi- pi0 2.99  36.95
c                         -------------------
c                          K + pi0 + e neue  1.6 
c                          pi+ pi- pi0        1.44
c                          K0s + pi0         1.22
c                          pi+ pi- 2pi0       1.0
         call rndc(u) 
         if(u .lt. 0.0331) then
c              D0    K-  mu+  neu  3.31
            call cdDecay20(pj, a, np)
         else
            call rndc(u)
            sumbr =0.3695
            u=u*sumbr
            if(u .lt. 0.139) then
c                          K- pi+ pi-       13.9   13.9
               call cdDecay21(pj, a, np)
            elseif(u .lt. 0.193 ) then
c                          K-+2pi+ pi-       5.4   19.3
               call cdDecay22( pj, a, np)
            elseif(u .lt. 0.235) then
c                          K-2pi+ pi- pi0    4.2   23.5
               call cdDecay23( pj, a, np)
            elseif(u .lt. 0.2739) then
c                          K-+pi+           3.89   27.39
               call cdDecay24( pj, a, np)
            elseif( u .lt. 0.3097) then
c                          K + e  + neue    3.58   30.97
               call cdDecay25( pj, a, np)
            elseif(u .lt. 0.3396) then
c                          K0s + pi+ pi-    2.99   33.96
               call cdDecay26(pj, a, np)
            else
c                          K0s + pi+ pi- pi0 2.99  36.95
               call cdDecay27(pj, a, np)
            endif
         endif
      endif
      end
c     ********************************
      subroutine cdDecay1( pj, a, np)
      implicit none
#include  "Zptcl.h"
#include  "Zcode.h"
c        D+->  K0b + mu + neu    9.3%
      record /ptcl/ pj   ! input. demeson
      integer np                ! output. # of ptcls stored in a
      record /ptcl/ a(*)  ! output. to store produced ptcls

      integer muchg, nusubc, kchg, ksubc, icon, i, echg
      integer pichg

      real*8 u, w

      call rndc(u)
      if(u .lt. .50) then
         ksubc = k0s
      else
         ksubc = k0l
      endif
      muchg = pj.charge
      nusubc = muchg
c           neue
      call cmkptc(kneue, nusubc, 0, a(1))
      call cmkptc(kmuon, 0,  muchg,  a(2))
      call cmkptc(kkaon, ksubc, 0, a(3))
c            3  body pure phase space
      call cnbdcy(3, pj.mass, a,  0, w, icon)
      np = 3
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      return
c     *******************************************
c        D+    K-  pi+ mu+  neumu 3.9 %  13.2
      entry cdDecay2(pj, a, np)

      kchg =-pj.charge
      nusubc = regptcl
      call cmkptc(kkaon, 0, kchg, a(1))
      call cmkptc(kpion, 0, -kchg, a(2))
      call cmkptc(kmuon, 0, -kchg, a(3))
      call cmkptc(kneumu, nusubc, 0, a(4))

      call cnbdcy(4, pj.mass, a,  0, w, icon)
      np = 4
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      return
c     ***********************************
c            D+   K- pi+ p+         9.22        9.22
      entry cdDecay3(pj, a, np)


      kchg = -pj.charge
      call cmkptc(kkaon, 0, kchg, a(1))
      call cmkptc(kpion, 0, -kchg, a(2))
      call cmkptc(kpion, 0, -kchg, a(3))

      call cnbdcy(3, pj.mass, a,  0, w, icon)
      np = 3
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      return
c*****************************************
c             K0b  e+  neu   8.6 %   17.82
      entry cdDecay4(pj, a, np)


      ksubc = k0s
      echg = 1
      call rndc(u)
      if(u .lt.0.5 ) then
         ksubc = k0l
         echg = -1
      endif
      nusubc = -echg
      call cmkptc(kkaon, ksubc, 0, a(1))
      call cmkptc(kelec, 0, echg, a(2))
      call cmkptc(kneue, nusubc, 0, a(3))

      call cnbdcy(3, pj.mass, a,  0, w, icon)
      np = 3
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      return
c     *******************************
c            K0s pi+ pi0    6.8        24.62
      entry cdDecay5( pj, a, np)


      ksubc = k0s
      pichg = pj.charge
      call cmkptc(kkaon, ksubc, 0, a(1))
      call cmkptc(kpion, 0, pichg,  a(2))
      call cmkptc(kpion, 0, 0,  a(3))

      call cnbdcy(3, pj.mass, a,  0, w, icon)
      np = 3
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      return
c     *************************************
c           K-pi+ pi+ pi0        6.0        30.62
      entry cdDecay6( pj, a, np)

      kchg = -pj.charge
      call cmkptc(kkaon, 0, kchg, a(1))
      call cmkptc(kpion, 0, -kchg, a(2))
      call cmkptc(kpion, 0, -kchg, a(3))
      call cmkptc(kpion, 0, 0, a(4))

      call cnbdcy(4, pj.mass, a,  0, w, icon)
      np = 4
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      return
c     **********************************
c          K-  pi+ e+ neue  4.1 %  34.72  
      entry cdDecay7( pj, a, np)

      kchg =-pj.charge
      nusubc = -kchg
      call cmkptc(kkaon, 0, kchg, a(1))
      call cmkptc(kpion, 0, -kchg, a(2))
      call cmkptc(kelec, 0, -kchg, a(3))
      call cmkptc(kneue, nusubc, 0, a(4))

      call cnbdcy(4, pj.mass, a,  0, w, icon)
      np = 4
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      return
c*****************************
c         K0s + pi+ pi+ pi-    3.02      37.74   
      entry cdDecay8(pj, a, np)

      ksubc = k0s
      pichg = pj.charge
      call cmkptc(kkaon, ksubc, 0, a(1))
      call cmkptc(kpion, 0, pichg, a(2))
      call cmkptc(kpion, 0, pichg, a(3))
      call cmkptc(kpion, 0, -pichg, a(4))


      call cnbdcy(4, pj.mass, a,  0, w, icon)
      np = 4
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      return
c    ******************************
c           K0L + pi      1.46      39.20
      entry cdDecay9(pj, a, np)

      ksubc = k0l
      pichg = pj.charge
      call cmkptc(kkaon, ksubc, 0, a(1))
      call cmkptc(kpion, 0, pichg, a(2))
      call c2bdcy(pj, a(1), a(2))
      np =2
      return
c     ****************************
c           K0s + pi      1.46      39.20
      entry cdDecay10(pj, a, np)

      ksubc = k0s
      pichg = pj.charge
      call cmkptc(kkaon, ksubc, 0, a(1))
      call cmkptc(kpion, 0, pichg, a(2))
      call c2bdcy(pj, a(1), a(2))
      np =2
      return
c  ***************************
c                 3pi + pi0     1.14      41.79
      entry cdDecay11(pj, a, np)

      pichg = pj.charge
      call cmkptc(kpion, 0, pichg, a(1))
      call cmkptc(kpion, 0, pichg, a(2))
      call cmkptc(kpion, 0, -pichg, a(3))
      call cmkptc(kpion, 0, 0, a(4))

      call cnbdcy(4, pj.mass, a,  0, w, icon)
      np = 4
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      return
c     **************************************
c              D0    K-  mu+  neu  3.31
      entry cdDecay20(pj, a, np)


      call cmkptc(kkaon, 0, -1, a(1))
      call cmkptc(kmuon, 1, 1, a(2))
      call cmkptc(kneumu, -1, 0, a(3))

      call cnbdcy(3, pj.mass, a,  0, w, icon)
      np = 3
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      return
c********************************************
c     D0        K- pi+ pi-       13.9   13.9
      entry cdDecay21(pj, a, np)

      call cmkptc(kkaon, 0, -1, a(1))
      call cmkptc(kpion, 0, 1, a(2))
      call cmkptc(kpion, 0, -1, a(3))

      call cnbdcy(3, pj.mass, a,  0, w, icon)
      np = 3
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      return
c****************************************************
c                 K-+2pi+ pi-       5.4   19.3
      entry cdDecay22( pj, a, np)


      call cmkptc(kkaon, 0, -1, a(1))
      call cmkptc(kpion, 0, 1, a(2))
      call cmkptc(kpion, 0, 1, a(3))
      call cmkptc(kpion, 0, -1, a(4))

      call cnbdcy(4, pj.mass, a,  0, w, icon)
      np = 4
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      return
c      *********************************
c                  K-2pi+ pi- pi0    4.2   23.5
      entry cdDecay23( pj, a, np)


      call cmkptc(kkaon, 0, -1, a(1))
      call cmkptc(kpion, 0, 1, a(2))
      call cmkptc(kpion, 0, 1, a(3))
      call cmkptc(kpion, 0, -1, a(4))
      call cmkptc(kpion, 0, 0, a(5))

      call cnbdcy(5, pj.mass, a,  0, w, icon)
      np = 5
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      return
c      ***************************
c            K-+pi+           3.89   27.39
      entry cdDecay24( pj, a, np)


      call cmkptc(kkaon, 0, -1, a(1))
      call cmkptc(kpion, 0,  1, a(2))
      call c2bdcy(pj, a(1), a(2))
      np =2
      return
c      *************************
c               K + e  + neue    3.58   30.97
      entry  cdDecay25( pj, a, np)


      call cmkptc(kkaon, 0, -1, a(1))
      call cmkptc(kelec, 0, 1, a(2))
      call cmkptc(kneue, -1, 0, a(3))

      call cnbdcy(3, pj.mass, a,  0, w, icon)
      np = 3
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      return
c**************************************
c                          K0s + pi+ pi-    2.99   33.96
      entry cdDecay26(pj, a, np)


      call cmkptc(kkaon, 0, -1, a(1))
      call cmkptc(kpion, 0, 1, a(2))
      call cmkptc(kpion, 0, -1, a(3))

      call cnbdcy(3, pj.mass, a,  0, w, icon)
      np = 3
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo
      return
c *******************************
c              K0s + pi+ pi- pi0 2.99  36.95
      entry cdDecay27(pj, a, np)


      ksubc = k0s
      call cmkptc(kkaon, ksubc, 0, a(1))
      call cmkptc(kpion,  0, 1, a(2))
      call cmkptc(kpion,  0, -1, a(3))
      call cmkptc(kpion,  0, 0, a(4))

      call cnbdcy(4, pj.mass, a,  0, w, icon)
      np = 4
      do   i=1, np
         call cibst1(i, pj, a(i), a(i))
      enddo

      end
