      subroutine cphits(pj, ia, iz, sig, a, ntp)
      implicit none
#include "Zcode.h"
#include "Zptcl.h"
      record /ptcl/pj           ! input. projectile.
      integer,intent(in)::ia    ! target A (nucleon #)
      integer,intent(in)::iz    ! target Z
      real(8),intent(in)::sig   ! cross-setion (mb) on this target
                         ! current  qmd00  dose not use but may  be
                         ! better to give it
	record /ptcl/ a(*)  ! output. produced particles
	      ! supoose Fe+Bi collsion.  If all Fe 
              ! nucleon of energy 4 GeV collide and produce
              !( 2pions + n  )*56 + 200 n; 3*56+200 = 380; max size of a.

	integer,intent(out):: ntp   ! total number of produced ptcls
	integer n, i, j

	integer code, subcode, charge
	integer ityp,ktyp
	real(8):: eein, bmax0
        integer,save:: first=0
        real(8):: u


        real(8):: totxs,  elaxs
        integer::icon 



	code = pj.code
	subcode  = pj.subcode
	charge = pj.charge

	call ccos2phits(code, subcode, charge, ityp, ktyp)

        if( code == knuc  ) then
           if( subcode /= antip ) then
              call rndc(u)
              call cphitsXs(pj, ia, iz, elaxs, totxs,icon)
              if(icon == -1) then
                 ntp = 0
              else 
                 if(u < elaxs/totxs ) then
                     ! elastic
                    call cnelas(pj, ia, iz, a, ntp)
                 else
                    call cbertini(pj, ia, iz, sig, a, ntp)
                 endif
              endif
           else
              call cjqmd(pj, ia, iz, sig, a, ntp)
c////////////////
c           if( pj.code == 6 .and. pj.subcode == antip .and.
c     *        pj.charge == -1 .and. pj.fm.p(4) - pj.mass <= 0.)
c     *         then
c              write(0,*) '1  sig=',sig, ' ntp=',ntp
c              do i = 1, ntp
c                 write(0,*)  a(i).code, a(i).fm.p(4)
c              enddo
c           endif
c//////////////
           endif
        elseif( code == kpion ) then
           call cbertini(pj, ia, iz, sig, a, ntp)
        else
           call cjqmd(pj, ia, iz, sig, a, ntp)
c////////////////
c           if( pj.code == 6 .and. pj.subcode == antip .and.
c     *        pj.charge == -1 .and. pj.fm.p(4) - pj.mass <= 0.)
c     *         then
c              write(0,*) '2 sig=',sig, ' ntp=',ntp
c              do i = 1, ntp
c                 write(0,*)  a(i).code, a(i).fm.p(4)
c              enddo
c           endif
c//////////////
        endif

        end subroutine
      subroutine cphitsXs(pj, ia, iz, elaxs, totxs, icon)
      use jqmd
      use bertini
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zmass.h"

      record /ptcl/ pj  ! input projectile
      integer,intent(in)::ia,iz  ! target A,Z
      real(8), intent(out):: elaxs
      real(8),intent(out):: totxs   ! xs in mb
                                 ! for p,n total (inela + elaxs)
                                 ! for Heavy  inela, elaxs =
      integer,intent(out):: icon ! =0; oK =-1; N.G

      integer::incp
      real(8),save:: EkMeV, inelaxs
      real(8)::ap,zp,ep,at,zt,bmax
      integer,save:: first=0
c            used to judge elastic or inela in cphits
      integer,save:: nstrange=0



      if(pj.code == knuc ) then
         EkMeV =( pj.fm.p(4) - pj.mass) *  1000.d0
         if(pj.charge == 1 ) then
            incp = 1
         elseif(pj.charge == 0 .and. pj.subcode == regptcl) then
            incp = 2
         else
            nstrange = nstrange + 1
            if( nstrange < 10) then
               write(0,*) 'in cphits: code, subc, charge=', pj.code,
     *             pj.subcode, pj.charge
               write(0,*) ' strange; neglect  '
            elseif( nstrange > 100 ) then
               write(0,*) ' too many strange ptcl in cphits'
               stop
            endif
            inelaxs = 0.
            elaxs = 0.
            icon = -1
            return
         endif
         call sigrc(incp, EkMeV, ia, iz, totxs, inelaxs, elaxs)
c             abvoe xs is in b.
      elseif(pj.code == kgnuc ) then
         ap = pj.subcode
         zp = pj.charge
         ep = pj.fm.p(4) * 1000.d0   ! total E in MeV
         at = ia
         zt = iz
!                use nasa cross-section.
!                elaxs = 0 always. bmax not used
         call sighi(ap,zp,ep,at,zt,inelaxs, elaxs,bmax)
         totxs =  inelaxs + elaxs
      else
         nstrange = nstrange + 1
         if( nstrange < 10 ) then
            write(0,*) 'in cphits: code, subc, charge=', pj.code,
     *        pj.subcode, pj.charge
            write(0,*) ' strange; neglected'
         elseif ( nstrange > 100) then
            write(0,*) ' too many strange ptcl in cphits'
            stop
         endif
         inelaxs = 0.
         elaxs = 0.
         icon = -1
      endif
      totxs  = totxs*1000.
      inelaxs = inelaxs *1000.
      elaxs = elaxs *1000.

      end subroutine

      subroutine cnelas(pj, ia, iz, a, ntp)
      implicit none
#include "Zptcl.h"
#include "Zmass.h"
      record /ptcl/ pj
      integer,intent(in):: ia, iz ! target A,Z  
      record /ptcl/ a(*)  ! normally size should  be  2
      integer,intent(out):: ntp

      integer ityp, ktyp
      real(8):: ata, atz, epin


      integer:: code, subcode, charge
      code = pj.code
      subcode = pj.subcode
      charge = pj.charge

      call ccos2phits(code, subcode, charge, ityp, ktyp)
      ata=ia
      atz =iz
      epin =( pj.fm.p(4) - pj.mass)*1000.   !  K.E in MeV
      call nelst(ityp,ktyp,ata,atz,epin)

      call cphitsOut(ntp, a)
      call crot3mom(pj, a, ntp)  ! to the  mother system.

      end
