c       get mean free path of magnetic pair creation.
c       Integration of Eq. (16) of Baring
      real*8 function cmPairMFP(eg, xai)
      implicit none
#include "Zglobalc.h"

      real*8  eg   !  input.  gamma energy in GeV
      real*8  xai  !  input.  xai value = Eg/m *  H/Hc/2
      
      real*8  alpha,  cmPairInt1
      real*8 const
      parameter (const = 3. * 1.73205 * 3.1415 )
    
c           SyncConvR is in GeV/m
      alpha = cmPairInt1(xai)*  SyncConvR/ eg /const
      cmPairMFP = 1./alpha
      end
c      implicit none
c      real*8 xai, cmPairInt1, norm
c
c      xai = .01
c      do while (xai .lt. 1000.) 
c         if(xai .lt. 4.) then
c            norm = 7.497 * xai * exp(-4./3./xai)
c         else
c            norm = xai**0.6666
c         endif
c         write(*,*) sngl(xai), sngl(cmPairInt1(xai)/norm)
c         xai = xai *10.**.1
c      enddo
c      end
      real*8 function cmPairInt1(xai)
      implicit none
c       compute the integral part of Eq. (16) of Baring; Mon. Not. R.
c       astr.Soc. (1988) 235., i,e.
c      inte(0,1) dv  (9-v**2)/(1-v**2)K23(y).
c      The numerical integration has been done by inteSpecPair.f
c      and the result is normalized as follows
c
c   For xai < 4:  log(xai) vs ans/(7.497xai*exp(-4/3/xai)) is approximated by
c            a polynomial
c   for xai > 4:  log(xai) vs  ans/ xai**0.6666 is approximated by
c                 a polynomial.
c
      real*8 xai
c
      real*8 ans, lxai
c
      if(xai .lt. .01) then
         ans =7.497*xai*exp(-4./3./xai)
      elseif(xai .lt. 4.0) then
         lxai = log(xai)
          ans =(( -0.7211221E-03*lxai -0.1692442E-01)* lxai
     *       -0.9929865E-01 )*lxai + 0.8214562  
         ans = 7.497*xai* exp(-4./3./xai)* ans
      elseif(xai .lt. 5000.) then
         lxai = log(xai)

         ans = (((( 0.2210200E-03*lxai -0.8950944E-02)*lxai
     *  + 0.1461679 )*lxai -1.218747)*lxai +5.274929)*lxai
     *  + 0.1683762       
         ans = ans * xai**0.66666
      else
         ans = 9.8*xai**0.66666
      endif
      cmPairInt1 = ans
      end







