c     *****************************************************************
c     *                                                               *
c     *  caveInteNuc:  get average no. of interacting nucleons
c     *  when a heavy ptcl interacts with air target   
c     *                                                               *
c     *****************************************************************
c  Note: this interacting nucleons do not include successive 
c        interactions; the number is smaller by <Nsuc> factor
c        than <N> = A sigma(pA)/sigma(A'A)
c
c
        subroutine caveInteNuc(pj, tgtMassN,  avn )
        implicit none

#include  "Zcode.h"
#include  "Zptcl.h"
#include  "Zheavyp.h"

        record /ptcl/ pj   !  projectile heavy
        real*8  avn  !  average no. of interacting nucleons 
        integer tgtMassN  ! target mass # ( # of nucleons)
        
        real*8  xspp, xspA, xsAA, tgtA, a3, sucave, pne, tgtZ
        integer ihg
c
        tgtA = tgtMassN
        tgtZ = tgtA*0.4   ! almost dummy
        a3 = tgtA**0.333333333
        ihg = Charge2heavyG(pj.charge)
        pne = pj.fm.p(4)/HeavyG2massN(ihg)

c        call cppXsec(pne, xspp)
c        call cxp2xAXsec(tgtA, xspp, xspA)
        call cinelx(pj, tgtA, tgtZ, xspA)
c                         this is 0.4d0*tgtA is rather dummy
        call cAAXsec2(pj, tgtA, tgtZ,  xsAA)
        avn = HeavyG2massN(ihg) * xspA /xsAA
c             this inlcude successive collision inside the target.
c            Cosmos needs the first collision inside the target
c            so divide this by the average number of successive
c            collisions. However, this theory has no firm basis, 
c            sot that we put a switch do use sucave =1
c              get <Nsuc>
        if(HowIntNuc .eq. 0) then
           call caveNoOfSucC(a3, xspp, sucave)
           avn = avn/sucave
        endif
      end
