************************************************************************
*                                                                      *
*        PART 9: Default Values                                        *
*                                                                      *
*                                                                      *
*   List of subprograms in rough order of relevance with main purpose  *
*      ( s = subroutine, f = function, b = block data, e = entry )     *
*                                                                      *
*                                                                      *
*  b  qmddata   to give default values for switches and parameters     *
*                                                                      *
************************************************************************
*                                                                      *
************************************************************************
*                                                                      *
      block data qmddata
*                                                                      *
*                                                                      *
*        Last Revised:     1998 11 27                                  *
*                                                                      *
*        Purpose:                                                      *
*                                                                      *
*              to give default values for switches and parameters      *
*                                                                      *
*                                                                      *
************************************************************************

      implicit real*8(a-h,o-z)

*-----------------------------------------------------------------------

#include "param00.inc"
#include "param01.inc"
#include "param02.inc"

*-----------------------------------------------------------------------

      common /input1/ mstq1(mxpa1), parq1(mxpa1)

      common /fnamid/ fname(mxfnm), idf(mxfnm), ifnl(mxfnm)

      character       fname*80

*-----------------------------------------------------------------------
*     Set defaults in the mstq1 array from 1 to 100
*-----------------------------------------------------------------------

*        1     2     3     4     5     6    7     8     9    10

      data ( mstq1(i), i = 1, 100 ) /
     $   0,   12,    6,    0,   40,   20,  10,   90,    1,12345,
     1   0,   20,    2,    0,    0,    0,   2,    0,    0,    0,
     2   0,    0,    0,    0,    0,    0,   0,    0,    0,    1,
     3   1,    1,    0,    0,    0,    0,   0,    0,    0,    0,
     4   0,    0,    0,    0,    0,    0,   0,    0,    0,    0,
     5   0,    0,    0,    0,    0,    0,   0,    0,    0,    1,
     6   1,    0,    0,    0,    0,    0,   0,    0,    0,    0,
     7   0,    0,    0,    0,    0,    0,   0,    0,    0,    0,
     8   0,    0,    0,    0,    0,    0,   0,    0,    0,    1,
     9 1000,   0,    0,    0,    0,    0,   0,    0,    0,    0/

*-----------------------------------------------------------------------
*     Set defaults in the mstq1 array from 101 to 200
*-----------------------------------------------------------------------

*        1     2     3     4     5     6    7     8     9    10

      data ( mstq1(i), i = 101, 200 ) /
     $   0,    0,    0,    0,    0,    0,   0,    0,    0,    0,
     1   0,    0,    0,    0,    0,    0,   0,    0,    0,    1,
     2   0,    1,    1,    1,   30,    1,   1,    1,    1,    0,
     3   0,    0,    0,    0,    0,    0,   0,    0,    0,    0,
     4   0,    0,    0,    0,    0,    0,   0,    0,    0,    1,
     5   1,    1,    1,    5,    1,    1,   1,    1,    1,    1,
     6   0,    1,    1,    1,    1,    0,   1,    0,    1,    1,
     7   2,   10,    1,    0,    0,    0,   0,    0,    0,    0,
     8   0,    0,    0,    0,    0,    0,   0,    0,    0,    0,
     9   0,    0,    0,    0,    0,    0,   0,    0,    0,    0/


*-----------------------------------------------------------------------
*     Set defaults in the parq1 array from 1 to 100
*-----------------------------------------------------------------------

*          1       2    3    4     5      6     7     8     9    10

      data ( parq1(i), i = 1, 100 ) /
     $   0.5,   -1.0, 0.0, 3.5,  1.0,   0.0,  0.0,  0.0,  0.0,  0.0,
     1   0.0,    0.0, 0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
     2   0.0,    0.0, 0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  2.0,
     3  -1.0,   25.0, 0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
     4   0.0,    0.0, 0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
     5   0.0,    0.0, 0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
     6   0.0,    0.0, 0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
     7   0.0,    0.0, 0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
     8   0.0,    0.0, 0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.2,
     9 1.124,    0.5, 0.9, 0.3,  1.0, -0.04, -1.0,  0.0,  0.0,  0.0/

*-----------------------------------------------------------------------
*     Set defaults in the parq1 array from 101 to 200
*-----------------------------------------------------------------------

*          1       2      3    4     5      6     7     8     9    10

      data (parq1(i),i=101,200)/
     $   0.0,    0.0,   0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
     1   0.0,    0.0,   0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  1.0,
     2   0.0,    0.0,   0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
     3   0.0,    0.0,   0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
     4   0.0,    0.0,   0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
     5  10.0,    2.0,  -25., 25., -15.,   15., 101., 101., 101., 101.,
     6   1.0,    1.0,   0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
     7   0.0,    0.0,   0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
     8   0.0,    0.0,   0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
     9   0.0,    0.0,   0.0, 0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0/


*-----------------------------------------------------------------------
*     Set defaults in the parq1 array from 101 to 200
*-----------------------------------------------------------------------

*-----------------------------------------------------------------------
*     Default File Name
*-----------------------------------------------------------------------

      data fname/ 'jqmd.cfg  ','          ','howmany.dat',
     &            'jqmd      ','          ','           ',
     &            '          ','          ','           ',
     &            'qmdout.dat',
     &            '          ','          ','           ',
     &            '          ','          ','           ',
     &            '          ','          ','           ',
     &            '          ',
     &            '          ','          ','           ',
     &            '          ','          ','           ',
     &            '          ','          ','           ',
     &            '          ',
     &            '          ','          ','           ',
     &            '          ','          ','           ',
     &            '          ','          ','           ',
     &            '          ',
     &            '          ','          ','           ',
     &            '          ','          ','           ',
     &            '          ','          ','           ',
     &            '          '/

      data ifnl/  8,  0, 11,
     &           10,  0,  0,
     &            0,  0,  0,
     &           10,
     &            0,  0,  0,
     &            0,  0,  0,
     &            0,  0,  0,
     &            0,
     &            0,  0,  0,
     &            0,  0,  0,
     &            0,  0,  0,
     &            0,
     &            0,  0,  0,
     &            0,  0,  0,
     &            0,  0,  0,
     &            0,
     &            0,  0,  0,
     &            0,  0,  0,
     &            0,  0,  0,
     &            0/

      data idf/   1, 2, 3, 4, 5, 6, 7, 8, 9,10,
     &           11,12,13,14,15,16,17,18,19,20,
     &           21,22,23,24,25,26,27,28,29,30,
     &           31,32,33,34,35,36,37,38,39,40,
     &           41,42,43,44,45,46,47,48,49,50/

*-----------------------------------------------------------------------


       end 

