c        csampGIntL:  sample phtoto interaction length.
       subroutine csampGIntL
c
c        pair, compton, photo-electric eff. photo-hadron
c
       implicit none
#include  "Zglobalc.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zelemagp.h"

c

       real*8  t, tkgpm2, cxai, den, cvh2den, eg
       real*8  prob, u, cmPairMFP
       real*8  tcomp, tphot, tpair, tgp, tcoh
       real*8 xprob(5), txray(5)
            
       real*4  xsec(5)  !  coh, incoh,  P.E  1/(g/cm2)  
       real*8 xaimin/0.1/
c     
       eg = TrackBefMove.p.fm.p(4)
       if(LpmEffect .and. eg .gt. LpmPairEmin) then
c          den = cthick2den(TrackBefMove.pos.depth)
          den = cvh2den(TrackBefMove.pos.height)  ! better
          call cpairLPMXsec(eg, den, prob)
          call rndc(u)
          t = -log(u) /prob
       elseif( eg .gt. 1.022d-3 ) then
          if(eg .le. Excom2 ) then
             call cXrayp(eg, 4, 5,  xprob, txray)
             prob= xprob(4)+xprob(5)  !  1/r.l
             call rndc(u)
             t = -log(u)/prob     !  r.l
          else             
             call cpairPath(eg, t)
          endif
       else
          t = Infty
       endif
       call csetIntInf(t*X0, .false., 'pair')

       if(eg .le. Excom1 )  then
c           use Xcom data
          call cXrayp(eg,  1, 3,  xprob, txray)
          call csetIntInf(txray(2)*X0, .false., 'compt')
          call csetIntInf(txray(3)*X0, .false., 'photoe')
          call csetIntInf(txray(1)*X0, .false., 'cohs')
       else
          if( eg .lt. MaxComptonE ) then
             call ccomptPath(eg, prob, t) 
          else
             t = Infty
          endif
          call csetIntInf(t*X0, .false., 'compt')
          if( eg .lt. MaxPhotoE ) then
             call cphotoEEPath(eg, prob, t)
             call csetIntInf(t*X0, .false., 'photoe')
          endif
       endif
c           photo hadron prod.
       if( eg .gt. MinPhotoProdE .and. HowPhotoP > 0 ) then
          call cghPath(eg,    tkgpm2)
          call csetIntInf(tkgpm2, .false., 'photop')
       endif

c           magnetic  pair
       if(MagPair .eq. 1 .and. eg .gt.  MagPairEmin) then
          Xai = cxai(TrackBefMove.p, Mag)
          if(Xai .gt. xaimin) then
             call rndc(u)
             t = -log(u) * cmPairMFP(eg, Xai)
             call csetIntInf(t, .true., 'mpair')
          endif
       endif
       end
