      subroutine cmuInte
      implicit none
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zcode.h"
      
      real*8 Et
      character*80 msg

      record /track/aTrack, MoveSave
      save

      aTrack=MovedTrack

      if( IntInfArray(ProcessNo).process .eq. 'mupair' ) then
         call cmuPrsmpE(MovedTrack.p.fm.p(4),  Et)
         aTrack.p.fm.p(4) = aTrack.p.fm.p(4) - Et  ! muon; neglect angle
         call ce2p(aTrack)
         Nproduced = Nproduced + 1
         Pwork(Nproduced) = aTrack.p

         if(MuPr .eq. 3 .or. Eabsorb(1) .ne. 0 ) then
c              If Eabsorb(1)=0 and MuPr=2, Et will be missing
c              so we generate pair explicitly when Eabsorb(1)!=0
c              generate pair electrons; employ cpair
c              to do so, make aTrack a gamma of energy Et
            MoveSave = MovedTrack
c               make MovedTrack to be a photon
            MovedTrack.p.fm.p(4) = Et
            call cmkptc(kphoton, kcasg, 0, MovedTrack.p)
            call ce2p(MovedTrack)
            call cpair
c             restore MovedTrack
            MovedTrack = MoveSave
         endif
      elseif(IntInfArray(ProcessNo).process .eq.'mubrem' ) then   
         call cmuBrsmpE(MovedTrack.p.fm.p(4),  Et)
         aTrack.p.fm.p(4) = aTrack.p.fm.p(4) - Et  ! muon
         call ce2p(aTrack)
         Nproduced = Nproduced + 1
         Pwork(Nproduced) = aTrack.p   ! muon
         if(MuBr .eq. 3 .or. Eabsorb(1) .ne. 0 ) then
c             generate brems gamma; no deflection
            aTrack.p.fm.p(4) = Et
            call cmkptc(kphoton, kcasg, 0, aTrack.p)
            call ce2p(aTrack)
            Nproduced = Nproduced + 1
            Pwork(Nproduced) = aTrack.p ! gamma
         endif
      elseif(IntInfArray(ProcessNo).process .eq.'munuci' ) then 
         call cmuNsmpE(aTrack.p.fm.p(4),  Et)
         aTrack.p.fm.p(4) = aTrack.p.fm.p(4) - Et ! muon
         call ce2p(aTrack)
         Nproduced = Nproduced + 1
         Pwork(Nproduced) = aTrack.p ! muon
         if(Et .gt.  150.d-3 ) then
            if(  MuNI .eq. 3  .or. Eabsorb(1) .ne. 0 )  then 
c             generate gamma-N interaction; employ gamma interaction
c             routine 
               MoveSave = MovedTrack
               MovedTrack.p.fm.p(4) = Et
               call cmkptc(kphoton, 0, 0, MovedTrack.p)
               call ce2p(MovedTrack) ! adjust momentum
               call cphotop 
c               restore muon
               MovedTrack = MoveSave
            endif
         endif
      else
         write(msg, *) ' in cinteMuon: process=',
     *        IntInfArray(ProcessNo).process,
     *        ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg, 0)
      endif   
      end
