c      real*8 ein, xs, a
c      ein =0.15
c      a = 14.6
c      do i = 1, 500
c         call cgpXsec(a, ein, xs)
c         ein = ein*10.0**0.025
c      enddo
c      end
c      xsection in mb for Photo production of hadrons at Neucleaus.
      subroutine  cgpXsec(a, energy, xs)
      implicit none
c       a: input. real*8  Target Mass No.
c     energy: input real*8.  gamma energy in GeV
c     xs:  output. real*8.   cross-section in mb
c
      real*8 a, energy, xs

      real*8 loge, pw

c
c           gp x-section,   xs in mb
      call cgpxs1(energy, xs)

      if( a .eq. 1.) then
c          nothing to do
      elseif(energy .lt. 2.) then    
         xs = xs*a*(1.02-.135*energy)
      elseif(energy .lt. 1.e6 ) then
c          before v7.50
c         xs = xs*a*0.75    ! this is close to A**0.91 dependence
c          pw = around 0.91 and decreading to 0.82 
c             (by Bezrukov and Bugaev, Sov.J. of Nuc. phys.
c              33(5), may, 1981 
         loge = log (energy)
         pw = (-0.00062749*loge + 0.004126)*loge +0.24338+0.6666 
         xs = xs* a**pw
      else
c            extraplation to reach A**2/3 dependence
         pw = 0.18*(energy/1.e6)**(-0.07) +0.6666
         xs = xs* a**pw
      endif
      end
