cc         testing clorez
c      include 'cpxyzp.f'
c      include 'cmkptc.f'
c      include 'cpm2e.f' 
c -----------------------
c      implicit none
c#include "Zptcl.h"
c#include "Zcode.h"
c
c      record /ptcl/ p, po
c      record /fmom/  gb, gbi
c      real*8  g
c      integer i, j
c      g=1.
c      call cmkptc(knuc, 0, 1, p)
cc
c      p.fm.p(1)= 1.5d0
c      p.fm.p(2)= -8.5d1
c      p.fm.p(3)= -5.d2
c      po = p
c      write(0,*) ' enter px, py, pz'
c      read(*,*)  p.fm.p(1), p.fm.p(2), p.fm.p(3)
c      write(0,*) ' input=', p.fm.p(1), p.fm.p(2), p.fm.p(3)
c      call cpm2e(p, p)
c      gb.p(1)=0.     
c      gb.p(2)=0.
c      do  i=1, 50
c           if(g  .lt. 1.d5) then
c              gb.p(3)= g * sqrt(1.d0-1.d0/g/g)
c           else
c              gb.p(3) = g - 0.5d0/g -1.d0/8.d0/g/g/g
c           endif
c           gb.p(4)= g
c           gbi.x=0.
c           gbi.y=0.
c           gbi.z=-gb.p(3)
c           gbi.t=g
c           call clorez( gb, p,  po)
cc            
cc           write(*, *) ' converted po',
cc     *     po.fm.p(1), po.fm.p(2), po.fm.p(3), po.fm.p(4)
c           call clorez( gbi, po,  po)
c           write(*,*) g,
c     *            ( ( p.fm.p(j), po.fm.p(j), 
c     *             (p.fm.p(j)-po.fm.p(j))/p.fm.p(j)),j=3, 4)
c     
c           g=g*10.d0**0.25d0
c
c       enddo    
c       end
c
c       **************************************************************
c       *
c       * clorez: Lorentz transformation in z direction.
c       *         relative accuracy is better than 10 digts
c       *
c       **************************************************************
c
c /usage/  call clorez(gb, p,  po)
c
c        Suppose two systems K and K'.  K' is moving with a
c        constant velocity relative to K (4 velocity is 
c        in gb).  The axises in the both system are parallel.
c        K' is moving along the direction of the z axis.
c        (i.e., gb=(0, 0, gb(3), gamma)).
c        p is a 4 momentum given in K'.  This routine
c        transforms p into po seen from K.
c    gb(4): Input. real*8 (g*beta, g) of K' system seen from K. 
c     p(4): Input. real*8. 4  momentum of a ptcl in K'.
c               p(1)=px', p(2)=py', p(3)=pz', p(4)=e'
c    po(4): Outut.  real*8. 
c           4 momentum seen from K.
c           po(1)=px', po(2)=py', po(3)=pz,  po(4)=e  
c           po can be the same array as p., po.mass is also copied.
c
       subroutine clorez(gb, p, po)
         implicit none
c----         include '../Zptcl.h'
#include  "Zptcl.h"
         record /fmom/ gb
         record /ptcl/  p, po

         record /ptcl/ pin
c
         real*8 bpp, ex, g, ge
         real*8 s, t
         real*8 a, b
         real*8 big/1.d2/, bigpz/1.d2/

c          sqrt(1+a)/sqrt(1+b) = 1+ u(a, b) (upto 3rd order)
         real*8 u, v

         u(a,b)= ((a/16.d0 - 1.d0/8.d0)*a + 0.5d0)*a +
     *       ((-5.d0*b/16.d0 +3.d0/8.d0)*b -0.5d0)*b 
     *        - a*b/4.d0 + (a + 3.d0*b)*a*b/16.d0
c          u(a, b) = (a - b)/2.d0 - a**2/8.d0 - a*b/4.d0
c     *             +  3.d0*b**2/8.d0


c          sqrt(1+a)sqrt(1+b)= 1 + v(a,b) (upto 3rd order)

         v(a,b)= ((a/16.d0-1.d0/8.d0)*a + 0.5d0)*a +
     *         ((b/16.d0 -1.d0/8.d0)*b + 0.5d0)*b 
     *     +a*b/4.d0 - (a + b)*a*b/16.d0
c          v(a, b)= (a+b)/2.d0  -(a**2 + b**2)/8.d0
c     *            + a*b/4.d0
c          v(a, b) = (a+b)/2.d0 -(a-b)**2/8.d0
c
         pin =p
         po = pin

         bpp = gb.p(3)*pin.fm.p(3)
         g = gb.p(4)
c     
         ge = g*pin.fm.p(4)
         ex =  ge+bpp
         if(bpp .ge. 0.) then
            po.fm.p(3) = g*pin.fm.p(3) + gb.p(3) * pin.fm.p(4)
            po.fm.p(4) = ex
         elseif(pin.fm.p(4) .lt. max(1.d2, 1.d2*p.mass)) then
            po.fm.p(3) = g*pin.fm.p(3) + gb.p(3) * pin.fm.p(4)
            po.fm.p(4) = ex
         else
            if(g .lt. big) then
               po.fm.p(3) = g*pin.fm.p(3) + gb.p(3) * pin.fm.p(4)
               po.fm.p(4) = ex
            elseif(abs(pin.fm.p(3)) .lt. bigpz ) then
               po.fm.p(3) = g*pin.fm.p(3) + gb.p(3) * pin.fm.p(4)
               po.fm.p(4) = ex
            else
c                  transverse mass square/pz^2
               t = (pin.fm.p(1)**2 + pin.fm.p(2)**2 + pin.mass**2)/
     *              pin.fm.p(3)**2 !  this should be small
               if(t .gt. 1.d-4) then
                  po.fm.p(3) = g*pin.fm.p(3) + gb.p(3) * pin.fm.p(4)
                  po.fm.p(4) = ex
               else
                  s = -1.d0/g/g
                  ex = g*pin.fm.p(4) * (-u(s,t))
                  po.fm.p(3) = g * pin.fm.p(3)*(-v(s, t))
                  po.fm.p(4) = ex
               endif
            endif
         endif
       end




