c        Initialize simulation.  
#if  defined (KEKB) || defined (KEKA)
#define DOMPI
#endif
c
      subroutine cbeginRun
      implicit none
#include  "Zmanagerp.h"
#include  "Zmanager.h"
#include  "Zelemagp.h"
#include  "Zevhnp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zincidentp.h" 
#include  "Zprimary.h"
#include  "Zprimaryv.h"
#include  "Zcondc.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#if defined (DOMPI)
#include  "mpif.h"
#include  "Zmpi.h"
      integer intdata
#endif
      character*16 temp
      integer jold, icon
      real*8 s1


      if(Cont) then
c           restore status at the end of previous run
         call crestoreStatus
         Cont =.true.
      elseif(Job .eq. 'flesh'  .or. Job .eq. 'newflesh') then
         temp = Job
         call cgetSkelFile 
         Job = temp    !  keet as now
      elseif(Job .eq. 'skeleton' .or. Job .eq. 'newskel' ) then
c            to be safe, parameters are written in a file first and read
c            again ; this will avoid the possible difference of internal
c            parameter values read from original param and SkeletonParam
c
#ifndef DOMPI
         temp = Job
         call copenNLfw(TempDev, SkeletonFile, icon)
         if(icon .ne. 0) then
            call cerrorMsg(SkeletonFile, 1)
            call cerrorMsg('File shown above cannot be opened',0)
         endif
c           at flesh time, you don't need to rewrite Job
         if(Job .eq. 'newskel') then
            Job = 'newflesh'
         else
            Job = 'flesh'
         endif
         call cwriteParam(TempDev, 1)
         close(TempDev)
c           macIFC/MACOSX cannot put correct namelist char data 
c           (' is missing) so cannot read SkeletonFile
c           avoid read it. the user must do the equiv.  by hand 
c            call copenNLf(TempDev, SkeletonFile, icon)
c            call creadParam(TempDev)
c            close(TempDev)
c            restore Job
         Job = temp
#endif
      endif
c        reset parameters
      if(BorderHeightH .eq. 0.0) then
         BorderHeightH = HeightOfInj + 1.0d0    ! from v6.10
      endif

      EventsInTheRun = 0      ! moved from ciniTracking0. 2001.09/30

      if(DestEventNo(2) .eq. 0) then
         DestEventNo(2) = DestEventNo(1)
      elseif(DestEventNo(1) .lt. 0) then
         DestEventNo(2) = -abs(DestEventNo(2))
      endif

c         to lower case letters.
      temp = Generate
      call c2lowerCase(temp, Generate)
      temp = Job
      call c2lowerCase(temp, Job)

      call rndsw(jold, 1)    ! specify random number generator 1.

c           set Target and do related xsec business; moved before
c           cintModels (for qgsjet dummy ptcl generation in cQGSini)
      call cixsec

c       cintModels probably reads disk file(s) internally, 
c       we may better to avoid simultaneous access to that disk 
c       by different ranks; reading  starts from rank0, rank1...
#if defined DOMPI
      if(mpirank .eq.  0) then
         call cintModels('cosmos') ! analysis of interaction models and init.
         if(mpisize .gt. 1) then
            call MPI_SEND(mpirank, 1, MPI_INTEGER, 1, 1,
     *           MPI_COMM_WORLD, mpierr)
         endif
      else
         call MPI_RECV(intdata, 1, MPI_INTEGER, mpirank-1, 1,
     *      MPI_COMM_WORLD, mpistat, mpierr)
         call cintModels('cosmos') ! analysis of interaction models and init.
         if( mpirank .lt. mpisize-1 ) then
            call MPI_SEND(mpirank, 1, MPI_INTEGER, mpirank+1, 1,
     *       MPI_COMM_WORLD, mpierr)
         endif
      endif
#else
      call cintModels('cosmos') ! analysis of interaction models and init.
#endif

#if ATMOSPHERE == 1
c          read segmented atmosphere data
      call creadAtmosD
c          manipulate data
      call catmosCnst1
      call catmosCnst2
#elif ATMOSPHERE == 2
c          read segmented atmosphere data
      call creadAtmosD
c          manipulate data
      call catmosCnst1
#endif
c         init for geomag
      call crdGeomag(GeomagFile, YearOfGeomag)
c        init for LPM effect energy sampling.
      s1 = (TargetAtomicN**(1./3.d0)/183.d0)**2
      call csetLPMCnst(s1, log(s1), 1.d-4, X0)
c        initialize  observation  
      call cinitObs
c        init for   primary sampling
      call ciniSPrim(PrimaryFile)

      if(CutOffFile .ne. ' ') then
         call crigCut0(CutOffFile) ! read cutoff talbe and init.
      endif
c       init for muon interaction routines; specific for Air.
      call cRdmuTab        ! set various consts for mu int.
      call cSetMu(TargetAtomicN, TargetMassN)
      FromEpics = .false.  ! muon interaction routines for Air are
                           ! inside Cosmos 
      call ciniSPrimAng    !  this is in csPrimaAgn.f in Tracking dir.
c        check job
      call cwhatJob
c          this is moved here; before v6.10 it was before cwhatJob
      call ciniTracking0  !  init for  tracking for all events
c           init for knockon process; Knockon is not used now.
      if(KnockOnRatio .lt. 1.d0) then
c              ********* Knockon is not used now ******
         if(Job .eq. 'newskel') then
            call cdedxEleci(KEminObs(1)*KnockOnRatio, Knockon)
         elseif(KEminObs2(1)*KnockOnRatio .gt. 0.) then
c                 this must come after cwhatJob, since KEminObs2 must
c           be fixed.  For skeleton-flesh job, KnockOnRatio should be
c           small enough so that KEminObs2*KnockOnRatio < KEminObs at
c           flesh time  

            call cdedxEleci(KEminObs2(1)*KnockOnRatio, Knockon)
         else
            call cerrorMsg('KnockOnRatio<1 and others mismatch', 0)
         endif
      else
         call cdedxEleci(RecoilKineMinE, Knockon)
      endif
c         user hook
      call chookBgRun
      
      end

      subroutine ciniTracking0
      implicit none
#include  "Zmanager.h"
#include  "Zmanagerp.h"
#include  "Zevhnp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zprimary.h"
#include  "Zprimaryv.h"
#include  "Zobs.h"
#include  "Zobsv.h"
#include  "Zincidentp.h"
#include  "Zheavyv.h"

c

      integer i
       real*8 dstep 
c  
c
c
      ObserveAS = index(Generate, 'as')  .gt. 0 .or.
     *            index(Generate, 'lat') .gt. 0 
      if(index(Generate, 'qas') .gt. 0) then
         SkipPtclGen = 1  ! quick as generation for heavies.
      else
         SkipPtclGen = 0
      endif
      
c
c    d = min( dZ/2, geneal min) for e+/e- other charged.
c    general min = same as so far for e+/e-, p, heavy
c                  mu, pi, K, --> dE/Ek< 1%; dE=Ek/100.
c                  min=Ek/100/2e-3 g/cm2 = Ek/10/2e-3 kg/m2
c                     =Ek/2e-2= 50Ek 
c                  Ek=1  -->50 kg/m2  = 5g/cm2 ~5000cm ~50m
c                  Ek=0.1-->5 kg/m2=0.5g/cm2   ~ 5m
c                    0.01-->0.05kg/m2=0.05g/cm2 ~ 0.5m
c                    0.001-->                     0.5m  
c        
c             ////////                   
      do i = 1, NoOfSites
         if( i .eq. 1) then
            dstep = ObsSites(1).pos.depth 
         else
            dstep = ObsSites(i).pos.depth - ObsSites(i-1).pos.depth
         endif
         if(dstep  .lt. 15. )  then
            StepControl=2
         else
            StepControl = dstep/25.0 
         endif
         maxstep(i) =   dstep/StepControl
      enddo

c          compute the offset point in 'xyz' system
c        the deepest detector origin + Offset is the point
c        to which the primary is directed.
c         offset in the detector system.
      Offset.r(1) = 0.
      Offset.r(2) = 0.
      Offset.r(3) = OffsetHeight
c        convert it to xyz system.
      call cdet2xyz(ObsSites(NoOfSites).pos.xyz, Offset, Offset)
c        make it offset 
      do i= 1, 3
         Offset.r(i) = Offset.r(i) -
     *    ObsSites(NoOfSites).pos.xyz.r(i)
      enddo
      if(Eabsorb(1) .ne. 0) then
         if(Eabsorb(2) .le. 0) then
            Eabsorb(2) = NoOfSites
         elseif( Eabsorb(2) .gt. NoOfSites) then
            call cerrorMsg("Eabsorb(2) > NoOfSites", 0)
         endif
      endif
      end
c     ************
      subroutine  cwhatJob
c     ************
      implicit none
#include  "Zmanager.h"
#include  "Zmanagerp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsp.h"
#include  "Zobsv.h"
c   
c
c
      character*190  msg
      integer klena, icon
      character*8  uid 
      character*16 temp
      real*8 u
      integer i, now(2)

c      move from ciniTracking0  
      RefreshIR = InitRN(1) .lt. 0 .and. 
     *        ( Job .ne. 'flesh' .and. Job .ne. 'newflesh')

      if(InitRN(1) .gt. 0 .and. InitRN(2) .gt. 0 ) then
         call rnd1r(InitRN)     ! init randeom number generator
c      *****************
      elseif(.not. RefreshIR .and. InitRN(2) .lt. 0) then
         call cmkSeed(0, now)   ! make seed using timer and hostname
         call rnd1r(now)
c           dummy use of 1000 times
         do i = 1, 1000
            call rndc(u)
         enddo
      endif
c          this is almost ok but later once more saved.
      call rnd1s(SeedSave)
c     ******************

      if(KEminObs(2) .ne. KEminObs(1)) then
         write(0,*) ' KEminObs(2) is forced to be the same as'
         write(0,*) ' KEminObs(1)=',KEminObs(1)
         KEminObs(2)= KEminObs(1)
      endif

      if(Job .eq. ' ' .or. Job .eq. 'skeleton' .or. 
     *   Job .eq. 'newskel'  ) then
         if(Job .ne. 'newskel') then
c             save present conditions
            do i = 1, 8
               KEminObs2(i) = KEminObs(i)
            enddo
            Generate2 = Generate
            EndLevel2 = EndLevel
         elseif(Job .eq. 'newskel') then
            if( KEminObs2(1) .ge. KEminObs(1) .and.
     *          EndLevel2 .le. EndLevel .and.
     *          index(Generate2,'as') .eq. 0 .and.
     *          index(Generate2,'lat') .eq. 0 ) then
               call cerrorMsg(
     *          'Doing newskel job seems nonsense', 1)
               call cerrorMsg(
     *          'Check Generate2, KEminObs2(1), EndLevel2',0)
            endif
         endif
         NoOfSites2 = NoOfSites    ! probably not needed
         if(Job .eq. ' ') then
            if(SeedFile .ne. ' ') then
c                  open seed file for output
               write(msg, *) 'opening SeedFile=',
     *         SeedFile(1:klena(SeedFile))
               call cerrorMsg(msg, 1)
               call copenfw(SeedFileDev, SeedFile, icon)
               if(icon .ne. 0) then
                  call cerrorMsg(SeedFile, 1)
                  call cerrorMsg('File shown above cannot be opened',0)
               endif
               if(Cont) then
                  call cskiptoEOF(SeedFileDev)
               endif
            endif               
         elseif(Job .eq. 'skeleton' .or. Job .eq. 'newskel' ) then
            call
     *      cerrorMsg('  ********** skeleton making **********', 1)
            write(msg, *)  '      Generate=', Generate
            call cerrorMsg(msg, 1)
c                 save skeleton inf. in skelotonFile file.
c             The file will be modified when the distjob command
c             processes Job = 'flesh' later. You need not modify
c             skeleton file if distjob is employed.
            if(.not. Cont) then
               temp = Job    ! save current Job
               if(Job .eq. 'newskel') then
                  Job = 'newflesh'
               else
                  Job = 'flesh'
               endif
               call copenNLfw(TempDev, SkeletonFile, icon)
               if(icon .ne. 0) then
                  call cerrorMsg(SkeletonFile, 1)
                  call cerrorMsg(
     *              'File shown above cannot be opened',0)
               endif
               call cwriteParam(TempDev, 1)
               close(TempDev)
               Job = temp
            endif

c                open SeedFile 
            if(SeedFile .eq. ' ') then
c                error. you need file; not needed actually
c               write(msg, *)
c     *         ' SeedFile must not be blank for skelton making'
c               call cerrorMsg(msg, 0)
            else
               write(msg, *) 'opening SeedFile=',
     *         SeedFile(1:klena(SeedFile))
               call cerrorMsg(msg, 1)
               call copenfw(SeedFileDev, SeedFile, icon)
               if(icon .ne. 0) then
                  call cerrorMsg(SeedFile, 1)
                  call cerrorMsg('File shown above cannot be opened',0)
               endif
               if(Cont) then
                  call cskiptoEOF(SeedFileDev)
               endif
            endif
         endif
      elseif(Job   .eq. 'flesh' .or. Job .eq. 'newflesh') then
c             don't worry about KEminObs2 etc.  They have been read
c             from &Hparam
          call cerrorMsg('  ********** fleshing job   *********', 1)
          if(Job .eq. 'flesh') then
             if(EndLevel .gt. EndLevel2) then
c                to deeper detph than skeleton
                write(msg, *)
     *          ' fleshing will be done to deeper depth than'//
     *               ' skeleton making time'
                call cerrorMsg(msg, 1)
                write(msg, *) ' No of old levels=', EndLevel2,
     *               ' No of new levels=', EndLevel
                call cerrorMsg(msg, 1)
             elseif(EndLevel .lt. EndLevel2) then
                call cerrorMsg('EndLevel must be >= skelton time', 0)
             endif
             write(msg, *)  '      Old Generate=', Generate2
             call cerrorMsg(msg, 1)
             write(msg, *)  '      New Generate=', Generate
             call cerrorMsg(msg, 1)
          else
             if(EndLevel .lt. EndLevel2) then
c                to deeper detph than skeleton
                write(msg, *)
     *          ' fleshing will be done to deeper depth than'//
     *           ' skeleton making time'
                call cerrorMsg(msg, 1)
             endif
c
c              copy  old Generate, KEminObs2 to current value
c              they are future values at newskel time
             do i = 1, 8
                KEminObs(i) = KEminObs2(i)
             enddo
             Generate = Generate2
             EndLevel = EndLevel2
          endif
c                open SeedFile
          if(SeedFile .eq. ' ') then
cc             write(*, *) ' SeedFile must not be blank for flesh job'
cc             call cerrorMsg(msg, 0)
c               seed will be read from Mdev.
          else
             write(msg, *) 'opening SeedFFile=', 
     *        SeedFile(1:klena(SeedFile))
             call cerrorMsg(msg, 1)
             call copenf(SeedFileDev, SeedFile, icon)
             if(icon .ne. 0) then
                call cerrorMsg(SeedFile, 0)
                call cerrorMsg('File shown above seems missing',0)
             endif
          endif
      else
           write(msg,*) ' Job=',Job, ' undefined'
           call cerrorMsg(msg, 0)
      endif
      if((Trace .gt. 0 .and. Trace .lt. 60) .or. Trace .gt. 100) then
c           defalut trace.  fix the dirctor
          if(TraceDir .eq. ' ') then
             call cgetLoginN(uid)
             TraceDir = '/tmp/'//uid(1:klena(uid))
          endif
       endif
      end
c        **************************************** read cont job info
      subroutine crestoreStatus
      implicit none
#include "Zmanagerp.h"
      integer icon

      call copenNLf(TempDev, ContFile,icon)
      if(icon .ne. 0) then
         call cerrorMsg(ContFile, 1)
         call cerrorMsg('File shown above seems missing',0)
      endif
      call creadParam(TempDev)
      close(TempDev)
      end
      subroutine cgetSkelFile
      implicit none
#include "Zmanagerp.h"
      integer icon
      call copenNLf(TempDev, SkeletonFile, icon)
      if(icon .ne. 0 ) then
         call cerrorMsg(SkeletonFile, 1)
         call cerrorMsg('File shown above seems missing',0)
      endif
c          read skelton parameters for flesing
      call creadParam(TempDev)
      close(TempDev)
      end


