c     ctotx: x A collsion total cross section 
c      
      subroutine ctotx(pj, A, xs)
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zevhnp.h"
      record /ptcl/pj   !input projectile particle
      real*8  A          ! input. effective target mass number
      real*8 xs          ! output. in mb. total xsection. 

      real*8 p

      real(8)::shp, shn
      if( pj.fm.p(4) .le. pj.mass) then
         if(pj.code .eq. knuc .and. pj.subcode .eq. antip) then
            xs = largexs
         elseif(pj.code .eq. kelec .and. pj.charge .eq. 1) then
            xs = largexs
         else
            xs  = smallxs
         endif
      else   
         p = sqrt(pj.fm.p(4)**2 - pj.mass**2)
c         p = max(p, 0.1d0) 
c         if( p .ge. 20.) then          
c            call cerrorMsg('Momentum is >20 GeV/c for ctotx',0)
c         endif

         if(pj.code .eq. knuc) then
            if(pj.charge .eq. 1) then
c            proton
c               shp = ctotpp1(p)
               call cppTotXs(p, shp)

               if(A .gt. 1.) then
                  call cnpTotXs(p, shn)
c               use average of pp,pn
c                  shp =( ctotpn1(p) + shp)/2.0
                  shp = (shp + shn)/2.0
                  call cxp2xAXsec(A, shp, xs)
               else
                  xs = shp
               endif
            elseif(pj.charge .eq. -1) then
c             pbar
c               shp = ctotpbarp1(p)
               call cpbarpTotXs(p, shp)
               if( A .gt. 1.) then
c                  shp = (shp + ctotpbarn1(p))/2.0
                  call cnbarpTotXs(p, shn)
                  shp = (shp + shn)/2.
                  call cxp2xAXsec(A, shp, xs)
               else
                  xs = shp
               endif
            elseif(pj.subcode .eq. antip) then
c              anti-neutron; assume the same one as pbar
c               shp = ctotpbarp1(p)
               call cnbarpTotXs(p, shp)
               if( A .gt. 1.) then
                  call cxp2xAXsec(A, shp, xs)
               else
                  xs = shp
               endif
            else
c               neutron
c               shp = ctotnp1(p)
               call cnpTotXs(p, shp)
               if(A .gt. 1.) then
                  call cxp2xAXsec(A, shp, xs)
               else
                  xs = shp
               endif
            endif
         elseif(pj.code .eq. kpion) then
            if(pj.charge .eq. 1) then
c               shp = ctotpiPp1(p)
               call cpippTotXs(p, shp)
            elseif(pj.charge .eq. -1) then
c               shp = ctotpiMp1(p)
               call cpimpTotXs(p, shp) 
            else
c              at low energy, pi0 would not interact. any would be o.k
c               shp = ctotpiMp1(p)
               call cpimpTotXs(p, shp)
            endif
            if(A .ne. 1.0) then
               call cxp2xAXsec(A, shp, xs)
            else
               xs = shp
            endif
         elseif(pj.code .eq. kkaon) then
            if(pj.charge .eq. 1) then
c               shp = ctotkPp1(p)
               call ckppTotXs(p, shp)
               if(A .gt. 1.) then
                  call ckpnTotXs(p, shn)
                  shp = (shp + shn)/2.0
                  call cxp2xAXsec(A, shp, xs)               
               else
                  xs = shp
               endif
            elseif(pj.charge .eq. -1) then
c               shp = ctotkMp1(p)
               call ckmpTotXs(p, shp)
               if(A .gt. 1.) then
                  call ckmnTotXs(p, shn)
                  shp = (shp + shn)/2.
                  call cxp2xAXsec(A, shp, xs)               
               else
                  xs = shp
               endif
            else
c             k0; don't worry so much 
c              xs =( ctotkMp1(p) +ctotkPp1(p))/2.0
               call ckmpTotXs(p, shp)
               call ckmnTotXs(p, shn)
               shp = (shp+ shn)/2.
               if(A .gt. 1.) then
                  call cxp2xAXsec(A, shp, xs)               
               else
                  xs = shp
               endif
            endif
         elseif(pj.code .eq. kgzai .or. pj.code .eq. ksigma .or.
     *           pj.code .eq. kbomega .or. pj.code .eq. klambda .or.
     *           pj.code .eq. klambdac) then
c          don't worry, not used almost at all; use proton
c            shp = ctotpp1(p)
            call cppTotXs(p, shp)
            call cxp2xAXsec(A, shp, xs)               
         else
c          use pion
c            shp =ctotpiPp1(p)
            call cpippTotXs(p, shp)
            call cxp2xAXsec(A, shp, xs)               
         endif
      endif
      end
