      subroutine cixsec
      implicit none
#include "Ztrackp.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zevhnv.h"
#include "Zcode.h"

c     c
      
      real*8 xs                 ! input.  cross-section for Air target
                                ! in mb
c
      integer noOfElem, nxsec
      parameter ( noOfElem = 3,  nxsec = 30 )
      real*8 shp, xsecmin, xsecstep
      parameter ( xsecmin = 10.d0, xsecstep = 10 )
      integer i, j, mbindex, jcon
      real*8  elemA(noOfElem), elemS(noOfElem, nxsec), sigma(nxsec)
      real*8  cumsigma(noOfElem, nxsec), elemZ(noOfElem)
      real*8  No(noOfElem)
      real*8  u, tgA
      data elemA/14.0d0, 16.0d0, 40.0d0/
      data   No/1.56d0, 0.42d0, 0.01d0/
      data   elemZ/7.0d0, 8.0d0, 18.0d0/

c     save elemA, No, elemZ
      save

      real*8 sumN
      
c      TargetMassN = 14.55   !  sum( Ai*Noi)  / sum (Noi )
c      TargetAtomicN = 7.266  !  sum( Zi*Noi) / sum(Noi)
c      TargetZ2 = 53.54  (cf. <Z>^2 =  52.8)

      TargetMassN = 0.
      TargetAtomicN = 0.
      TargetZ2 = 0.
      sumN = 0.
      do i = 1, noOfElem
         TargetMassN =  TargetMassN + No(i)*elemA(i) 
         TargetAtomicN = TargetAtomicN + No(i)*elemZ(i)
         TargetZ2 = TargetZ2 + No(i)*elemZ(i)**2
         sumN = sumN + No(i)
      enddo
      TargetMassN =  TargetMassN/sumN
      TargetAtomicN = TargetAtomicN/sumN
      TargetZ2 = TargetZ2 /sumN
c              <Z>^0.666 = 3.7464 <Z^0.666>=3.7457
      TargetZ2_3rd = TargetAtomicN**0.66666
c              <Z>^0.333 =1.9367 <Z^0.3333>=1.9347
      TargetZ1_3rd = TargetAtomicN**0.33333
c//////////
      write(0,*) "<A>=", TargetMassN
      write(0,*) "<Z>=", TargetAtomicN 
      write(0,*) "<Z^2>=", TargetZ2
      write(0,*) "<Z>^2=", TargetAtomicN**2
      write(0,*) "<Z>^(2/3)=", TargetZ2_3rd
      write(0,*) "<Z>^(1/3)=", TargetZ1_3rd
c//////////// 

      TargetNucleonNo = 14   !  these two will be updated 
      TargetProtonNo =7      ! for each collision

      do j = 1, noOfElem
         shp = xsecmin          ! (say 10mb)
         do i = 1, nxsec
            call cxp2xAXsec(elemA(j), shp,elemS(j,i))
            shp = shp + xsecstep
         enddo
      enddo


      do i = 1, nxsec
         sigma(i) = 0.
         do j = 1, noOfElem
            sigma(i) = sigma(i) + No(j)* elemS(j,i)
         enddo
      enddo

      do i = 1, nxsec
         do j = 1, noOfElem
            cumsigma(j, i) =
     *           No(j)*elemS(j,i)/sigma(i)
         enddo
      enddo

      do i = 1, nxsec
         do j = 2, noOfElem
            cumsigma(j, i) = 
     *         cumsigma(j, i) + cumsigma(j-1, i)
         enddo
c          for safety
         cumsigma(noOfElem, i) = 1.0
      enddo
c  &&&&&&
c      do i = 1, nxsec
c         write(*,*) ' sigma=', sigma(i)
c         write(*,*) (cumsigma(j, i), j=1,noOfElem)
c      enddo
c  &&&&&&
      return
c     ************************************
      entry cfixTarget(xs)
c     ************************************
c             xs   xs                        xs
c      jcon = 1    0                         0
c       i          1                         nxsec
      call kfrge(sigma, 1, nxsec,  xs,  i, jcon)
      if(jcon .ne. 0 ) then
         mbindex = 1
      elseif( i .lt. nxsec - 1) then
         mbindex = i + 1
      else
         mbindex = nxsec
      endif

      call rndc(u)
      do j = 1, noOfElem
         if(u .le. cumsigma(j, mbindex))  goto 10
      enddo
 10   continue
      TargetNucleonNo = elemA(j) 
      TargetProtonNo =elemZ(j)
      if( ActiveMdl  == 'jam' .and. 
     *    TrackBefMove.p.code /= kmuon ) then
c          we need xs on the target nucleon for bmax; for other models
c          need not do this
         tgA =  TargetNucleonNo 
c         if(TrackBefMove.p.code <= knuc  .and. 
c     *     (TrackBefMove.p.fm.p(4)-TrackBefMove.p.mass)  < 10.d0) then
         if(TrackBefMove.p.code <= knuc ) then
            call ctotx(TrackBefMove.p, tgA,  TargetXs)
         else
            call cinelx(TrackBefMove.p,  tgA, TargetXs)
         endif
      endif
c///////////////////
c      write(0,*) ' A, Z=', TargetNucleonNo, TargetProtonNo 
c///////////////
      end
