c     cinelx: x A / AA' inelastic xsection
c        
      subroutine cinelx(pj, A, xs)
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zevhnp.h"
      record /ptcl/pj   !input projectile particle
      real*8  A          ! input. effective target mass number
      real*8 xs          ! output. in mb. total xsection. 

      real*8 p, Ek
      integer subcode

      real(8)::shp, shn
      if( pj.fm.p(4) .le. pj.mass) then
         if(pj.code .eq. knuc .and. pj.subcode .eq. antip) then
            xs = largexs
         elseif(pj.code .eq. kelec .and. pj.charge .eq. 1) then
            xs = largexs
         else
            xs  = smallxs
         endif
      else   
         p = sqrt(pj.fm.p(4)**2 - pj.mass**2)
         if(pj.code .eq. knuc) then
            if(pj.charge .eq. 1) then
               call cppInelaXs(p, shp)
               if(A .gt. 1.) then
                  call cnpInelaXs(p, shn)
                  shp = (shp + shn)/2.0
                  call cxp2xAXsec(A, shp, xs)
               else
                  xs = shp
               endif
            elseif(pj.charge .eq. -1) then
               call cpbarpInelaXs(p, shp)
               if( A .gt. 1.) then
                  call cnbarpInelaXs(p, shn)
                  shp = (shp + shn)/2.
                  call cxp2xAXsec(A, shp, xs)
               else
                  xs = shp
               endif
            elseif(pj.subcode .eq. antip) then
c              anti-neutron; assume the same one as pbar
               call cnbarpInelaXs(p, shp)
               if( A .gt. 1.) then
                  call cxp2xAXsec(A, shp, xs)
               else
                  xs = shp
               endif
            else
c               neutron
               call cnpInelaXs(p, shp)
               if(A .gt. 1.) then
                  call cxp2xAXsec(A, shp, xs)
               else
                  xs = shp
               endif
            endif
         elseif(pj.code == kpion .or. pj.code == keta) then
            if(pj.charge .eq. 1) then
               call cpippInelaXs(p, shp)
            elseif(pj.charge .eq. -1) then
               call cpimpInelaXs(p, shp) 
            else 
                  ! pi0 or eta
               call cpimpInelaXs(p, shp)
            endif
            if(A .ne. 1.0) then
               call cxp2xAXsec(A, shp, xs)
            else
               xs = shp
            endif
         elseif(pj.code .eq. kkaon) then
            if(pj.charge .eq. 1) then
               call ckppInelaXs(p, shp)
               if(A .gt. 1.) then
                  call ckpnInelaXs(p, shn)
                  shp = (shp + shn)/2.0
                  call cxp2xAXsec(A, shp, xs)               
               else
                  xs = shp
               endif
            elseif(pj.charge .eq. -1) then
               call ckmpInelaXs(p, shp)
               if(A .gt. 1.) then
                  call ckmnInelaXs(p, shn)
                  shp = (shp + shn)/2.
                  call cxp2xAXsec(A, shp, xs)               
               else
                  xs = shp
               endif
            else
c             k0; don't worry so much 
               call ckmpInelaXs(p, shp)
               call ckmnInelaXs(p, shn)
               shp = (shp+ shn)/2.
               if(A .gt. 1.) then
                  call cxp2xAXsec(A, shp, xs)               
               else
                  xs = shp
               endif
            endif
         elseif(pj.code .eq. kgnuc ) then
c                heavy xs
            subcode =pj.subcode
            Ek = pj.fm.p(4)- pj.mass
            call cAAXsec(subcode, A, Ek, xs)
         elseif(pj.code .eq. kdmes) then
            call ckppInelaXs(p, shp)
            call cxp2xAXsec(A, shp, xs)               
         elseif(pj.code .eq. kgzai .or. pj.code .eq. ksigma .or.
     *           pj.code .eq. kbomega .or. pj.code .eq. klambda .or.
     *           pj.code .eq. klambdac) then
c          don't worry, not used almost at all; use proton
c            shp = ctotpp1(p)
            call cppInelaXs(p, shp)
            call cxp2xAXsec(A, shp, xs)               
         elseif(pj.code .eq. kneumu) then
            xs= smallxs
         elseif(pj.code .eq. kneue) then
            xs= smallxs
         elseif(pj.code == knnb .or. pj.code == kddb ) then
            xs = smallxs
         elseif(pj.code == kmuon) then
            write(0,*) 'cinelx: code=',pj.code, ' should not come'
            stop
         else
c          use pion
            call cpippInelaXs(p, shp)
            call cxp2xAXsec(A, shp, xs)               
         endif
      endif
      end
