      subroutine cgetlf(p,  gb)
c         get Lorentz factor of a particle or 
c         system of particles of which 4 momentum
c         is given in p.
c      p: structure /ptcl/, Input.  4 momentum and mass 
c                           must be given
c     gb: structure /fmom/, Output. (g*beta, g)
c
         implicit none
c----         include '../Zptcl.h'
#include  "Zptcl.h"
         record /ptcl/ p
         record /fmom/ gb
c
         if(p.mass .gt. 0.d0) then
             gb.p(1)=p.fm.p(1)/p.mass
             gb.p(2)=p.fm.p(2)/p.mass
             gb.p(3)=p.fm.p(3)/p.mass
             gb.p(4)=max(p.fm.p(4)/p.mass, 1.d0)
         else
             write(*, *) ' mass=', p.mass, ' invalid to cgetlf'
             stop 9999
         endif
        end   
