c       *****************************************************
c       * 
c       *  cadjm: adjust momentum when energy has changed
c       *
c       ***************************************************
c  call cadjm(p, q)
c  
c  p:  /ptcl/  Input.   4 momeuntum and mass must be given.
c  q:  /ptcl/  Output.  Momentum of p is adjusted and stored in q
c              q can be p.
c
      subroutine cadjm(p, q)
c----      include '../Zptcl.h'
#include  "Zptcl.h"
      record /ptcl/ p, q
c      
      real*8  pabs, cpabs, r
c        |p| from 3 momentum
      call cpxyzp(p.fm, pabs)
c        true |p|      
      cpabs = p.fm.p(4)**2 - p.mass**2
      if(cpabs .gt. 0.d0 .and. pabs .gt. 0.d0) then
           cpabs = sqrt(cpabs)
           r = cpabs/pabs
           q.fm.p(1) = p.fm.p(1) * r
           q.fm.p(2) = p.fm.p(2) * r
           q.fm.p(3) = p.fm.p(3) * r
      else
           q.fm.p(1) =0.
           q.fm.p(2) =0.
           q.fm.p(3) =0.
      endif
      q.fm.p(4) = p.fm.p(4)
      q.mass = p.mass
      end
