      subroutine cphitsOut(n, a)
c       **** note  param00.inc by phits dose not accept implicit none
c            a-h,o-z: double.  i-m; integer
c            New variables here must be explicitly declared
c            without exception 
c      implicit none
#include "Zcode.h"
#include "Zptcl.h"
      include "JQMD/param00.inc"
      integer,intent(out)::n  ! total number of ptcls 
      record /ptcl/ a(*)       !   a(n). each ptcl property
      integer code, subcode, charge

      integer nclst, iclust
*        nclst   : total number of out going particles and nuclei      *
      common /clustf/ nclst, iclust(nnn)
      integer jclust
      real(8):: qclust
      common /clustg/ jclust(0:7,nnn),  qclust(0:12,nnn)

      integer i, j
*                                                                      *
*                j = 0, nucleus                                        *
*                  = 1, proton                                         *
*                  = 2, neutron                                        *
*                  = 3, pion                                           *
*                  = 4, photon                                         *
*                  = 5, kaon                                           *
*                  = 6, muon                                           *
*                  = 7, others                                         *
*                                                                      *

*          jclust(j,:)                                                 *
*                j = 0, angular momentum                               *
*                  = 1, proton number                                  *
*                  = 2, neutron number                                 *
*                  = 3, ip, see below                                  *
*                  = 4,                                                *
*                  = 5, charge                                         *
*                  = 6, baryon number                                  *
*                  = 7, kf code                                        *
*                                                                      *
*        qclust(i,nclst)                                               *
*                                                                      *
*                i = 0, impact parameter                               *
*                  = 1, px (GeV/c)                                     *
*                  = 2, py (GeV/c)                                     *
*                  = 3, pz (GeV/c)                                     *
*                  = 4, etot = sqrt( p**2 + rm**2 ) (GeV)              *
*                  = 5, rest mass (GeV)                                *
*                  = 6, excitation energy (MeV)                        *
*                  = 7, kinetic energy (MeV)                           *
*                  = 8, weight change                                  *
*                  = 9, delay time                                     *
*                  = 10, x-displace                                    *
*                  = 11, y-displace                                    *
*                  = 12, z-displace                                    *
*                                                                      *
*        numpat(i) : total number of out going particles or nuclei     *
*                                                                      *
*                i =  0, nuclei                                        *
*                  =  1, proton                                        *
*                  =  2, neutron                                       *
*                  =  3, pi+                                           *
*                  =  4, pi0                                           *
*                  =  5, pi-                                           *
*                  =  6, mu+                                           *
*                  =  7, mu-                                           *
*                  =  8, K+                                            *
*                  =  9, K0                                            *
*                  = 10, K-                                            *
*                                                                      *
*                  = 11, other particles                               *
*                                                                      *
*                  = 12, electron                                      *
*                  = 13, positron                                      *
*                  = 14, photon                                        *
*                                                                      *
*                  = 15, deuteron                                      *
*                  = 16, triton                                        *
*                  = 17, 3He                                           *
*                  = 18, Alpha                                         *
*                  = 19, residual nucleus                              *
*                                                                      *
*                                                                      *
************************************************************************
      integer kfcode
c/////////
c      write(0,*) 'cphitsOut:  nclst=', nclst
c      write(0,*) '  iclust =',  iclust(1:nclst)
c//////////
      do i=1, nclst
c//////////
c         write(0,*) 'i=', i, ' jclust=',jclust(0:7,i)
c///////////
         if( iclust(i) == 0 ) then
            ! nucleus
            charge = jclust(5,i)
            subcode = jclust(6,i)
            code = kgnuc
         else
            kfcode=jclust(7,i)
c/////////////
c            write(0,*) 'i=',i, "  kfcode =",kfcode, 
c     *           ' iclust=', iclust(i)
c/////////////
            call ckf2cos(kfcode, code, subcode, charge)
         endif
c/////////
c         write(0,*)  ' calling cmkptc'
c////////////
         call cmkptc(code, subcode, charge, a(i))
         
         a(i).fm.p(4) = 
     *    sqrt( (qclust(7, i)/1000.d0)**2 + a(i).mass**2) 
                  ! (7,i) is  K.E in MeV
         a(i).fm.p(1) = qclust(1, i)    ! in GeV/c
         a(i).fm.p(2) = qclust(2, i)
         a(i).fm.p(3) = qclust(3, i)
c/////////////////////
c         write(0,*) ' code ,sub,ch=', code, subcode, charge
c         write(0,*) 'i=',i, ' qclust(1~7,i)=', qclust(1:7, i)
c         write(0,*)
c////////////////   
      enddo
      n = nclst
c/////////
c      write(0,*) ' exiting cjqmdout'
c//////
      end
