c     ******************************************************************
c     *                                                                *
c     * csampNEPIntL: samples integraction length for a given
c     *              non e, gamma  particle in a given material air
c     *                                                                *
c     ******************************************************************
cc            From Epicsv7.0. this is not used from Epcis
c       I.e. this is for Air
c     *****************************************************************
      subroutine  csampNEPIntL
      implicit none
#include  "Zglobalc.h"
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zevhnp.h"

c     **************************************************
c
      real*8 mfp, xs, length

c            
c        m.f.p (kg/m**2) = abn /xsec(mb)

#if defined (LOOPCHK)
c////////////////////
      integer ksave/0/, esave/-1./, ncount/0/
      integer ka
      save
      ka = TrackBefMove.p.code
      if(ksave .eq. ka .and. esave .eq.  
     *   TrackBefMove.p.fm.p(4)) then
         ncount = ncount +1
         if(ncount .gt. 10) then
            write(0,*)'  ncount=',ncount, 
     *        ' ka=',ka, ' e=',esave, ' mass=',
     *      TrackBefMove.p.mass
         endif
      else
         ksave =ka
         esave = TrackBefMove.p.fm.p(4)
         ncount =0
      endif
c///////////////////
#endif

      call cdecayLeng(TrackBefMove, length)

      if(length .ne. Infty) then
         call csetIntInf(length, .true., 'decay')
      endif
c      nnb ddb rho phi omega ---> length=0 (instant decay)
c              or stopping mu pi etc -> length=0 
      if(length .gt. 0.) then 
         if(TrackBefMove.p.charge .ne. 0) then
c                  heavy (non e+/e-) knockon
c             if Freec and mu or had makes first hadronic
c             interaction, this call will be non-effective
            call cknockonH
         endif
c                  non stopping-decay paticle
         if( TrackBefMove.p.code .eq. kmuon) then
c                   muon; pair, brems, n.i   
            call csampMuint(xs, mfp)
         else   
c                hadronic  collisions
            call csampHadint(xs, mfp)
            if(xs .ne. smallxs .and. xs .ne. largexs) then
c                 fix target
               call cfixTarget(xs)
            endif
         endif
      endif
      end

      subroutine csampMuint(xs, mfp)
      implicit none
#include  "Zglobalc.h"
c #include  "Zcode.h"
#include  "ZbpCnst.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
c #include  "Zheavyp.h"
#include  "Zelemagp.h"
#include  "Zevhnp.h"
c #include  "Zevhnv.h"
#include  "Zcmuint.h"
      real*8   xs, mfp

      real*8  prob, path, collkgram

      xs = smallxs
      if(MuPr .ge. 2 .and.
     *     TrackBefMove.p.fm.p(4) .gt. muPrEmin) then
         call cmuPrsmpP(TrackBefMove.p.fm.p(4), prob, path)
c          prob is /r.l  path is in r.l     
c          prob   /r.l /X0    --> prob/ (kg/m2) *10 -> prob/(g/cm2)
c          = mb*4.138e-5
c            mb2pg = 1.e-27 * Avogn/A = 4.138e-5
c          xs =prob*10/X0/mb2pg = prob*10/X0*A/Avogn*1.e27
c             = prob/X0*A/Avogn*1.e28
c             = prob/X0*A*A2deninv    
c       (   A2deninv = 1.d28/Avogn   )
c         xs =max( prob/X0* A2deninv*TargetMassN, smallxs)
c           n mfp xs =1    
         xs =max( prob/mbtoPX0, smallxs)
         collkgram = path * X0  ! kg/m^2
         call csetIntInf(collkgram, .false., 'mupair')
      endif
      if(MuBr .ge. 2 .and. 
     *     TrackBefMove.p.fm.p(4) .gt. muBrEmin) then
               
         call cmuBrsmpP(TrackBefMove.p.fm.p(4), prob, path)
         xs =max( prob/mbtoPX0, smallxs)
         collkgram = path * X0 ! kg/m^2
         call csetIntInf(collkgram, .false., 'mubrem')
      endif
      if(MuNI .ge. 2 .and. 
     *     TrackBefMove.p.fm.p(4) .gt. muNEmin) then
         call cmuNsmpP(TrackBefMove.p.fm.p(4), prob, path)
         xs =max( prob/mbtoPX0, smallxs)         
         collkgram = path * X0 ! kg/m^2
         if( xs .ne. smallxs .and.
     *        .not.Freec .and. Zfirst.pos.depth .eq. 0. ) then
            collkgram = 0.
         endif
         call csetIntInf(collkgram, .false., 'munuci')

         if( xs .ne. smallxs .and. xs .ne. largexs ) then
c                 fix target; used only n.i
            call cfixTarget(xs)
         endif
      endif
      end


      subroutine csampHadint(xs, mfp)
      implicit none
#include  "Zglobalc.h"
c #include  "Zcode.h"
c #include  "ZbpCnst.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
c #include  "Zheavyp.h"
c #include  "Zelemagp.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
#include  "Zcmuint.h"
      real*8   xs, mfp

      real*8  prob, path, collkgram, u

      if(ActiveMdl .eq. 'phits') then
         call cmfpPhits(xs, mfp)
      elseif(ActiveMdl .eq. 'dpmjet3') then
         call cmfpdpmjet3(xs, mfp)
      elseif( ActiveMdl .eq. 'jam') then
         call cmfpjam(xs, mfp)
      elseif(ActiveMdl .eq. 'qgsjet2') then
         call cmfpqgsjet2(xs, mfp)
      elseif(ActiveMdl .eq. 'gheisha') then
         call cmfpgheisha(xs, mfp)
      elseif(ActiveMdl .eq. 'incdpm3') then

         call cmfpincdpm3(xs, mfp)
      else
         call cmfpother(xs, mfp)
      endif
c                    for hadronic interaction 
c                 we can fix the fist col. point at the input
c                 point when Freec=f
      if(xs .eq. smallxs) then
         collkgram = Infty
      elseif(.not. Freec .and. Zfirst.pos.depth .eq. 0. ) then
c         forced collision at the inut deth.
         collkgram = 0.
      elseif( xs .eq. largexs) then
c                  say stopping pbar
         collkgram = 0.
      else
c                 sample interaction length
         call rndc(u)
         collkgram=-mfp*log(u)
      endif
      call csetIntInf(collkgram, .false., 'coll')

      end

      subroutine cmfpdpmjet3(xs, mfp)
      implicit none
#include  "Zglobalc.h"
#include  "Zcode.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
#include  "Zcmuint.h"
      real*8   xs, mfp


c      record /ptcl/ dumkaon, dumproton
      integer ka, ica
      ka = TrackBefMove.p.code
      ica = TrackBefMove.p.charge

      if( ka .eq. knuc .or. ka .eq. kpion   .or.
     *    ka .eq. kkaon) then
         if( TrackBefMove.p.fm.p(4)  .lt. 4.1  ) then ! this is smoother
c     *     (TrackBefMove.p.fm.p(4) - TrackBefMove.p.mass)
c     *        .lt.  5.0 
c                     danger 5.0 is fixed &&&&&&&&&&
c             use total X-section
            call ctotx(TrackBefMove.p, TargetMassN,  xs)
            mfp = A2deninv*TargetMassN/xs ! in kg/m2
         else
            call cmfpother(xs,mfp)
         endif
      else
         call cmfpother(xs, mfp)
      endif
      end
      subroutine cmfpPhits(xs, mfp)
      implicit none
#include  "Zglobalc.h"
#include  "Zcode.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
#include  "Zcmuint.h"
      real*8   xs, mfp


      integer ka, ica, subc, ia, iz
      real(8):: u, elaxs

      ka = TrackBefMove.p.code
      subc = TrackBefMove.p.subcode

      ia = TargetMassN
      iz = TargetAtomicN
      call rndc(u)
      if(u .lt.  TargetMassN - ia) then
         ia = ia +1
      endif
      if(u .lt. TargetAtomicN - iz ) then
         iz = iz + 1
      endif

      if( ( ka == knuc .and. subc /= antip )
     *  .or. ka == kgnuc) then
         call cphitsXs(TrackBefMove.p, ia, iz, elaxs,  xs)
         mfp = A2deninv*TargetMassN/xs ! in kg/m2
      else
         call cmfpother(xs, mfp)
      endif
      end
      subroutine cmfpjam(xs, mfp)
      implicit none
#include  "Zglobalc.h"
#include  "Zcode.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
#include  "Zcmuint.h"
      real*8   xs, mfp


c      record /ptcl/ dumkaon, dumproton
      integer ka, ica
      real(8):: KE

      ka = TrackBefMove.p.code
      ica = TrackBefMove.p.charge

      if( ka .eq. knuc .or. ka .eq. kpion   .or.
     *    ka .eq. kkaon) then
         KE = TrackBefMove.p.fm.p(4) - TrackBefMove.p.mass
c     if you change next (10), do similar in cixsec @ call cinelx.
         if( KE < 10.d0  ) then ! consider elastic too
            call ctotx(TrackBefMove.p, TargetMassN,  xs)
         else
            call cinelx(TrackBefMove.p, TargetMassN,  xs)
         endif
         mfp = A2deninv*TargetMassN/xs ! in kg/m2
      else
         call cmfpother(xs, mfp)
      endif
      end

      subroutine cmfpqgsjet2(xs, mfp)
      implicit none
#include  "Zglobalc.h"
#include  "Zcode.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
#include  "Zcmuint.h"
      real*8   xs, mfp

      logical here
      record /ptcl/ proj
      integer ka, ica, ia
      real*8 u
      
      here = .false.
      proj = TrackBefMove.p
      ka = proj.code
      ica = proj.charge
      if( ka .eq. kpion) then
         here =.true.
      elseif(ka. eq. knuc) then
         here = .true.
      elseif(ka .eq. kkaon) then
         here = .true.
      elseif(ka .eq. kgnuc) then
         here = .true.
      elseif( ka .eq. kdmes) then
         here = .true.
c                   use kaon
         if(ica .ne. 0) then
            call cmkptc(kkaon, -1, ica, proj)
         else
            call cmkptc(kkaon, k0l,  0, proj)
         endif
      elseif(ka .eq. kgzai .or. ka .eq. ksigma .or.
     *     ka .eq. kbomega    .or. ka .eq.  klambda .or. 
     *     ka .eq. klambdac ) then
         here = .true.
c                   use proton
         call cmkptc(knuc, -1, 1, proj)
      endif
      if(here ) then
         ia = TargetMassN
         call rndc(u)
         if(u .lt.  TargetMassN - ia) then
            call cxsecQGS(proj, ia+1, xs)
         else
            call cxsecQGS(proj, ia, xs)
         endif
         mfp = A2deninv*TargetMassN/xs   ! in kg/m2
      else
         call cmfpother(xs, mfp)
      endif
      end

      subroutine cmfpincdpm3(xs,mfp)
      implicit none
#include  "Zglobalc.h"
#include  "Zcode.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
      real*8   xs, mfp

      real*8 crossint, ek
      integer kinc

      ek = TrackBefMove.p.fm.p(4)- TrackBefMove.p.mass

      if( ek .gt. 0.2d0 ) then
c            special for inclusive treatment.  target is always air
c         *********************************
         call cccode2hcode(TrackBefMove.p, kinc)
         xs = crossint(kinc, ek)
         mfp = A2deninv*TargetMassN/xs ! in kg/m2
      else
         xs = smallxs
         mfp = Infty
      endif
      end

      subroutine cmfpgheisha(xs, mfp)
      implicit none
#include  "Zglobalc.h"
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"

      real*8 xs, mfp
      integer ka

      ka = TrackBefMove.p.code
c         *******************************
c                Gheisha should be used for collisions
c                it include elastic scattering;
      if(ka .eq.  kpion .or.  ka .eq. kkaon .or. ka .eq. knuc) then
         call cxsecGheisha(TrackBefMove.p, 
     *        TargetMassN, TargetAtomicN, xs)
         mfp = A2deninv*TargetMassN/xs ! in kg/m2
      elseif( ka .eq. ktriton ) then
         call cxsecGheisha(TrackBefMove.p,
     *        TargetMassN, TargetAtomicN, xs)
         mfp = A2deninv*TargetMassN/xs ! in kg/m2   
      else
         call cmfpother(xs, mfp)
      endif
      end

      subroutine cmfpother(xs, mfp)
      implicit none
#include  "Zglobalc.h"
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zevhnp.h"

      real*8 xs, mfp
      integer ka, ica, subcode
      real*8 ek

      ka =TrackBefMove.p.code 
      ica =TrackBefMove.p.charge
      ek =TrackBefMove.p.fm.p(4)-TrackBefMove.p.mass
c         get mean free path for collision
      if(ka .eq. kpion .or. ka .eq. keta) then
         if(ica .ge. 0) then    ! pi+, 0. 
            call cpiPlusAXsec(TargetMassN, ek, xs)
         else
            call cpiMinusAXsec(TargetMassN, ek, xs)
         endif
      elseif(ka .eq. kkaon) then
         if(ica .ge. 0) then
            call ckPlusAXsec(TargetMassN, ek, xs)
         else
            call ckMinusAXsec(TargetMassN, ek, xs)
         endif
      elseif(ka .eq. knuc) then
         if(TrackBefMove.p.subcode .eq. antip) then
            if(TrackBefMove.p.fm.p(4) .gt. TrackBefMove.p.mass ) then
               call cpbarAXsec(TargetMassN, ek, xs)
            else
               xs = largexs
            endif
         else
            call cprotonAXsec(TargetMassN, ek, xs)
         endif    
      elseif(ka .eq. kgnuc ) then
c          heavy xs
         subcode =TrackBefMove.p.subcode
         call cAAXsec(subcode, TargetMassN, ek, xs)
      elseif(ka .ge. kalfa .and. ka .le. khvymax) then    
         write(0,*) 'will not come; csampNEPIntL'
         stop 
      elseif(ka .eq. kneumu) then
         xs= smallxs
      elseif(ka .eq. kneue) then
         xs= smallxs
      elseif(ka .eq. kdmes) then
         call ckPlusAXsec(TargetMassN, ek, xs)
c                nnb, ddb, will not come here    
      elseif(ka .eq. kgzai .or. ka .eq. ksigma .or.
     *     ka .eq. kbomega    .or. ka .eq.  klambda .or. 
     *     ka .eq. klambdac ) then
ccc               use proton x-section            
         call cprotonAXsec(TargetMassN, ek, xs)
      else
         write(0,*)
     *   ' csampNEPIntL/cmfpother:  strange ptcl: ka=',ka
         stop 12222
      endif


      if(xs .eq. smallxs) then
         mfp = Infty
      elseif( xs .eq. largexs) then
         mfp = 0. 
      else
         mfp = A2deninv*TargetMassN/xs ! in kg/m2
      endif
      end

      subroutine cknockonH
      implicit none
#include  "Zglobalc.h"
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zelemagp.h"
#include  "Zevhnv.h"
      real*8 prob, path
c              knock on by non e+/e- charged ptcl
      call cKnockp(TrackBefMove.p, prob, path) ! path in r.l
      if(prob .gt. 0.d0) then
         call csetIntInf(path *X0, .false., 'knock')
      else
         call csetIntInf(Infty,   .false., 'knock')
      endif
      end
