c              test kdwhereis
c  
c     
c      implicit none
cc      real*8 xa(5)/-1., 0., 1.33, 1.33, 9./
c      real*8 xa(5)/9.d0, 1.33d0, 1.33d0, 0.d0, -1.d0/
c      real*8 x
c      integer ios, loc
c      do while(1)
c        write(*,*) xa
c        write(*, *) 'enter x'
c        read(*, *, iostat=ios)  x
c        if(ios .ne. 0) stop
c        call kdwhereis(x, 5, xa, 1, loc)
c        if(loc .eq. 0 .or. loc .eq. 5) then
c           write(*, *) " out of range"
c        endif
c        write(*, *) " loc=", loc, " xa =", xa(loc), xa(loc+1) 
c      enddo
c      end
c --------------------------------------------------------------------
c       find location of a given double value in a sorted given double
c     array.
c
c     *********************************
      subroutine kdwhereis(x, in, a, step, loc)
c     *********************************
c      x : real*8. input. given double value.
c     in : integer. input. number of data in a.
c      a : real*8 a(step, in). input array.
c                 a(1, 1), a(1, 2), a(1, 3)... are examined.
c    step: integer. input. see above. give 1 for one dim. array.
c     loc: integer. ouput.  a(1,loc) <= x < a(1,loc+1)  if a is ascending
c                                (if a(1,in) = x, loc= in)
c                           a(1, loc) > x >= a(1, loc+1) if a is dscending
cc                              (if a(1,1) = x, loc = 0)
c                   if loc=0 or loc =in; x is out of range.

      implicit none
      integer in, loc, step
      real*8  x, a(step, in)

      logical  ascending
      integer i1, i2, im
      
      i1 = 0             ! lower and
      i2 = in + 1        ! upper bound
      
      ascending = a(1, in) .gt. a(1, 1) 
      do while (i2 - i1 .gt. 1)
            im = (i1 + i2)/2
            if( ascending .eqv. x .ge. a(1, im) ) then
               i1 = im
            else
               i2 = im
            endif
      enddo       
      loc = i1
      end
c
c     *********************************
      subroutine kwhereis(x, in, a, step, loc)
c     *********************************
c      x : real*4. input. given  value.
c     in : integer. input. number of data in a.
c      a : real*4 a(step, in). input array.
c                 a(1, 1), a(1, 2), a(1, 3)... are examined.
c    step: integer. input. see above. give 1 for one dim. array.
c     loc: integer. ouput.  a(1,loc) <= x < a(1,loc+1)  if a is ascending
c                                (if a(1,in) = x, loc= in)
c                           a(1, loc) > x >= a(1, loc+1) if a is dscending
cc                              (if a(1,1) = x, loc = 0)
c                   if loc=0 or loc =in; x is out of range.

      implicit none
      integer in, loc, step
      real*4  x, a(step, in)

      logical  ascending
      integer i1, i2, im
      
      i1 = 0             ! lower and
      i2 = in + 1        ! upper bound
      
      ascending = a(1, in) .gt. a(1, 1) 
      do while (i2 - i1 .gt. 1)
            im = (i1 + i2)/2
            if( ascending .eqv. x .ge. a(1, im) ) then
               i1 = im
            else
               i2 = im
            endif
      enddo       
      loc = i1
      end
