      subroutine cllh2sph(llh, sph)
c       llh:  /coord/ structure. input. lat_long_height
c       sph:  /coord/ structue. output.. spherical coordinate system
c
c    ***  note  ***
c          sph can be the same as llh.  time component is unchanged
c
      implicit none

#include  "Zglobalc.h"
#include  "Zcoord.h"
#include  "Zearth.h"
      record /coord/llh,  sph
      record /coord/ temp
#include  "Zcoordtype.h"
c         ecentricity 0 approximation
#ifdef UNIONMAP
           temp.radius = llh.h + Eradius
           temp.theta = 90.d0 - llh.lat
c
           if(llh.long .lt. 0.d0) then
              temp.phi = llh.long + 360.d0
           else
              temp.phi = llh.long
           endif
#else
           temp.r(3) = llh.r(3) + Eradius
           temp.r(1) = 90.d0 - llh.r(1)
c
           if(llh.r(2) .lt. 0.d0) then
              temp.r(2) = llh.r(2) + 360.d0
           else
              temp.r(2) = llh.r(2)
           endif
#endif
           temp.sys = coord_types(3)
           sph = temp
       end
