c      include 'cllh2eCent.f'
c     program test_ceCent2llh
c
c      include '../Zcoord.h'
c      record /coord/ a, b
c      integer ios
c      real*8 x, y, z 
c      do while (.true.)
c         read(*, *,iostat=ios) x, y, z
c         if(ios .ne.. 0) goto 10
c         call csetCoord('llh', x, y, z, a)
c         call cconv_coord_to('ecen', a, b)
c         call cconv_coord_to('llh',  b, a)
c         write(*,*) a.lat, a.long, a.h
c      enddo   
c 10   continue
c      end
c    earth center rectangular coordinate to longitude latitude height 
c    coordinate  converstion.
c
      subroutine ceCent2llh(xyz, llh)
c       xyz:  /coord/ structue. Input. The coordinate system is
c            such that the origin is at  the center of the earth
c            x-axis is directed to (0, 0) latitude and longitude.
c            y-axis is directed to (0, 90) latitude and longitude.
c            z-axsi is directed to the north pole.
c       llh:  /coord/ structure. Output. to contain data in latitude,
c                                       longitude, height.
c    ***  note  ***
c           llh can be the same as xyz.  time component is unchanged
c
      implicit none
c----      include '../../Zglobalc.h'
#include  "Zglobalc.h"
c----      include '../Zcoord.h'
#include  "Zcoord.h"
c----      include 'Zearth.h'
#include  "Zearth.h"
      record /coord/llh,  xyz
      record /coord/ temp
c
      real*8 n, cosphi, sinphi, cosl, sinl, hold
      integer i
c        start with ecentricity 0 approximation
         temp.h = 0.
         n = Eradius
         do i = 1, 6
            hold = temp.h
            temp.h = sqrt( xyz.r(1)**2 + xyz.r(2)**2 +(xyz.r(3)/
     *      (1.d0 - n*ecen2/(n+temp.h)))**2 ) - n
             cosphi = sqrt( (xyz.r(1)/(n+temp.h))**2 +
     *                      (xyz.r(2)/(n+temp.h))**2 ) 
             sinphi = xyz.r(3)/(n*one_ecen2 + temp.h)
c      
             cosl = xyz.r(1)/(n+temp.h)/cosphi
             sinl = xyz.r(2)/(n+temp.h)/cosphi
             n = Eradius /sqrt(1.d0 - ecen2*sinphi**2)
            if(abs(temp.h -hold) .lt. 1.d-2) goto 100   ! abs error < 1 mm 
         enddo 
 100     continue
c        write(*, *) ' i=', i  !  <i> = 4 
c
         temp.lat = atan2(sinphi, cosphi)*Todeg
         temp.long = atan2(sinl, cosl)*Todeg
         llh.lat = temp.lat
         llh.long = temp.long
         llh.h = temp.h
         llh.sys = coord_types(2)
       end

