c   This version is faster than cl2tT and accurracy is comparable.
c
c     *********************************************
      real*8 function clen2thickTA(z,  leng)
c
c     z: real*8. input.  vertical height in m.
c   leng: real*8. input.  length along cosz direction.
c   function value.      thickness of air in kg/m2. for leng
      implicit none
#include "Zatmos.h"
      real*8 z,  leng
      real*8  s1, t1, s2, t2

c          get slant length along cosz for z:   s1
c          get slant length ; s2 = s1 + leng
c          get thickness <-- by T vs slant length
      call cl2tIntp(HeightTbl, LenTbl, z, s1)
      call cl2tIntp(LenTbl, ThickTbl, s1, t1)
      s2 = s1 + leng
      call cl2tIntp(LenTbl, ThickTbl, s2, t2)
      clen2thickTA = t2 - t1   		
      if(clen2thickTA  .le. 0.) then
c          actually case of < 0 dose not happen.
c          when particle comes to the last segment of 
c          the table,  this happens.  and the
c          particle does not move at all. To avoid this
c          give some thikness. (actually this is not
c          used but this is for comfort only)
         clen2thickTA  = 10.
      endif
      end
c          
      subroutine cl2tIntp(x, y, xx, ans)
      implicit none
#include "Zatmos.h"

	real*8 x(*)  !  input. 
        real*8 y(*)  !  input.
        real*8  xx   !  input. some value inside x(*).
        real*8  ans  !  output.  interpolated value of y at xx.

	real*8 error
	integer  m
	integer loca, k
	parameter (m = 3)  ! old value was 5
c            where is xx in x
	call kdwhereis(xx, NumStep, x, 1, loca)
        if(loca .ge. NumStep) then
c            give arbitray large value.
  	     ans = y(NumStep)
        else
c              use max of m points around loca for interpolation
             k = min(max(loca - (m-1)/2,1), NumStep+1-m) 
                            ! max of m points from k
             call kpolintp(x(k), 1, y(k), 1, m, xx, ans, error)
	endif
        end
c         get slant length  corresponding to slant thickness
c
      real*8 function ct2lTA(z,  t)
      implicit none
#include "Zatmos.h"

      real*8 z  ! input vertical height in m
      real*8 t  !  input.  thickness of air in kg/m^2 along cosz
c
      real*8 t1, t2, s1, s2
c          z ---> thick 
      call cl2tIntp(HeightTbl, ThickTbl, z, t1)
      call cl2tIntp(HeightTbl, LenTbl,  z, s1)
      t2 = t1 + t
      call cl2tIntp(ThickTbl,  LenTbl, t2, s2)
      ct2lTA = s2- s1	
      if(ct2lTA .le. 0.) then
c           actually case of < 0 dose not happen.
c           when a particle comes to an end segment of
c           a table, this happnes and the particle 
c           cannot move. To avoid this, give some
c           finite value to move it.
c           clen2thickTA  a thickness corresponding to this length
c           but is not used since the particle reaches
c           the bottom observation depth.
         ct2lTA = 10.
      endif
      end
