c
c     ctotx: x A collsion total cross section 
c      
      subroutine ctotx(pj, A, xs)
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zevhnp.h"
      record /ptcl/pj   !input projectile particle
      real*8  A          ! input. effective target mass number
      real*8 xs          ! output. in mb. total xsection. 

      real ctotpp1, ctotpn1, ctotpiPp1, ctotpiMp1, ctotkPp1
      real ctotnp1, ctotkPn1, ctotkMn1, ctotkMp1
      real ctotpbarp1, ctotpbarn1
      real p

      real*8 shp
      if( pj.fm.p(4) .le. pj.mass) then
         if(pj.code .eq. knuc .and. pj.subcode .eq. antip) then
            xs = largexs
         elseif(pj.code .eq. kelec .and. pj.charge .eq. 1) then
            xs = largexs
         else
            xs  = smallxs
         endif
      else   
         p = sqrt(pj.fm.p(4)**2 - pj.mass**2)
         p = max(p, 0.1d0) 
         if( p .ge. 20.) then          
            call cerrorMsg('Momentum is >20 GeV/c for ctotx',0)
         endif

         if(pj.code .eq. knuc) then
            if(pj.charge .eq. 1) then
c            proton
               shp = ctotpp1(p)
               if(A .gt. 1.) then
c               use average of pp,pn
                  shp =( ctotpn1(p) + shp)/2.0
                  call cxp2xAXsec(A, shp, xs)
               else
                  xs = shp
               endif
            elseif(pj.charge .eq. -1) then
c             pbar
               shp = ctotpbarp1(p)
               if( A .gt. 1.) then
                  shp = (shp + ctotpbarn1(p))/2.0
                  call cxp2xAXsec(A, shp, xs)
               else
                  xs = shp
               endif
            elseif(pj.subcode .eq. antip) then
c              anti-neutron; assume the same one as pbar
               shp = ctotpbarp1(p)
               if( A .gt. 1.) then
                  shp = (shp + ctotpbarn1(p))/2.0
                  call cxp2xAXsec(A, shp, xs)
               else
                  xs = shp
               endif
            else
c               neutron
               shp = ctotnp1(p)
               if(A .gt. 1.) then
                  call cxp2xAXsec(A, shp, xs)
               else
                  xs = shp
               endif
            endif
         elseif(pj.code .eq. kpion) then
            if(pj.charge .eq. 1) then
               shp = ctotpiPp1(p)
            elseif(pj.charge .eq. -1) then
               shp = ctotpiMp1(p)
            else
c              at low energy, pi0 would not interact. any would be o.k
               shp = ctotpiMp1(p)
            endif
            if(A .ne. 1.0) then
               call cxp2xAXsec(A, shp, xs)
            else
               xs = shp
            endif
         elseif(pj.code .eq. kkaon) then
            if(pj.charge .eq. 1) then
               shp = ctotkPp1(p)
               if(A .gt. 1.) then
                  shp = (shp + ctotkPn1(p))/2.0
                  call cxp2xAXsec(A, shp, xs)               
               else
                  xs = shp
               endif
            elseif(pj.charge .eq. -1) then
               shp = ctotkMp1(p)
               if(A .gt. 1.) then
                  call cxp2xAXsec(A, shp, xs)               
               else
                  xs = shp
               endif
            else
c             k0; don't worry so much
               xs =( ctotkMp1(p) +ctotkPp1(p))/2.0
            endif
         elseif(pj.code .eq. kgzai .or. pj.code .eq. ksigma .or.
     *           pj.code .eq. kbomega .or. pj.code .eq. klambda .or.
     *           pj.code .eq. klambdac) then
c          don't worry, not used almost at all; use proton
            shp = ctotpp1(p)
            call cxp2xAXsec(A, shp, xs)               
         else
c          use pion
            shp =ctotpiPp1(p)
            call cxp2xAXsec(A, shp, xs)               
         endif
      endif
      end
cc      collection of subroutines for the total Xsection at low
cc      energy (0.1<= p <20 GeV/c), (some can be used upto 400 GeV/c,though)
cc      If p<0.1,  extrapolation is used.
cc    ctotpp1:  pp
cc    ctotpn1:  pn
cc    ctotnp1:  np
cc    ctotpiPp1: pi+ p
cc    ctotpiMp1: pi- p
cc    ctotkPp1 : K+ p
cc    ctotkMp1 : K- p
cc    ctotkPn1 : k+ n
cc    ctotkMn1 : k- n
cc    ctotpbarp1: pbar p
cc    ctotpbarn1: pbar n
cc
c        test  ctotnp1
c      real p, dx
c      real ctotkPp1
c      p =0.1
c      dx = 10.**0.02
c      do while(p .lt. 20.)
c         write(*,*)  p, ctotkPp1(p)
c         p = p*dx
c      enddo
c      end

      real function ctotpp1(p)
      implicit none
      real p
      real cbwf
      
      if(p .lt. 1.) then
         ctotpp1 = 3.009*p**(-2.3604) + 23.718*p**1.1771
      elseif(p .lt. 3.) then
         ctotpp1 = cbwf(p,69.431, 1.8412, 1.4112) +
     *   ((( 5.7451*p -62.796)*p+236.04)*p-324.81)*p+104.63
      elseif(p .le. 20.) then
         ctotpp1 = 292.99*p**(-3.936) + (4.484e-3*p-0.2298)*p+41.677
      else
         write(0,*) ' p>20 for ctotpp1'
         stop
      endif
      end

      real function cbwf(x, n, g, m)
      implicit none
      real x    ! input   argument
      real n    ! input.  
      real g    ! input.  n/( (x-m)**2 + g**2/4)
      real m    ! input.

      cbwf = n/( (x-m)**2 + g**2/4.)
      end

      real function ctotpn1(p)
      implicit none
      real p
      real cbwf

      if(p .lt. 0.5) then
         ctotpn1 = 3701*exp(-13.943 *p) + 22.886*p**(-1.3236)
      elseif(p .lt. 2.) then
         ctotpn1 = ((-28.085*p+119.79)*p-154.08)*p+94.417
      elseif(p .lt. 20.) then
         ctotpn1 = 42.5*p**(-0.01) + cbwf(p, 0.4,1.2, 3.0) 
      else
         write(0,*) 'p >20 for ctotpn1'
         stop
      endif
      end
      

      real function ctotpiMp1(p)
      implicit none
      real p, cbwf
      
      if(p .lt. 0.5) then
         ctotpiMp1 = cbwf(p,.33629, .14611,.28354) -11.929+ 63.901*p
      elseif(p .lt.0.6) then
         ctotpiMp1 = (399.63*p -393.91 )*p+123.76
      elseif(p .lt. 1.0) then
         ctotpiMp1 = cbwf(p, .35965, .20485, .71909)
     *     + (475.17*p-657.50)*p+239.04
      elseif(p .lt. 1.5) then
         ctotpiMp1 = 45.121*p**(-6.6374) + 18.609*p** 1.4841  
      elseif(p .lt. 3.) then
         ctotpiMp1 = cbwf(p,1.9462,1.00000,2.1448)
     *  +  (5.8400*p-26.557)*p + 58.432
      elseif(p .lt. 30.) then
         ctotpiMp1 = 24.441*p**(-.79000)+21.700*p**0.018238
      else
         write(0,*) 'p > 30 for ctotpiMp1'
         stop
      endif
      end

      real function ctotpiPp1(p)
      implicit none
      
      real p
      real cbwf

      
      if(p .lt. 0.7) then
         ctotpiPp1 =
     *      cbwf(p, 1.1809, .15314, .28615) 
         if( p.gt. 0.16) then
            ctotpiPp1 = ctotpiPp1 +
     *           (-275.07*p + 291.24)*p - 63.356
         else
            ctotpiPp1 = ctotpiPp1 - 23.8
         endif
      elseif(p .lt. 5.0) then
         ctotpiPp1 =  -.94717+ 4.6646*p +
     *    cbwf(p, 1.4369, .53300, 1.4382) +
     *    cbwf(p,  49.446, 3.2948,2.4000) +
     *    cbwf(p,.67273E-01,  .24781,  1.0000)
      elseif(p .lt. 50.) then
         ctotpiPp1 = 35.613*p**( -.91977E-01)
     *     +  (-.29886E-03 *p+.72519E-01)*p -4.7220
      else
         write(0,*) ' p>50 for ctotpiPp1'
         stop
      endif
      end

      real function ctotpbarp1(p)
      implicit none
      real p
      
      if(p .lt. 400.) then
         ctotpbarp1 = 42.688*p**( -1.0786) +73.078*p**(-.12905)
      else
         write(0,*) 'p>400 for ctotpbarp1'
         stop
      endif
      end


      real function ctotpbarn1(p)
      implicit none
      real p
      
      if(p .lt. 1.5) then
         ctotpbarn1 = 42.688*p**( -1.0786) +73.078*p**(-.12905)
      elseif(p .lt. 20.) then
         ctotpbarn1 = (.15486*p -6.4753)*p + 106.97
      else
         write(0,*) 'p>20 for ctotpbarn1'
         stop
      endif
      end
      

      real function ctotnp1(p)
      implicit none
      real p
      
      if(p .lt. 0.35) then
         ctotnp1 = 2826.6*p**( -.40368)
     *     + (-3995.7*p+ 7261.2)*p-6264.6
      elseif( p .lt. 1.) then
         ctotnp1 =      3.8610*p**( -3.0300 ) +29.597*p**.87645E-01  
      elseif( p .lt. 5.) then
         ctotnp1 =
     *     (((-.12211*p+2.2861 )*p-13.855)*p+ 34.136)*p+ 10.944
      elseif(p .lt. 30.) then
         ctotnp1 =
     *   (((-.76651E-05*p+ .53401E-04)*p+.25548E-01)*p-.81076)*p+45.079
      else
         write(0,*) 'p>30 for ctotnp1'
         stop
      endif
      end


      real function ctotkMp1(p)
      implicit none
      real p
      
      real cbwf

      if(p .lt. 0.5) then
         ctotkMp1 = cbwf(p,.16388E-01, -.49100E-01, .39254)
     *      + 16.765*p**(-1.3001)
      elseif( p .lt. 1.) then
         ctotkMp1 = cbwf(p,.97045E-01,.20000,.79000)
     *         + ( 273.85*p -400.32)*p+ 175.49
      elseif( p .lt. 2.) then
         ctotkMp1 = cbwf(p, 3.6881,.7000, 1.6500)
     *   + ( 102.70 *p  -340.28)*p+  286.09
      elseif(p .lt. 20.) then
         ctotkMp1 = 18.763*p**(-1.6286) +
     *         ( .10302E-01*p-.41391)*p+ 25.430
      else
         write(0,*) 'p>20 for ctotkMp1'
         stop
      endif
      end



      real function ctotkMn1(p)
      implicit none
      real p
      
      real cbwf

      if(p .lt. 20.) then
         ctotkMn1 = cbwf(p, 1.0452, -.54014, 1.0119)
     *      + 22.119 -.12937*p
      elseif( p .lt. 400.) then
         ctotkMn1 =
     *    (.40954E-05*p +  .35501E-02)*p + 19.540
      else
         write(0,*) 'p>400 for ctotkMn1'
         stop
      endif
      end


      real function ctotkPn1(p)
      implicit none
      real p
      
      real cbwf

      if(p .lt. 1.5) then
         ctotkPn1 = cbwf(p,.17000,-.38564,1.1204) +
     *         10.890 +4.7535*p
      elseif(p .lt. 3.0) then
         ctotkPn1 =
     *   (((.18020*p -.73918)*p -.62824)*p+ 4.7551)*p + 14.611
      elseif(p .lt.50.) then
         ctotkPn1 =
     *   (((.71283E-06*p-.97370E-04)*p+.46866E-02)
     *     -.69113E-01)*p+17.870
      else
         write(0,*) 'p>50 for ctotkPn1'
         stop
      endif
      end



      real function ctotkPp1(p)
      implicit none
      real p
      
      real cbwf

      if(p .lt. 1.0) then
         ctotkPp1 = 
     *   (((10.374*p+ 48.352)*p  -103.59)*p + 57.477)*p+ 3.9947
      elseif(p .lt. 3.70) then
         ctotkPp1 = cbwf(p, .59260E-01, -.31455, 1.2247) +
     *   (((-.33717*p +4.1286)*p -17.731)*p + 31.772)*p-2.6480
      elseif(p .lt.500.) then
         ctotkPp1 =
     *       ( -.71228E-05*p + .12423E-01)*p + 17.526
      else
         write(0,*) 'p>500 for ctotkPp1'
         stop
      endif
      end
