      subroutine chookEabsorbi(info)
c           init for each event
      implicit none
#include "Zmaxdef.h"
#include "Zcode.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"
#include "./Zabsorb.h"
      integer info ! not used now
      integer i
      do i = 0, NoOfSites + 1
c            i = 0 and NoOfSite+1 will not be used now. 
         dEbydEdx(i) = 0.
         dEbyDeath(i) = 0.
         dEbyDeathG(i) = 0.
         dEbyDeathE(i) = 0.
         dEbyDeathMuPiK(i) = 0.
         dEbyDeathNeu(i) = 0.
         dEbyDeathP(i) = 0.
         dEbyDeathNut(i) = 0.
         dEbyDeathO(i) = 0.
      enddo
      do i = 1, 7
c          i for g,e,mu,pi,K, n, (neu and others)
c             Energy crashing to the given layer
c             default is the NoOfSites. Can be changed by Eabosrb(2)
         Ecrash(i) = 0.
c             Energy escaping to the upper bound( default is injection
c             height + 1m)  
         Espace(i) = 0.
      enddo
c          counter used for checking energy conservation 
c          at the multiple producion.   
c           negative value is generated energy is < ininial energy
c           positive value is generated energy is > initial energy 
      do i = 1, 2
c         i=1 for max Ebreak, i=2 Relative Break value for that event
         MaxEbreak(i) = 0.
c         i=1 for max RelEgreak, i=2 E Break value for that event
         MaxRelEbreak(i) = 0.
      enddo

      SumEdiff = 0.
      SumAbsEdiff = 0.

      end
      subroutine chookEabsorb( a, b, dE, info )
      implicit none
#include "Zmaxdef.h"
#include "Zobs.h"
#include "Ztrack.h"
#include "./Zabsorb.h"
c   This is called when Eabsorb != 0 and
c   when a charged particle runs from a 
c   to b and deposits energy dE (GeV) to the  Air.
c             
      record /track/  a  ! input. charged particle track info. at a.
      record /track/  b  ! input. charged particle track info. at b.
      real*8  dE  ! input.  energy deposit in GeV; no weight is applied yet
      integer info ! in/out. not used now

      if(a.where .ge. 1)  then
         dEbydEdx(a.where)= dEbydEdx(a.where) + dE*a.wgt
      endif
      end
      subroutine chookEabsorbD( a, dE, info )
      implicit none
#include "Zmaxdef.h"
#include "Zcode.h"
#include "Zobs.h"
#include "Ztrack.h"
#include "./Zabsorb.h"
c   This is called when Eabsorb != 0 and
c   when a  particle energy becomes < Emin (info=0) for 
c   its traveling time becomes > limit or (info=2)
c   its angle relative to the 1ry becomes > limit.(info=4) 
c   Whether this is called or not depends on the   particle
c   and bit in Eabsorb.  dE is energy that can be regarded
c   as absorbed in the Air. (GeV) eventually.
c   bit 1 is the LSB of Eabsorb.
c     
c   bit   particle
c    1     photon: used to absorb shell energy at 
c          photoelectric effect. This bit is not used in the Air.  
c    2    photon.  
c    3    e+/e-
c    4    proton
c    5    neutron
c    6    anti-N
c    7    decaying prtcl 
c    8    others
c             
c***** Normally Eabsorb=6 (110 in bit pattarn) is enough.****
c
c
      record /track/  a  ! input.  a particle that is < Emin 
                          ! at birth
      real*8  dE  ! input.  energy which is supposed to  be emitted by 
                  ! the dying particle
      integer info ! in/out. not used now.
      if(a.where .ge. 1) then
         if(a.p.code .eq. kneue .or. a.p.code .eq. kneumu) then
           !  neutrino
            dEbyDeathNeu(a.where) = dEbyDeathNeu(a.where) + dE*a.wgt
         elseif(a.p.code .eq. knuc .and. a.p.charge .eq. 0 .and.
     *          a.p.subcode .eq. regptcl ) then
            !  low E nutron
            dEbyDeathNut(a.where) = dEbyDeathNut(a.where) + dE*a.wgt
         else
c                  next one and above are kept same as older versions for 
c                  compativilty 
            dEbyDeath(a.where) = dEbyDeath(a.where) + dE*a.wgt

c                  we further put details 
            if(a.p.code .eq. kphoton ) then
               dEbyDeathG(a.where) = dEbyDeathG(a.where) + dE*a.wgt
            elseif(a.p.code .eq. kelec ) then
               dEbyDeathE(a.where) = dEbyDeathE(a.where) + dE*a.wgt
            elseif( a.p.code .le. kkaon )  then
               dEbyDeathMuPiK(a.where) = dEbyDeathMuPiK(a.where)
     *             + dE*a.wgt
            elseif(a.p.code .eq. knuc .and. a.p.charge .eq. 1 ) then
c                 p
               dEbyDeathP(a.where) = dEbyDeathP(a.where) + dE*a.wgt
            else
c                pbar, nbar, heavy,  others 
               dEbyDeathO(a.where) = dEbyDeathO(a.where) + dE*a.wgt
            endif
         endif
      endif
      end

      subroutine chookEabsorbB(a,info)
      implicit none
#include "Zmaxdef.h"
#include "Zcode.h"
#include "Ztrack.h"
#include "Ztrackp.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"
#include "./Zabsorb.h"
c  This is called when Eabsorb(1) !=0 and
c    a particle crosses an observation level
c  info=2:  normal observation level
c      =1:  upper boundary (whcih is equal to or higher than the injection
c           height)
c      =3:  lower boundary (which is equal to or lower than the last
c           observation depth).  
c
      record /track/  a  ! input.  a particle that croses the observation level
      integer info  ! input.  see above

      integer code
      integer lv
      logical count

      count =.false. 
      if(info .eq. 2 .and. a.where .eq. Eabsorb(2) )  then
c           Eabsorb(2) is the layer number where the user want to
c           take sum of particle energy reaching there from above.
c                ptcl comes to the specified level OR
c                upper boundary.  This condition neglect
c                ptcles reaching the real lower boundary
c               (if Eabosrb(2) is not NoOfSites+1)
         if( a.vec.coszenith .gt. 0.)   then
c          if info=2,  this is to count energy  reaching
c          the level from above, we discard going up ptcls
c          (but it may come down, so some over count may happen) 
            count = .true.
            lv = 1
         endif
      elseif( info .eq. 1 ) then
         lv = 2      ! escape to space
         count = .true.
      endif
c
c            
      if(count) then
         code = a.p.code
c              for other ptcls than g,e,mu, pi, K, N, use 7
         if(code .gt. 7) code=7
c             at the last layer we see sum of the particle energy
c             what energy we should use here is somewhat annoying 
c             point.  We use total energy here.  
         if(lv .eq. 1) then
c            Ecrash(code) = Ecrash(code) +  a.p.fm.p(4)*a.wgt
            Ecrash(code) = Ecrash(code) + (a.p.fm.p(4)-a.p.mass)*a.wgt
         else
c           Espace(code) = Espace(code) + a.p.fm.p(4)*a.wgt
            Espace(code) = Espace(code) +  (a.p.fm.p(4)-a.p.mass)*a.wgt
         endif
      endif
      end
      subroutine chookEabsorbC(a, n, p, info)
      implicit none
#include "Zmaxdef.h"
#include "Zcode.h"
#include "Zmass.h"
#include "Zobs.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "./Zabsorb.h"

      record /track/  a    ! input.  incident particle track
                           !  that made the collision
      integer n     ! input. number of procuded ptcls in the collision
      record /ptcl/  p(n) ! input. produced ptpcls.
      integer info  ! input. not used now.
      
      real*8 Eout, diff, reldiff, Ein
      real*8 diff1, diff2, Ein1, Ein2
      integer i
c          We check conservation above  this energy (GeV).
      real*8 Ebig/5.d3/
      save
c          since target is not well known and  nucleon there
c          has Fermi momentum, we simply assume rest mass.
c          For E>5TeV, Ar mass ~40GeV/5000 < 4/500 < 1 % 
c          So we can see the conservation neglecting mass term
c            
      if( a.p.fm.p(4) .gt. Ebig ) then
         Ein1 = a.p.fm.p(4) + masn*(TargetNucleonNo-TargetProtonNo) +
     *       masp*TargetProtonNo
         Ein2 = a.p.fm.p(4) + masp
         Eout = 0.
         do i = 1, n
            Eout = Eout + p(i).fm.p(4)
         enddo

         diff1 = Eout - Ein1
         diff2 = Eout - Ein2
         Ein = Ein1
         diff = diff1
c              take smaller diff one for Ein
         if( abs(diff2) .lt. abs(diff1)) then
            diff = diff2
            Ein = Ein2
         endif
         reldiff = (Eout/Ein -1.)

         if( abs(reldiff) .gt. 0.02 ) then
            call chookEabsorbW(a, n, p, Eout, diff)
         endif

         if( abs(diff) .gt. abs(MaxEbreak(1)) ) then
            MaxEbreak(1) = diff
            MaxEbreak(2) = reldiff
         endif

         if( abs(reldiff) .gt. abs(MaxRelEbreak(1)) ) then
            MaxRelEbreak(1) = reldiff
            MaxRelEbreak(2) = diff
         endif

         SumEdiff = SumEdiff + diff
         SumAbsEdiff = SumAbsEdiff + abs(diff)
      endif
      end
      subroutine chookEabsorbW(a, n, p, Eout, diff)
      implicit none
#include "Zmaxdef.h"
#include "Zcode.h"
#include "Zmass.h"
#include "Zobs.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "./Zabsorb.h"

      record /track/  a    ! input.  incident particle track
                           !  that made the collision
      integer n     ! input. number of procuded ptcls in the collision
      record /ptcl/  p(n) ! input. produced ptpcls.
      real*8 Eout, diff
      integer nevent, ntevent


      call cqEventNo(nevent, ntevent)

      write(0,*) "=================  Warning: Ebreak ============="
      write(0,*) " event #=", nevent, " 1ry Energy=", inci.p.fm.p(4)
      write(0,*) "incident(not 1ry) code=", a.p.code,
     *     " subcode=", a.p.subcode, " Ein~", a.p.fm.p(4)
      write(0,*) "Target(A,Z)=", TargetNucleonNo, TargetProtonNo
      write(0,*) "No. of generted particles =", n
      write(0,*) "Sum of outgoing ptcl Energy:Eout=", Eout
      write(0,*) "dE=(Eout-Ein)=", diff, " dE/Ein~",  
     *          diff/a.p.fm.p(4)
      write(0,*) "(Eout-Ein)/1ryE=",  diff/inci.p.fm.p(4)
      write(0,*) "Height=", a.pos.height," depth=",a.pos.depth/10.
      write(0,*) " where=", a.where, " weight=", a.wgt
      write(0,*) "================================================"

      end
