      subroutine cjamini(pj, ia, iz)
c      This must be called before generating one exclusive 
c      event (call jamev) 
c      implicit none  ! this cannot be used since jam1.inc uses
c      implicit double (...)
#include "jam1.inc"
#include "jam2.inc"

#include "Zptcl.h"
#include "Zkfcode.h"
#include "Zmanagerp.h"
#include "Zevhnp.h"
#include "Zevhnv.h"
#include "Zcode.h"
#include "Zmass.h"

      character frame*8, proj*8, targ*8, cwin*15
      real*8 bmin, bmax, dt
      integer mevent, nstep
      integer first /1/
      save
      
      if(first .eq. 1) then
         first = 0
         mevent = 1
         bmin = 0.
         bmax = -1.d0
         bmax=-7.50D0           ! maximum impact parameter (1530mb)Au  
         dt = 100.d0
         nstep =1
         mstc(8) = 0       ! job mode
         mstc(156) = 0     ! no call to jamanacl
         mstc(161) = 0     ! no output on JAMINFO.DAT, JAMRUN.DAT        
         mstc(39) = 0     ! no ouptut on JAMMULTI.DAT  
         frame = 'lab'
      endif
      call ccos2jamsymb(pj, proj)  ! make projectile symbol
c               such as proj = 'k+'
      write(targ,'(i3,":",i3)') ia, ia-iz
      call kseblk(targ, "*", nc)
      write(cwin, '(f12.2,"gev")')  pj.fm.p(4)
      call kseblk(cwin, "*", nc)
c      cwin = '14.6gevc'

      call jaminit(mevent, bmin, bmax, dt, nstep, frame, proj, targ,
     *  cwin)
      end

      subroutine cjam(a, ntp)
c      implicit none  ! this cannot be used since jam1.inc uses
c      implicit double (...)
#include "jam1.inc"
#include "jam2.inc"

#include "Zptcl.h"
c  #include "Zkfcode.h"
c  #include "Zmanagerp.h"
c   #include "Zevhnp.h"
c   #include "Zevhnv.h"
c   #include "Zcode.h"
c   #include "Zmass.h"
      integer ntp
      record /prcl/a(*)

      integer i
      integer code, subcode, charge
      integer iev/1/
      save

      call jamevt(iev)
      ntp = 0
      do i = 1, nv
         if( k(1,i) .le. 11 .or. k(1,i) .ge. 0  ) then
            call kf2cos(k(2,i), code, subcode, charge)
            ntp = ntp + 1
            call cmkptc(code, subcode, charge, a(ntp))
            a(ntp).fm.p(1) = p(1,i)
            a(ntp).fm.p(2) = p(2,i)
            a(ntp).fm.p(3) = p(3,i)
            a(ntp).fm.p(3) = p(4,i) + a(ntp).mass  ! jam is K.E
c            write(*,*) i, k(2,i), p(1,i), p(2,i), p(3,i),
c     *             p(4,i), p(5,i)
         endif
      enddo
c	call jamfin
      end
      subroutine  ccos2jamsymbl(pj, symb)
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
      record /ptcl/ pj  ! input. code, subcode, charge 
      character*8 symb  ! output. symbol used by jam

      integer nc

      if(pj.code .eq. kpion) then
         if(pj.charge .eq. 1) then
            symb = 'pi+'
         elseif(pj.charge .eq. 0) then
            write(0,*)
     *       'pi0 cannot be col. projectile in jam'
            stop
         else
            symb = 'pi-'
         endif
      elseif(pj.code .eq. kkaon) then
         if(pj.charge .eq. 1) then
            symb = 'k+'
         elseif(pj.charge .eq. -1) then
            symb = 'k-'
         else
            write(0,*)  ' k0 cannot be proj. in jam'
            stop
         endif
      elseif(pj.code .eq. knuc ) then
         if(pj.charge .eq. 1) then
            symb = 'p'
         elseif(pj.charge .eq.  -1 ) then
            symb = 'pbar'
         elseif(pj.subcode .eq. regptcl) then
            symb = 'n'
         else
            symb = 'nbar'
         endif
      elseif(pj.code .eq.kgnuc) then
         write(symb, '(i3,":", i3)' ) pj.subcode, 
     *       pj.subcode-pj.charge
c            remove blanks
         call kseblk(symb, "*", nc)  !  A:N say 207:125
      else
         write(0,*) 'code=',pj.code, ' charge=',pj.charge
         write(0,*) ' not supported in jam'
         stop
      endif
      end
