c              test primary sampling routines
#include  "BlockData/cblkGene.h"

      implicit none
#include  "Zmanagerp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Zprimary.h"
#include  "Zcode.h"
      
      record /ptcl/ p
      record /track/incident
      record /coord/ angle

      real*8 eorporrig
      integer label, icon, i
      real*4 mom, wgt, kepn
      integer fin

      call creadParam(5)
      call cbeginRun
      call cprintPrim(ErrorOut)
      write(ErrorOut, 
     *   '("#seq. No.|   Orig Erg | Code # | Total E(GeV)")')
      do i = 1, abs(DestEventNo(1))
         icon = 1
         do while (icon .ne. 0)
            call csampPrimary(incident.p, fin)
            if(fin .ne. 0) goto 10 
            call csPrimAng(angle)
            call cmkInc(incident, angle)
            if(CutOffFile .ne. ' ') then
               call cifCutOff(icon)
            else
              icon =0
            endif
         enddo
 10      continue
         call cqPrimE(eorporrig)
         call cqPrimLabel(label)
         p = incident.p
         kepn =( p.fm.p(4)-p.mass) 

         if(p.code .eq. kgnuc) then
            kepn = kepn / p.subcode
         endif

         mom =  sngl(sqrt(p.fm.p(4)**2 - p.mass**2))
         wgt =0.2323*mom**1.7       
         write(*, '(i2,g14.3, i3, 3f9.4, g12.5, f9.4, g13.3)')
     *      label, sngl(eorporrig),
     *      p.code,  sngl(log10(p.fm.p(4))),
     *      log10(kepn),
     *      sngl(log10(eorporrig)),
     *      sngl(0.2323/eorporrig),  log10(mom), wgt
      enddo
      end
      subroutine chookTrace
      end
      subroutine chookCeren
      end
      subroutine chookCerenS
      end
      subroutine chookCerenE
      end
      subroutine chookBgRun
      end
