#include <stdlib.h>
#include <stdio.h>
#include <fstream>
#include <iostream>

#include "./lateral_ph_fit.C"
#include "./lateral_e_fit.C"
#include "./lateral_mu_fit.C"
#include "./lateral_h_fit.C"

using namespace std ;

void usage();

double function(char *str3){
  FILE *fin ;

  char sbuf[0x500];

  // divide files into pieces

  int i;
  char tmpstring[5][0x100] ;

  // initialize

  int mode = 0,tmpint[10],test,maxr;
  double tmpdouble[10],pw,logx,logy;
  char title[0x500],xlab[100],xunit[100],key[0x500] ;
  char directory[0x500] ;
  double normf,sum,nf = 0.;
  int azimuth = 0,porder = 0; // we do not consider the fail of incliment of this variable

  double hist[0x200],xhist[0x200],yerror[0x200],area[0x200];
  Double_t fp_ph[6],fpe_ph[6],chisqr,fp_e[5],fpe_e[5],fp_mu[5],fpe_mu[5];
  Double_t fp_h[4],fpe_h[4] ;
  Int_t ndf,rflag ;

  for(i = 0;i < 10;i++){
    tmpint[i] = 0;
    tmpdouble[i] = 0.;
  }

  // search how many ptcls for each types

  fin=fopen(str3,"r"); // check open error!!

/*   fout=fopen("test.bin","wb"); */

  while(fgets(sbuf,0x500,fin) != NULL){
    if(strstr(sbuf,"#hist1") != NULL){
      mode = 1;
      sscanf(sbuf,"%s %lf %d %d %d %d %lf",tmpstring[0],&normf,&tmpint[0],&tmpint[1],&tmpint[2],&tmpint[3],&tmpdouble[0]);
    }
    else if(strstr(sbuf,"#t") != NULL){
      sprintf(title,sbuf);
      // azimuth is needed to be checked titleparticle type try.

      if(azimuth < 12){
	azimuth += 1;
// 	printf("azimuth %d \n",azimuth);
      }
      else if(azimuth == 12){
	azimuth = 1;
// 	printf("azimuth %d \n",azimuth);
      }
      else{
	printf("Azimuth error. \n");
      }
      porder = 0;
    }    
    else if(strstr(sbuf,"#x") != NULL){
      sscanf(sbuf,"%s %s %s",tmpstring[0],xlab,xunit);
    }    
    else if(strstr(sbuf,"#pw") != NULL){
      sscanf(sbuf,"%s %lf",tmpstring[0],&pw);
    }    
    else if(strstr(sbuf,"#dN") != NULL){
      sscanf(sbuf,"%s %s",tmpstring[0],tmpstring[1]);
    } 
    else if(strstr(sbuf,"#k") != NULL){
      sprintf(key,sbuf);
    } 
    else if(strstr(sbuf,"#l") != NULL){
      sscanf(sbuf,"%s %lf %lf",tmpstring[0],&logx,&logy);
    } 
    else if(strstr(sbuf,"#c") != NULL){
      sscanf(sbuf,"%s %s",tmpstring[0],tmpstring[1]);
    } 
    else if(strstr(sbuf,"#n") != NULL){
      sscanf(sbuf,"%s %lf %lf",tmpstring[0],&sum,&normf);

      if(normf == 1.0) nf = 1./sum ;
      else nf = sum ;
    } 
    else if(strstr(sbuf,"#o") != NULL){
      sscanf(sbuf,"%s %d %d %lf %lf",tmpstring[0],&test,&maxr,&tmpdouble[0],&tmpdouble[1]);
    } 
    else if(strstr(sbuf,"#d") != NULL){
      sscanf(sbuf,"%s %s",tmpstring[0],directory);
    } 
    else{
      if(mode == 1){
	sscanf(sbuf,"%d %lf %lf %lf %lf %lf %lf",&tmpint[0],&tmpdouble[0],&tmpdouble[1],&tmpdouble[2],&tmpdouble[3],&tmpdouble[4],&tmpdouble[5]);
	
	if(tmpint[0] == 1){
// 	  printf(directory);
// 	  printf("%f %f %f %f %f %f %f \n",tmpdouble[0],tmpdouble[1],tmpdouble[1]*nf,tmpdouble[2],tmpdouble[3],tmpdouble[4],tmpdouble[5]);

	  xhist[porder] = tmpdouble[0] ;
	  hist[porder] = tmpdouble[2] ;
	  yerror[porder] = tmpdouble[3] ;
	  area[porder] = tmpdouble[4] ;

	  porder ++;
	}
	else if(tmpint[0] != 0){
// 	  printf("%f %f %f %f %f %f %f \n",tmpdouble[0],tmpdouble[1],tmpdouble[1]*nf,tmpdouble[2],tmpdouble[3],tmpdouble[4],tmpdouble[5]);

	  xhist[porder] = tmpdouble[0] ;
	  hist[porder] = tmpdouble[2] ;
	  yerror[porder] = tmpdouble[3] ;
	  area[porder] = tmpdouble[4] ;

	  porder ++;
	}
	else if(tmpint[0] == 0){
	  // and particle order and include fit functions

// 	  printf("Summary data \n");
	  porder -= 1;  // before histogram making bug fixing

	  if(porder >= 40){
	    porder = 40;
	  }

// 	  for(i = 0;i < porder;i++){
// 	    printf("%f %f %f %f \n",xhist[i],hist[i],yerror[i],area[i]);
// 	  }

	  sprintf(tmpstring[0],"%s_%d ",directory,azimuth);

          for(i = 0;i < (int)(strlen(tmpstring[0]));i++){
            if(tmpstring[0][i] == '/'){
              tmpstring[0][i] = '_' ;
            }
          }

	  if(strstr(title,"Photons")!= NULL){
	    lateral_ph_fit(xhist,hist,yerror,area,tmpstring[0],porder,fp_ph,fpe_ph,&chisqr,&ndf,&rflag);
// 	    printf(tmpstring[0]);
	    printf("l 30 1 %d 0 \n",azimuth);

	    printf("%f %f %f %f %f %f \n",fp_ph[0],fp_ph[1],fp_ph[2],fp_ph[3],fp_ph[4],fp_ph[5]);
// 	    printf("%f %f %f %f %f %f ",fpe_ph[0],fpe_ph[1],fpe_ph[2],fpe_ph[3],fpe_ph[4],fpe_ph[5]);
// 	    printf("%f %d %d \n",chisqr,ndf,rflag); // how about err flag?
	  }
	  if(strstr(title,"Electrons")!= NULL){
// 	    lateral_e_fit(xhist,hist,yerror,area,tmpstring[0],porder);
	    lateral_e_fit(xhist,hist,yerror,area,tmpstring[0],porder,fp_e,fpe_e,&chisqr,&ndf,&rflag);
// 	    printf(tmpstring[0]);
	    printf("l 30 2 %d 0 \n",azimuth);

	    printf("%f %f %f %f %f \n",fp_e[0],fp_e[1],fp_e[2],fp_e[3],fp_e[4]);
// 	    printf("%f %f %f %f %f ",fpe_e[0],fpe_e[1],fpe_e[2],fpe_e[3],fpe_e[4]);
// 	    printf("%f %d %d \n",chisqr,ndf,rflag);
	  }
	  if(strstr(title,"Muons")!= NULL){
	    lateral_mu_fit(xhist,hist,yerror,area,tmpstring[0],porder,fp_mu,fpe_mu,&chisqr,&ndf,&rflag);
// 	    printf(tmpstring[0]);
	    printf("l 30 3 %d 0 \n",azimuth);

	    printf("%f %f %f %f %f \n",fp_mu[0],fp_mu[1],fp_mu[2],fp_mu[3],fp_mu[4]);
// 	    printf("%f %f %f %f %f ",fpe_mu[0],fpe_mu[1],fpe_mu[2],fpe_mu[3],fpe_mu[4]);
// 	    printf("%f %d %d \n",chisqr,ndf,rflag);
	  }
	  if(strstr(title,"hadron")!= NULL){ // pay attention!!!
	    lateral_h_fit(xhist,hist,yerror,area,tmpstring[0],porder,fp_h,fpe_h,&chisqr,&ndf,&rflag);
// 	    printf(tmpstring[0]);
	    printf("l 30 4 %d 0 \n",azimuth);

	    printf("%f %f %f %f \n",fp_h[0],fp_h[1],fp_h[2],fp_h[3]);
// 	    printf("%f %f %f %f ",fpe_h[0],fpe_h[1],fpe_h[2],fpe_h[3]);
// 	    printf("%f %d %d \n",chisqr,ndf,rflag);
	  }

	}

      }

    }
  }

  fclose(fin);

  printf("l 0 0 0 \n");

  return 0;
}


int main( int argc, char *argv[] )
{
        char *p,*set;
        double peak ;

        set = (char *)malloc(0x256*sizeof(char));
        peak = 0.;

        while ( --argc > 0 && *( p = *++argv ) == '-' ) {
                switch ( p[1] ) {
                case 'f' :
                        if ( --argc <= 0 ) usage() ;
                        set = *++argv  ;
                        break ;

                default :
                        usage() ;
                }
        }
        function(set);

        return 0;
}


void usage()
{
        fprintf( stderr, "usage : file [-f] \n" ) ;
        exit( 1 ) ;
}
