c
      subroutine cAAXsec(pjmassn, tgmassn, ek,  xs)
c         pjmassn:  input. integer. incident heavy mass number.
c         tgmassn:  input. real*8. average target mass number.
c              ek:  input. real*8. incident heavy kinetic energy in GeV.
c              xs:   output. real*8. collision x-section in mb.
c
c     formula: xs = pi(r1 + r2 - d)**2
c        r = r0 A**(1/3)
c        d = 1.189 r0 exp(-0.055min(A1,A2))
c       r0 = (1.29f to 1.41f)
c  Therefore
c      xs = pi r0^2 (A1^0.333 + A2^0.333 - 1.189exp(-0.055min(A1,A2)))**2
c  This is by Frier et al in ICRC Paris conf. (from Uchu Hosha Sen Edited
c      by Nishimura, p.170)
c
c  At high energies (sqrt(s) > 80 GeV for E/A), we include energy dependence
c  of cross-section as follows.
c    Let the pp cross-section increases as E**delta, then
c    AB crosssection is well fitted by the dependence of E**alfa with
c    
c     alfa = 2.5* delta/(p + t + p*t/2)
c
c   where  p = A**(1/3) and t = B**(1/3)
c
c  
c       

      implicit none
#include "Zxsectionp.h"
      integer pjmassn
      real*8  tgmassn, ek, xs
c      character*70 msg
c      ------------------------old ------(main frame age)
c      if(abs(tgmassn-14.5) .lt. 5.) then
c         xs =  45.2 * (pjmassn**.333 + 2.03)**2
c      else
c         write(msg, *) ' update cAAXsection so that target can be ',
c     *               ' non air'
c         call cerrorMsg(msg, 0)
c      endif    
c        
c      ---------------------------------------------------------
c         difference for He-Air(=14.5)) collisions ( r0=1.29 )
c      old         new 
c He   591 mb      492   mb
c Fe  1549        1710 
c
       real*8 p, t
       real*8 einc/500./
c
       if( ek .le. 0. ) then
          xs = 0.
       else
          p = pjmassn**0.3333
          t = tgmassn**0.3333 
          xs = 52.2 *( p + t - 
     *       1.189 * exp(- 0.055*min( dble(pjmassn), tgmassn)))**2
          if(ek/pjmassn .gt. einc) then
             xs = xs * (ek/einc/pjmassn)**(2.5* Deltpp/(p+t+p*t/2.))
          endif 
       endif
      end

