#include "mpif.h"

      integer iapmax, nptmax, nsp, nsf, iaf, ich
      real*8  esp 

      parameter(iapmax=209,nptmax=50000)
c      dimension ep(4),ebal(4)
      common /qgarr12/ nsp                       !number of secondaries
      common /qgarr13/ nsf,iaf(iapmax)           !number of nuclear fragments,
      common /qgarr14/ esp(4,nptmax),ich(nptmax) !4-momenta and types of second.


      integer i
      real*8 xs, ke0n, qgsect
      integer kicz, kiap

      integer err, mpisize, mpirank
      real*8  Elt1, Elt2

      
      call mpi_init(err)
      call mpi_comm_size(MPI_COMM_WORLD, mpisize, err)
      call mpi_comm_rank(MPI_COMM_WORLD, mpirank, err)


      write(0, *) 'before ciniQGS'
      Elt1= mpi_wtime()
      call ciniQGS
      Elt2= mpi_wtime()
      write(*,*) 'in1 ', Elt2-Elt1
       write(0, *) 'before qgaini'
      Elt1= mpi_wtime()
      call qgaini
      Elt2= mpi_wtime()
      write(*,*) 'in2 ', Elt2-Elt1
      kiat = 14
      kicz=2
      kiap=1
      kicp = 2
      ke0n = 1.e6
      write(0, *) 'before xsect'
      Elt1= mpi_wtime()
      xs=qgsect(ke0n,kicz,kiap,kiat) !get particle production cross sectio
      Elt2= mpi_wtime()
      write(*,*) 'in3 ',  Elt2-Elt1


      do i = 1, 10
         Elt1=mpi_wtime()

         call qgini( ke0n, kicp, kiap, kiat) !initialize current interaction
         call qgconf            !inelastic interaction
         Elt2=mpi_wtime()
         write(*,*) nsp, Elt2-Elt1
         write(0,*) nsp, Elt2-Elt1
      enddo
      end
      subroutine ciniQGS
      implicit none
#include "Zmanagerp.h"
      integerdebug      
      common /debug/   debug
      integer moniou
      common /qgarr43/ moniou

      logical  first
      save first
      integer iseq, j
      integer iseed(103,10)
c                managed inside qgaini
cc      character*120 file1, file2
      real*8 u
      data first /.true./
      integer now(2)

      if( first ) then
         call cmkSeed(0, now) 
         call rnd1r(now)

         moniou = ErrorOut      !set output channel (6-default)
c                managed inside qgaini
cc         call cqQGSfile(file1, file2)
         iseq=1                 !set random sequence&seed
         call rndc(u)
         iseed(1,iseq)=int(u*1.e7)
         call rndc(u)
         iseed(2,iseq)=int(u*1.e7)
         iseed(3,iseq)=0
         call rmmaq( iseed(1,iseq), iseq, 's' )
         call rmmaq( iseed(1,iseq), iseq, 'r' )
         write(moniou,*) iseq,(iseed(j,iseq),j=1,3)
         call qgset             !set model parameters
         debug=0                !set debugging level (1-default) 
         call qgaini            !initialize QGSJET-II
         first = .false.
      endif
      end
c     **********************************
      subroutine cqQGSfile(file1, file2)
c        check if data files exist for QGSJetII
      implicit none
      character*120  cosmostop
      character*(*) file1, file2
      integer kgetenv2, leng
      logical yes1, yes2 

      leng = kgetenv2("COSMOSTOP", cosmostop)
c      file1= cosmostop(1:leng)//"/Data/QGS/qgsdat-II-1"
      file1= cosmostop(1:leng)//"/Data/QGS/qgsdat-II-03.ascii"
      inquire(file =file1, exist=yes1) 
      if(.not. yes1) then
         call cerrorMsg(file1, 1)
         call cerrorMsg("Data for QGS shown above is missing", 0)
      endif
c      file2= cosmostop(1:leng)//"/Data/QGS/sectnu-II-1"
      file2= cosmostop(1:leng)//"/Data/QGS/sectnu-II-03"
      inquire(file =file2, exist=yes2) 
      if(.not. yes2) then
         call cerrorMsg(file2, 1)
         call cerrorMsg("Data for QGS shown above is missing", 0)
         if(.not. yes1) stop  99999
      endif
      end

