c      ******************************************************
       subroutine csnchp(icon)
c            sample # of charged ptcls
c      ******************************************************
c        Nch: integer. Output. sampled charged
c                              particle number (excludeing
c                              leadings)
c       icon: integer. Output. 0 --> o.k
c                              1 --> n.g (missing mass
c                                       is too small)
       implicit none

#include  "Zptcl.h"
#include  "Zmass.h"
#include  "Zevhnv.h"
c
        integer  icon
        real*8 redf
        real*8 missgm     ! missing mass
        real*8 roots, parmk

c
        roots =  Cmsp.mass
        missgm = Missingp.mass
        if(missgm  .gt. maspic*1.1) then
c             Efrs = missgm* 2.5 *(roots/200.)**0.05
c             Efrs = missgm* 2.5 *(roots/200.)**0.06 
              Efrs =max(
     *            missgm* 2.5 *(roots/200.)**0.06,
     *            missgm*2. + Pjtatr.mass + masp)

c                <nch> as a funcion of roots
            call ccpmul(Efrs, Avncharged)
c            call ccpmul(roots, Avncharged)
c                see p.l 116b p195; correction : NOW  OBSOLUTE. in this case
c                                           we must use Avncharged by roots.  
c                for available energy (reduction factor)
c            redf=1.5d0*sqrt(missgm/roots)   good at 53 gev
c     *        /(1.d0+ 95.d0/Pjlab.fm.p(4))**0.30d0 *.977d0  
c            redf=1.560d0*sqrt(missgm/roots)      ! good at 900 gev
c     *        /(1.d0+ 95.d0/Pjlab.fm.p(4))**0.30d0 
c               compromise  two above.
c            redf = 1.4385 * (Pjlab.fm.p(4)/1490)**0.0143 *
c     *             sqrt(missgm/roots)

c              <n> from ccpmul is for NSD.
c              For inclusion of SD events,
c              aven must be corrected at low energies
c            Avncharged = Avncharged* redf    ! effective <N>

c
c                fix n_b (=negative binormial) parameter k
            call cnbk(Efrs,  parmk)
c                sample n_charge
            if(parmk .le. 0.d0) then
              call cknoNarrow(Avncharged, Nch)
c               call kpoisn(Avncharged, Nch)
            elseif(Avncharged .lt. 8.) then
c                 normal distribution is too wide
               call cknoNarrow(Avncharged, Nch)
c               call kpoisn(Avncharged, Nch)
            else
c                    negative binomial
               call knbino(parmk, Avncharged, Nch)
            endif
            icon=0
        else
            Nch=0
            icon=1
        endif

        end
c       *************** simplest kno
      subroutine ckno(ave, sampled)
c
c          use z*exp(-pi/4 *x**2) dz
c  
      implicit none
      real*8  ave  ! input. average number
      integer sampled
c  
      real*8 u
      real*8  sqrtpi/1.772453851/  ! sqrt(pi)

      call rndc(u)
c           not add 0.5
      sampled = max(0.d0, sqrt( -log(u) )* 2.0/sqrtpi * ave )
      end
c       *************** narrow kno good at low energies.
      subroutine cknoNarrow(ave, sampled)
c
c          use z**2 exp(-0.73 *x**3) dz
c  
      implicit none
      real*8  ave  ! input. average number
      integer sampled
c  
      real*8 u
      call rndc(u)
      sampled = ( -log(u)/0.73)**0.333 * ave
      end
c     *****************************************************
      subroutine cnbk(roots,  ak)
        implicit none
        real*8 roots, ak
c             Negative binormial parameter k.(UA5 parameterization)
c             slog= log(s/gev**2); effective s
        real*8 slog
c
          slog = log(roots)*2
          if(slog .gt. 5.3d0)then
             ak= 1.d0/ (slog * 0.029d0 - 0.104d0)
          else
             ak=-1.d0
          endif
        end
c       ******************
        subroutine cfnptc(a,  ntot)
c       ******************
c          fix # of ptcls of each type, give mass, code
c
c  nch: integer.  Input. # of charged ptcls to be sampled.

c    a: /ptcl/     Output. to get ptcls. (mass, code, 
c                  charge) are assigned. some of subcode  is
c                  also assigned. (nn~, dd~ mass should be
c                  refixed later)
c ntot: integer.   Output. to get the toal # of ptcls to be
c                  produced.
c                 
c  *** Note ***
c       After this call, the # of particle of pi+-0, K+-0,
c       etc can be obtained as Npi0 etc which are in
c       ../Zevhnv.h
c       ----------------------------
        implicit none
c----        include '../../Zptcl.h'
#include  "Zptcl.h"
c----        include '../../Zcode.h'
#include  "Zcode.h"
c----        include '../../Zmass.h'
#include  "Zmass.h"
c----        include '../Zevhnp.h'
#include  "Zevhnp.h"
c----        include '../Zevhnv.h' 
#include  "Zevhnv.h"
        record /ptcl/  a(*)
        integer  ntot
c
c
        real*8 missml, rnnb, rkc, p, exe, ddb
        integer nchc,  ntp, i
c

        missml = log( Missingp.mass ) * 2
c             get average fraction of n-n~ pair to Nch (non leading)
c             lamda decay product. (exclude lamda c)
        call cfrnnb(missml, rnnb)
c                get average fraction; (k+ + k-)/(pi+ + pi-)
cc        call cfrkc(missml, rkc)
        call cfrkc(log(Efrs)*2, rkc)
c                get average # of dd~ pair
c                this is to account for the prompt muon production
        call cnddb(Efrs, ddb)
        ddb=ddb * Mudirp      ! mudirp;  default is 1.0
c                 fix the # of particles of each type -------------
        if(Nch .eq. 0) then
                Nnnb = 0
                Nkaon = 0
                Nddb = 0
                Npic = 0
                Nk0 = 0
                Nkch = 0
                call kpoisn(Avncharged/2, Npi0)
c                call ckno(Avncharged/2, Npi0)
         else
                nchc=Nch
                p =rnnb*nchc
                call kpoisn(p, Nnnb)
c                call ckno(p, Nnnb)
                call kpoisn(ddb, Nddb)
c                call ckno(ddb, Nddb)
c                  the number of remaining charge(statistically)
                nchc = nchc-Nnnb - Nddb
c                   k+,k-,k0,k0~ (eqaul number in each type)
                p =rkc/(1.+rkc)*nchc
                call kpoisn(p , Nkch)
c                call ckno(p , Nkch)
                Nkaon = Nkch*2
                Nk0 = Nkaon- Nkch
                Npic = max(nchc- Nkch, 0)
                p = Nch*.51
                call kpoisn(p, Npi0)
c                call ckno(p, Npi0)
         endif
         if(Npi0 .gt. 10) then
c            assume some of them are eta.   the pi0/eta ratio is
c            a parameter. normally 0.2. which means Neta= 0.16*Npi0 
c           this is only to see the effect at >>10^19 ev region where
c           the decay of pi0 is inhibited and only eta can be the
c           source of h.e gamma.
            Neta =  Eta2Pi0 / (1 . + Eta2Pi0)  * Npi0
            Npi0 = Npi0 - Neta
         else
            Neta = 0
         endif
c             
         ntp=0      ! counter for storing ptlcs in a.
         do   i=1, Nnnb
c                     sample additional excitation mass of nn~
c                      <>=400 MeV
                  call ksgmim(1, 400.d-3, exe)
                  ntp=ntp+1
                  call cmkptc(knnb, 0, 0,  a(ntp)) 
                  a(ntp).mass=exe + a(ntp).mass
         enddo
c                (d,d~)
         do   i=1, Nddb
c                     sample additional excitation mass of dd~=
                  call ksgmim(1, 400.d-3, exe)
                  ntp=ntp+1
                  call cmkptc(kddb, 0, 0,  a(ntp))
                  a(ntp).mass=exe + a(ntp).mass
         enddo
c                 pi+/-
         do   i=1, Npic
                  ntp=ntp+1
c                     + or - is determined later (set tentative +)
                  call cmkptc(kpion, 0, 1,  a(ntp))
         enddo
c                 pi0
         do   i=1, Npi0
                  ntp=ntp+1
                  call cmkptc(kpion, 0, 0, a(ntp))
         enddo
         do  i = 1, Neta
            ntp = ntp + 1
            call cmkptc(keta, 0, 0, a(ntp))
         enddo
c                 kaon +/ -
         do   i=1, Nkch
                  ntp=ntp+1
c                     + or - is determined later (set tentative +)
                  call cmkptc(kkaon,  0, 1,  a(ntp))
         enddo
c                 k0
         do   i=1, Nk0
                  ntp=ntp+1
c                     k0,k0~ (long,short) is determined later
                  call cmkptc(kkaon, 0, 0, a(ntp))
         enddo
         ntot=ntp
        end
c     *****************************************************
        subroutine cfrnnb(efsl, rn)
c         fraction of (nn~) pairs; including lamda decay products
c         (but not lamda_c) to the total charged ptcls
c          efsl: log(s/gev**2). s is effective s. based on UA5
        implicit none
        real*8 efsl, rn
c           rn= 0.0115*efsl - 0.015  ; this is # of n + n~
           rn= 0.0057d0*efsl - 0.0075d0
        end
c     *****************************************************
        subroutine cfrkc(efsl, rk)
        implicit none
c----        include '../../Zptcl.h' 
#include  "Zptcl.h"
c----        include '../Zevhnp.h' 
#include  "Zevhnp.h"
c----        include '../Zevhnv.h'
#include  "Zevhnv.h"
c          fraction of k_charge to the pi_charge
c          efsl=log(s/gev**2). Cmsp.mass=root(s)
c          rk=0.07, 12.3, 14, 21 at 10, 100, 10000 GeV, 10**18 eV.

        real*8 efsl, rk, tmp
          tmp = Cmsp.mass**2-4.63
          if(tmp .le. 0.) then
             rk = 0.
          else
             rk=(Kpilog*(efsl+0.069) + Kpicns)*
     *        exp(-8.0/ tmp)
          endif
        end
c     ************************************************
        subroutine cnddb(efrs,  ddb)
c            average # of ddb pairs for p-p collisions
c          efrs: effective roots in GeV
c         *** for p-p or pi-p collision. the number of ddb
c          ---------old----------------
c            is assumed to be 1.e-3*log(roots)* exp(-78/roots)
c            at 1 TeV lab., this is about 6.2e-4
c            at 10000 TeV lab.,     8e-3
c         ---------after v3.0 ----------
c             is assumed to be 3.e-3*roots**0.25* exp(-78/roots)
c             at 1 TeV lab., this is about 1.2e-3
c             at 10000 TeV lab.         2.e-2
        implicit none

        real*8 efrs,  ddb
c
           ddb=3.d-3 * efrs ** 0.25 * exp(-78.d0/efrs)
        end










