cc       teste ksampAF
cc      (x,y) is wave length vs light yield for  Li2B4O7 
c      integer n
c      parameter (n=33)
c      real*8 x(n), y(n)
cc      data x/300., 320., 340., 360., 380., 390., 400.,
c      data x/ 320., 340., 360., 380., 390., 400.,
c     *       410., 420., 430., 440.,450.,460.,470., 480., 490, 500.,
c     *       510., 520., 530., 540.,550.,560.,570., 580., 590, 600.,
c     *       610., 620., 630., 640., 650., 660., 670./
cc      data y/0.,  0.1, 1.,4., 15.,20.,32.,
c      data y/ 0.0, 1., 4., 15.,20.,32.,
c     *      39., 56., 70., 78., 90., 95., 99., 105.,111.,118.,
c     *      117., 99., 79., 63.,56., 47., 43., 40.,37.,31.,23.,
c     *      20., 17., 16., 10., 5., 0./
c      integer  nc
c      parameter (nc=n+1)
c      real*8 coef(nc, 3)
c
c      real*8 yi(n)
c      real*8 coef2(nc,3)
c      real*8 a, b, dx, xx, u, yy
c
c      real*8 xs
c      integer i
c      call ksampAF0(x, y, n, coef, nc,  yi, coef2)
c        to see how well interpolation was done
c      do i = 1, n
c         write(*,'(a, 3g15.4)') 'o ', x(i), y(i),  yi(i)
c      enddo
c      a= x(1)
c      b= x(n)
c      dx = (b-a)/(5*n)
c      do i = 1, 5*n+1
c        xx = a + (i-1)*dx
c         u =  (i-1)/(5.0*n)
c         call  kcsplIntp(x, y, n, coef, nc,   xx,  xs)
c         call  kcsplIntp(yi, x, n, coef2, nc,  u,  yy)
c         write(*,'(a, 4e15.4)') 'i ',  xx, xs, u, yy
c      enddo
c
cc       generate random number
c      do i = 1, 100000
c         call ksampAF(x, yi, n, coef2, nc, xs)
c         write(*,*) xs
c      enddo
c      end
c
c    sample a random number following an arbitrary function
c    which is expressed as a table of n-point  (x,y)
c    This is initialization routine
c
      subroutine ksampAF0(x, y, n, coef, nc,  yi,
     *      coef2)
      implicit none
      integer n  !  input number of data points
      real*8 x(n), y(n) ! input data points (x,y)
c                          zero is assumed at x<x(1) or x>x(n)
      integer nc  ! input. must be >=n-1
      real*8 coef(nc, 3) ! output. to keep the spline coefficents
      real*8 yi(n) ! output. yi(i)= Normalized integral from x=x(1) to x(i)
c                   (i = 1, n)      (yia(1)=0. yi(n)= 1.0) 
c
      real*8 coef2(nc, 3)  !ouptut. coef2 to be used for (yi, x)
c                   spline interploation      
c
      real*8  total


      real*8 dx, a, b, sum
      integer i
      real*8 x1, x2
 
      if( nc .lt. n-1 ) then
         write(0,*) ' nc< n-1 in ksamplAF0'
         stop 1234
      endif

      call kcsplCoef(x, y, n, coef, nc)
      a = x(1)
      b = x(n)
      call kcsplInteg(x, y, n, coef, nc, a, b, total)

      yi(1) = 0.
      do i = 2, n
         b = x(i)
         call kcsplInteg(x, y, n, coef, nc, a, b, sum)
         yi(i) = sum/total
      enddo
c          to assure yi(n) = 1.
      yi(n) = 1.
      call kcsplCoef(yi, x, n, coef2, nc)
      end
      subroutine ksampAF(x, yi, n, coef2, nc, xs)
      implicit none
      integer n
      real*8 x(n), yi(n)
      integer nc
      real*8 coef2(nc, 3)
      real*8 xs  !output.  sampled x
      real*8 u

      call rndc(u)
      call kcsplIntp(yi, x, n, coef2, nc, u,  xs)
      end
