c***********************************************************************
c***********************************************************************
c                                                                      *
c        PART 1:                                                       *
c                                                                      *
c   List of subprograms in rough order of relevance with main purpose  *
c      (S = subroutine, F = function, B = block data, E = entry)       *
c                                                                      *
c  b   jamdata  to give default parameters for jam                     *
c  b   jydata   to contain all default values for pythia               *
c                                                                      *
c***********************************************************************
c***********************************************************************
 
      block data jamdata
 
c...Purpose: to give default values to switches and parameters
      implicit double precision(a-h, o-z)
      include '../../../Import/Jam/jam2.inc'
 
c...Set defaults in the mstc array
c...     1     2     3     4     5     6    7     8     9    10
      data (mstc(i),i=1,100)/
     $ 19780503, 1,  1,    2,    1,    0,   0,    0,    0,    1,
     1   1,   30,    1,   30,    0,    0,   0,    0,   27,    0,
     2   0,  9*0,
     3   0,    0,    0,    0,    0,    1,   2,    3,    4,    8,
     4   1,    1,    1,    2,    0,    1, 4*0,
     5   3,    5,    1,    1,    0,    1,  4*0,
     6   3,   22,    3,    3,    1,    0,   2,    2,    2,    2,
     7   1,    3,    2,    1,    1,    0,   0,    0,    0,    0,
     8   1,    3,    2,    0,    2,    0,   0,    0,    0,    0,
     9 10*0/

c...     1     2     3     4     5     6    7     8     9    10
      data (mstc(i),i=101,200)/
     $  0,1,8*0,
     1  10*0,
     2  10*0,
     3  10*0,
     4  10*0,
     5   0,    0,    0,    0,    0,    0,   0,    0,    0,    0,
     6   1,    0,    0,    0,    0,    0,   0,    0,    0,    0,
     7   20*0,
     9   1,   090, 2005,08,14,5*0/


c...Set defaults in the parc array
c..     1     2      3      4     5     6       7     8     9   10
      data (parc(i),i=1,100)/
     $   -1.d0,100.0d0,  0.0d0,  0.0d0,  -1.d0,   2.d0,  1.0d0,  1.0d0, 
     &   0.0d0,  0.0d0,
     1  0.54d0,1.124d0,  0.8d0,  0.8d0,  2.0d0,  0.0d0,  0.0d0,  0.0d0, 
     &   0.0d0,  0.0d0,
     2 0.168d0,-16.0d0,0.001439767d0,.9396d0,.9383d0,.135d0,.1396d0, 
     & .93895d0,.1373d0,0.d0,
     3   5.0d0, 55.0d0, 55.0d0,200.0d0,200.0d0,150.0d0,350.0d0, 0.05d0, 
     &   0.0d0,  0.0d0,
     4 0.001d0,  0.5d0,  0.4d0,  2.5d0,  0.7d0,  2.d0,  0.36d0,  0.3d0, 
     &   0.2d0,   0.d0,
     5   2.0d0,  3.5d0,  2.0d0,  1.0d0,  1.0d0,  4.0d0,  0.1d0,   0.d0, 
     &    0.d0,   0.d0,
     6   4.6d0,  2.8d0,  1.8d0, 1.09d0,  0.7d0, 0.36d0,  0.1d0,  1.4d0, 
     &   0.05d0, 1.0d0,
     7   10.d0, 0.71d0,  0.1d0,  0.1d0,  1.0d0,   0.d0,  0.0d0,  0.0d0, 
     &    0.d0,  0.0d0, 
     8    0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0, 
     &    0.d0,   0.d0, 
     9    0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0, 
     &    0.d0,   0.d0/


      data (parc(i),i=101,200)/
     $ 10*0.d0,
     1    0.d0,  9*0.d0, 
     2    0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0, 
     &    0.d0,   0.d0, 
     3    0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0, 
     &    0.d0,   0.d0, 
     4    0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0, 
     &    0.d0,   0.d0, 
     5   2.1d0,  0.3d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0, 
     &    0.d0,   0.d0, 
     6    0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0, 
     &    0.d0,   0.d0, 
     7    0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0, 
     &    0.d0,   0.d0, 
     8    0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0, 
     &    0.d0,   0.d0, 
     9    0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0,   0.d0, 
     &    0.d0,   0.d0/ 

c...Elementary particles.
      data id_quark/1/,id_lept/2/,id_exc/3/,id_boson/4/
     $    ,id_diq/5/
     $    ,id_tec/6/
     $    ,id_susy/7/
     $    ,id_special/6/

c...Light Mesons.
      data id_pi/101/,id_light1/100/
     $     id_light0/120/
     $    ,id_str/130/
     $    ,id_charm/140/
     $    ,id_bott/150/
     $    ,id_cc/160/
     $    ,id_bb/170/
     $    ,id_mdiff/199/

c...Baryons
      data id_nucl/11/,id_nucls/12/,id_delt/13/,id_delts/14/
     $    ,id_lamb/21/,id_lambs/22/
     $    ,id_sigm/31/,id_sigms/32/
     $    ,id_xi/41/,id_xis/42/
     $    ,id_omega/51/
     $    ,id_charmb/61/,id_bottb/72/
     $    ,id_bdiff/99/


      data fname/ '0','JAMRUN.DAT','JAMINFO.DAT','JAMMULTI.DAT'
     $           ,'JAMDISP.DAT', ' ', ' ', ' '/

      data check/10*' '/

      end

C*********************************************************************
C*********************************************************************
C...PYDATA
C...Default values for switches and parameters,
C...and particle, decay and process data.
 
      block data pjdata
 
C...Double precision and integer declarations.
      implicit double precision(a-h, o-z)
C...Commonblocks.
      include '../../../Import/Jam/jam2.inc'
      common/jydatr/mrpy(6),rrpy(100)
      common/pjsubs/msel,mselpd,msub(500),kfin(2,-40:40),ckin(200)
      common/pjpars/mstp(200),parp(200),msti(200),pari(200)
      common/pjint1/mint(400),vint(400)
      common/pjint2/iset(500),kfpr(500,2),coef(500,20),icol(40,4,2)
      common/pjint3/xsfx(2,-40:40),isig(1000,3),sigh(1000)
      common/pjint4/mwid(500),wids(500,5)
      common/pjint5/ngenpd,ngen(0:500,3),xsec(0:500,3)
      common/pjint6/proc(0:500)
      character proc*28
      common/pjint7/sigt(0:6,0:6,0:5)
      common/pjmssm/imss(0:99),rmss(0:99)
      common/pjssmt/zmix(4,4),umix(2,2),vmix(2,2),smz(4),smw(2),
     &sfmix(16,4)
c     common/pybins/ihist(4),indx(1000),bin(20000)
      save /jydatr/,/pjsubs/,
     &/pjpars/,/pjint1/,/pjint2/,/pjint3/,/pjint4/,/pjint5/,
     &/pjint6/,/pjint7/,/pjmssm/,/pjssmt/
 
C...PYDAT1, containing status codes and most parameters.
      data mstu/
     &   0,    0,    0, 1000,10000,  500, 4000,    0,    0,    2,
     1   6,    1,    1,    0,    1,    1,    0,    0,    0,    0,
     2   2,   10,    0,    0,    1,   10,    0,    0,    0,    0,
     3   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     4   2,    2,    1,    4,    2,    1,    1,    0,    0,    0,
     5  25,   24,    0,    1,    0,    0,    0,    0,    0,    0,
     6   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     7  30*0,
     1   1,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     2   1,    5,    3,    5,    0,    0,    0,    0,    0,    0,
     &  80*0/
      data paru/
     &  3.141592653589793d0, 6.283185307179586d0,
     &  0.197327d0, 5.06773d0, 0.389380d0, 2.56819d0,  4*0d0,
     1  0.001d0, 0.09d0, 0.01d0, 0d0, 0d0, 0d0, 0d0, 0d0, 0d0, 0d0,
     2  0d0,   0d0,   0d0,   0d0,  0d0,  0d0,  0d0,  0d0,  0d0,  0d0,
     3  0d0,   0d0,   0d0,   0d0,  0d0,  0d0,  0d0,  0d0,  0d0,  0d0,
     4  2.0d0,  1.0d0, 0.25d0,  2.5d0, 0.05d0,
     4  0d0,   0d0, 0.0001d0, 0d0,   0d0,
     5  2.5d0,1.5d0,7.0d0,1.0d0,0.5d0,2.0d0,3.2d0, 0d0, 0d0, 0d0,
     6  40*0d0,
     &  0.00729735d0, 0.232d0, 0.007764d0, 1.0d0, 1.16639d-5,
     &  0d0, 0d0, 0d0, 0d0,  0d0,
     1  0.20d0, 0.25d0, 1.0d0, 4.0d0, 10d0, 0d0, 0d0,  0d0, 0d0, 0d0,
     2 -0.693d0, -1.0d0, 0.387d0, 1.0d0, -0.08d0,
     2 -1.0d0,  1.0d0,  1.0d0,  1.0d0,  0d0,
     3  1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,  0d0,  0d0, 0d0, 0d0, 0d0,
     4  5.0d0, 1.0d0, 1.0d0,  0d0, 1.0d0, 1.0d0,  0d0, 0d0, 0d0, 0d0,
     5  1.0d0, 0d0, 0d0, 0d0, 1000d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0,0d0,
     6  1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0,  0d0,  0d0, 0d0, 0d0, 0d0,
     7  1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 0d0,0d0,0d0,
     8  1.0d0, 1.0d0, 1.0d0, 0.0d0, 0.0d0, 1.0d0, 1.0d0, 0d0,0d0,0d0,
     9  0d0,  0d0,  0d0,  0d0, 1.0d0,  0d0,  0d0, 0d0, 0d0, 0d0/
      data mstj/
     &  1,    3,    0,    0,    0,    0,    0,    0,    0,    2,
     1  4,    2,    0,    1,    0,    0,    0,    0,    0,    0,
     2  2,    1,    1,    2,    1,    2,    2,    0,    0,    0,
     3  0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     4  2,    2,    4,    2,    5,    3,    3,    0,    0,    3,
     5  0,    3,    0,    0,    0,    0,    0,    0,    0,    0,
     6  40*0,
     &  5,    2,    7,    5,    1,    1,    0,    2,    0,    2,
     1  0,    0,    0,    0,    1,    1,    0,    0,    0,    0,
     2  80*0/
      data parj/
     &  0.10d0, 0.30d0, 0.40d0, 0.05d0, 0.50d0,
     &  0.50d0, 0.50d0,   0.6d0,   1.2d0,   0.6d0,
     1  0.50d0,0.60d0,0.75d0,0.5d0,0.2d0, 0d0, 0d0, 1.0d0, 1.0d0, 0d0,
     2  0.36d0, 1.0d0,0.01d0, 2.0d0,1.0d0,0.4d0,0.5d0, 0d0, 0d0, 0d0,
     3  0.10d0, 1.0d0, 0.8d0, 1.5d0,0d0,2.0d0,0.2d0,2.5d0,0.6d0,0d0,
     4  0.3d0, 0.58d0, 0.5d0, 0.9d0,0.5d0,1.0d0,1.0d0,1.0d0,0d0,0d0,
     5  0.77d0, 0.77d0, 0.77d0, -0.05d0, -0.005d0,
     5 -0.00001d0, -0.00001d0, -0.00001d0, 1.0d0, 0d0,
     6  4.5d0, 0.7d0, 0d0,0.003d0, 0.5d0, 0.5d0, 0d0, 0d0, 0d0, 0d0,
     7  10d0, 1000d0, 100d0, 1000d0, 0d0, 0.7d0,10d0, 0d0, 0d0, 0d0,
     8  0.29d0, 1.0d0, 1.0d0,  0d0,  10d0, 10d0, 0d0, 0d0, 0d0, 0d0,
     9  0.02d0, 1.0d0, 0.2d0,  0d0,  0d0,  0d0,  0d0, 0d0, 0d0, 0d0,
     &  0d0,  0d0,  0d0,  0d0,   0d0,   0d0,  0d0,  0d0,  0d0,  0d0,
     1  0d0,  0d0,  0d0,  0d0,   0d0,   0d0,  0d0,  0d0,  0d0,  0d0,
     2  1.0d0, 0.25d0,91.187d0,2.489d0, 0.01d0,
     2  2.0d0,  1.0d0, 0.25d0,0.002d0,   0d0,
     3  0d0, 0d0, 0d0, 0d0, 0.01d0, 0.99d0, 0d0, 0d0,  0.2d0,   0d0,
     4  60*0d0/
 
 
C...PYDATR, with initial values for the random number generator.
      data mrpy/19780503,0,0,97,33,0/
 
C...Default values for allowed processes and kinematics constraints.
      data msel/1/
      data msub/500*0/
      data ((kfin(i,j),j=-40,40),i=1,2)/16*0,4*1,4*0,6*1,5*0,5*1,0,
     &5*1,5*0,6*1,4*0,4*1,16*0,16*0,4*1,4*0,6*1,5*0,5*1,0,5*1,5*0,
     &6*1,4*0,4*1,16*0/
      data ckin/
     &  2.0d0, -1.0d0,  0.0d0, -1.0d0,  1.0d0,
     &  1.0d0,  -10d0,   10d0,  -10d0,   10d0,
     1  -10d0,   10d0,  -10d0,   10d0,  -10d0,
     1   10d0, -1.0d0,  1.0d0, -1.0d0,  1.0d0,
     2  0.0d0,  1.0d0,  0.0d0,  1.0d0, -1.0d0,
     2  1.0d0, -1.0d0,  1.0d0,    0d0,    0d0,
     3  2.0d0, -1.0d0,    0d0,    0d0,  0.0d0,
     3 -1.0d0,  0.0d0, -1.0d0,  4.0d0, -1.0d0,
     4 12.0d0, -1.0d0, 12.0d0, -1.0d0, 12.0d0,
     4 -1.0d0, 12.0d0, -1.0d0,    0d0,    0d0,
     5  0.0d0, -1.0d0,  0.0d0, -1.0d0,  0.0d0,
     5 -1.0d0,    0d0,    0d0,    0d0,    0d0,
     6  140*0d0/
 
C...Default values for main switches and parameters. Reset information.
      data (mstp(i),i=1,100)/
     &  3,    1,    2,    0,    0,    0,    0,    0,    0,    0,
     1  1,    0,    1,    0,    5,    0,    0,    0,    0,    0,
     2  1,    0,    1,    0,    0,    0,    0,    0,    0,    1,
     3  1,    2,    0,    1,    0,    2,    1,    5,    2,    0,
     4  1,    1,    3,    7,    3,    1,    1,    0,    1,    0,
     5  4,    1,    3,    1,    5,    1,    1,    6,    1,    7,
     6  1,    3,    2,    2,    1,    1,    2,    0,    0,    0,
     7  1,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     8  1,    1,  100,    0,    0,    0,    0,    0,    0,    0,
     9  1,    4,    1,    2,    0,    0,    0,    0,    0,    0/
      data (mstp(i),i=101,200)/
     &  3,    1,    0,    0,    0,    0,    0,    0,    0,    0,
     1  1,    1,    1,    0,    0,    0,    0,    0,    0,    0,
     2  0,    1,    2,    1,    1,   50,    0,    0,   10,    0,
     3  0,    4,    0,    1,    0,    0,    0,    0,    0,    0,
     4  0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     5  0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     6  0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     7  0,    2,    0,    0,    0,    0,    0,    0,    0,    0,
     8  6,  115, 1998,   01,   27,    0,    0,    0,    0,    0,
     9  0,    0,    0,    0,    0,    0,    0,    0,    0,    0/
      data (parp(i),i=1,100)/
     &  0.25d0,  10d0, 8*0d0,
     1  0d0,   0d0,  1.0d0, 0.01d0,  0.6d0,  1.0d0,  1.0d0, 3*0d0,
     2  10*0d0,
     3  1.5d0,2.0d0,0.075d0,1.0d0,0.2d0,0d0,2.0d0,0.70d0,0.006d0,0d0,
     4  0.02d0,2.0d0,0.10d0,1000d0,2054d0, 123d0, 246d0, 50d0, 2*0d0,
     5  1.0d0, 9*0d0,
     6  0.25d0, 1.0d0,0.25d0, 1.0d0, 2.0d0,1d-3, 4.0d0,1d-3,2*0d0,
     7  4.0d0, 0.25d0, 8*0d0,
     8  1.40d0,1.55d0,0.5d0, 0.2d0,0.33d0,0.66d0, 0.7d0, 0.5d0,2*0d0,
     9  0.44d0,0.20d0,2.0d0,1.0d0,0d0,3.0d0,1.0d0,0.75d0,0.44d0,2.0d0/
      data (parp(i),i=101,200)/
     &  0.5d0, 0.28d0,  1.0d0, 0.8d0, 6*0d0,
     1  2.0d0, 3*0d0, 1.5d0, 0.5d0, 0.6d0, 2.5d0, 2.0d0, 1.0d0,
     2  1.0d0,  0.4d0, 8*0d0,
     3  0.01d0, 9*0d0,
     4  0.33333d0, 82d0, 1d0, 4d0, 200d0, 5*0d0,
     5  0d0,   0d0,   0d0,   0d0, 6*0d0,
     6  2.20d0, 23.6d0, 18.4d0, 11.5d0, 6*0d0,
     7  0d0,   0d0,   0d0,  1.0d0, 6*0d0,
     8  20*0d0/
      data msti/200*0/
      data pari/200*0d0/
      data mint/400*0/
      data vint/400*0d0/
 
C...Constants for the generation of the various processes.
      data (iset(i),i=1,100)/
     &  1,    1,    1,   -1,    3,   -1,   -1,    3,   -2,    2,
     1  2,    2,    2,    2,    2,    2,   -1,    2,    2,    2,
     2 -1,    2,    2,    2,    2,    2,   -1,    2,    2,    2,
     3  2,   -1,    2,    2,    2,    2,   -1,   -1,   -1,   -1,
     4 -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
     5 -1,   -1,    2,    2,   -1,   -1,   -1,    2,   -1,   -1,
     6 -1,   -1,   -1,   -1,   -1,   -1,   -1,    2,    2,    2,
     7  4,    4,    4,   -1,   -1,    4,    4,   -1,   -1,    2,
     8  2,    2,    2,    2,    2,    2,    2,    2,    2,   -2,
     9  0,    0,    0,    0,    0,    9,   -2,   -2,   -2,   -2/
      data (iset(i),i=101,200)/
     & -1,    1,    1,   -2,   -2,    2,    2,    2,   -2,    2,
     1  2,    2,    2,    2,    2,   -1,   -1,   -1,   -2,   -2,
     2  5,    5,    5,    5,   -2,   -2,   -2,   -2,   -2,   -2,
     3 -1,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,
     4  1,    1,    1,    1,    1,   -2,    1,    1,    1,   -2,
     5  1,    1,    1,   -2,   -2,    1,    1,    1,   -2,   -2,
     6  2,    2,    2,    2,    2,    2,    2,    2,   -2,   -2,
     7  2,    2,    5,    5,   -2,    2,    2,    5,    5,   -2,
     8  5,    5,   -2,   -2,   -2,    5,    5,   -2,   -2,   -2,
     9  1,    1,    1,    2,   -2,   -2,   -2,   -2,   -2,   -2/
      data (iset(i),i=201,300)/
     &  2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
     1  2,    2,    2,    2,   -2,    2,    2,    2,    2,    2,
     2  2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
     3  2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
     4  2,    2,    2,    2,   -1,    2,    2,    2,    2,    2,
     5  2,    2,    2,    2,   -1,    2,   -1,    2,    2,   -2,
     6  2,    2,    2,    2,    2,   -1,   -1,   -1,   -1,   -1,
     7  2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
     8 -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,
     9 -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2/
      data (iset(i),i=301,500)/200*-2/
      data ((kfpr(i,j),j=1,2),i=1,50)/
     &  23,    0,   24,    0,   25,    0,   24,    0,   25,    0,
     &  24,    0,   23,    0,   25,    0,    0,    0,    0,    0,
     1   0,    0,    0,    0,   21,   21,   21,   22,   21,   23,
     1  21,   24,   21,   25,   22,   22,   22,   23,   22,   24,
     2  22,   25,   23,   23,   23,   24,   23,   25,   24,   24,
     2  24,   25,   25,   25,    0,   21,    0,   22,    0,   23,
     3   0,   24,    0,   25,    0,   21,    0,   22,    0,   23,
     3   0,   24,    0,   25,    0,   21,    0,   22,    0,   23,
     4   0,   24,    0,   25,    0,   21,    0,   22,    0,   23,
     4   0,   24,    0,   25,    0,   21,    0,   22,    0,   23/
      data ((kfpr(i,j),j=1,2),i=51,100)/
     5   0,   24,    0,   25,    0,    0,    0,    0,    0,    0,
     5   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     6   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     6   0,    0,    0,    0,   21,   21,   24,   24,   23,   24,
     7  23,   23,   24,   24,   23,   24,   23,   25,   22,   22,
     7  23,   23,   24,   24,   24,   25,   25,   25,    0,  211,
     8   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     8 443,   21,10441,   21,20443,   21,  445,   21,    0,    0,
     9   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     9   0,    0,    0,    0,    0,    0,    0,    0,    0,    0/
      data ((kfpr(i,j),j=1,2),i=101,150)/
     &  23,    0,   25,    0,   25,    0,    0,    0,    0,    0,
     & 443,   22,  443,   21,  443,   22,    0,    0,   22,   25,
     1  21,   25,    0,   25,   21,   25,   22,   22,   21,   22,
     1  22,   23,   23,   23,   24,   24,    0,    0,    0,    0,
     2  25,    6,   25,    6,   25,    0,   25,    0,    0,    0,
     2   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     3  23,    5,    0,    0,    0,    0,    0,    0,    0,    0,
     3   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     4  32,    0,   34,    0,   37,    0,   40,    0,   39,    0,
     4   0,    0, 4000001, 0, 4000002, 0,   38,    0,    0,    0/
      data ((kfpr(i,j),j=1,2),i=151,200)/
     5  35,    0,   35,    0,   35,    0,    0,    0,    0,    0,
     5  36,    0,   36,    0,   36,    0,    0,    0,    0,    0,
     6   6,   37,   39,    0,   39,   39,   39,   39,   11,    0,
     6  11,    0, 0, 4000001, 0, 4000002,    0,    0,    0,    0,
     7  23,   35,   24,   35,   35,    0,   35,    0,    0,    0,
     7  23,   36,   24,   36,   36,    0,   36,    0,    0,    0,
     8  35,    6,   35,    6,    0,    0,    0,    0,    0,    0,
     8  36,    6,   36,    6,    0,    0,    0,    0,    0,    0,
     9  54,    0,   55,    0,   56,    0,   11,    0,    0,    0,
     9   0,    0,    0,    0,    0,    0,    0,    0,    0,    0/
      data ((kfpr(i,j),j=1,2),i=201,240)/
     &  1000011,   1000011,   2000011,   2000011,   1000011,
     &  2000011,   1000013,   1000013,   2000013,   2000013,
     &  1000013,   2000013,   1000015,   1000015,   2000015,
     &  2000015,   1000015,   2000015,   1000011,   1000012,
     1  1000015,   1000016,   2000015,   1000016,   1000012,
     1  1000012,   1000016,   1000016,         0,         0,
     1  1000022,   1000022,   1000023,   1000023,   1000025,
     1  1000025,   1000035,   1000035,   1000022,   1000023,
     2  1000022,   1000025,   1000022,   1000035,   1000023,
     2  1000025,   1000023,   1000035,   1000025,   1000035,
     2  1000024,   1000024,   1000037,   1000037,   1000024,
     2  1000037,   1000022,   1000024,   1000023,   1000024,
     3  1000025,   1000024,   1000035,   1000024,   1000022,
     3  1000037,   1000023,   1000037,   1000025,   1000037,
     3  1000035,   1000037,   1000021,   1000022,   1000021,
     3  1000023,   1000021,   1000025,   1000021,   1000035/
      data ((kfpr(i,j),j=1,2),i=241,280)/
     4  1000021,   1000024,   1000021,   1000037,   1000021,
     4  1000021,   1000021,   1000021,         0,         0,
     4  1000002,   1000022,   2000002,   1000022,   1000002,
     4  1000023,   2000002,   1000023,   1000002,   1000025,
     5  2000002,   1000025,   1000002,   1000035,   2000002,
     5  1000035,   1000001,   1000024,   2000005,   1000024,
     5  1000001,   1000037,   2000005,   1000037,   1000002,
     5  1000021,   2000002,   1000021,         0,         0,
     6  1000006,   1000006,   2000006,   2000006,   1000006,
     6  2000006,   1000006,   1000006,   2000006,   2000006,
     6        0,         0,         0,         0,         0,
     6        0,         0,         0,         0,         0,
     7  1000002,   1000002,   2000002,   2000002,   1000002,
     7  2000002,   1000002,   1000002,   2000002,   2000002,
     7  1000002,   2000002,   1000002,   1000002,   2000002,
     7  2000002,   1000002,   1000002,   2000002,   2000002/
      data ((kfpr(i,j),j=1,2),i=281,500)/440*0/
      data coef/10000*0d0/
      data (((icol(i,j,k),k=1,2),j=1,4),i=1,40)/
     &4,0,3,0,2,0,1,0,3,0,4,0,1,0,2,0,2,0,0,1,4,0,0,3,3,0,0,4,1,0,0,2,
     &3,0,0,4,1,4,3,2,4,0,0,3,4,2,1,3,2,0,4,1,4,0,2,3,4,0,3,4,2,0,1,2,
     &3,2,1,0,1,4,3,0,4,3,3,0,2,1,1,0,3,2,1,4,1,0,0,2,2,4,3,1,2,0,0,1,
     &3,2,1,4,1,4,3,2,4,2,1,3,4,2,1,3,3,4,4,3,1,2,2,1,2,0,3,1,2,0,0,0,
     &4,2,1,0,0,0,1,0,3,0,0,3,1,2,0,0,4,0,0,4,0,0,1,2,2,0,0,1,4,4,3,3,
     &2,2,1,1,4,4,3,3,3,3,4,4,1,1,2,2,3,2,1,3,1,2,0,0,4,2,1,4,0,0,1,2,
     &4,0,0,0,4,0,1,3,0,0,3,0,2,4,3,0,3,4,0,0,1,0,0,1,0,0,3,4,2,0,0,2,
     &3,0,0,0,1,0,0,0,0,0,3,0,2,0,0,0,2,0,3,1,2,0,0,0,3,2,1,0,1,0,0,0,
     &4,4,3,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     &0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0/
 
 
C...Character constants: name of processes.
      data proc(0)/                    'All included subprocesses   '/
      data (proc(i),i=1,20)/
     &'f + fbar -> gamma*/Z0       ',  'f + fbar'' -> W+/-           ',
     &'f + fbar -> h0              ',  'gamma + W+/- -> W+/-        ',
     &'Z0 + Z0 -> h0               ',  'Z0 + W+/- -> W+/-           ',
     &'                            ',  'W+ + W- -> h0               ',
     &'                            ',  'f + f'' -> f + f'' (QFD)      ',
     1'f + f'' -> f + f'' (QCD)      ','f + fbar -> f'' + fbar''      ',
     1'f + fbar -> g + g           ',  'f + fbar -> g + gamma       ',
     1'f + fbar -> g + Z0          ',  'f + fbar'' -> g + W+/-       ',
     1'f + fbar -> g + h0          ',  'f + fbar -> gamma + gamma   ',
     1'f + fbar -> gamma + Z0      ',  'f + fbar'' -> gamma + W+/-   '/
      data (proc(i),i=21,40)/
     2'f + fbar -> gamma + h0      ',  'f + fbar -> Z0 + Z0         ',
     2'f + fbar'' -> Z0 + W+/-      ', 'f + fbar -> Z0 + h0         ',
     2'f + fbar -> W+ + W-         ',  'f + fbar'' -> W+/- + h0      ',
     2'f + fbar -> h0 + h0         ',  'f + g -> f + g              ',
     2'f + g -> f + gamma          ',  'f + g -> f + Z0             ',
     3'f + g -> f'' + W+/-          ', 'f + g -> f + h0             ',
     3'f + gamma -> f + g          ',  'f + gamma -> f + gamma      ',
     3'f + gamma -> f + Z0         ',  'f + gamma -> f'' + W+/-      ',
     3'f + gamma -> f + h0         ',  'f + Z0 -> f + g             ',
     3'f + Z0 -> f + gamma         ',  'f + Z0 -> f + Z0            '/
      data (proc(i),i=41,60)/
     4'f + Z0 -> f'' + W+/-         ', 'f + Z0 -> f + h0            ',
     4'f + W+/- -> f'' + g          ', 'f + W+/- -> f'' + gamma      ',
     4'f + W+/- -> f'' + Z0         ', 'f + W+/- -> f'' + W+/-       ',
     4'f + W+/- -> f'' + h0         ', 'f + h0 -> f + g             ',
     4'f + h0 -> f + gamma         ',  'f + h0 -> f + Z0            ',
     5'f + h0 -> f'' + W+/-         ', 'f + h0 -> f + h0            ',
     5'g + g -> f + fbar           ',  'g + gamma -> f + fbar       ',
     5'g + Z0 -> f + fbar          ',  'g + W+/- -> f + fbar''       ',
     5'g + h0 -> f + fbar          ',  'gamma + gamma -> f + fbar   ',
     5'gamma + Z0 -> f + fbar      ',  'gamma + W+/- -> f + fbar''   '/
      data (proc(i),i=61,80)/
     6'gamma + h0 -> f + fbar      ',  'Z0 + Z0 -> f + fbar         ',
     6'Z0 + W+/- -> f + fbar''      ', 'Z0 + h0 -> f + fbar         ',
     6'W+ + W- -> f + fbar         ',  'W+/- + h0 -> f + fbar''      ',
     6'h0 + h0 -> f + fbar         ',  'g + g -> g + g              ',
     6'gamma + gamma -> W+ + W-    ',  'gamma + W+/- -> Z0 + W+/-   ',
     7'Z0 + Z0 -> Z0 + Z0          ',  'Z0 + Z0 -> W+ + W-          ',
     7'Z0 + W+/- -> Z0 + W+/-      ',  'Z0 + Z0 -> Z0 + h0          ',
     7'W+ + W- -> gamma + gamma    ',  'W+ + W- -> Z0 + Z0          ',
     7'W+/- + W+/- -> W+/- + W+/-  ',  'W+/- + h0 -> W+/- + h0      ',
     7'h0 + h0 -> h0 + h0          ',  'q + gamma -> q'' + pi+/-     '/
      data (proc(i),i=81,100)/
     8'q + qbar -> Q + Qbar, mass  ',  'g + g -> Q + Qbar, massive  ',
     8'f + q -> f'' + Q, massive    ', 'g + gamma -> Q + Qbar, mass ',
     8'gamma + gamma -> F + Fbar, m',  'g + g -> J/Psi + g          ',
     8'g + g -> chi_0c + g         ',  'g + g -> chi_1c + g         ',
     8'g + g -> chi_2c + g         ',  '                            ',
     9'Elastic scattering          ',  'Single diffractive (XB)     ',
     9'Single diffractive (AX)     ',  'Double  diffractive         ',
     9'Low-pT scattering           ',  'Semihard QCD 2 -> 2         ',
     9'                            ',  '                            ',
     9'                            ',  '                            '/
      data (proc(i),i=101,120)/
     &'g + g -> gamma*/Z0          ',  'g + g -> h0                 ',
     &'gamma + gamma -> h0         ',  '                            ',
     &'                            ',  'g + g -> J/Psi + gamma      ',
     &'gamma + g -> J/Psi + g      ',  'gamma+gamma -> J/Psi + gamma',
     &'                            ',  'f + fbar -> gamma + h0      ',
     1'f + fbar -> g + h0          ',  'q + g -> q + h0             ',
     1'g + g -> g + h0             ',  'g + g -> gamma + gamma      ',
     1'g + g -> g + gamma          ',  'g + g -> gamma + Z0         ',
     1'g + g -> Z0 + Z0            ',  'g + g -> W+ + W-            ',
     1'                            ',  '                            '/
      data (proc(i),i=121,140)/
     2'g + g -> Q + Qbar + h0      ',  'q + qbar -> Q + Qbar + h0   ',
     2'f + f'' -> f + f'' + h0       ',
     2'f + f'' -> f" + f"'' + h0     ',
     2'                            ',  '                            ',
     2'                            ',  '                            ',
     2'                            ',  '                            ',
     3'g + g -> Z0 + q + qbar      ',  '                            ',
     3'                            ',  '                            ',
     3'                            ',  '                            ',
     3'                            ',  '                            ',
     3'                            ',  '                            '/
      data (proc(i),i=141,160)/
     4'f + fbar -> gamma*/Z0/Z''0   ', 'f + fbar'' -> W''+/-          ',
     4'f + fbar'' -> H+/-           ', 'f + fbar'' -> R              ',
     4'q + l -> LQ                 ',  '                            ',
     4'd + g -> d*                 ',  'u + g -> u*                 ',
     4'g + g -> eta_techni         ',  '                            ',
     5'f + fbar -> H0              ',  'g + g -> H0                 ',
     5'gamma + gamma -> H0         ',  '                            ',
     5'                            ',  'f + fbar -> A0              ',
     5'g + g -> A0                 ',  'gamma + gamma -> A0         ',
     5'                            ',  '                            '/
      data (proc(i),i=161,180)/
     6'f + g -> f'' + H+/-          ', 'q + g -> LQ + lbar          ',
     6'g + g -> LQ + LQbar         ',  'q + qbar -> LQ + LQbar      ',
     6'f + fbar -> f'' + fbar'' (g/Z)',
     6'f +fbar'' -> f" + fbar"'' (W) ',
     6'q + q'' -> q" + d*           ',  'q + q'' -> q" + u*           ',
     6'                            ',  '                            ',
     7'f + fbar -> Z0 + H0         ', 'f + fbar'' -> W+/- + H0      ',
     7'f + f'' -> f + f'' + H0       ',
     7'f + f'' -> f" + f"'' + H0     ',
     7'                            ',  'f + fbar -> Z0 + A0         ',
     7'f + fbar'' -> W+/- + A0      ',
     7'f + f'' -> f + f'' + A0       ',
     7'f + f'' -> f" + f"'' + A0     ',
     7'                            '/
      data (proc(i),i=181,200)/
     8'g + g -> Q + Qbar + H0      ',  'q + qbar -> Q + Qbar + H0   ',
     8'                            ',  '                            ',
     8'                            ',  'g + g -> Q + Qbar + A0      ',
     8'q + qbar -> Q + Qbar + A0   ',  '                            ',
     8'                            ',  '                            ',
     9'f + fbar -> rho_tech0       ',  'f + f'' -> rho_tech+/-       ',
     9'f + fbar -> omega_tech0     ',  'f+fbar -> f''+fbar'' (technic)',
     9'                            ',  '                            ',
     9'                            ',  '                            ',
     9'                            ',  '                            '/
      data (proc(i),i=201,220)/
     &'f + fbar -> ~e_L + ~e_Lbar  ',  'f + fbar -> ~e_R + ~e_Rbar  ',
     &'f + fbar -> ~e_R + ~e_Lbar  ',  'f + fbar -> ~mu_L + ~mu_Lbar',
     &'f + fbar -> ~mu_R + ~mu_Rbar',  'f + fbar -> ~mu_L + ~mu_Rbar',
     &'f+fbar -> ~tau_1 + ~tau_1bar',  'f+fbar -> ~tau_2 + ~tau_2bar',
     &'f+fbar -> ~tau_1 + ~tau_2bar',  'q + qbar'' -> ~l_L + ~nulbar ',
     1'q+qbar''-> ~tau_1 + ~nutaubar', 'q+qbar''-> ~tau_2 + ~nutaubar',
     1'f + fbar -> ~nul + ~nulbar  ',  'f+fbar -> ~nutau + ~nutaubar',
     1'                            ',  'f + fbar -> ~chi1 + ~chi1   ',
     1'f + fbar -> ~chi2 + ~chi2   ',  'f + fbar -> ~chi3 + ~chi3   ',
     1'f + fbar -> ~chi4 + ~chi4   ',  'f + fbar -> ~chi1 + ~chi2   '/
      data (proc(i),i=221,240)/
     2'f + fbar -> ~chi1 + ~chi3   ',  'f + fbar -> ~chi1 + ~chi4   ',
     2'f + fbar -> ~chi2 + ~chi3   ',  'f + fbar -> ~chi2 + ~chi4   ',
     2'f + fbar -> ~chi3 + ~chi4   ',  'f+fbar -> ~chi+-1 + ~chi-+1 ',
     2'f+fbar -> ~chi+-2 + ~chi-+2 ',  'f+fbar -> ~chi+-1 + ~chi-+2 ',
     2'q + qbar'' -> ~chi1 + ~chi+-1', 'q + qbar'' -> ~chi2 + ~chi+-1',
     3'q + qbar'' -> ~chi3 + ~chi+-1', 'q + qbar'' -> ~chi4 + ~chi+-1',
     3'q + qbar'' -> ~chi1 + ~chi+-2', 'q + qbar'' -> ~chi2 + ~chi+-2',
     3'q + qbar'' -> ~chi3 + ~chi+-2', 'q + qbar'' -> ~chi4 + ~chi+-2',
     3'q + qbar -> ~chi1 + ~g      ',  'q + qbar -> ~chi2 + ~g      ',
     3'q + qbar -> ~chi3 + ~g      ',  'q + qbar -> ~chi4 + ~g      '/
      data (proc(i),i=241,260)/
     4'q + qbar'' -> ~chi+-1 + ~g   ', 'q + qbar'' -> ~chi+-2 + ~g  ',
     4'q + qbar -> ~g + ~g         ',  'g + g -> ~g + ~g            ',
     4'                            ',  'qj + g -> ~qj_L + ~chi1     ',
     4'qj + g -> ~qj_R + ~chi1     ',  'qj + g -> ~qj_L + ~chi2     ',
     4'qj + g -> ~qj_R + ~chi2     ',  'qj + g -> ~qj_L + ~chi3     ',
     5'qj + g -> ~qj_R + ~chi3     ',  'qj + g -> ~qj_L + ~chi4     ',
     5'qj + g -> ~qj_R + ~chi4     ',  'qj + g -> ~qk_L + ~chi+-1   ',
     5'qj + g -> ~qk_R + ~chi+-1   ',  'qj + g -> ~qk_L + ~chi+-2   ',
     5'qj + g -> ~qk_R + ~chi+-2   ',  'qj + g -> ~qj_L + ~g        ',
     5'qj + g -> ~qj_R + ~g        ',  '                            '/
      data (proc(i),i=261,280)/
     6'f + fbar -> ~t_1 + ~t_1bar  ',  'f + fbar -> ~t_2 + ~t_2bar  ',
     6'f + fbar -> ~t_1 + ~t_2bar  ',  'g + g -> ~t_1 + ~t_1bar     ',
     6'g + g -> ~t_2 + ~t_2bar     ',  '                            ',
     6'                            ',  '                            ',
     6'                            ',  '                            ',
     7'qi + qj -> ~qi_L + ~qj_L    ',  'qi + qj -> ~qi_R + ~qj_R    ',
     7'qi + qj -> ~qi_L + ~qj_R    ',  'qi+qjbar -> ~qi_L + ~qj_Lbar',
     7'qi+qjbar -> ~qi_R + ~qj_Rbar',  'qi+qjbar -> ~qi_L + ~qj_Rbar',
     7'f + fbar -> ~qi_L + ~qi_Lbar',  'f + fbar -> ~qi_R + ~qi_Rbar',
     7'g + g -> ~qi_L + ~qi_Lbar   ',  'g + g -> ~qi_R + ~qi_Rbar   '/
      data (proc(i),i=281,500)/220*'                            '/
 
C...Cross sections and slope offsets.
      data sigt/294*0d0/
 
C...Supersymmetry switches and parameters.
      data imss/0,
     &  0,  0,  0,  1,  0,  0,  0,  1,  0,  0,
     1  89*0/
      data rmss/0d0,
     &  80d0,160d0,500d0,800d0,2d0,250d0,200d0,800d0,700d0,800d0,
     1  700d0,500d0,250d0,200d0,800d0,400d0,0d0,0.1d0,850d0,0.041d0,
     2   1d0,800d0,1d4,1d4,1d4,0d0,0d0,24d17,2*0d0,
     3  69*0d0/
 
C...Data for histogramming routines.
c     data ihist/1000,20000,55,1/
c     data indx/1000*0/

      data parf/
     &  0.5d0,0.25d0, 0.5d0,0.25d0, 1d0, 0.5d0,  0d0,  0d0,  0d0, 0d0,
     1  0.5d0,  0d0, 0.5d0,  0d0,  1d0,  1d0,  0d0,  0d0,  0d0, 0d0,
     2  0.5d0,  0d0, 0.5d0,  0d0,  1d0,  1d0,  0d0,  0d0,  0d0, 0d0,
     3  0.5d0,  0d0, 0.5d0,  0d0,  1d0,  1d0,  0d0,  0d0,  0d0, 0d0,
     4  0.5d0,  0d0, 0.5d0,  0d0,  1d0,  1d0,  0d0,  0d0,  0d0, 0d0,
     5  0.5d0,  0d0, 0.5d0,  0d0,  1d0,  1d0,  0d0,  0d0,  0d0, 0d0,
     6  0.75d0, 0.5d0, 0d0,0.1667d0,0.0833d0,0.1667d0,0d0,0d0,0d0, 0d0,
     7  0d0,  0d0,  1d0,0.3333d0,0.6667d0,0.3333d0,0d0,0d0,0d0, 0d0,
     8  0d0,  0d0,  0d0,  0d0,  0d0,  0d0,  0d0,  0d0,  0d0, 0d0,
     9  0d0,  0d0,  0d0,  0d0,  0d0,  0d0,  0d0,  0d0,  0d0, 0d0,
     & 0.325d0,0.325d0,0.5d0,1.6d0, 5.0d0,  0d0,  0d0,  0d0,  0d0, 0d0,
     1 0d0,0.11d0,0.16d0,0.048d0,0.50d0,0.45d0,0.55d0,0.60d0,0d0,0d0,
     2 0.2d0, 0.1d0,  0d0,  0d0,  0d0,  0d0,  0d0,  0d0,  0d0, 0d0,
     3 60*0d0,
     4 0.2d0,  0.5d0,  8*0d0, 
     5 1800*0d0/
      data ((vckm(i,j),j=1,4),i=1,4)/
     &  0.95113d0,  0.04884d0,  0.00003d0,  0.00000d0,
     &  0.04884d0,  0.94940d0,  0.00176d0,  0.00000d0,
     &  0.00003d0,  0.00176d0,  0.99821d0,  0.00000d0,
     &  0.00000d0,  0.00000d0,  0.00000d0,  1.00000d0/
 
c     include 'jydat.f'

C...PYDAT2, with particle data and flavour treatment parameters.
      data (kchg(i,1),i=   1, 500)/-1,2,-1,2,-1,2,-1,2,2*0,-3,0,-3,0,   
     &-3,0,-3,6*0,3,9*0,3,2*0,3,0,-1,12*0,3,2*0,3,28*0,2,-1,15*0,3,4*0, 
     &3,-2,2*1,4,2*-2,2*1,-2,2*1,3*4,2*1,2*-2,2*1,2*-2,2*1,-2,0,3,0,3,  
     &0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,22*0,3,0,3,0,3,0,3,0,3,0,3,0,3,0, 
     &3,0,3,0,3,0,4*3,3*0,3*3,4*0,2*3,2*0,2*3,2*0,3,0,3,5*0,3*3,3*0,    
     &3*3,5*0,2*3,2*0,2*3,3*0,3,0,3,3*0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,  
     &0,3,0,3,0,3,-3,0,3,6,-3,0,3,6,-3,0,3,6,-3,0,3,6,-3,0,3,6,-3,0,3,  
     &6,-3,0,3,6,-3,0,3,6,-3,0,3,6,-3,0,3,6,13*0,-3,0,3,-3,0,3,-3,0,3,  
     &-3,0,3,-3,0,3,-3,0,3,-3,0,3,-3,0,3,-3,0,3,-3,0,-3,0,-3,0,-3,0,-3, 
     &0,-3,0,-3,2*0,3,0,2*3,2*6,3,2*0,2*3,2*0,2*3,2*6,2*3,6,2*-3,0,-3,  
     &3*0,2*3,0,3,2*-3,2*0,2*-3,3*0,2*3,2*0,2*3,2*-3,2*0,2*-3,2*0,-3,   
     &-1,2,-1,2,-1,2,-3,0,-3,0,-3,4*0,3,2*0,3,0,-1,2,-1,2,-1,2,-3,0,-3, 
     &0,-3,0,-1,2,-3,42*0/                                              
      data (kchg(i,2),i=   1, 500)/8*1,12*0,2,16*0,2,1,67*0,25*-1,      
     &292*0,6*1,6*0,2,7*0,6*1,6*0,2*1,43*0/                             
      data (kchg(i,3),i=   1, 500)/8*1,2*0,8*1,5*0,1,9*0,1,2*0,1,0,2*1, 
     &11*0,1,2*0,1,26*0,1,0,2*1,15*0,1,3*0,27*1,0,1,0,1,0,1,0,1,0,1,0,  
     &1,0,1,0,1,0,1,0,1,21*0,31*1,4*0,6*1,2*0,3*1,2*0,12*1,3*0,8*1,2*0, 
     &4*1,2*0,184*1,3*0,1,2*0,1,0,16*1,41*0/                            
      data (kchg(i,4),i=   1, 281)/1,2,3,4,5,6,7,8,9,10,11,12,13,14,15, 
     &16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,   
     &37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,   
     &58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,   
     &79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,   
     &100,210,110,330,220,2110,2210,1103,2101,2103,2203,3101,3103,3201, 
     &3203,3303,4101,4103,4201,4203,4403,4301,4303,5101,5103,5201,5203, 
     &5301,5303,5401,5403,5503,111,211,113,213,10111,10211,20113,20213, 
     &115,215,10113,10213,20111,20211,10115,10215,30113,30213,40113,    
     &40213,10220,221,223,225,331,333,335,10221,10223,10331,10333,      
     &20221,20223,20333,30221,30223,30333,50223,60223,130,310,311,321,  
     &313,323,10313,10323,315,325,10311,10321,20313,20323,30313,30323,  
     &40313,40323,317,327,10315,10325,20315,20325,411,413,415,421,423,  
     &425,431,433,435,440,441,443,445,10411,10413,10421,10423,10431,    
     &10433,10441,10443,20413,20423,20433,20443,100443,511,513,515,521, 
     &523,525,531,533,535,541,543,545,551,553,555,10511,10513,10521,    
     &10523,10531,10533,10541,10543,10551,10553,20513,20523,20533,      
     &20543,20553,100553,2112,2212,12112,12212,1214,2124,22112,22212,   
     &32112,32212,2116,2216,12116,12216,21214,22124,42112,42212,31214,  
     &32124,11218,12128,1114,2114,2214,2224,31114,32114,32214,32224/    
      data (kchg(i,4),i= 282, 500)/1112,1212,2122,2222,11114,12114,     
     &12214,12224,11112,11212,12122,12222,1116,1216,2126,2226,21112,    
     &21212,22122,22222,21114,22114,22214,22224,11116,11216,12126,      
     &12226,1118,2118,2218,2228,3122,13122,3124,23122,33122,13124,      
     &43122,53122,3126,13126,23124,3128,23126,3112,3212,3222,3114,3214, 
     &3224,13112,13212,13222,13114,13214,13224,23112,23212,23222,3116,  
     &3216,3226,13116,13216,13226,23114,23214,23224,3118,3218,3228,     
     &3312,3322,3314,3324,13312,13322,13314,13324,23312,23322,3316,     
     &3326,3334,4112,4114,4122,4132,4212,4214,4222,4224,4232,4312,4314, 
     &4322,4324,4332,4334,4412,4414,4422,4424,4432,4434,4444,5112,5114, 
     &5122,5132,5142,5212,5214,5222,5224,5232,5242,5312,5314,5322,5324, 
     &5332,5334,5342,5412,5414,5422,5424,5432,5434,5442,5444,5512,5514, 
     &5522,5524,5532,5534,5542,5544,5554,1000001,1000002,1000003,       
     &1000004,1000005,1000006,1000011,1000012,1000013,1000014,1000015,  
     &1000016,1000021,1000022,1000023,1000024,1000025,1000035,1000037,  
     &1000039,2000001,2000002,2000003,2000004,2000005,2000006,2000011,  
     &2000012,2000013,2000014,2000015,2000016,4000001,4000002,4000011,  
     &4000012,41*0/                                                     
      data (kchg(i,5),i=   1, 500)/8*1,2*0,8*2,2*0,5*4,2*0,2*4,2*0,6*4, 
     &3*6,10*0,6*6,44*0,4*199,2*99,25*5,2*101,18*100,19*120,24*130,     
     &9*140,4*160,6*140,2*160,3*140,2*160,12*150,3*170,8*150,2*170,     
     &4*150,2*170,2*11,20*12,4*13,36*14,21,12*22,3*31,24*32,2*41,10*42, 
     &51,22*61,35*72,32*7,4*3,41*0/                                     
      data (kchg(i,6),i=   1, 500)/8*1,96*0,2*3,25*2,120*0,172*3,6*1,   
     &14*0,6*1,6*0,2*1,43*0/                                            
      data (kchg(i,7),i=   1, 500)/2*0,-1,107*0,4*-1,-2,5*0,2*-1,4*0,   
     &2*-1,42*0,24*1,6*0,3*1,8*0,2*1,4*0,1,8*0,3*-1,10*0,2*-1,6*0,-1,   
     &65*0,40*-1,12*-2,-3,3*0,-1,4*0,5*-1,2*-2,4*0,2*-1,4*0,-1,5*0,-1,  
     &0,4*-1,2*-2,-1,4*0,2*-1,6*0,2*-1,5*0,-1,19*0,-1,54*0/             
      data (pmas(i,1),i=   1, 236)/0.0099d0,0.0056d0,0.199d0,1.35d0,    
     &5d0,175d0,2*400d0,2*0d0,0.00051d0,0d0,0.10566d0,0d0,1.777d0,0d0,  
     &400d0,5*0d0,91.187d0,80.33d0,80d0,6*0d0,500d0,900d0,500d0,        
     &3*300d0,350d0,200d0,5000d0,10*0d0,3*100d0,3*200d0,26*0d0,1d0,2d0, 
     &5d0,21*0d0,0.77133d0,0.57933d0,2*0.77133d0,0.80473d0,0.92953d0,   
     &0.80473d0,0.92953d0,1.09361d0,1.96908d0,2.00808d0,1.96908d0,      
     &2.00808d0,3.27531d0,2.15432d0,2.17967d0,5.38897d0,5.40145d0,      
     &5.38897d0,5.40145d0,5.56725d0,5.57536d0,6.67143d0,6.67397d0,      
     &10.07354d0,0.13498d0,0.13957d0,0.7685d0,0.7669d0,2*0.9835d0,      
     &2*1.23d0,2*1.318d0,2*1.231d0,2*1.3d0,2*1.67d0,2*1.465d0,2*1.7d0,  
     &0.55d0,0.54745d0,0.78194d0,1.275d0,0.95777d0,1.0194d0,1.525d0,    
     &0.98d0,1.17d0,2*1.4d0,1.295d0,1.282d0,1.427d0,1.3d0,1.419d0,      
     &1.68d0,1.512d0,1.662d0,3*0.49767d0,0.4936d0,0.8961d0,0.8916d0,    
     &2*1.29d0,1.432d0,1.425d0,2*1.429d0,2*1.402d0,2*1.4124d0,          
     &2*1.714d0,2*1.77d0,2*1.773d0,2*1.816d0,1.8693d0,2.01d0,2.46d0,    
     &1.8645d0,2.0067d0,2.46d0,1.9685d0,2.1124d0,2.5735d0,0d0,2.9798d0, 
     &3.09688d0,3.5562d0,2.272d0,2.424d0,2.272d0,2.424d0,2.5d0,2.536d0, 
     &3.4151d0,3.46d0,2*2.372d0,2.56d0,3.5106d0,3.686d0,5.2792d0,       
     &5.3248d0,5.83d0,5.2789d0,5.3248d0,5.83d0,5.3693d0,5.4163d0,       
     &6.07d0,6.594d0,6.602d0,7.35d0,9.4d0,9.4603d0,9.9132d0,5.68d0/     
      data (pmas(i,1),i= 237, 500)/5.73d0,5.68d0,5.73d0,5.92d0,5.97d0,  
     &7.25d0,7.3d0,9.8598d0,9.875d0,2*5.78d0,6.02d0,7.3d0,9.8919d0,     
     &10.0233d0,0.93957d0,0.93827d0,2*1.44d0,2*1.52d0,2*1.535d0,        
     &2*1.65d0,2*1.675d0,2*1.68d0,2*1.7d0,2*1.71d0,2*1.72d0,2*1.99d0,   
     &1.234d0,1.233d0,1.232d0,1.231d0,4*1.6d0,4*1.62d0,4*1.7d0,4*1.9d0, 
     &4*1.905d0,4*1.91d0,4*1.92d0,4*1.93d0,4*1.95d0,1.11568d0,1.405d0,  
     &1.52d0,1.6d0,1.67d0,1.69d0,1.8d0,1.81d0,1.82d0,1.83d0,1.89d0,     
     &2.1d0,2.11d0,1.19744d0,1.19255d0,1.18937d0,1.3872d0,1.3837d0,     
     &1.3828d0,3*1.66d0,3*1.67d0,3*1.75d0,3*1.775d0,3*1.915d0,3*1.94d0, 
     &3*2.03d0,1.3213d0,1.3149d0,1.535d0,1.5318d0,2*1.69d0,2*1.82d0,    
     &2*1.95d0,2*2.03d0,1.67245d0,2.4521d0,2.5d0,2.2849d0,2.4703d0,     
     &2.4535d0,2.5d0,2.4529d0,2.5d0,2.4656d0,2.55d0,2.63d0,2.55d0,      
     &2.63d0,2.704d0,2.8d0,3.59798d0,3.65648d0,3.59798d0,3.65648d0,     
     &3.78663d0,3.82466d0,4.91594d0,5.8d0,5.81d0,5.641d0,5.84d0,        
     &7.00575d0,5.8d0,5.81d0,5.8d0,5.81d0,5.84d0,7.00575d0,5.96d0,      
     &5.97d0,5.96d0,5.97d0,6.12d0,6.13d0,7.19099d0,7.03724d0,7.0485d0,  
     &7.03724d0,7.0485d0,7.21101d0,7.219d0,8.30945d0,8.31325d0,         
     &10.42272d0,10.44144d0,10.42272d0,10.44144d0,10.60209d0,           
     &10.61426d0,11.70767d0,11.71147d0,15.11061d0,32*500d0,4*400d0,     
     &41*0d0/                                                           
      data (pmas(i,2),i=   1, 500)/5*0d0,1.4d0,16*0d0,2.47833d0,        
     &2.069d0,0.00295d0,6*0d0,14.67788d0,0d0,16.79392d0,8.45231d0,      
     &4.93534d0,5.80468d0,19.1898d0,0.39162d0,417.35284d0,93*0d0,       
     &0.151d0,0.149d0,2*0.06d0,2*0.4d0,2*0.107d0,2*0.142d0,2*0.4d0,     
     &2*0.24d0,2*0.31d0,2*0.235d0,0.5d0,0d0,0.00843d0,0.185d0,0.0002d0, 
     &0.00443d0,0.076d0,0.04d0,0.36d0,0.25d0,0.08d0,0.053d0,0.025d0,    
     &0.053d0,0.2d0,0.174d0,0.15d0,0.035d0,0.28d0,4*0d0,0.0505d0,       
     &0.0498d0,2*0.09d0,0.109d0,0.098d0,2*0.287d0,2*0.174d0,2*0.227d0,  
     &2*0.323d0,2*0.164d0,2*0.186d0,2*0.276d0,2*0d0,0.023d0,2*0d0,      
     &0.023d0,2*0d0,0.015d0,0d0,0.0013d0,0d0,0.002d0,0.05d0,0.02d0,     
     &0.05d0,0.02d0,0.05d0,0d0,0.014d0,0.01d0,3*0.05d0,0.0009d0,3*0d0,  
     &0.02d0,2*0d0,0.02d0,2*0d0,0.02d0,2*0d0,0.02d0,3*0d0,8*0.05d0,0d0, 
     &0.01d0,4*0.05d0,4*0d0,2*0.35d0,2*0.12d0,6*0.15d0,2*0.13d0,        
     &4*0.1d0,2*0.15d0,2*0.35d0,4*0.12d0,4*0.35d0,4*0.15d0,4*0.3d0,     
     &4*0.2d0,4*0.35d0,4*0.25d0,4*0.2d0,4*0.35d0,4*0.3d0,0d0,0.05d0,    
     &0.0156d0,0.15d0,0.035d0,0.065d0,0.3d0,0.15d0,0.08d0,0.095d0,      
     &0.1d0,2*0.2d0,3*0d0,0.0394d0,0.036d0,0.0358d0,3*0.1d0,3*0.06d0,   
     &3*0.09d0,6*0.12d0,3*0.22d0,3*0.18d0,2*0d0,0.0099d0,0.0091d0,      
     &2*0.05d0,2*0.024d0,2*0.06d0,2*0.02d0,58*0d0,19*1d0,0d0,7*1d0,0d0, 
     &1d0,0d0,1d0,0d0,2.60511d0,2.60839d0,0.42904d0,0.41921d0,41*0d0/   
      data (pmas(i,3),i=   1, 500)/5*0d0,14d0,16*0d0,24.78326d0,        
     &20.69d0,0.02954d0,6*0d0,146.77876d0,0d0,167.93924d0,84.52308d0,   
     &49.35344d0,58.04675d0,191.89803d0,3.91624d0,4173.52832d0,93*0d0,  
     &2*0.4d0,2*0.05d0,2*0.3d0,4*0.25d0,2*0.2d0,2*0.25d0,2*0.2d0,       
     &2*0.3d0,0.24d0,0d0,0.1d0,0.17d0,0.002d0,0.015d0,3*0.2d0,0.35d0,   
     &0.001d0,2*0.05d0,0.02d0,0.3d0,3*0.2d0,0.28d0,4*0d0,2*0.2d0,       
     &0.005d0,0.01d0,2*0.12d0,2*0.4d0,2*0.3d0,2*0.227d0,2*0.323d0,      
     &6*0.2d0,2*0d0,0.12d0,2*0d0,0.12d0,2*0d0,0.05d0,0d0,0.005d0,0d0,   
     &0.01d0,0.1d0,0.08d0,0.1d0,0.08d0,0.1d0,0d0,0.05d0,0.02d0,2*0.1d0, 
     &0.03d0,0.001d0,3*0d0,0.05d0,2*0d0,0.05d0,2*0d0,0.05d0,2*0d0,      
     &0.05d0,3*0d0,6*0.1d0,0.05d0,0.1d0,0d0,0.02d0,4*0.1d0,4*0d0,       
     &2*0.35d0,2*0.12d0,6*0.15d0,2*0.13d0,4*0.1d0,2*0.15d0,2*0.35d0,    
     &4*0.14d0,4*0.35d0,4*0.15d0,4*0.3d0,4*0.2d0,4*0.35d0,4*0.25d0,     
     &4*0.2d0,4*0.35d0,4*0.3d0,0d0,0.05d0,0.062d0,0.15d0,0.035d0,       
     &0.065d0,0.3d0,0.15d0,0.08d0,0.095d0,0.1d0,2*0.2d0,3*0d0,0.04d0,   
     &2*0.035d0,3*0.236d0,3*0.06d0,3*0.09d0,6*0.12d0,3*0.22d0,3*0.18d0, 
     &2*0d0,2*0.05d0,2*0.143d0,2*0.077d0,2*0.103d0,2*0.02d0,58*0d0,     
     &19*10d0,0.00001d0,7*10d0,0.00001d0,10d0,0.00001d0,10d0,0.00001d0, 
     &26.05109d0,26.08388d0,4.29043d0,4.19206d0,41*0d0/                 
      data (pmas(i,4),i=   1, 500)/12*0d0,658654d0,0d0,0.0872d0,68*0d0, 
     &0.1d0,0.387d0,46*0d0,0.00003d0,7804.5d0,37*0d0,15500d0,26.762d0,  
     &0d0,3709d0,20*0d0,0.317d0,2*0d0,0.1244d0,2*0d0,0.14d0,19*0d0,     
     &0.468d0,2*0d0,0.462d0,2*0d0,0.483d0,2*0d0,0.15d0,83*0d0,78.88d0,  
     &12*0d0,44.34d0,0d0,23.96d0,24*0d0,49.1d0,87.1d0,10*0d0,24.6d0,    
     &2*0d0,0.0618d0,0.029d0,4*0d0,0.106d0,4*0d0,0.019d0,0d0,7*0.1d0,   
     &2*0d0,0.342d0,2*0.387d0,4*0d0,2*0.387d0,4*0d0,0.387d0,0d0,        
     &18*0.387d0,36*0d0,41*0d0/                                         

c...PYDAT3, with particle decay parameters and data.
      data (mdcy(i,1),i=   1, 500)/5*0,3*1,6*0,1,0,1,5*0,3*1,6*0,1,0,   
     &7*1,10*0,2*1,0,3*1,26*0,3*1,48*0,19*1,0,17*1,4*0,20*1,0,2*1,0,    
     &2*1,0,2*1,2*0,15*1,0,2*1,0,2*1,0,24*1,2*0,60*1,0,12*1,3*0,24*1,   
     &2*0,10*1,2*0,1,3*0,1,0,1,2*0,1,0,1,0,1,0,1,0,1,0,2*1,0,1,4*0,1,0, 
     &1,3*0,1,0,1,0,1,2*0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,21*1,0,7*1,0,1,0, 
     &1,0,4*1,41*0/                                                     
      data (mdcy(i,2),i=   1, 366)/1,9,17,25,33,41,54,64,2*0,74,78,80,  
     &85,87,141,143,148,2*0,151,160,172,188,208,6*0,287,0,309,332,414,  
     &494,521,524,525,10*0,534,539,0,544,564,588,26*0,606,607,611,46*0, 
     &620,622,624,629,631,633,635,637,639,648,655,656,657,660,663,670,  
     &677,683,689,690,691,694,702,708,717,723,734,740,745,748,755,759,  
     &763,777,781,786,789,791,793,796,805,807,809,815,818,821,826,831,  
     &841,852,854,856,858,860,866,872,878,884,893,902,909,916,923,930,  
     &993,996,1004,1065,1067,1075,1108,1110,0,1114,1115,1118,1120,1122, 
     &1124,1126,1128,1130,1132,1134,1135,1137,1139,1141,1143,1154,1190, 
     &1191,1199,1235,1236,1244,1283,1284,1288,1319,1320,1324,1325,1334, 
     &1336,1338,1340,1342,1344,1346,1348,1350,1352,1354,1355,1357,1359, 
     &1361,1363,1365,2*0,1379,1387,1395,1404,1413,1422,1431,1441,1451,  
     &1461,1471,1479,1487,1496,1505,1517,1529,1542,1555,1569,1583,1584, 
     &1587,1590,1591,1596,1605,1614,1619,1624,1633,1642,1647,1652,1661, 
     &1670,1675,1680,1689,1698,1703,1708,1717,1726,1731,1736,1745,1754, 
     &1759,1764,1773,1782,1787,1789,1793,1797,1799,1805,1816,1827,1833, 
     &1837,1840,1848,1856,1865,1874,1884,1894,1905,1914,1925,1939,1950, 
     &1952,1953,1956,1959,1962,1965,1972,1981,1988,1995,2004,2011,2019, 
     &2028,2036,2042,2050,2056,2066,2080,2090,2100,2113,2123,2133,2147, 
     &2157,2162,2165,2167,2169,2176,2183,2190,2197,2204,2211,2214,2217/ 
      data (mdcy(i,2),i= 367, 500)/2221,2222,2223,2299,2303,2304,2305,  
     &2306,2307,2311,2312,2314,2315,2317,2321,2322,2326,2330,2334,2338, 
     &2342,2346,2350,2351,2352,2369,2378,2387,2388,2389,2390,2391,2400, 
     &2409,2410,2411,2412,2413,2422,2423,2432,2441,2450,2459,2468,2477, 
     &2486,2495,2504,2513,2522,2531,2540,2549,2558,2567,2576,2585,2597, 
     &2609,2621,2633,2645,2658,2669,2680,2691,2702,2713,2724,2785,2790, 
     &2892,2948,3066,3200,0,3271,3287,3303,3319,3335,3351,3367,0,3382,  
     &0,3397,0,3412,3416,3420,3423,41*0/                                
      data (mdcy(i,3),i=   1, 500)/5*8,13,2*10,2*0,4,2,5,2,54,2,5,3,    
     &2*0,9,12,16,20,79,6*0,22,0,23,82,80,27,3,1,9,10*0,2*5,0,20,24,18, 
     &26*0,1,4,9,46*0,2*2,5,5*2,9,7,2*1,2*3,2*7,2*6,2*1,3,8,6,9,6,11,6, 
     &5,3,7,2*4,14,4,5,3,2*2,3,9,2*2,6,2*3,2*5,10,11,4*2,4*6,2*9,4*7,   
     &63,3,8,61,2,8,33,2,4,0,1,3,8*2,1,4*2,11,36,1,8,36,1,8,39,1,4,31,  
     &1,4,1,9,10*2,1,5*2,14,2*0,2*8,4*9,4*10,2*8,2*9,2*12,2*13,2*14,1,  
     &2*3,1,5,2*9,2*5,2*9,2*5,2*9,2*5,2*9,2*5,2*9,2*5,2*9,2*5,2*9,5,2,  
     &2*4,2,6,2*11,6,4,3,2*8,2*9,2*10,11,9,11,14,11,2,1,4*3,7,9,2*7,9,  
     &7,8,9,8,6,8,6,10,14,2*10,13,2*10,14,10,5,3,2*2,6*7,2*3,4,2*1,76,  
     &4,4*1,4,1,2,1,2,4,1,7*4,2*1,17,2*9,4*1,2*9,4*1,9,1,18*9,5*12,13,  
     &6*11,61,5,102,56,118,134,71,0,6*16,15,0,15,0,15,0,2*4,3,2,41*0/   
      data (mdme(i,1),i=   1,4000)/6*1,-1,7*1,-1,7*1,-1,7*1,-1,7*1,-1,  
     &7*1,-1,1,-1,12*1,2*-1,8*1,2*-1,73*1,-1,2*1,-1,6*1,2*-1,7*1,2*-1,  
     &3*1,-1,6*1,2*-1,6*1,2*-1,3*1,-1,3*1,-1,3*1,5*-1,3*1,-1,85*1,2*-1, 
     &6*1,8*-1,3*1,-1,3*1,-1,3*1,5*-1,3*1,4*-1,197*1,2*-1,2*1,-1,20*1,  
     &2*-1,6*1,2*-1,7*1,-1,3*1,-1,3*1,5*-1,3*1,-1,1,-1,6*1,2*-1,6*1,    
     &2*-1,2819*1,576*0/                                                
      data (mdme(i,2),i=   1,4000)/43*102,4*0,102,0,4*53,3*102,4*0,102, 
     &2*0,3*102,4*0,102,2*0,6*102,42,6*102,2*42,2*0,8*41,2*0,36*41,     
     &8*102,0,102,0,102,2*0,21*102,8*32,8*0,16*32,21*0,62*53,8*32,14*0, 
     &16*32,27*0,62*53,18*0,62*53,9*0,18*53,3*32,0,6*32,3*0,2*32,3*0,   
     &2*32,7*0,8*32,12*0,16*32,6*0,8*32,8*0,12,2*42,2*11,9*42,0,2,2*0,  
     &3,4*0,3,68*0,2,3*0,1,0,3,18*0,2*3,3*0,1,69*0,4*42,11*0,2*42,2*3,  
     &0,2*3,110*0,22*42,41*0,2*3,9*0,16*42,45*0,3,10*0,10*42,20*0,2*13, 
     &6*0,12,2*0,12,0,12,13*0,2*12,7*0,12,2*0,12,8*0,14*42,16*0,48,     
     &3*13,2*42,9*0,14*42,16*0,48,3*13,2*42,9*0,14*42,19*0,48,3*13,     
     &2*42,6*0,2*11,28*42,5*0,32,3*0,4*32,2*4,0,32,17*0,2*32,9*0,32,    
     &3*0,4*32,2*4,849*0,14*42,52*0,10*13,2*42,2*11,4*0,2*42,2*11,6*0,  
     &2*42,2*11,0,2*42,2*11,2*42,2*11,2*42,2*11,2*42,2*11,2*42,2*11,    
     &2*42,2*11,2*42,2*11,2*0,3*42,8*0,48,3*13,20*42,4*0,18*42,4*0,     
     &9*42,0,162*42,828*53,588*0/                                       
      data (mdme(i,3),i=   1,4000)/623*0,1,4*0,1,9*0,2*1,2,0,3*2,1,2,   
     &2*1,2,0,2,1,2,2*0,2*1,0,2*1,0,2,2*1,2,2*1,2*2,2*1,2,2*1,2,1,5*0,  
     &1,20*0,1,3*0,2*2,2*0,4*2,7*0,2*1,8*0,1,6*2,23*0,3*1,49*0,2*1,0,   
     &2*1,11*0,2*2,2*1,2*0,3*1,3*2,2*1,2*0,3*1,2,1,10*0,2*1,4*0,2*1,    
     &2*0,2*1,4*0,2*1,4*0,4*2,3*3,2*1,6*2,3*3,2*0,2*1,0,2*1,2*0,2*1,0,  
     &2*1,2*0,2*1,0,2*1,2*0,2*1,0,2*1,63*0,2*1,0,2*2,2*1,65*0,1,0,2*2,  
     &2*1,38*0,1,2*2,2*1,5*0,1,71*0,2*2,2*1,41*0,2*2,2*1,44*0,2*2,2*1,  
     &32*0,2*2,2*1,55*0,16*1,3*2,3*0,6*2,3*0,3*2,3*0,3*2,6*0,3*2,6*0,   
     &3*2,7*0,3*2,4*0,20*2,3*3,5*1,3*3,5*1,6*2,2*0,7*2,2*0,2,50*1,28*3, 
     &3*1,0,2*1,0,29*1,2,0,2*2,0,2*2,2*0,3*2,2*0,2*2,2*0,3*2,2*0,2,0,   
     &2*2,0,2,3*0,3*2,5*0,4*2,5*0,3*2,3*0,2,2*0,3*2,4*0,5*2,4*0,5*2,    
     &2*0,3*2,3,3*2,3*3,5*2,4*3,5*2,3*3,3*2,3,56*1,12*2,34*3,7*0,8*2,   
     &8*1,9*0,6*2,11*0,2*2,10*1,6*3,3*1,2*3,9*2,5*1,3*3,3*1,12*4,2*2,   
     &5*3,3*1,3*3,6*0,32*1,4*2,0,7*2,2*0,6*2,0,2*2,25*0,20*2,6*3,1,     
     &11*3,2*1,10*3,1,3*3,5*2,0,2,3*0,6*2,2*0,2,4*0,5*2,0,2,3*0,6*3,2,  
     &12*3,2,10*3,2,3*3,8*0,18*1,14*2,14*0,6*2,3*1,2*0,1,81*0,1,0,1,    
     &5*0,1,2*0,1,35*0,1,36*0,1,0,1,241*0,1,3*0,1,7*0,1,3*0,2*1,6*0,2,  
     &1,47*0,1,10*0,2*1,206*0,2*1,10*0,2*1,29*0,2*1,44*0,8*1,16*0,8*1,  
     &40*0,2*1,60*0,8*1,16*0,8*1,36*0,3*1,5*0,1,17*0,2,1,2*0,4*2,4*1,   
     &4*0,4*2,4*1,69*0,1,3*0,1,11*0,1,3*0,2*1,10*0,2,33*0,1,600*0/      
      data (brat(i)  ,i=   1, 418)/43*0d0,0.00003d0,0.00177d0,0.9982d0, 
     &33*0d0,1d0,6*0d0,0.1783d0,0.1735d0,0.1131d0,0.2494d0,0.003d0,     
     &0.09d0,0.0027d0,0.01d0,0.0014d0,0.0012d0,2*0.00025d0,0.0071d0,    
     &0.012d0,0.0004d0,0.00075d0,0.00006d0,2*0.00078d0,0.0034d0,0.08d0, 
     &0.011d0,0.0191d0,0.00006d0,0.005d0,0.0133d0,0.0067d0,0.0005d0,    
     &0.0035d0,0.0006d0,0.0015d0,0.00021d0,0.0002d0,0.00075d0,0.0001d0, 
     &0.0002d0,0.0011d0,3*0.0002d0,0.00022d0,0.0004d0,0.0001d0,         
     &2*0.00205d0,2*0.00069d0,0.00025d0,0.00051d0,0.00025d0,35*0d0,     
     &0.15403d0,0.11945d0,0.15402d0,0.11931d0,0.15215d0,3*0d0,          
     &0.03357d0,0.0668d0,0.03357d0,0.0668d0,0.0335d0,0.0668d0,2*0d0,    
     &0.32139d0,0.0165d0,2*0d0,0.0165d0,0.32067d0,2*0d0,0.00001d0,      
     &0.00059d0,6*0d0,2*0.10814d0,0.10806d0,3*0d0,0.00031d0,0.04438d0,  
     &0.88031d0,4*0d0,0.0002d0,0.05531d0,0d0,0.01838d0,0.00071d0,0d0,   
     &0.00009d0,0.00032d0,62*0d0,0.14449d0,0.11223d0,0.14449d0,         
     &0.11223d0,0.14443d0,0.05782d0,2*0d0,0.03172d0,0.06305d0,          
     &0.03172d0,0.06305d0,0.03172d0,0.06305d0,8*0d0,0.24928d0,0.0128d0, 
     &0.00001d0,0d0,0.0128d0,0.24882d0,0.00039d0,0d0,0.00001d0,         
     &0.00046d0,0.22153d0,5*0d0,2*0.08464d0,0.08463d0,7*0d0,0.00005d0,  
     &0.00097d0,5*0d0,0.00007d0,0d0,0.00049d0,0.00001d0,0.00006d0,      
     &0.30591d0,0.68863d0,0d0,0.0038d0,66*0d0,0.00008d0,0.00167d0/      
      data (brat(i)  ,i= 419, 733)/5*0d0,0.00013d0,0d0,0.00294d0,       
     &0.00001d0,3*0d0,0.99517d0,63*0d0,0.00002d0,0.07231d0,2*0d0,       
     &0.00001d0,0.00269d0,0d0,0.92497d0,18*0d0,0.0024d0,0.99483d0,      
     &0.00278d0,1d0,3*0.21511d0,0.21478d0,2*0d0,2*0.06995d0,2*0d0,1d0,  
     &3*0d0,0.95d0,0.05d0,3*0d0,4*0.25d0,16*0d0,4*0.25d0,20*0d0,1d0,    
     &17*0d0,1d0,2*0.08d0,0.76d0,0.08d0,2*0.105d0,0.04d0,0.5d0,0.08d0,  
     &0.14d0,0.01d0,0.015d0,0.005d0,0.988d0,0.012d0,0.999877d0,         
     &0.000123d0,0.998739d0,0.00079d0,0.00038d0,0.000046d0,0.000045d0,  
     &0.99955d0,0.00045d0,0.78d0,0.22d0,0.78d0,0.22d0,4*0.5d0,          
     &2*0.34725d0,0.144d0,0.104d0,0.0245d0,2*0.01225d0,0.0028d0,        
     &0.0057d0,2*0.34725d0,0.144d0,0.104d0,0.049d0,0.0028d0,0.0057d0,   
     &2*1d0,2*0.25d0,0.5d0,2*0.25d0,0.5d0,0.562d0,2*0.155d0,0.08d0,     
     &2*0.021d0,0.006d0,0.562d0,2*0.155d0,0.08d0,2*0.021d0,0.006d0,     
     &0.5d0,0.14333d0,0.28667d0,0.04d0,0.02d0,0.01d0,0.5d0,0.14333d0,   
     &0.28667d0,0.04d0,0.02d0,0.01d0,2*1d0,3*0.33333d0,0.3923d0,        
     &0.321d0,0.2317d0,0.0478d0,0.0049d0,0.0013d0,0.0003d0,0.0007d0,    
     &0.89d0,0.08693d0,0.0221d0,0.00083d0,2*0.00007d0,0.564d0,0.282d0,  
     &0.072d0,0.028d0,0.023d0,2*0.0115d0,0.005d0,0.003d0,0.437d0,       
     &0.208d0,0.302d0,0.0302d0,0.0212d0,0.0016d0,0.48947d0,0.34d0,      
     &3*0.043d0,0.027d0,0.0126d0,0.0013d0,0.0003d0,0.00025d0,0.00008d0/ 
      data (brat(i)  ,i= 734, 905)/0.444d0,2*0.222d0,0.104d0,2*0.004d0, 
     &0.52d0,0.26d0,0.11d0,2*0.055d0,0.333d0,0.334d0,0.333d0,0.36d0,    
     &0.18d0,0.03d0,2*0.015d0,2*0.2d0,4*0.25d0,3*0.16666d0,0.5d0,       
     &3*0.146d0,3*0.05d0,0.15d0,2*0.05d0,4*0.024d0,0.066d0,4*0.25d0,    
     &0.624d0,0.312d0,0.032d0,2*0.016d0,3*0.33333d0,4*0.5d0,            
     &3*0.33333d0,0.2112d0,0.1256d0,2*0.1939d0,2*0.1359d0,0.002d0,      
     &0.001d0,0.0006d0,0.6861d0,0.3139d0,2*0.5d0,0.6352d0,0.2116d0,     
     &0.0559d0,0.0173d0,0.0482d0,0.0318d0,0.665d0,0.333d0,0.002d0,      
     &0.666d0,0.333d0,0.001d0,0.28d0,0.14d0,0.313d0,0.157d0,0.11d0,     
     &0.28d0,0.14d0,0.313d0,0.157d0,0.11d0,0.333d0,0.166d0,0.168d0,     
     &0.084d0,0.087d0,0.043d0,0.059d0,2*0.029d0,0.002d0,0.332d0,        
     &0.166d0,0.168d0,0.084d0,0.086d0,0.043d0,0.059d0,2*0.029d0,        
     &2*0.002d0,0.667d0,0.333d0,0.667d0,0.333d0,0.667d0,0.333d0,        
     &0.667d0,0.333d0,0.576d0,0.288d0,0.044d0,0.022d0,0.04667d0,        
     &0.02333d0,0.576d0,0.288d0,0.044d0,0.022d0,0.04667d0,0.02333d0,    
     &0.258d0,0.129d0,0.20934d0,0.10466d0,0.1993d0,0.0997d0,0.258d0,    
     &0.129d0,0.20934d0,0.10466d0,0.1993d0,0.0997d0,0.3d0,0.15d0,       
     &0.182d0,0.091d0,0.12867d0,0.06433d0,0.08d0,0.00267d0,0.00133d0,   
     &0.3d0,0.15d0,0.182d0,0.091d0,0.12867d0,0.06433d0,0.08d0,          
     &0.00267d0,0.00133d0,0.53334d0,0.26666d0,0.03334d0,0.01666d0/      
      data (brat(i)  ,i= 906,1078)/3*0.05d0,0.53334d0,0.26666d0,        
     &0.03334d0,0.01666d0,3*0.05d0,0.53334d0,0.26666d0,0.03334d0,       
     &0.01666d0,3*0.05d0,0.53334d0,0.26666d0,0.03334d0,0.01666d0,       
     &3*0.05d0,0.07d0,0.065d0,2*0.005d0,2*0.011d0,5*0.001d0,0.07d0,     
     &0.065d0,2*0.005d0,2*0.011d0,5*0.001d0,0.026d0,0.019d0,0.066d0,    
     &0.041d0,0.045d0,0.076d0,0.0073d0,2*0.0047d0,0.026d0,0.001d0,      
     &0.0006d0,0.0066d0,0.005d0,2*0.003d0,2*0.0006d0,2*0.001d0,0.006d0, 
     &0.005d0,0.012d0,0.0057d0,0.067d0,0.008d0,0.0022d0,0.027d0,        
     &0.004d0,0.019d0,0.012d0,0.002d0,0.009d0,0.0218d0,0.001d0,0.022d0, 
     &0.087d0,0.001d0,0.0019d0,0.0015d0,0.0028d0,0.683d0,0.306d0,       
     &0.011d0,0.3d0,0.15d0,0.16d0,0.08d0,0.13d0,0.06d0,0.08d0,0.04d0,   
     &0.034d0,0.027d0,2*0.002d0,2*0.004d0,2*0.002d0,0.034d0,0.027d0,    
     &2*0.002d0,2*0.004d0,2*0.002d0,0.0365d0,0.045d0,0.073d0,0.062d0,   
     &3*0.021d0,0.0061d0,0.015d0,0.025d0,0.0088d0,0.074d0,0.0109d0,     
     &0.0041d0,0.002d0,0.0035d0,0.0011d0,0.001d0,0.0027d0,2*0.0016d0,   
     &0.0018d0,0.011d0,0.0063d0,0.0052d0,0.018d0,0.016d0,0.0034d0,      
     &0.0036d0,0.0009d0,0.0006d0,0.015d0,0.0923d0,0.018d0,0.022d0,      
     &0.0077d0,0.009d0,0.0075d0,0.024d0,0.0085d0,0.067d0,0.0511d0,      
     &0.017d0,0.0004d0,0.0028d0,0.619d0,0.381d0,0.3d0,0.15d0,0.16d0,    
     &0.08d0,0.13d0,0.06d0,0.08d0,0.04d0,0.01d0,2*0.02d0,0.03d0/        
      data (brat(i)  ,i=1079,1249)/2*0.005d0,2*0.02d0,0.03d0,2*0.005d0, 
     &0.015d0,0.037d0,0.028d0,0.079d0,0.095d0,0.052d0,0.0078d0,         
     &4*0.001d0,0.028d0,0.033d0,0.026d0,0.05d0,0.01d0,4*0.005d0,0.25d0, 
     &0.0952d0,0.94d0,0.06d0,2*0.4d0,2*0.1d0,1d0,0.0602d0,0.0601d0,     
     &0.8797d0,0.135d0,0.865d0,0.667d0,0.333d0,0.667d0,0.333d0,0.667d0, 
     &0.333d0,0.667d0,0.333d0,4*0.5d0,0.007d0,0.993d0,1d0,0.667d0,      
     &0.333d0,0.667d0,0.333d0,2*0.5d0,0.273d0,0.727d0,2*0.0083d0,       
     &0.1866d0,0.324d0,0.184d0,0.027d0,0.001d0,0.093d0,0.087d0,0.078d0, 
     &0.0028d0,0.02d0,0.055d0,2*0.005d0,0.008d0,0.012d0,0.02d0,0.055d0, 
     &2*0.005d0,0.008d0,0.012d0,0.01d0,0.03d0,0.0035d0,0.011d0,         
     &0.0055d0,0.0042d0,0.009d0,0.018d0,0.015d0,0.0185d0,0.0135d0,      
     &0.025d0,0.0004d0,0.0007d0,0.0008d0,0.0014d0,0.0019d0,0.0025d0,    
     &0.4291d0,0.08d0,0.07d0,0.02d0,0.015d0,0.005d0,1d0,0.3d0,0.15d0,   
     &0.16d0,0.08d0,0.13d0,0.06d0,0.08d0,0.04d0,0.02d0,0.055d0,         
     &2*0.005d0,0.008d0,0.012d0,0.02d0,0.055d0,2*0.005d0,0.008d0,       
     &0.012d0,0.01d0,0.03d0,0.0035d0,0.011d0,0.0055d0,0.0042d0,0.009d0, 
     &0.018d0,0.015d0,0.0185d0,0.0135d0,0.025d0,0.0004d0,0.0007d0,      
     &0.0008d0,0.0014d0,0.0019d0,0.0025d0,0.4291d0,0.08d0,0.07d0,       
     &0.02d0,0.015d0,0.005d0,1d0,0.3d0,0.15d0,0.16d0,0.08d0,0.13d0,     
     &0.06d0,0.08d0,0.04d0,0.02d0,0.055d0,2*0.005d0,0.008d0,0.012d0/    
      data (brat(i)  ,i=1250,1416)/0.02d0,0.055d0,2*0.005d0,0.008d0,    
     &0.012d0,0.01d0,0.03d0,0.0035d0,0.011d0,0.0055d0,0.0042d0,0.009d0, 
     &0.018d0,0.015d0,0.0185d0,0.0135d0,0.025d0,2*0.0002d0,0.0007d0,    
     &2*0.0004d0,0.0014d0,0.001d0,0.0009d0,0.0025d0,0.4291d0,0.08d0,    
     &0.07d0,0.02d0,0.015d0,0.005d0,1d0,2*0.3d0,2*0.2d0,0.047d0,        
     &0.122d0,0.006d0,0.012d0,0.035d0,0.012d0,0.035d0,0.003d0,0.007d0,  
     &0.15d0,0.037d0,0.008d0,0.002d0,0.05d0,0.015d0,0.003d0,0.001d0,    
     &0.014d0,0.042d0,0.014d0,0.042d0,0.24d0,0.065d0,0.012d0,0.003d0,   
     &0.001d0,0.002d0,0.001d0,0.002d0,0.014d0,0.003d0,1d0,2*0.3d0,      
     &2*0.2d0,1d0,0.0252d0,0.0248d0,0.0267d0,0.015d0,0.045d0,0.015d0,   
     &0.045d0,0.7743d0,0.029d0,0.22d0,0.78d0,0.667d0,0.333d0,0.667d0,   
     &0.333d0,0.667d0,0.333d0,0.667d0,0.333d0,8*0.5d0,0.02d0,0.98d0,    
     &1d0,0.667d0,0.333d0,0.667d0,0.333d0,4*0.5d0,0.35d0,0.65d0,        
     &3*0.014d0,0.008d0,0.024d0,0.008d0,0.024d0,0.425d0,0.02d0,0.185d0, 
     &0.088d0,0.043d0,0.067d0,0.066d0,0.05d0,0.21667d0,0.43333d0,       
     &0.125d0,0.08333d0,0.04167d0,0.01667d0,0.03333d0,0.05d0,0.21667d0, 
     &0.43333d0,0.125d0,0.08333d0,0.04167d0,0.01667d0,0.03333d0,        
     &0.049d0,0.18333d0,0.36667d0,0.1125d0,0.075d0,0.0375d0,0.05833d0,  
     &0.11667d0,0.001d0,0.049d0,0.18333d0,0.36667d0,0.1125d0,0.075d0,   
     &0.0375d0,0.05833d0,0.11667d0,0.001d0,0.05d0,0.15d0,0.3d0,0.025d0/ 
      data (brat(i)  ,i=1417,1558)/0.01667d0,0.00833d0,0.01667d0,       
     &0.03333d0,0.4d0,0.05d0,0.15d0,0.3d0,0.025d0,0.01667d0,0.00833d0,  
     &0.01667d0,0.03333d0,0.4d0,0.05d0,0.23333d0,0.46667d0,0.025d0,     
     &0.01667d0,0.00833d0,0.04333d0,0.08667d0,0.01d0,0.06d0,0.05d0,     
     &0.23333d0,0.46667d0,0.025d0,0.01667d0,0.00833d0,0.04333d0,        
     &0.08667d0,0.01d0,0.06d0,0.009d0,0.11333d0,0.22667d0,0.275d0,      
     &0.18333d0,0.09167d0,0.03d0,0.06d0,0.01d0,0.001d0,0.009d0,         
     &0.11333d0,0.22667d0,0.275d0,0.18333d0,0.09167d0,0.03d0,0.06d0,    
     &0.01d0,0.001d0,0.15d0,0.21667d0,0.43333d0,0.05d0,0.03333d0,       
     &0.01667d0,0.03333d0,0.06667d0,0.15d0,0.21667d0,0.43333d0,0.05d0,  
     &0.03333d0,0.01667d0,0.03333d0,0.06667d0,0.399d0,0.03333d0,        
     &0.06667d0,0.1995d0,0.133d0,0.0665d0,0.03333d0,0.06667d0,0.002d0,  
     &0.399d0,0.03333d0,0.06667d0,0.1995d0,0.133d0,0.0665d0,0.03333d0,  
     &0.06667d0,0.002d0,0.015d0,0.05d0,0.1d0,0.075d0,0.05d0,0.025d0,    
     &0.04167d0,0.08333d0,0.3d0,0.2d0,0.02d0,0.04d0,0.015d0,0.05d0,     
     &0.1d0,0.075d0,0.05d0,0.025d0,0.04167d0,0.08333d0,0.3d0,0.2d0,     
     &0.02d0,0.04d0,0.1d0,0.05d0,0.1d0,0.05d0,0.03333d0,0.01667d0,      
     &0.06667d0,0.13333d0,0.04d0,0.05d0,0.02d0,0.04d0,0.3d0,0.1d0,      
     &0.05d0,0.1d0,0.05d0,0.03333d0,0.01667d0,0.06667d0,0.13333d0,      
     &0.04d0,0.05d0,0.02d0,0.04d0,0.3d0,0.03d0,0.05d0,0.1d0,0.05d0/     
      data (brat(i)  ,i=1559,1702)/0.03333d0,0.01667d0,0.06667d0,       
     &0.13333d0,0.04d0,0.05d0,0.03333d0,0.06667d0,0.3d0,2*0.03d0,       
     &0.05d0,0.1d0,0.05d0,0.03333d0,0.01667d0,0.06667d0,0.13333d0,      
     &0.04d0,0.05d0,0.03333d0,0.06667d0,0.3d0,0.03d0,1d0,0.331d0,       
     &0.663d0,0.006d0,0.663d0,0.331d0,0.006d0,1d0,0.15d0,0.175d0,       
     &0.33d0,0.22d0,0.125d0,0.1d0,0.05d0,0.11667d0,0.05833d0,0.03667d0, 
     &0.29333d0,0.22d0,0.08333d0,0.04167d0,0.1d0,0.05d0,0.11667d0,      
     &0.05833d0,0.03667d0,0.29333d0,0.22d0,0.08333d0,0.04167d0,0.15d0,  
     &0.175d0,0.33d0,0.22d0,0.125d0,0.05d0,0.25d0,0.3d0,2*0.2d0,        
     &0.03333d0,0.01667d0,0.16667d0,0.08333d0,0.03333d0,0.26667d0,      
     &0.2d0,0.13333d0,0.06667d0,0.03333d0,0.01667d0,0.16667d0,          
     &0.08333d0,0.03333d0,0.26667d0,0.2d0,0.13333d0,0.06667d0,0.05d0,   
     &0.25d0,0.3d0,3*0.2d0,0.24d0,0.16d0,0.3984d0,0.0016d0,0.13333d0,   
     &0.06667d0,0.02667d0,0.21333d0,0.16d0,0.2656d0,0.1328d0,0.00107d0, 
     &0.00053d0,0.13333d0,0.06667d0,0.02667d0,0.21333d0,0.16d0,         
     &0.2656d0,0.1328d0,0.00107d0,0.00053d0,0.2d0,0.24d0,0.16d0,        
     &0.3984d0,0.0016d0,0.4d0,0.1d0,0.03d0,0.02d0,0.45d0,0.26667d0,     
     &0.13333d0,0.06667d0,0.03333d0,0.00333d0,0.02667d0,0.02d0,0.3d0,   
     &0.15d0,0.26667d0,0.13333d0,0.06667d0,0.03333d0,0.00333d0,         
     &0.02667d0,0.02d0,0.3d0,0.15d0,0.4d0,0.1d0,0.03d0,0.02d0,0.45d0/   
      data (brat(i)  ,i=1703,1866)/0.1d0,0.08999d0,0.05999d0,0.75d0,    
     &0.00002d0,0.06667d0,0.03333d0,0.01d0,0.07999d0,0.05999d0,0.5d0,   
     &0.25d0,2*0.00001d0,0.06667d0,0.03333d0,0.01d0,0.07999d0,          
     &0.05999d0,0.5d0,0.25d0,2*0.00001d0,0.1d0,0.08999d0,0.05999d0,     
     &0.75d0,0.00002d0,0.6d0,0.225d0,0.015d0,0.01d0,0.15d0,0.4d0,0.2d0, 
     &0.15d0,0.075d0,0.00167d0,0.01333d0,0.01d0,0.1d0,0.05d0,0.4d0,     
     &0.2d0,0.15d0,0.075d0,0.00167d0,0.01333d0,0.01d0,0.1d0,0.05d0,     
     &0.6d0,0.225d0,0.015d0,0.01d0,0.15d0,0.37d0,0.2d0,0.24d0,0.16d0,   
     &0.03d0,0.24667d0,0.12333d0,0.13333d0,0.06667d0,0.02667d0,         
     &0.21333d0,0.16d0,0.02d0,0.01d0,0.24667d0,0.12333d0,0.13333d0,     
     &0.06667d0,0.02667d0,0.21333d0,0.16d0,0.02d0,0.01d0,0.37d0,0.2d0,  
     &0.24d0,0.16d0,0.03d0,0.15d0,0.85d0,0.1d0,0.05d0,0.56667d0,        
     &0.28333d0,0.1d0,0.05d0,0.56667d0,0.28333d0,0.15d0,0.85d0,0.19d0,  
     &0.4d0,0.18d0,0.12d0,0.1d0,0.01d0,0.12667d0,0.06333d0,0.26667d0,   
     &0.13333d0,0.02d0,0.16d0,0.12d0,0.06667d0,0.03333d0,0.00667d0,     
     &0.00333d0,0.12667d0,0.06333d0,0.26667d0,0.13333d0,0.02d0,0.16d0,  
     &0.12d0,0.06667d0,0.03333d0,0.00667d0,0.00333d0,0.19d0,0.4d0,      
     &0.18d0,0.12d0,0.1d0,0.01d0,0.639d0,0.358d0,0.002d0,0.001d0,       
     &3*0.33333d0,2*0.23d0,3*0.14d0,3*0.04d0,2*0.1d0,3*0.2d0,           
     &3*0.06667d0,2*0.1d0,3*0.11667d0,0.35d0,3*0.03333d0,2*0.125d0/     
      data (brat(i)  ,i=1867,2097)/3*0.1d0,0.25d0,3*0.06667d0,          
     &2*0.175d0,3*0.01667d0,3*0.1d0,2*0.15d0,2*0.125d0,3*0.08667d0,     
     &3*0.00333d0,2*0.24d0,2*0.3d0,3*0.03333d0,0.06d0,3*0.04d0,         
     &2*0.06d0,2*0.0275d0,3*0.16667d0,0.02d0,3*0.14167d0,2*0.15d0,      
     &3*0.01667d0,3*0.05d0,0.35d0,2*0.075d0,2*0.125d0,3*0.01667d0,      
     &0.03d0,2*0.015d0,3*0.09333d0,0.051d0,2*0.1545d0,2*0.025d0,        
     &3*0.03333d0,3*0.04167d0,0.125d0,2*0.3d0,0.999d0,0.001d0,1d0,      
     &0.516d0,0.483d0,0.001d0,0.88d0,2*0.06d0,0.88d0,2*0.06d0,0.88d0,   
     &2*0.06d0,0.2d0,0.35d0,2*0.175d0,0.0375d0,0.0125d0,0.05d0,2*0.1d0, 
     &0.35d0,2*0.175d0,4*0.025d0,0.2d0,0.35d0,2*0.175d0,0.0375d0,       
     &0.0125d0,0.05d0,0.1d0,0.15d0,2*0.225d0,3*0.1d0,2*0.05d0,0.15d0,   
     &2*0.225d0,2*0.05d0,3*0.1d0,0.15d0,2*0.225d0,3*0.1d0,0.2d0,0.05d0, 
     &2*0.04d0,0.52d0,0.1d0,0.0375d0,0.0125d0,2*0.1d0,0.05d0,2*0.04d0,  
     &0.52d0,0.1d0,2*0.025d0,0.2d0,0.05d0,2*0.04d0,0.52d0,0.1d0,        
     &0.0375d0,0.0125d0,0.4d0,0.2d0,2*0.02d0,0.13d0,0.23d0,3*0.2d0,     
     &2*0.02d0,2*0.065d0,0.23d0,0.4d0,0.2d0,2*0.02d0,0.13d0,0.23d0,     
     &0.05d0,0.2d0,2*0.015d0,0.11d0,0.09d0,0.15d0,0.1125d0,0.0375d0,    
     &0.22d0,2*0.025d0,0.2d0,2*0.015d0,0.11d0,2*0.045d0,4*0.075d0,      
     &2*0.11d0,0.05d0,0.2d0,2*0.015d0,0.11d0,0.09d0,0.15d0,0.1125d0,    
     &0.0375d0,0.22d0,2*0.05d0,2*0.01d0,0.1d0,0.18d0,0.2d0,0.15d0/      
      data (brat(i)  ,i=2098,2295)/0.05d0,0.2d0,2*0.025d0,0.05d0,       
     &2*0.01d0,0.1d0,2*0.09d0,0.2d0,4*0.1d0,2*0.05d0,2*0.01d0,0.1d0,    
     &0.18d0,0.2d0,0.15d0,0.05d0,3*0.2d0,2*0.03d0,0.06d0,0.07d0,0.13d0, 
     &0.15d0,0.05d0,0.08d0,2*0.1d0,0.2d0,4*0.03d0,2*0.035d0,0.13d0,     
     &2*0.1d0,2*0.04d0,2*0.2d0,2*0.03d0,0.06d0,0.07d0,0.13d0,0.15d0,    
     &0.05d0,0.08d0,0.9988d0,0.0001d0,0.0006d0,0.0004d0,0.0001d0,       
     &0.9954d0,0.0011d0,0.0035d0,0.667d0,2*0.333d0,0.667d0,0.03333d0,   
     &0.06667d0,2*0.2d0,0.4d0,0.03333d0,0.06667d0,0.03333d0,0.06667d0,  
     &2*0.2d0,0.4d0,0.03333d0,0.06667d0,0.03333d0,0.06667d0,0.3d0,      
     &0.1d0,0.2d0,0.1d0,0.2d0,0.03333d0,0.06667d0,0.3d0,0.1d0,0.2d0,    
     &0.1d0,0.2d0,0.1d0,0.2d0,0.3d0,0.1d0,0.2d0,0.03333d0,0.06667d0,    
     &0.1d0,0.2d0,0.3d0,0.1d0,0.2d0,0.03333d0,0.06667d0,0.2d0,          
     &0.26667d0,0.53333d0,0.2d0,0.26667d0,0.53333d0,0.676d0,0.234d0,    
     &0.085d0,0.005d0,2*1d0,0.018d0,2*0.005d0,0.003d0,0.002d0,          
     &2*0.006d0,0.018d0,2*0.005d0,0.003d0,0.002d0,2*0.006d0,0.0066d0,   
     &0.025d0,0.016d0,0.0088d0,2*0.005d0,0.0058d0,0.005d0,0.0055d0,     
     &4*0.004d0,2*0.002d0,2*0.004d0,0.003d0,0.002d0,2*0.003d0,          
     &3*0.002d0,2*0.001d0,0.002d0,2*0.001d0,2*0.002d0,0.0013d0,         
     &0.0018d0,5*0.001d0,4*0.003d0,2*0.005d0,2*0.002d0,2*0.001d0,       
     &2*0.002d0,2*0.001d0,0.2432d0,0.057d0,2*0.035d0,0.15d0,2*0.075d0/  
      data (brat(i)  ,i=2296,2496)/0.03d0,2*0.015d0,2*0.08d0,0.76d0,    
     &0.08d0,4*1d0,2*0.08d0,0.76d0,0.08d0,1d0,2*0.5d0,1d0,2*0.5d0,      
     &2*0.08d0,0.76d0,0.08d0,1d0,2*0.08d0,0.76d0,3*0.08d0,0.76d0,       
     &3*0.08d0,0.76d0,3*0.08d0,0.76d0,3*0.08d0,0.76d0,3*0.08d0,0.76d0,  
     &3*0.08d0,0.76d0,0.08d0,2*1d0,2*0.105d0,0.04d0,0.0077d0,0.02d0,    
     &0.0235d0,0.0285d0,0.0435d0,0.0011d0,0.0022d0,0.0044d0,0.4291d0,   
     &0.08d0,0.07d0,0.02d0,0.015d0,0.005d0,2*0.105d0,0.04d0,0.5d0,      
     &0.08d0,0.14d0,0.01d0,0.015d0,0.005d0,2*0.105d0,0.04d0,0.5d0,      
     &0.08d0,0.14d0,0.01d0,0.015d0,0.005d0,4*1d0,2*0.105d0,0.04d0,      
     &0.5d0,0.08d0,0.14d0,0.01d0,0.015d0,0.005d0,2*0.105d0,0.04d0,      
     &0.5d0,0.08d0,0.14d0,0.01d0,0.015d0,0.005d0,4*1d0,2*0.105d0,       
     &0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,0.015d0,0.005d0,1d0,2*0.105d0,  
     &0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,0.015d0,0.005d0,2*0.105d0,      
     &0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,0.015d0,0.005d0,2*0.105d0,      
     &0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,0.015d0,0.005d0,2*0.105d0,      
     &0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,0.015d0,0.005d0,2*0.105d0,      
     &0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,0.015d0,0.005d0,2*0.105d0,      
     &0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,0.015d0,0.005d0,2*0.105d0,      
     &0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,0.015d0,0.005d0,2*0.105d0,      
     &0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,0.015d0,0.005d0,2*0.105d0/      
      data (brat(i)  ,i=2497,4000)/0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,   
     &0.015d0,0.005d0,2*0.105d0,0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,      
     &0.015d0,0.005d0,2*0.105d0,0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,      
     &0.015d0,0.005d0,2*0.105d0,0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,      
     &0.015d0,0.005d0,2*0.105d0,0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,      
     &0.015d0,0.005d0,2*0.105d0,0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,      
     &0.015d0,0.005d0,2*0.105d0,0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,      
     &0.015d0,0.005d0,2*0.105d0,0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,      
     &0.015d0,0.005d0,2*0.105d0,0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,      
     &0.015d0,0.005d0,2*0.105d0,0.04d0,0.5d0,0.08d0,0.14d0,0.01d0,      
     &0.015d0,0.005d0,827*0d0,0.8516d0,0.00539d0,0.04483d0,0.09819d0,   
     &0.85053d0,0.02152d0,0.02989d0,0.09806d0,0.29439d0,0.10943d0,      
     &0.59618d0,0.38983d0,0.61017d0,576*0d0/                            
      data (kfdp(i,1),i=   1, 375)/21,22,23,4*-24,25,21,22,23,4*24,25,  
     &21,22,23,4*-24,25,21,22,23,4*24,25,21,22,23,4*-24,25,21,22,23,    
     &4*24,25,37,1000022,1000023,1000025,1000035,21,22,23,4*-24,25,     
     &2*-37,21,22,23,4*24,25,2*37,22,23,-24,25,23,24,-12,22,23,-24,25,  
     &23,24,-12,-14,48*16,22,23,-24,25,23,24,22,23,-24,25,-37,23,24,37, 
     &1,2,3,4,5,6,7,8,21,1,2,3,4,5,6,7,8,11,13,15,17,1,2,3,4,5,6,7,8,   
     &11,12,13,14,15,16,17,18,4*-1,4*-3,4*-5,4*-7,-11,-13,-15,-17,1,2,  
     &3,4,5,6,7,8,11,13,15,17,21,2*22,23,24,1000022,2*1000023,          
     &3*1000025,4*1000035,2*1000024,2*1000037,1000001,2000001,1000001,  
     &-1000001,1000002,2000002,1000002,-1000002,1000003,2000003,        
     &1000003,-1000003,1000004,2000004,1000004,-1000004,1000005,        
     &2000005,1000005,-1000005,1000006,2000006,1000006,-1000006,        
     &1000011,2000011,1000011,-1000011,1000012,2000012,1000012,         
     &-1000012,1000013,2000013,1000013,-1000013,1000014,2000014,        
     &1000014,-1000014,1000015,2000015,1000015,-1000015,1000016,        
     &2000016,1000016,-1000016,1,2,3,4,5,6,7,8,11,12,13,14,15,16,17,18, 
     &24,37,2*23,25,35,4*-1,4*-3,4*-5,4*-7,-11,-13,-15,-17,3*24,1,2,3,  
     &4,5,6,7,8,11,13,15,17,21,2*22,23,24,23,25,36,1000022,2*1000023,   
     &3*1000025,4*1000035,2*1000024,2*1000037,1000001,2000001,1000001,  
     &-1000001,1000002,2000002,1000002,-1000002,1000003,2000003/        
      data (kfdp(i,1),i= 376, 606)/1000003,-1000003,1000004,2000004,    
     &1000004,-1000004,1000005,2000005,1000005,-1000005,1000006,        
     &2000006,1000006,-1000006,1000011,2000011,1000011,-1000011,        
     &1000012,2000012,1000012,-1000012,1000013,2000013,1000013,         
     &-1000013,1000014,2000014,1000014,-1000014,1000015,2000015,        
     &1000015,-1000015,1000016,2000016,1000016,-1000016,1,2,3,4,5,6,7,  
     &8,11,13,15,17,21,2*22,23,24,23,1000022,2*1000023,3*1000025,       
     &4*1000035,2*1000024,2*1000037,1000001,2000001,1000001,-1000001,   
     &1000002,2000002,1000002,-1000002,1000003,2000003,1000003,         
     &-1000003,1000004,2000004,1000004,-1000004,1000005,2000005,        
     &1000005,-1000005,1000006,2000006,1000006,-1000006,1000011,        
     &2000011,1000011,-1000011,1000012,2000012,1000012,-1000012,        
     &1000013,2000013,1000013,-1000013,1000014,2000014,1000014,         
     &-1000014,1000015,2000015,1000015,-1000015,1000016,2000016,        
     &1000016,-1000016,-1,-3,-5,-7,-11,-13,-15,-17,24,2*1000022,        
     &2*1000023,2*1000025,2*1000035,1000006,2000006,1000006,2000006,    
     &-1000001,-1000003,-1000011,-1000013,-1000015,-2000015,5,6,21,2,1, 
     &2,3,4,5,6,11,13,15,4,5,11,13,15,2*4,-11,-13,-15,2*24,2*52,1,2,3,  
     &4,5,6,7,8,11,12,13,14,15,16,17,18,2*24,2*52,4*-1,4*-3,4*-5,4*-7,  
     &-11,-13,-15,-17,22,23,1,2,3,4,5,6,7,8,11,12,13,14,15,16,17,18,82/ 
      data (kfdp(i,1),i= 607, 956)/-11,-13,2*2,-12,-14,-16,2*-2,2*-4,   
     &-2,-4,2*22,-13,-11,211,111,221,13,11,2*211,221,321,221,321,213,   
     &-213,113,2*213,-213,221,223,321,130,310,111,331,213,113,221,223,  
     &321,211,331,2*223,213,-213,10220,213,113,10220,225,213,-213,      
     &30221,321,-321,221,225,213,113,30221,321,-311,221,3*211,221,223,  
     &333,3*211,221,223,333,113,213,211,111,-211,22,111,211,2*22,211,   
     &22,111,211,22,211,221,111,11,211,111,2*211,321,130,310,221,111,   
     &211,111,3*22,111,321,130,-213,113,213,211,22,111,11,13,211,321,   
     &130,310,221,211,111,211,111,321,130,310,213,113,-213,211,111,321, 
     &130,310,2*211,313,-313,323,-323,10111,10211,-10211,221,10211,     
     &10111,-10211,2*221,213,2*113,-213,2*321,2*311,113,313,-313,323,   
     &-323,211,111,-321,130,310,213,-213,113,321,-321,323,-323,213,     
     &-213,113,111,211,-12,12,-14,14,211,111,22,211,111,130,310,-13,    
     &3*211,12,14,321,3*311,3*321,311,323,313,2*311,321,313,323,2*321,  
     &311,323,313,323,313,321,4*311,321,313,323,313,323,311,5*321,      
     &2*311,321,323,2*313,2*323,313,321,311,321,311,313,323,311,321,    
     &311,2*321,311,321,311,323,313,311,321,311,321,313,323,321,311,    
     &323,313,321,2*311,325,315,311,321,313,323,311,2*321,315,2*325,    
     &315,323,313,3*311,315,325,313,323,3*321,325,315,323,313,3*311,    
     &315,325,313,323,3*321,11*-11,11*-13,-311,-313,-311,-313,-20313/   
      data (kfdp(i,1),i= 957,1368)/2*-311,-313,-311,-313,2*111,2*221,   
     &2*331,2*113,2*223,2*333,-311,-313,2*-321,211,-311,-321,333,-311,  
     &-313,-321,211,2*-321,2*-311,-321,211,113,421,2*411,421,411,423,   
     &413,423,413,421,411,8*-11,8*-13,-321,-323,-321,-323,-311,2*-313,  
     &-311,-313,2*-311,-321,-10323,-321,-323,-321,-311,2*-313,211,111,  
     &333,3*-321,-311,-313,-321,-313,310,333,211,2*-321,-311,-313,-311, 
     &211,-321,3*-311,211,113,321,2*421,411,421,413,423,413,423,411,    
     &421,-15,5*-11,5*-13,221,331,333,221,331,333,10221,211,213,211,    
     &213,321,323,321,323,2212,221,331,333,221,2*2,2*431,421,411,423,   
     &413,82,11,13,82,443,82,421,411,423,413,411,421,413,423,411,421,   
     &423,413,443,2*82,423,2*413,2*423,413,443,82,11,13,82,4*443,10441, 
     &20443,445,441,6*12,6*14,2*16,3*-411,3*-413,2*-411,2*-413,2*441,   
     &2*443,2*20443,2*2,2*4,2,4,511,521,511,523,513,523,513,521,511,    
     &6*12,6*14,2*16,3*-421,3*-423,2*-421,2*-423,2*441,2*443,2*20443,   
     &2*2,2*4,2,4,521,511,521,513,523,513,523,511,521,6*12,6*14,2*16,   
     &3*-431,3*-433,2*-431,2*-433,3*441,3*443,3*20443,2*2,2*4,2,4,531,  
     &521,511,523,513,16,2*4,2*12,2*14,2*16,4*2,4*4,2*-11,2*-13,2*-1,   
     &2*-3,2*-11,2*-13,2*-1,541,511,521,513,523,21,11,13,15,1,2,3,4,21, 
     &22,553,21,521,511,523,513,511,521,513,523,521,511,523,513,511,    
     &521,513,523,553,2*21,523,2*513,2*523,2*513,523,553,21,11,13,15,1/ 
      data (kfdp(i,1),i=1369,1633)/2,3,4,21,22,2*553,10551,20553,555,   
     &2*2112,2212,1114,2114,2214,2112,3*2212,2112,2224,2214,2114,2212,  
     &3*2112,2212,1114,2114,2214,2112,2212,2112,2*2212,2112,2224,2214,  
     &2114,2212,2112,2212,2*2112,2212,1114,2114,2214,2112,2212,2112,    
     &2*2212,2112,2224,2214,2114,2212,2112,2212,2*2112,2212,1114,2114,  
     &2214,2112,2212,2112,3122,2*2212,2112,2224,2214,2114,2212,2112,    
     &2212,3122,2*2112,2212,1114,2114,2214,2112,2212,2112,3122,2*2212,  
     &2112,2224,2214,2114,2212,2112,2212,3122,2*2112,2212,1114,2114,    
     &2214,2112,3*2212,2112,2224,2214,2114,2212,3*2112,2212,1114,2114,  
     &2214,2112,2212,3122,2*2212,2112,2224,2214,2114,2212,2112,3122,    
     &2*2112,2212,1114,2114,2214,2112,2212,2112,3122,3212,3112,2*2212,  
     &2112,2224,2214,2114,2212,2112,2212,3122,3212,3222,2*2112,2212,    
     &1114,2114,2214,2112,2212,2112,3122,3212,3112,2112,2*2212,2112,    
     &2224,2214,2114,2212,2112,2212,3122,3212,3222,2212,2*2112,2212,    
     &1114,2114,2214,2112,2212,2112,3122,3212,3112,2*2112,2*2212,2112,  
     &2224,2214,2114,2212,2112,2212,3122,3212,3222,2*2212,2112,2212,    
     &2*2112,2212,2112,2*2212,12112,2112,1114,2114,2112,12112,12212,    
     &2112,2212,2114,2214,1114,2112,2212,12212,12112,2212,2112,2214,    
     &2114,2224,2212,2112,12212,2212,2224,2214,2212,12112,2112,1114,    
     &2114,2112,12112,12212,2112,2212,2114,2214,1114,2112,2212,12212/   
      data (kfdp(i,1),i=1634,1879)/12112,2212,2112,2214,2114,2224,2212, 
     &2112,12212,2212,2224,2214,2212,2112,1114,2114,2112,3112,2112,     
     &2212,2114,2214,1114,2112,2212,3212,3112,2212,2112,2214,2114,2224, 
     &2212,2112,3212,3222,2212,2224,2214,2212,3222,12112,2112,1114,     
     &2114,2112,12112,12212,2112,2212,2114,2214,1114,2112,2212,12212,   
     &12112,2212,2112,2214,2114,2224,2212,2112,12212,2212,2224,2214,    
     &2212,2112,1114,2114,2112,3112,2112,2212,2114,2214,1114,2112,2212, 
     &3212,3112,2212,2112,2214,2114,2224,2212,2112,3212,3222,2212,2224, 
     &2214,2212,3222,12112,2112,1114,2114,2112,12112,12212,2112,2212,   
     &2114,2214,1114,2112,2212,12212,12112,2212,2112,2214,2114,2224,    
     &2212,2112,12212,2212,2224,2214,2212,12112,2112,1114,2114,3112,    
     &12112,12212,2112,2212,2114,2214,1114,3212,3112,12212,12112,2212,  
     &2112,2214,2114,2224,3212,3222,12212,2212,2224,2214,3222,3*2112,   
     &2212,2112,2*2212,2112,2212,2112,2*2212,12116,2112,1114,2114,2112, 
     &3112,12116,12216,2112,2212,2114,2214,1114,2112,2212,3212,3112,    
     &12216,12116,2212,2112,2214,2114,2224,2212,2112,3212,3222,12216,   
     &2212,2224,2214,2212,3222,2212,2*2112,-12,3212,3222,3112,2112,     
     &2212,3212,3222,3112,3214,3224,3114,2112,2212,3212,3222,3112,3214, 
     &3224,3114,2112,2212,3212,3222,3112,3122,3214,3224,3114,2112,2212, 
     &3212,3222,3112,3122,3214,3224,3114,2112,2212,3212,3222,3112,3214/ 
      data (kfdp(i,1),i=1880,2129)/3224,3114,2112,2212,2112,2212,3212,  
     &3222,3112,3214,3224,3114,2112,2212,2112,2212,3212,3222,3112,3122, 
     &3214,3224,3114,2112,2212,2112,2212,3212,3222,3112,3122,3214,3224, 
     &3114,2112,2212,3212,3222,3112,3214,3224,3114,3122,2112,2212,2112, 
     &2212,3212,3222,3112,3122,3322,3312,3214,3224,3114,3122,2112,2212, 
     &2112,2212,3212,3222,3112,3214,3224,3114,3122,2112,2212,2112,-12,  
     &3122,2212,2112,2212,3122,3212,3112,3122,3222,3112,3122,3222,3212, 
     &2112,3122,3212,3112,1114,2114,3314,2112,2212,3122,3222,3112,2114, 
     &2214,3324,3314,2212,3122,3222,3212,2224,2214,3324,2112,3122,3212, 
     &3112,3214,13122,3124,2112,2212,3122,3222,3112,3224,3114,13122,    
     &3124,2212,3122,3222,3212,3224,13122,3124,2112,3122,3212,2*3112,   
     &3124,1114,2114,2112,2212,3122,3222,3112,3212,3124,2114,2214,2212, 
     &3122,3222,3212,3222,3124,2224,2214,2112,3122,3212,3112,3214,3124, 
     &2112,2212,3122,3222,3112,3224,3114,3124,2212,3122,3222,3212,3224, 
     &3124,2112,3122,3212,2*3112,3312,3214,1114,2114,3314,2112,2212,    
     &3122,3222,3112,3212,3322,3312,3224,3114,2114,2214,3324,3314,2212, 
     &3122,3222,3212,3222,3322,3224,2224,2214,3324,2112,3122,3212,      
     &2*3112,3214,13122,1114,2114,3314,2112,2212,3122,3222,3112,3212,   
     &3224,3114,13122,2114,2214,3324,3314,2212,3122,3222,3212,3222,     
     &3224,13122,2224,2214,3324,2112,3122,3212,3112,3312,3214,3124/     
      data (kfdp(i,1),i=2130,2504)/1114,2114,3314,2112,2212,3122,3222,  
     &3112,3322,3312,3224,3114,3124,2114,2214,3324,3314,2212,3122,3222, 
     &3212,3322,3224,3124,2224,2214,3324,3122,3112,-12,-14,-12,2*3122,  
     &3212,3322,3312,3322,2*3312,3322,3122,3212,3112,3314,3324,3322,    
     &3312,3122,3212,3222,3324,3314,3312,3322,3122,3212,3112,3314,3324, 
     &3322,3312,3122,3212,3222,3324,3314,3312,3322,3122,3212,3112,3314, 
     &3324,3322,3312,3122,3212,3222,3324,3314,3122,3212,3112,3122,3212, 
     &3222,3122,3322,3312,-12,2*4122,7*-11,7*-13,2*2224,2*2212,2*2214,  
     &2*3122,2*3212,2*3214,5*3222,4*3224,2*3322,3324,2*2224,7*2212,     
     &5*2214,2*2112,2*2114,2*3122,2*3212,2*3214,2*3222,2*3224,4*2,3,    
     &2*2,1,2*2,-11,-13,2*2,4*4122,-11,-13,2*2,3*4132,3*4232,-11,-13,   
     &2*2,4332,-11,-13,2*2,-11,-13,2*2,-11,-13,2*2,-11,-13,2*2,-11,-13, 
     &2*2,-11,-13,2*2,-11,-13,2*2,2*5122,-12,-14,-16,5*4122,441,443,    
     &20443,2*-2,2*-4,-2,-4,-12,-14,-16,2*-2,2*-4,-2,-4,-12,-14,-16,    
     &2*-2,2*-4,-2,-4,4*5122,-12,-14,-16,2*-2,2*-4,-2,-4,-12,-14,-16,   
     &2*-2,2*-4,-2,-4,2*5132,2*5232,-12,-14,-16,2*-2,2*-4,-2,-4,5332,   
     &-12,-14,-16,2*-2,2*-4,-2,-4,-12,-14,-16,2*-2,2*-4,-2,-4,-12,-14,  
     &-16,2*-2,2*-4,-2,-4,-12,-14,-16,2*-2,2*-4,-2,-4,-12,-14,-16,2*-2, 
     &2*-4,-2,-4,-12,-14,-16,2*-2,2*-4,-2,-4,-12,-14,-16,2*-2,2*-4,-2,  
     &-4,-12,-14,-16,2*-2,2*-4,-2,-4,-12,-14,-16,2*-2,2*-4,-2,-4,-12/   
      data (kfdp(i,1),i=2505,2704)/-14,-16,2*-2,2*-4,-2,-4,-12,-14,-16, 
     &2*-2,2*-4,-2,-4,-12,-14,-16,2*-2,2*-4,-2,-4,-12,-14,-16,2*-2,     
     &2*-4,-2,-4,-12,-14,-16,2*-2,2*-4,-2,-4,-12,-14,-16,2*-2,2*-4,-2,  
     &-4,-12,-14,-16,2*-2,2*-4,-2,-4,-12,-14,-16,2*-2,2*-4,-2,-4,-12,   
     &-14,-16,2*-2,2*-4,-2,-4,1000039,-1000024,-1000037,1000022,        
     &1000023,1000025,1000035,1000002,2000002,1000002,2000002,1000021,  
     &1000039,1000024,1000037,1000022,1000023,1000025,1000035,1000001,  
     &2000001,1000001,2000001,1000021,1000039,-1000024,-1000037,        
     &1000022,1000023,1000025,1000035,1000004,2000004,1000004,2000004,  
     &1000021,1000039,1000024,1000037,1000022,1000023,1000025,1000035,  
     &1000003,2000003,1000003,2000003,1000021,1000039,-1000024,         
     &-1000037,1000022,1000023,1000025,1000035,1000006,2000006,1000006, 
     &2000006,1000021,1000039,1000024,1000037,1000022,1000023,1000025,  
     &1000035,1000005,2000005,1000005,2000005,1000021,1000022,1000039,  
     &-1000024,-1000037,1000022,1000023,1000025,1000035,1000012,        
     &2000012,1000012,2000012,1000039,1000024,1000037,1000022,1000023,  
     &1000025,1000035,1000011,2000011,1000011,2000011,1000039,-1000024, 
     &-1000037,1000022,1000023,1000025,1000035,1000014,2000014,1000014, 
     &2000014,1000039,1000024,1000037,1000022,1000023,1000025,1000035,  
     &1000013,2000013,1000013,2000013,1000039,-1000024,-1000037/        
      data (kfdp(i,1),i=2705,2886)/1000022,1000023,1000025,1000035,     
     &1000016,2000016,1000016,2000016,1000039,1000024,1000037,1000022,  
     &1000023,1000025,1000035,1000015,2000015,1000015,2000015,1000039,  
     &1000001,-1000001,2000001,-2000001,1000002,-1000002,2000002,       
     &-2000002,1000003,-1000003,2000003,-2000003,1000004,-1000004,      
     &2000004,-2000004,1000005,-1000005,2000005,-2000005,1000006,       
     &-1000006,2000006,-2000006,6*1000022,6*1000023,6*1000025,          
     &6*1000035,1000024,-1000024,1000024,-1000024,1000024,-1000024,     
     &1000037,-1000037,1000037,-1000037,1000037,-1000037,10*1000039,    
     &16*1000022,1000024,-1000024,1000024,-1000024,1000024,-1000024,    
     &1000024,-1000024,1000024,-1000024,1000024,-1000024,1000037,       
     &-1000037,1000037,-1000037,1000037,-1000037,1000037,-1000037,      
     &1000037,-1000037,1000037,-1000037,1000024,-1000024,1000037,       
     &-1000037,1000001,-1000001,2000001,-2000001,1000002,-1000002,      
     &2000002,-2000002,1000003,-1000003,2000003,-2000003,1000004,       
     &-1000004,2000004,-2000004,1000005,-1000005,2000005,-2000005,      
     &1000006,-1000006,2000006,-2000006,1000011,-1000011,2000011,       
     &-2000011,1000012,-1000012,2000012,-2000012,1000013,-1000013,      
     &2000013,-2000013,1000014,-1000014,2000014,-2000014,1000015,       
     &-1000015,2000015,-2000015,1000016,-1000016,2000016,-2000016/      
      data (kfdp(i,1),i=2887,3133)/5*1000021,2*1000039,6*1000022,       
     &6*1000023,6*1000025,6*1000035,1000022,1000023,1000025,1000035,    
     &1000002,2000002,-1000001,-2000001,1000004,2000004,-1000003,       
     &-2000003,1000006,2000006,-1000005,-2000005,1000012,2000012,       
     &-1000011,-2000011,1000014,2000014,-1000013,-2000013,1000016,      
     &2000016,-1000015,-2000015,2*1000021,5*1000039,16*1000022,         
     &16*1000023,1000024,-1000024,1000024,-1000024,1000024,-1000024,    
     &1000024,-1000024,1000024,-1000024,1000024,-1000024,1000037,       
     &-1000037,1000037,-1000037,1000037,-1000037,1000037,-1000037,      
     &1000037,-1000037,1000037,-1000037,1000024,-1000024,1000037,       
     &-1000037,1000001,-1000001,2000001,-2000001,1000002,-1000002,      
     &2000002,-2000002,1000003,-1000003,2000003,-2000003,1000004,       
     &-1000004,2000004,-2000004,1000005,-1000005,2000005,-2000005,      
     &1000006,-1000006,2000006,-2000006,1000011,-1000011,2000011,       
     &-2000011,1000012,-1000012,2000012,-2000012,1000013,-1000013,      
     &2000013,-2000013,1000014,-1000014,2000014,-2000014,1000015,       
     &-1000015,2000015,-2000015,1000016,-1000016,2000016,-2000016,      
     &5*1000021,5*1000039,16*1000022,16*1000023,16*1000025,1000024,     
     &-1000024,1000024,-1000024,1000024,-1000024,1000024,-1000024,      
     &1000024,-1000024,1000024,-1000024,1000037,-1000037,1000037/       
      data (kfdp(i,1),i=3134,3319)/-1000037,1000037,-1000037,1000037,   
     &-1000037,1000037,-1000037,1000037,-1000037,1000024,-1000024,      
     &1000037,-1000037,1000001,-1000001,2000001,-2000001,1000002,       
     &-1000002,2000002,-2000002,1000003,-1000003,2000003,-2000003,      
     &1000004,-1000004,2000004,-2000004,1000005,-1000005,2000005,       
     &-2000005,1000006,-1000006,2000006,-2000006,1000011,-1000011,      
     &2000011,-2000011,1000012,-1000012,2000012,-2000012,1000013,       
     &-1000013,2000013,-2000013,1000014,-1000014,2000014,-2000014,      
     &1000015,-1000015,2000015,-2000015,1000016,-1000016,2000016,       
     &-2000016,5*1000021,2*1000039,15*1000024,6*1000022,6*1000023,      
     &6*1000025,6*1000035,1000022,1000023,1000025,1000035,1000002,      
     &2000002,-1000001,-2000001,1000004,2000004,-1000003,-2000003,      
     &1000006,2000006,-1000005,-2000005,1000012,2000012,-1000011,       
     &-2000011,1000014,2000014,-1000013,-2000013,1000016,2000016,       
     &-1000015,-2000015,2*1000021,1000039,-1000024,-1000037,1000022,    
     &1000023,1000025,1000035,4*1000001,1000002,2000002,1000002,        
     &2000002,1000021,1000039,1000024,1000037,1000022,1000023,1000025,  
     &1000035,4*1000002,1000001,2000001,1000001,2000001,1000021,        
     &1000039,-1000024,-1000037,1000022,1000023,1000025,1000035,        
     &4*1000003,1000004,2000004,1000004,2000004,1000021,1000039/        
      data (kfdp(i,1),i=3320,4000)/1000024,1000037,1000022,1000023,     
     &1000025,1000035,4*1000004,1000003,2000003,1000003,2000003,        
     &1000021,1000039,-1000024,-1000037,1000022,1000023,1000025,        
     &1000035,4*1000005,1000006,2000006,1000006,2000006,1000021,        
     &1000039,1000024,1000037,1000022,1000023,1000025,1000035,          
     &4*1000006,1000005,2000005,1000005,2000005,1000021,1000039,        
     &-1000024,-1000037,1000022,1000023,1000025,1000035,4*1000011,      
     &1000012,2000012,1000012,2000012,1000039,-1000024,-1000037,        
     &1000022,1000023,1000025,1000035,4*1000013,1000014,2000014,        
     &1000014,2000014,1000039,-1000024,-1000037,1000022,1000023,        
     &1000025,1000035,4*1000015,1000016,2000016,1000016,2000016,21,22,  
     &23,-24,21,22,23,24,22,23,-24,23,24,576*0/                         
      data (kfdp(i,2),i=   1, 337)/3*1,2,4,6,8,1,3*2,1,3,5,7,2,3*3,2,4, 
     &6,8,3,3*4,1,3,5,7,4,3*5,2,4,6,8,5,3*6,1,3,5,7,6,5,4*1000006,3*7,  
     &2,4,6,8,7,4,6,3*8,1,3,5,7,8,5,7,2*11,12,11,12,2*11,2*13,14,13,14, 
     &13,11,13,-211,-213,-211,-213,-211,-213,-211,-213,2*-211,-321,     
     &-323,-321,2*-323,3*-321,4*-211,-213,-211,-213,-211,-213,-211,     
     &-213,-211,-213,3*-211,-213,4*-211,-323,-321,2*-211,2*-321,3*-211, 
     &2*15,16,15,16,15,2*17,18,17,2*18,2*17,-1,-2,-3,-4,-5,-6,-7,-8,21, 
     &-1,-2,-3,-4,-5,-6,-7,-8,-11,-13,-15,-17,-1,-2,-3,-4,-5,-6,-7,-8,  
     &-11,-12,-13,-14,-15,-16,-17,-18,2,4,6,8,2,4,6,8,2,4,6,8,2,4,6,8,  
     &12,14,16,18,-1,-2,-3,-4,-5,-6,-7,-8,-11,-13,-15,-17,21,22,2*23,   
     &-24,2*1000022,1000023,1000022,1000023,1000025,1000022,1000023,    
     &1000025,1000035,-1000024,-1000037,-1000024,-1000037,-1000001,     
     &2*-2000001,2000001,-1000002,2*-2000002,2000002,-1000003,          
     &2*-2000003,2000003,-1000004,2*-2000004,2000004,-1000005,          
     &2*-2000005,2000005,-1000006,2*-2000006,2000006,-1000011,          
     &2*-2000011,2000011,-1000012,2*-2000012,2000012,-1000013,          
     &2*-2000013,2000013,-1000014,2*-2000014,2000014,-1000015,          
     &2*-2000015,2000015,-1000016,2*-2000016,2000016,-1,-2,-3,-4,-5,-6, 
     &-7,-8,-11,-12,-13,-14,-15,-16,-17,-18,-24,-37,22,25,2*36,2,4,6,8, 
     &2,4,6,8,2,4,6,8,2,4,6,8,12,14,16,18,23,22,25,-1,-2,-3,-4,-5,-6/   
      data (kfdp(i,2),i= 338, 524)/-7,-8,-11,-13,-15,-17,21,22,2*23,    
     &-24,2*25,36,2*1000022,1000023,1000022,1000023,1000025,1000022,    
     &1000023,1000025,1000035,-1000024,-1000037,-1000024,-1000037,      
     &-1000001,2*-2000001,2000001,-1000002,2*-2000002,2000002,-1000003, 
     &2*-2000003,2000003,-1000004,2*-2000004,2000004,-1000005,          
     &2*-2000005,2000005,-1000006,2*-2000006,2000006,-1000011,          
     &2*-2000011,2000011,-1000012,2*-2000012,2000012,-1000013,          
     &2*-2000013,2000013,-1000014,2*-2000014,2000014,-1000015,          
     &2*-2000015,2000015,-1000016,2*-2000016,2000016,-1,-2,-3,-4,-5,-6, 
     &-7,-8,-11,-13,-15,-17,21,22,2*23,-24,25,2*1000022,1000023,        
     &1000022,1000023,1000025,1000022,1000023,1000025,1000035,-1000024, 
     &-1000037,-1000024,-1000037,-1000001,2*-2000001,2000001,-1000002,  
     &2*-2000002,2000002,-1000003,2*-2000003,2000003,-1000004,          
     &2*-2000004,2000004,-1000005,2*-2000005,2000005,-1000006,          
     &2*-2000006,2000006,-1000011,2*-2000011,2000011,-1000012,          
     &2*-2000012,2000012,-1000013,2*-2000013,2000013,-1000014,          
     &2*-2000014,2000014,-1000015,2*-2000015,2000015,-1000016,          
     &2*-2000016,2000016,2,4,6,8,12,14,16,18,25,1000024,1000037,        
     &1000024,1000037,1000024,1000037,1000024,1000037,2*-1000005,       
     &2*-2000005,1000002,1000004,1000012,1000014,2*1000016,-5,-6,21,11/ 
      data (kfdp(i,2),i= 525, 860)/-3,-4,-5,-6,-7,-8,-13,-15,-17,-4,-5, 
     &-11,-13,-15,-5,-3,12,14,16,-24,-52,-24,-52,-1,-2,-3,-4,-5,-6,-7,  
     &-8,-11,-12,-13,-14,-15,-16,-17,-18,23,51,23,51,2,4,6,8,2,4,6,8,2, 
     &4,6,8,2,4,6,8,12,14,16,18,2*51,-1,-2,-3,-4,-5,-6,-7,-8,-11,-12,   
     &-13,-14,-15,-16,-17,-18,-82,12,14,-1,-3,11,13,15,1,4,3,4,1,3,22,  
     &11,14,12,-211,2*22,-13,-11,111,22,111,-321,211,-311,-211,2*211,   
     &111,-211,211,111,211,-321,130,310,22,2*111,3*211,-311,22,211,111, 
     &211,-211,211,2*111,2*211,111,-211,211,111,-323,323,111,211,111,   
     &2*211,-313,323,211,3*-211,113,4*111,-211,213,2*211,-211,111,-211, 
     &111,211,22,111,-211,211,11,-211,13,22,-211,111,-211,22,111,-11,   
     &-211,111,2*-211,-321,130,310,221,111,-211,111,113,223,22,111,     
     &-321,310,211,111,2*-211,221,22,-11,-13,-211,-321,130,310,221,     
     &-211,111,-211,111,-321,130,310,-211,111,211,-211,111,-321,130,    
     &310,2*-211,-311,311,-321,321,111,-211,211,113,-211,111,2*211,111, 
     &-211,211,111,211,-321,2*-311,-321,22,-311,311,-321,321,-211,111,  
     &321,130,310,-211,211,111,-323,323,-321,321,-211,211,2*111,-211,   
     &11,-11,13,-13,-211,111,22,-211,111,2*0,14,111,211,111,-11,-13,    
     &-211,111,22,211,111,22,-213,113,-211,111,223,213,113,211,111,223, 
     &-211,111,-211,111,-211,211,-213,113,223,221,211,111,211,111,      
     &2*211,213,113,223,221,22,-211,111,211,111,-211,111,211,111,-211/  
      data (kfdp(i,2),i= 861,1266)/111,-211,111,-213,113,211,111,211,   
     &111,213,113,-211,111,-213,113,-211,111,211,111,213,113,211,111,   
     &-213,113,-211,111,-211,111,221,-211,111,213,113,211,111,211,111,  
     &221,211,111,-211,111,-211,111,225,333,223,211,111,211,111,225,    
     &333,223,-211,111,-211,111,225,333,223,211,111,211,111,225,333,    
     &223,11*12,11*14,2*211,2*213,211,20213,2*321,2*323,211,213,211,    
     &213,211,213,211,213,211,213,211,213,3*211,213,211,2*321,8*211,    
     &2*113,3*211,111,22,211,111,211,111,4*211,8*12,8*14,2*211,2*213,   
     &2*111,221,2*113,223,333,20213,211,2*321,323,2*311,313,-211,111,   
     &113,2*211,321,2*211,311,321,310,211,-211,4*211,321,4*211,113,     
     &2*211,-321,111,22,-211,111,-211,111,-211,211,-211,211,16,5*12,    
     &5*14,3*211,3*213,211,2*111,2*113,2*-311,2*-313,-2112,3*321,323,   
     &2*-1,22,111,321,311,321,311,-82,-11,-13,-82,22,-82,211,111,211,   
     &111,-211,111,-211,111,311,2*321,311,22,2*-82,211,111,-211,111,    
     &321,311,22,-82,-11,-13,-82,211,111,221,111,4*22,6*-11,6*-13,      
     &2*-15,211,213,20213,211,213,20213,431,433,431,433,311,313,311,    
     &313,311,313,-1,-4,-3,-4,-1,-3,22,-211,111,-211,111,-211,211,-211, 
     &211,6*-11,6*-13,2*-15,211,213,20213,211,213,20213,431,433,431,    
     &433,321,323,321,323,321,323,-1,-4,-3,-4,-1,-3,22,211,111,211,111, 
     &4*211,6*-11,6*-13,2*-15,211,213,20213,211,213,20213,431,433,431/  
      data (kfdp(i,2),i=1267,1572)/433,221,331,333,221,331,333,221,331, 
     &333,-1,-4,-3,-4,-1,-3,22,-321,-311,-321,-311,-15,-3,-1,2*-11,     
     &2*-13,2*-15,-1,-4,-3,-4,-3,-4,-1,-4,2*12,2*14,2,3,2,3,2*12,2*14,  
     &2,1,22,411,421,411,421,21,-11,-13,-15,-1,-2,-3,-4,2*21,22,21,     
     &-211,111,-211,111,211,111,211,111,-321,-311,-321,-311,411,421,    
     &411,421,22,2*21,-211,111,211,111,-321,-311,411,421,22,21,-11,-13, 
     &-15,-1,-2,-3,-4,2*21,211,111,3*22,10220,111,-211,211,111,-211,    
     &113,-213,10220,111,211,-211,111,211,113,213,10220,111,-211,211,   
     &111,-211,113,-213,221,10220,111,211,-211,111,211,113,213,221,     
     &10220,111,-211,211,111,-211,113,-213,221,10220,111,211,-211,111,  
     &211,113,213,221,10220,111,-211,211,111,-211,113,-213,221,311,     
     &10220,111,211,-211,111,211,113,213,221,321,10220,111,-211,211,    
     &111,-211,113,-213,221,311,10220,111,211,-211,111,211,113,213,221, 
     &321,10220,111,-211,211,111,-211,113,-213,10220,111,211,-211,111,  
     &211,113,213,10220,111,-211,211,111,-211,113,-213,311,10220,111,   
     &211,-211,111,211,113,213,321,10220,111,-211,211,111,-211,113,     
     &-213,221,2*311,321,10220,111,211,-211,111,211,113,213,221,2*321,  
     &311,10220,111,-211,211,111,-211,113,-213,221,2*311,321,223,10220, 
     &111,211,-211,111,211,113,213,221,2*321,311,223,10220,111,-211,    
     &211,111,-211,113,-213,221,2*311,321,223,331,10220,111,211,-211/   
      data (kfdp(i,2),i=1573,1870)/111,211,113,213,221,2*321,311,223,   
     &331,2*-211,111,22,111,211,22,211,2*-211,111,-211,-213,111,-211,   
     &111,-211,111,-211,211,113,-213,111,211,111,211,111,211,-211,113,  
     &213,2*211,111,211,213,2*-211,111,-211,-213,111,-211,111,-211,111, 
     &-211,211,113,-213,111,211,111,211,111,211,-211,113,213,2*211,111, 
     &211,213,-211,111,-211,-213,311,111,-211,111,-211,211,113,-213,    
     &311,321,111,211,111,211,-211,113,213,321,311,211,111,211,213,321, 
     &2*-211,111,-211,-213,111,-211,111,-211,111,-211,211,113,-213,111, 
     &211,111,211,111,211,-211,113,213,2*211,111,211,213,-211,111,-211, 
     &-213,311,111,-211,111,-211,211,113,-213,311,321,111,211,111,211,  
     &-211,113,213,321,311,211,111,211,213,321,2*-211,111,-211,-213,    
     &111,-211,111,-211,111,-211,211,113,-213,111,211,111,211,111,211,  
     &-211,113,213,2*211,111,211,213,2*-211,111,-211,311,111,-211,111,  
     &-211,111,-211,211,311,321,111,211,111,211,111,211,-211,321,311,   
     &2*211,111,211,321,-211,-213,111,-211,113,-213,111,211,113,213,    
     &211,213,2*-211,111,-211,-213,311,111,-211,111,-211,111,-211,211,  
     &113,-213,311,321,111,211,111,211,111,211,-211,113,213,321,311,    
     &2*211,111,211,213,321,-211,111,22,11,111,-211,211,-311,-321,111,  
     &-211,211,111,-211,211,-311,-321,111,-211,211,111,-211,211,-311,   
     &-321,111,-211,211,221,111,-211,211,-311,-321,111,-211,211,221/    
      data (kfdp(i,2),i=1871,2156)/111,-211,211,-311,-321,111,-211,211, 
     &111,-211,211,-313,-323,-311,-321,111,-211,211,111,-211,211,-313,  
     &-323,-311,-321,111,-211,211,221,111,-211,211,-313,-323,-311,-321, 
     &111,-211,211,221,111,-211,211,-311,-321,111,-211,211,111,-211,    
     &211,223,-313,-323,-311,-321,111,-211,211,221,311,321,111,-211,    
     &211,223,-313,-323,-311,-321,111,-211,211,111,-211,211,223,-313,   
     &-323,-211,11,22,111,211,22,2*-211,2*111,-211,2*211,111,211,-321,  
     &2*-211,111,-311,-321,311,-311,-321,111,-211,211,-311,-321,311,    
     &321,-311,211,111,211,-321,-311,321,-321,2*-211,111,3*-211,-311,   
     &-321,111,-211,211,-211,211,2*111,-311,211,111,211,111,2*211,-321, 
     &2*-211,111,221,-211,-311,-321,-311,-321,111,-211,211,221,111,     
     &-311,-321,-311,211,111,211,221,211,-321,-311,-321,2*-211,111,     
     &2*-211,-311,-321,111,-211,211,-211,211,111,-311,211,111,211,111,  
     &211,-321,2*-211,111,221,311,-211,-311,-321,311,-311,-321,111,     
     &-211,211,221,311,321,-211,211,-311,-321,311,321,-311,211,111,211, 
     &221,321,111,-321,-311,321,-321,2*-211,111,221,2*-211,-311,-321,   
     &311,-311,-321,111,-211,211,221,-211,211,111,-311,-321,311,321,    
     &-311,211,111,211,221,111,211,-321,-311,321,-321,2*-211,111,311,   
     &2*-211,-311,-321,311,-311,-321,111,-211,211,311,321,-211,211,111, 
     &-311,-321,311,321,-311,211,111,211,321,111,211,-321,-311,321/     
      data (kfdp(i,2),i=2157,2583)/-211,22,11,13,11,111,2*22,-211,      
     &2*111,211,111,-211,2*-321,-311,111,-211,111,211,2*-311,-321,111,  
     &211,111,-211,2*-321,-311,111,-211,111,211,2*-311,-321,111,211,    
     &111,-211,2*-321,-311,111,-211,111,211,2*-311,-321,111,211,2*-321, 
     &3*-311,2*-321,-211,111,11,2*-211,7*12,7*14,-321,-323,-311,-313,   
     &-311,-313,211,213,211,213,211,213,111,221,331,113,223,111,221,    
     &113,223,321,323,321,-211,-213,111,221,331,113,223,333,10221,111,  
     &221,331,113,223,211,213,211,213,321,323,321,323,321,323,311,313,  
     &311,313,2*-1,-3,-1,2203,3201,3203,2203,2101,2103,12,14,-1,-3,     
     &2*111,2*211,12,14,-1,-3,22,111,2*22,111,22,12,14,-1,-3,22,12,14,  
     &-1,-3,12,14,-1,-3,12,14,-1,-3,12,14,-1,-3,12,14,-1,-3,12,14,-1,   
     &-3,12,14,-1,-3,2*-211,11,13,15,-211,-213,-20213,-431,-433,3*3122, 
     &1,4,3,4,1,3,11,13,15,1,4,3,4,1,3,11,13,15,1,4,3,4,1,3,2*111,      
     &2*211,11,13,15,1,4,3,4,1,3,11,13,15,1,4,3,4,1,3,4*22,11,13,15,1,  
     &4,3,4,1,3,22,11,13,15,1,4,3,4,1,3,11,13,15,1,4,3,4,1,3,11,13,15,  
     &1,4,3,4,1,3,11,13,15,1,4,3,4,1,3,11,13,15,1,4,3,4,1,3,11,13,15,1, 
     &4,3,4,1,3,11,13,15,1,4,3,4,1,3,11,13,15,1,4,3,4,1,3,11,13,15,1,4, 
     &3,4,1,3,11,13,15,1,4,3,4,1,3,11,13,15,1,4,3,4,1,3,11,13,15,1,4,3, 
     &4,1,3,11,13,15,1,4,3,4,1,3,11,13,15,1,4,3,4,1,3,11,13,15,1,4,3,4, 
     &1,3,11,13,15,1,4,3,4,1,3,11,13,15,1,4,3,4,1,3,11,13,15,1,4,3,4,1/ 
      data (kfdp(i,2),i=2584,3059)/3,1,2*2,4*1,2*-24,2*-37,1,2,2*1,4*2, 
     &2*24,2*37,2,3,2*4,4*3,2*-24,2*-37,3,4,2*3,4*4,2*24,2*37,4,5,2*6,  
     &4*5,2*-24,2*-37,5,6,2*5,4*6,2*24,2*37,6,4,11,2*12,4*11,2*-24,     
     &2*-37,12,2*11,4*12,2*24,2*37,13,2*14,4*13,2*-24,2*-37,14,2*13,    
     &4*14,2*24,2*37,15,2*16,4*15,2*-24,2*-37,16,2*15,4*16,2*24,2*37,   
     &21,-1,1,-1,1,-2,2,-2,2,-3,3,-3,3,-4,4,-4,4,-5,5,-5,5,-6,6,-6,6,1, 
     &3,5,2,4,6,1,3,5,2,4,6,1,3,5,2,4,6,1,3,5,2,4,6,1,-1,3,-3,5,-5,1,   
     &-1,3,-3,5,-5,22,23,25,35,36,22,23,25,35,36,22,23,11,13,15,12,14,  
     &16,1,3,5,2,4,25,35,36,-24,24,11,-11,13,-13,15,-15,1,-1,3,-3,-24,  
     &24,11,-11,13,-13,15,-15,1,-1,3,-3,-37,37,-37,37,-1,1,-1,1,-2,2,   
     &-2,2,-3,3,-3,3,-4,4,-4,4,-5,5,-5,5,-6,6,-6,6,-11,11,-11,11,-12,   
     &12,-12,12,-13,13,-13,13,-14,14,-14,14,-15,15,-15,15,-16,16,-16,   
     &16,1,3,5,2,4,24,37,24,-11,-13,-15,-1,-3,24,-11,-13,-15,-1,-3,24,  
     &-11,-13,-15,-1,-3,24,-11,-13,-15,-1,-3,4*37,2*-1,2*2,2*-3,2*4,    
     &2*-5,2*6,2*-11,2*12,2*-13,2*14,2*-15,2*16,-1,-3,22,23,25,35,36,   
     &22,23,11,13,15,12,14,16,1,3,5,2,4,25,35,36,22,23,11,13,15,12,14,  
     &16,1,3,5,2,4,25,35,36,-24,24,11,-11,13,-13,15,-15,1,-1,3,-3,-24,  
     &24,11,-11,13,-13,15,-15,1,-1,3,-3,-37,37,-37,37,-1,1,-1,1,-2,2,   
     &-2,2,-3,3,-3,3,-4,4,-4,4,-5,5,-5,5,-6,6,-6,6,-11,11,-11,11,-12,   
     &12,-12,12,-13,13,-13,13,-14,14,-14,14,-15,15,-15,15,-16,16,-16/   
      data (kfdp(i,2),i=3060,4000)/16,1,3,5,2,4,22,23,25,35,36,22,23,   
     &11,13,15,12,14,16,1,3,5,2,4,25,35,36,22,23,11,13,15,12,14,16,1,3, 
     &5,2,4,25,35,36,22,23,11,13,15,12,14,16,1,3,5,2,4,25,35,36,-24,24, 
     &11,-11,13,-13,15,-15,1,-1,3,-3,-24,24,11,-11,13,-13,15,-15,1,-1,  
     &3,-3,-37,37,-37,37,-1,1,-1,1,-2,2,-2,2,-3,3,-3,3,-4,4,-4,4,-5,5,  
     &-5,5,-6,6,-6,6,-11,11,-11,11,-12,12,-12,12,-13,13,-13,13,-14,14,  
     &-14,14,-15,15,-15,15,-16,16,-16,16,1,3,5,2,4,24,37,23,11,13,15,   
     &12,14,16,1,3,5,2,4,25,35,36,24,-11,-13,-15,-1,-3,24,-11,-13,-15,  
     &-1,-3,24,-11,-13,-15,-1,-3,24,-11,-13,-15,-1,-3,4*37,2*-1,2*2,    
     &2*-3,2*4,2*-5,2*6,2*-11,2*12,2*-13,2*14,2*-15,2*16,-1,-3,1,2*2,   
     &4*1,23,25,35,36,2*-24,2*-37,1,2,2*1,4*2,23,25,35,36,2*24,2*37,2,  
     &3,2*4,4*3,23,25,35,36,2*-24,2*-37,3,4,2*3,4*4,23,25,35,36,2*24,   
     &2*37,4,5,2*6,4*5,23,25,35,36,2*-24,2*-37,5,6,2*5,4*6,23,25,35,36, 
     &2*24,2*37,6,11,2*12,4*11,23,25,35,36,2*-24,2*-37,13,2*14,4*13,23, 
     &25,35,36,2*-24,2*-37,15,2*16,4*15,23,25,35,36,2*-24,2*-37,3*1,    
     &4*2,1,2*11,2*12,11,576*0/                                         
      data (kfdp(i,3),i=   1,1276)/79*0,14,6*0,2*16,2*0,6*111,310,130,  
     &2*0,3*111,310,130,321,113,211,223,221,2*113,2*211,2*223,2*221,    
     &2*113,221,2*113,2*213,-213,113,2*111,310,130,310,130,2*310,130,   
     &470*0,4*3,4*4,1,4,3,2*2,0,-11,20*0,-211,8*0,111,26*0,111,211,4*0, 
     &111,211,3*0,211,111,4*0,2*111,-211,-11,11,-13,22,111,3*0,22,3*0,  
     &111,211,4*0,111,2*221,3*0,111,5*0,111,24*0,211,111,11*0,-211,     
     &2*111,-211,3*111,-211,111,211,20*0,2*111,211,-211,211,-211,9*0,   
     &-211,3*111,20*0,111,-211,8*0,111,-211,83*0,-311,-313,-311,-321,   
     &-313,-323,111,221,331,113,223,-311,-313,-311,-321,-313,-323,111,  
     &221,331,113,223,22*0,111,113,2*211,-211,-311,211,111,3*211,-211,  
     &7*211,7*0,111,-211,111,-211,-321,-323,-311,-321,-313,-323,-211,   
     &-213,-321,-323,-311,-321,-313,-323,-211,-213,22*0,111,113,-311,   
     &2*-211,211,-211,310,-211,2*111,211,2*-211,-321,-211,2*211,-211,   
     &111,-211,2*211,6*0,111,-211,111,-211,0,221,331,333,321,311,221,   
     &331,333,321,311,20*0,3,39*0,-211,111,6*0,-411,-413,-10413,-10411, 
     &-20413,-415,-411,-413,-10413,-10411,-20413,-415,-411,-413,16*0,   
     &-4,-1,-4,-3,2*-2,5*0,111,-211,111,-211,-421,-423,-10423,-10421,   
     &-20423,-425,-421,-423,-10423,-10421,-20423,-425,-421,-423,16*0,   
     &-4,-1,-4,-3,2*-2,5*0,111,-211,111,-211,-431,-433,-10433,-10431,   
     &-20433,-435,-431,-433,-10433,-10431,-20433,-435,-431,-433,19*0/   
      data (kfdp(i,3),i=1277,3098)/-4,-1,-4,-3,2*-2,8*0,441,443,441,    
     &443,441,443,-4,-1,-4,-3,-4,-3,-4,-1,531,533,531,533,3,2,3,2,511,  
     &513,511,513,1,2,13*0,2*21,38*0,2*21,-211,111,460*0,2212,114*0,    
     &2112,207*0,2*3122,3212,58*0,3322,2*0,3122,3212,3214,2112,2114,    
     &2212,2112,3122,3212,3214,2112,2114,2212,2112,52*0,3*3,1,6*0,4*3,  
     &4*0,4*3,6*0,4*3,0,28*3,2*0,3*4122,8*0,4,1,4,3,2*2,4*4,1,4,3,2*2,  
     &4*4,1,4,3,2*2,4*0,4*4,1,4,3,2*2,4*4,1,4,3,2*2,4*0,4*4,1,4,3,2*2,  
     &0,4*4,1,4,3,2*2,4*4,1,4,3,2*2,4*4,1,4,3,2*2,4*4,1,4,3,2*2,4*4,1,  
     &4,3,2*2,4*4,1,4,3,2*2,4*4,1,4,3,2*2,4*4,1,4,3,2*2,4*4,1,4,3,2*2,  
     &4*4,1,4,3,2*2,4*4,1,4,3,2*2,4*4,1,4,3,2*2,4*4,1,4,3,2*2,4*4,1,4,  
     &3,2*2,4*4,1,4,3,2*2,4*4,1,4,3,2*2,4*4,1,4,3,2*2,4*4,1,4,3,2*2,    
     &164*0,-1,-3,-5,-2,-4,-6,-1,-3,-5,-2,-4,-6,-1,-3,-5,-2,-4,-6,-1,   
     &-3,-5,-2,-4,-6,-2,2,-4,4,-6,6,-2,2,-4,4,-6,6,12*0,-11,-13,-15,    
     &-12,-14,-16,-1,-3,-5,-2,-4,5*0,-12,12,-14,14,-16,16,-2,2,-4,4,    
     &2*0,-12,12,-14,14,-16,16,-2,2,-4,4,52*0,-1,-3,-5,-2,-4,3*0,12,14, 
     &16,2,4,0,12,14,16,2,4,0,12,14,16,2,4,0,12,14,16,2,4,28*0,2,4,7*0, 
     &-11,-13,-15,-12,-14,-16,-1,-3,-5,-2,-4,5*0,-11,-13,-15,-12,-14,   
     &-16,-1,-3,-5,-2,-4,5*0,-12,12,-14,14,-16,16,-2,2,-4,4,2*0,-12,12, 
     &-14,14,-16,16,-2,2,-4,4,52*0,-1,-3,-5,-2,-4,7*0,-11,-13,-15,-12,  
     &-14,-16,-1,-3,-5,-2,-4,5*0,-11,-13,-15,-12,-14,-16,-1,-3,-5,-2/   
      data (kfdp(i,3),i=3099,4000)/-4,5*0,-11,-13,-15,-12,-14,-16,-1,   
     &-3,-5,-2,-4,5*0,-12,12,-14,14,-16,16,-2,2,-4,4,2*0,-12,12,-14,14, 
     &-16,16,-2,2,-4,4,52*0,-1,-3,-5,-2,-4,3*0,-11,-13,-15,-12,-14,-16, 
     &-1,-3,-5,-2,-4,4*0,12,14,16,2,4,0,12,14,16,2,4,0,12,14,16,2,4,0,  
     &12,14,16,2,4,28*0,2,4,730*0/                                      
      data (kfdp(i,4),i=   1,4000)/92*0,4*111,6*0,111,2*0,-211,0,-211,  
     &3*0,111,2*-211,0,111,0,2*111,113,221,2*111,-213,-211,211,113,     
     &6*111,310,2*130,470*0,13*81,58*0,111,-211,4*0,2*111,13*0,-11,     
     &10*0,111,-211,4*0,111,36*0,-211,111,177*0,111,211,111,211,7*0,    
     &111,211,111,211,35*0,2*-211,2*111,211,111,-211,2*211,2*-211,13*0, 
     &-211,111,-211,111,4*0,-211,111,-211,111,34*0,111,-211,3*111,      
     &3*-211,2*111,3*-211,14*0,-321,-311,3*0,-321,-311,20*0,-3,77*0,    
     &6*1,39*0,6*2,42*0,6*3,14*0,8*4,4*0,4*-5,4*0,2*-5,909*0,-211,111,  
     &5*0,-211,111,52*0,2101,2103,2*2101,6*0,4*81,4*0,4*81,6*0,4*81,0,  
     &28*81,13*0,6*2101,18*81,4*0,18*81,4*0,9*81,0,162*81,1416*0/       
      data (kfdp(i,5),i=   1,4000)/94*0,2*111,17*0,111,7*0,2*111,0,     
     &3*111,0,111,856*0,-211,2*111,-211,111,-211,111,65*0,111,-211,     
     &3*111,-211,111,2936*0/                                            

c...PYDAT4, with particle names (character strings).
      data (chaf(i,1),i=   1, 184)/'d','u','s','c','b','t','b''','t''', 
     &2*' ','e-','nu_e','mu-','nu_mu','tau-','nu_tau','tau''-',         
     &'nu''_tau',2*' ','g','gamma','Z0','W+','h0',2*' ','reggeon',      
     &'pomeron',2*' ','Z''0','Z"0','W''+','H0','A0','H+','eta_tech0',   
     &'LQ_ue','R0',10*' ','pi_tech0','pi_tech+','pi''_tech0',           
     &'rho_tech0','rho_tech+','omega_tech',24*' ','specflav',           
     &'rndmflav','phasespa','c-hadron','b-hadron',5*' ','cluster',      
     &'string','indep.','CMshower','SPHEaxis','THRUaxis','CLUSjet',     
     &'CELLjet','table',' ','pi_diffr+','rho_diff0','phi_diff',         
     &'omega_di','n_diffr0','p_diffr+','dd_1','ud_0','ud_1','uu_1',     
     &'sd_0','sd_1','su_0','su_1','ss_1','cd_0','cd_1','cu_0','cu_1',   
     &'cc_1','cs_0','cs_1','bd_0','bd_1','bu_0','bu_1','bs_0','bs_1',   
     &'bc_0','bc_1','bb_1','pi0','pi+','rho0','rho+','a_00','a_0+',     
     &'a_10','a_1+','a_20','a_2+','b_10','b_1+','pi(1300)0',            
     &'pi(1300)+','pi_2(1670)0','pi_2(1670)+','rho(1465)0',             
     &'rho(1465)+','rho(1700)0','rho(1700)+','sigma-m','eta','omega',   
     &'f_2','eta''','phi','f''_2','f_0','h_1','f''_0','h''_1',          
     &'eta(1295)','f_1','f''_1','f_0(1300)','omega(1420)','phi(1680)',  
     &'f_1(1510)','omega(1600)','K_L0','K_S0','K0','K+','K*0','K*+',    
     &'K_10','K_1+','K*_20','K*_2+','K*_00','K*_0+','K*_10','K*_1+'/    
      data (chaf(i,1),i= 185, 305)/'K*(1410)0','K*(1410)+','K*(1680)0', 
     &'K*(1680)+','K_3(1780)0','K_3(1780)+','K_2(1770)0','K_2(1770)+',  
     &'K_2(1820)0','K_2(1820)+','D+','D*+','D*_2+','D0','D*0','D*_20',  
     &'D_s+','D*_s+','D*_2s+','J/psi_di','eta_c','J/psi','chi_2c',      
     &'D*_0+','D_1+','D*_00','D_10','D*_0s+','D_1s+','chi_0c','h_1c',   
     &'D*_1+','D*_10','D*_1s+','chi_1c','psi''','B0','B*0','B*_20',     
     &'B+','B*+','B*_2+','B_s0','B*_s0','B*_2s0','B_c+','B*_c+',        
     &'B*_2c+','eta_b','Upsilon','chi_2b','B*_00','B_10','B*_0+',       
     &'B_1+','B*_0s0','B_1s0','B*_0c+','B_1c+','chi_0b','h_1b','B*_10', 
     &'B*_1+','B*_1s0','B*_1c+','chi_1b','Upsilon''','n0','p+',         
     &'N(1440)0','N(1440)+','N(1520)0','N(1520)+','N(1535)0',           
     &'N(1535)+','N(1650)0','N(1650)+','N(1675)0','N(1675)+',           
     &'N(1680)0','N(1680)+','N(1700)0','N(1700)+','N(1710)0',           
     &'N(1710)+','N(1720)0','N(1720)+','N(1990)0','N(1990)+','Delta-',  
     &'Delta0','Delta+','Delta++','D(1600)-','D(1600)0','D(1600)+',     
     &'D(1600)++','D(1620)-','D(1620)0','D(1620)+','D(1620)++',         
     &'D(1700)-','D(1700)0','D(1700)+','D(1700)++','D(1900)-',          
     &'D(1900)0','D(1900)+','D(1900)++','D(1905)-','D(1905)0',          
     &'D(1905)+','D(1905)++','D(1910)-','D(1910)0','D(1910)+',          
     &'D(1910)++','D(1920)-','D(1920)0','D(1920)+','D(1920)++'/         
      data (chaf(i,1),i= 306, 413)/'D(1930)-','D(1930)0','D(1930)+',    
     &'D(1930)++','D(1950)-','D(1950)0','D(1950)+','D(1950)++',         
     &'Lambda0','L(1405)0','L(1520)0','L(1600)0','L(1670)0','L(1690)0', 
     &'L(1800)0','L(1810)0','L(1820)0','L(1830)0','L(1890)0',           
     &'L(2100)0','L(2110)0','Sigma-','Sigma0','Sigma+','Sigma*-',       
     &'Sigma*0','Sigma*+','S(1660)-','S(1660)0','S(1660)+','S(1670)-',  
     &'S(1670)0','S(1670)+','S(1750)-','S(1750)0','S(1750)+',           
     &'S(1775)-','S(1775)0','S(1775)+','S(1915)-','S(1915)0',           
     &'S(1915)+','S(1940)-','S(1940)0','S(1940)+','S(2030)-',           
     &'S(2030)0','S(2030)+','Xi-','Xi0','Xi*-','Xi*0','X(1690)-',       
     &'X(1690)0','X(1820)-','X(1820)0','X(1950)-','X(1950)0',           
     &'X(2030)-','X(2030)0','Omega-','Sigma_c0','Sigma*_c0',            
     &'Lambda_c+','Xi_c0','Sigma_c+','Sigma*_c+','Sigma_c++',           
     &'Sigma*_c++','Xi_c+','Xi''_c0','Xi*_c0','Xi''_c+','Xi*_c+',       
     &'Omega_c0','Omega*_c0','Xi_cc+','Xi*_cc+','Xi_cc++','Xi*_cc++',   
     &'Omega_cc+','Omega*_cc+','Omega*_ccc++','Sigma_b-','Sigma*_b-',   
     &'Lambda_b0','Xi_b-','Xi_bc0','Sigma_b0','Sigma*_b0','Sigma_b+',   
     &'Sigma*_b+','Xi_b0','Xi_bc+','Xi''_b-','Xi*_b-','Xi''_b0',        
     &'Xi*_b0','Omega_b-','Omega*_b-','Omega_bc0','Xi''_bc0','Xi*_bc0', 
     &'Xi''_bc+','Xi*_bc+','Omega''_bc0','Omega*_bc0','Omega_bcc+'/     
      data (chaf(i,1),i= 414, 500)/'Omega*_bcc+','Xi_bb-','Xi*_bb-',    
     &'Xi_bb0','Xi*_bb0','Omega_bb-','Omega*_bb-','Omega_bbc0',         
     &'Omega*_bbc0','Omega*_bbb-','~d_L','~u_L','~s_L','~c_L','~b_1',   
     &'~t_1','~e_L-','~nu_eL','~mu_L-','~nu_muL','~tau_1-','~nu_tauL',  
     &'~g','~chi_10','~chi_20','~chi_1+','~chi_30','~chi_40','~chi_2+', 
     &'~gravitino','~d_R','~u_R','~s_R','~c_R','~b_2','~t_2','~e_R-',   
     &'~nu_eR','~mu_R-','~nu_muR','~tau_2-','~nu_tauR','d*','u*','e*-', 
     &'nu*_e0',41*' '/                                                  
      data (chaf(i,2),i=   1, 227)/'dbar','ubar','sbar','cbar','bbar',  
     &'tbar','b''bar','t''bar',2*' ','e+','nu_ebar','mu+','nu_mubar',   
     &'tau+','nu_taubar','tau''+','nu''_taubar',5*' ','W-',9*' ',       
     &'W''-',2*' ','H-',' ','LQ_uebar','Rbar0',11*' ','pi_tech-',2*' ', 
     &'rho_tech-',26*' ','rndmflavbar',' ','c-hadronbar','b-hadronbar', 
     &15*' ','pi_diffr-',3*' ','n_diffrbar0','p_diffrbar-','dd_1bar',   
     &'ud_0bar','ud_1bar','uu_1bar','sd_0bar','sd_1bar','su_0bar',      
     &'su_1bar','ss_1bar','cd_0bar','cd_1bar','cu_0bar','cu_1bar',      
     &'cc_1bar','cs_0bar','cs_1bar','bd_0bar','bd_1bar','bu_0bar',      
     &'bu_1bar','bs_0bar','bs_1bar','bc_0bar','bc_1bar','bb_1bar',' ',  
     &'pi-',' ','rho-',' ','a_0-',' ','a_1-',' ','a_2-',' ','b_1-',' ', 
     &'pi(1300)-',' ','pi_2(1670)-',' ','rho(1465)-',' ','rho(1700)-',  
     &21*' ','Kbar0','K-','K*bar0','K*-','K_1bar0','K_1-','K*_2bar0',   
     &'K*_2-','K*_0bar0','K*_0-','K*_1bar0','K*_1-','K*(1410)bar0',     
     &'K*(1410)-','K*(1680)bar0','K*(1680)-','K_3(1780)bar0',           
     &'K_3(1780)-','K_2(1770)bar0','K_2(1770)-','K_2(1820)bar0',        
     &'K_2(1820)-','D-','D*-','D*_2-','Dbar0','D*bar0','D*_2bar0',      
     &'D_s-','D*_s-','D*_2s-',4*' ','D*_0-','D_1-','D*_0bar0',          
     &'D_1bar0','D*_0s-','D_1s-',2*' ','D*_1-','D*_1bar0','D*_1s-',     
     &2*' ','Bbar0','B*bar0','B*_2bar0','B-','B*-','B*_2-','B_sbar0'/   
      data (chaf(i,2),i= 228, 319)/'B*_sbar0','B*_2sbar0','B_c-',       
     &'B*_c-','B*_2c-',3*' ','B*_0bar0','B_1bar0','B*_0-','B_1-',       
     &'B*_0sbar0','B_1sbar0','B*_0c-','B_1c-',2*' ','B*_1bar0','B*_1-', 
     &'B*_1sbar0','B*_1c-',2*' ','nbar0','pbar-','N(1440)bar0',         
     &'N(1440)bar-','N(1520)bar0','N(1520)bar-','N(1535)bar0',          
     &'N(1535)bar-','N(1650)bar0','N(1650)bar-','N(1675)bar0',          
     &'N(1675)bar-','N(1680)bar0','N(1680)bar-','N(1700)bar0',          
     &'N(1700)bar-','N(1710)bar0','N(1710)bar-','N(1720)bar0',          
     &'N(1720)bar-','N(1990)bar0','N(1990)bar-','Deltabar+',            
     &'Deltabar0','Deltabar-','Deltabar--','D(1600)bar+','D(1600)bar0', 
     &'D(1600)bar-','D(1600)bar--','D(1620)bar+','D(1620)bar0',         
     &'D(1620)bar-','D(1620)bar--','D(1700)bar+','D(1700)bar0',         
     &'D(1700)bar-','D(1700)bar--','D(1900)bar+','D(1900)bar0',         
     &'D(1900)bar-','D(1900)bar--','D(1905)bar+','D(1905)bar0',         
     &'D(1905)bar-','D(1905)bar--','D(1910)bar+','D(1910)bar0',         
     &'D(1910)bar-','D(1910)bar--','D(1920)bar+','D(1920)bar0',         
     &'D(1920)bar-','D(1920)bar--','D(1930)bar+','D(1930)bar0',         
     &'D(1930)bar-','D(1930)bar--','D(1950)bar+','D(1950)bar0',         
     &'D(1950)bar-','D(1950)bar--','Lambdabar0','L(1405)bar0',          
     &'L(1520)bar0','L(1600)bar0','L(1670)bar0','L(1690)bar0'/          
      data (chaf(i,2),i= 320, 401)/'L(1800)bar0','L(1810)bar0',         
     &'L(1820)bar0','L(1830)bar0','L(1890)bar0','L(2100)bar0',          
     &'L(2110)bar0','Sigmabar+','Sigmabar0','Sigmabar-','Sigma*bar+',   
     &'Sigma*bar0','Sigma*bar-','S(1660)bar+','S(1660)bar0',            
     &'S(1660)bar-','S(1670)bar+','S(1670)bar0','S(1670)bar-',          
     &'S(1750)bar+','S(1750)bar0','S(1750)bar-','S(1775)bar+',          
     &'S(1775)bar0','S(1775)bar-','S(1915)bar+','S(1915)bar0',          
     &'S(1915)bar-','S(1940)bar+','S(1940)bar0','S(1940)bar-',          
     &'S(2030)bar+','S(2030)bar0','S(2030)bar-','Xibar+','Xibar0',      
     &'Xi*bar+','Xi*bar0','X(1690)bar+','X(1690)bar0','X(1820)bar+',    
     &'X(1820)bar0','X(1950)bar+','X(1950)bar0','X(2030)bar+',          
     &'X(2030)bar0','Omegabar+','Sigma_cbar0','Sigma*_cbar0',           
     &'Lambda_cbar-','Xi_cbar0','Sigma_cbar-','Sigma*_cbar-',           
     &'Sigma_cbar--','Sigma*_cbar--','Xi_cbar-','Xi''_cbar0',           
     &'Xi*_cbar0','Xi''_cbar-','Xi*_cbar-','Omega_cbar0',               
     &'Omega*_cbar0','Xi_ccbar-','Xi*_ccbar-','Xi_ccbar--',             
     &'Xi*_ccbar--','Omega_ccbar-','Omega*_ccbar-','Omega*_cccbar-',    
     &'Sigma_bbar+','Sigma*_bbar+','Lambda_bbar0','Xi_bbar+',           
     &'Xi_bcbar0','Sigma_bbar0','Sigma*_bbar0','Sigma_bbar-',           
     &'Sigma*_bbar-','Xi_bbar0','Xi_bcbar-','Xi''_bbar+','Xi*_bbar+'/   
      data (chaf(i,2),i= 402, 500)/'Xi''_bbar0','Xi*_bbar0',            
     &'Omega_bbar+','Omega*_bbar+','Omega_bcbar0','Xi''_bcbar0',        
     &'Xi*_bcbar0','Xi''_bcbar-','Xi*_bcbar-','Omega''_bcba',           
     &'Omega*_bcbar0','Omega_bccbar-','Omega*_bccbar-','Xi_bbbar+',     
     &'Xi*_bbbar+','Xi_bbbar0','Xi*_bbbar0','Omega_bbbar+',             
     &'Omega*_bbbar+','Omega_bbcbar0','Omega*_bbcbar0',                 
     &'Omega*_bbbbar+','~d_Lbar','~u_Lbar','~s_Lbar','~c_Lbar',         
     &'~b_1bar','~t_1bar','~e_L+','~nu_eLbar','~mu_L+','~nu_muLbar',    
     &'~tau_1+','~nu_tauLbar',3*' ','~chi_1-',2*' ','~chi_2-',' ',      
     &'~d_Rbar','~u_Rbar','~s_Rbar','~c_Rbar','~b_2bar','~t_2bar',      
     &'~e_R+','~nu_eRbar','~mu_R+','~nu_muRbar','~tau_2+',              
     &'~nu_tauRbar','d*bar','u*bar','e*bar+','nu*_ebar0',41*' '/        

c...Treatment of resonances.
      data (mwid(i)  ,i=   1, 500)/5*0,3*1,8*0,1,5*0,3*1,6*0,1,0,7*1,   
     &10*0,2*1,0,3*1,367*0,19*2,0,7*2,0,2,0,2,0,4*1,41*0/               
      end
